/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_M_StorageOnHand;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MStorageOnHand
extends X_M_StorageOnHand {
    private static final long serialVersionUID = -3820729340100521329L;
    private static CLogger s_log = CLogger.getCLogger(MStorageOnHand.class);
    private int m_M_Warehouse_ID = 0;

    @Deprecated
    public static MStorageOnHand get(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        return MStorageOnHand.get(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, null, trxName);
    }

    public static MStorageOnHand get(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp dateMPolicy, String trxName) {
        Object sqlWhere = "M_Locator_ID=? AND M_Product_ID=? AND ";
        sqlWhere = M_AttributeSetInstance_ID == 0 ? (String)sqlWhere + "(M_AttributeSetInstance_ID=? OR M_AttributeSetInstance_ID IS NULL)" : (String)sqlWhere + "M_AttributeSetInstance_ID=?";
        if (dateMPolicy != null) {
            sqlWhere = (String)sqlWhere + " AND DateMaterialPolicy=trunc(cast(? as date))";
        }
        Query query = new Query(ctx, "M_StorageOnHand", (String)sqlWhere, trxName);
        if (dateMPolicy != null) {
            query.setParameters(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy);
        } else {
            query.setParameters(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID);
        }
        MStorageOnHand retValue = (MStorageOnHand)query.first();
        if (retValue == null) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("Not Found - M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
            }
        } else if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        }
        return retValue;
    }

    public static MStorageOnHand[] getAllWithASI(Properties ctx, int M_Product_ID, int M_Locator_ID, boolean FiFo, String trxName) {
        ArrayList<MStorageOnHand> list;
        block7: {
            list = new ArrayList<MStorageOnHand>();
            Object sql = "SELECT * FROM M_StorageOnHand WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID > 0  AND QtyOnHand <> 0 ORDER BY M_AttributeSetInstance_ID";
            if (!FiFo) {
                sql = (String)sql + " DESC";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(1, M_Product_ID);
                    pstmt.setInt(2, M_Locator_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStorageOnHand(ctx, rs, trxName));
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, (String)sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorageOnHand[] getAll(Properties ctx, int M_Product_ID, int M_Locator_ID, String trxName) {
        return MStorageOnHand.getAll(ctx, M_Product_ID, M_Locator_ID, trxName, false, 0);
    }

    public static MStorageOnHand[] getAll(Properties ctx, int M_Product_ID, int M_Locator_ID, String trxName, boolean forUpdate, int timeout) {
        return MStorageOnHand.getAll(ctx, M_Product_ID, M_Locator_ID, false, true, trxName, forUpdate, timeout);
    }

    public static MStorageOnHand[] getAll(Properties ctx, int M_Product_ID, int M_Locator_ID, boolean locatorPriority, boolean fifo, String trxName, boolean forUpdate, int timeout) {
        Object sqlWhere = "M_Product_ID=? AND QtyOnHand <> 0";
        if (M_Locator_ID > 0) {
            sqlWhere = (String)sqlWhere + " AND M_Locator_ID=? ";
        }
        Query query = new Query(ctx, "M_StorageOnHand", (String)sqlWhere, trxName);
        if (M_Locator_ID > 0) {
            query.setParameters(M_Product_ID, M_Locator_ID);
        } else {
            query.setParameters(M_Product_ID);
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        StringBuilder orderBy = new StringBuilder();
        if (locatorPriority) {
            query.addJoinClause("JOIN M_Locator locator ON (M_StorageOnHand.M_Locator_ID=locator.M_Locator_ID) ");
            orderBy.append("locator.PriorityNo DESC, ");
        }
        if (product.isUseGuaranteeDateForMPolicy()) {
            query.addJoinClause(" LEFT OUTER JOIN M_AttributeSetInstance asi ON (M_StorageOnHand.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) ");
            orderBy.append("asi.").append("GuaranteeDate");
            if (!fifo) {
                orderBy.append(" DESC");
            }
            orderBy.append(", ");
            orderBy.append("M_StorageOnHand").append(".").append("M_AttributeSetInstance_ID");
            if (!fifo) {
                orderBy.append(" DESC");
            }
            query.setOrderBy(orderBy.toString());
        } else {
            orderBy.append("M_StorageOnHand").append(".").append("DateMaterialPolicy");
            if (!fifo) {
                orderBy.append(" DESC");
            }
            orderBy.append(", ");
            orderBy.append("M_StorageOnHand").append(".").append("M_AttributeSetInstance_ID");
            if (!fifo) {
                orderBy.append(" DESC");
            }
            query.setOrderBy(orderBy.toString());
        }
        if (forUpdate) {
            query.setForUpdate(forUpdate);
            if (timeout > 0) {
                query.setQueryTimeout(timeout);
            }
        }
        List<MStorageOnHand> list = query.list();
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorageOnHand[] getAll(Properties ctx, int M_Product_ID, int M_Locator_ID, int M_AttributeSetInstance_ID, Timestamp dateMPolicy, boolean ignoreZeroQty, String trxName) {
        Object sqlWhere = "M_Locator_ID=? AND M_Product_ID=? AND ";
        sqlWhere = M_AttributeSetInstance_ID == 0 ? (String)sqlWhere + "(M_AttributeSetInstance_ID=? OR M_AttributeSetInstance_ID IS NULL)" : (String)sqlWhere + "M_AttributeSetInstance_ID=?";
        if (ignoreZeroQty) {
            sqlWhere = (String)sqlWhere + " AND QtyOnHand<>0 ";
        }
        if (dateMPolicy != null) {
            sqlWhere = (String)sqlWhere + " AND DateMaterialPolicy=trunc(cast(? as date))";
        }
        Query query = new Query(ctx, "M_StorageOnHand", (String)sqlWhere, trxName);
        if (dateMPolicy != null) {
            query.setParameters(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy);
        } else {
            query.setParameters(M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID);
        }
        List<MStorageOnHand> list = query.list();
        if (list == null || list.isEmpty()) {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("Not Found - M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
            }
        } else if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Found " + list.size() + " - M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        }
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorageOnHand[] getOfProduct(Properties ctx, int M_Product_ID, String trxName) {
        String sqlWhere = "M_Product_ID=?";
        List<MStorageOnHand> list = new Query(ctx, "M_StorageOnHand", sqlWhere, trxName).setParameters(M_Product_ID).list();
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Deprecated
    public static MStorageOnHand[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_AttributeSet_ID, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean FiFo, String trxName) {
        return MStorageOnHand.getWarehouse(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, false, 0, trxName);
    }

    public static MStorageOnHand[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, boolean positiveOnly, int M_Locator_ID, String trxName) {
        return MStorageOnHand.getWarehouse(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, positiveOnly, M_Locator_ID, trxName, false);
    }

    public static MStorageOnHand[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, boolean positiveOnly, int M_Locator_ID, String trxName, boolean forUpdate) {
        return MStorageOnHand.getWarehouse(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, positiveOnly, M_Locator_ID, trxName, forUpdate, 0);
    }

    public static MStorageOnHand[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, boolean positiveOnly, int M_Locator_ID, String trxName, boolean forUpdate, int timeout) {
        ArrayList<MStorageOnHand> list;
        block17: {
            Object sql;
            if (M_Warehouse_ID == 0 && M_Locator_ID == 0 || M_Product_ID == 0) {
                return new MStorageOnHand[0];
            }
            boolean allAttributeInstances = false;
            if (M_AttributeSetInstance_ID == 0) {
                allAttributeInstances = true;
            }
            list = new ArrayList<MStorageOnHand>();
            if (!allAttributeInstances) {
                sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.DateLastInventory,s.M_StorageOnHand_UU,s.DateMaterialPolicy FROM M_StorageOnHand s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) ";
                sql = M_Locator_ID > 0 ? (String)sql + "WHERE l.M_Locator_ID = ?" : (String)sql + "WHERE l.M_Warehouse_ID=?";
                sql = (String)sql + " AND s.M_Product_ID=? AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
                sql = positiveOnly ? (String)sql + " AND s.QtyOnHand > 0 " : (String)sql + " AND s.QtyOnHand <> 0 ";
                sql = (String)sql + " ORDER BY l.PriorityNo DESC, DateMaterialPolicy ";
                sql = !FiFo ? (String)sql + " DESC, s.M_AttributeSetInstance_ID DESC " : (String)sql + ", s.M_AttributeSetInstance_ID ";
            } else {
                MProduct product;
                sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID, s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy, s.QtyOnHand,s.DateLastInventory,s.M_StorageOnHand_UU,s.DateMaterialPolicy  FROM M_StorageOnHand s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) ";
                sql = M_Locator_ID > 0 ? (String)sql + "WHERE l.M_Locator_ID = ?" : (String)sql + "WHERE l.M_Warehouse_ID=?";
                sql = (String)sql + " AND s.M_Product_ID=? ";
                sql = positiveOnly ? (String)sql + " AND s.QtyOnHand > 0 " : (String)sql + " AND s.QtyOnHand <> 0 ";
                if (minGuaranteeDate != null) {
                    sql = (String)sql + " AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate>?) ";
                }
                if ((product = MProduct.get(Env.getCtx(), M_Product_ID)).isUseGuaranteeDateForMPolicy()) {
                    sql = (String)sql + " ORDER BY l.PriorityNo DESC, COALESCE(asi.GuaranteeDate,s.DateMaterialPolicy)";
                    sql = !FiFo ? (String)sql + " DESC, s.M_AttributeSetInstance_ID DESC " : (String)sql + ", s.M_AttributeSetInstance_ID ";
                } else {
                    sql = (String)sql + " ORDER BY l.PriorityNo DESC, s.DateMaterialPolicy";
                    sql = !FiFo ? (String)sql + " DESC, s.M_AttributeSetInstance_ID DESC " : (String)sql + ", s.M_AttributeSetInstance_ID ";
                }
                sql = (String)sql + ", s.QtyOnHand DESC";
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(1, M_Locator_ID > 0 ? M_Locator_ID : M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (!allAttributeInstances) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    } else if (minGuaranteeDate != null) {
                        pstmt.setTimestamp(3, minGuaranteeDate);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (rs.getBigDecimal(11).signum() == 0) continue;
                        MStorageOnHand storage = new MStorageOnHand(ctx, rs, trxName);
                        if (!Util.isEmpty(trxName) && forUpdate) {
                            DB.getDatabase().forUpdate(storage, timeout);
                        }
                        list.add(storage);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorageOnHand[] getWarehouseNegative(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, int M_Locator_ID, String trxName) {
        return MStorageOnHand.getWarehouseNegative(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, M_Locator_ID, trxName, false);
    }

    public static MStorageOnHand[] getWarehouseNegative(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, int M_Locator_ID, String trxName, boolean forUpdate) {
        return MStorageOnHand.getWarehouseNegative(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, M_Locator_ID, trxName, forUpdate, 0);
    }

    public static MStorageOnHand[] getWarehouseNegative(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, int M_Locator_ID, String trxName, boolean forUpdate, int timeout) {
        ArrayList<MStorageOnHand> list;
        block17: {
            if (M_Warehouse_ID == 0 && M_Locator_ID == 0 || M_Product_ID == 0) {
                return new MStorageOnHand[0];
            }
            list = new ArrayList<MStorageOnHand>();
            Object sql = "SELECT s.M_Product_ID,s.M_Locator_ID,s.M_AttributeSetInstance_ID,s.AD_Client_ID,s.AD_Org_ID,s.IsActive,s.Created,s.CreatedBy,s.Updated,s.UpdatedBy,s.QtyOnHand,s.DateLastInventory,s.M_StorageOnHand_UU,s.DateMaterialPolicy FROM M_StorageOnHand s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) ";
            sql = M_Locator_ID > 0 ? (String)sql + "WHERE l.M_Locator_ID = ?" : (String)sql + "WHERE l.M_Warehouse_ID=?";
            sql = (String)sql + " AND s.M_Product_ID=?  AND s.QtyOnHand < 0 ";
            if (minGuaranteeDate != null) {
                sql = (String)sql + "AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate>?) ";
            }
            if (M_AttributeSetInstance_ID > 0) {
                sql = (String)sql + "AND s.M_AttributeSetInstance_ID=? ";
            } else if (M_AttributeSetInstance_ID == 0) {
                sql = (String)sql + "AND (s.M_AttributeSetInstance_ID=0 OR s.M_AttributeSetInstance_ID IS NULL) ";
            }
            MProduct product = MProduct.get(Env.getCtx(), M_Product_ID, trxName);
            if (product.isUseGuaranteeDateForMPolicy()) {
                sql = (String)sql + " ORDER BY l.PriorityNo DESC, asi.GuaranteeDate";
                if (!FiFo) {
                    sql = (String)sql + " DESC";
                }
            } else {
                sql = (String)sql + " ORDER BY l.PriorityNo DESC, s.DateMaterialPolicy";
                sql = !FiFo ? (String)sql + " DESC, s.M_AttributeSetInstance_ID DESC " : (String)sql + ", s.M_AttributeSetInstance_ID ";
            }
            sql = (String)sql + ", s.QtyOnHand DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int index = 0;
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(++index, M_Locator_ID > 0 ? M_Locator_ID : M_Warehouse_ID);
                    pstmt.setInt(++index, M_Product_ID);
                    if (minGuaranteeDate != null) {
                        pstmt.setTimestamp(++index, minGuaranteeDate);
                    }
                    if (M_AttributeSetInstance_ID > 0) {
                        pstmt.setInt(++index, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        if (rs.getBigDecimal(11).signum() == 0) continue;
                        MStorageOnHand storage = new MStorageOnHand(ctx, rs, trxName);
                        if (!Util.isEmpty(trxName) && forUpdate) {
                            DB.getDatabase().forUpdate(storage, timeout);
                        }
                        list.add(storage);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MStorageOnHand[] retValue = new MStorageOnHand[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorageOnHand getCreate(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp dateMPolicy, String trxName) {
        return MStorageOnHand.getCreate(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy, trxName, false);
    }

    public static MStorageOnHand getCreate(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp dateMPolicy, String trxName, boolean forUpdate) {
        return MStorageOnHand.getCreate(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy, trxName, forUpdate, 0);
    }

    public static MStorageOnHand getCreate(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp dateMPolicy, String trxName, boolean forUpdate, int timeout) {
        MStorageOnHand retValue;
        if (M_Locator_ID == 0) {
            throw new IllegalArgumentException("M_Locator_ID=0");
        }
        if (M_Product_ID == 0) {
            throw new IllegalArgumentException("M_Product_ID=0");
        }
        if (dateMPolicy != null) {
            dateMPolicy = Util.removeTime(dateMPolicy);
        }
        if ((retValue = MStorageOnHand.get(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy, trxName)) != null) {
            if (forUpdate) {
                DB.getDatabase().forUpdate(retValue, timeout);
            }
            return retValue;
        }
        MLocator locator = new MLocator(ctx, M_Locator_ID, trxName);
        if (locator.get_ID() != M_Locator_ID) {
            throw new IllegalArgumentException("Not found M_Locator_ID=" + M_Locator_ID);
        }
        if (dateMPolicy == null) {
            dateMPolicy = new Timestamp(new Date().getTime());
            dateMPolicy = Util.removeTime(dateMPolicy);
        }
        retValue = new MStorageOnHand(locator, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy);
        retValue.saveEx(trxName);
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("New " + String.valueOf(retValue));
        }
        return retValue;
    }

    @Deprecated
    public static boolean add(Properties ctx, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal diffQtyOnHand, String trxName) {
        return MStorageOnHand.add(ctx, M_Warehouse_ID, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, diffQtyOnHand, null, trxName);
    }

    @Deprecated
    public static boolean add(Properties ctx, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal diffQtyOnHand, Timestamp dateMPolicy, String trxName) {
        return MStorageOnHand.add(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, diffQtyOnHand, dateMPolicy, null, trxName);
    }

    public static boolean add(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal diffQtyOnHand, Timestamp dateMPolicy, String trxName) {
        return MStorageOnHand.add(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, diffQtyOnHand, dateMPolicy, null, trxName);
    }

    public static boolean add(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal diffQtyOnHand, Timestamp dateMPolicy, Timestamp dateLastInventory, String trxName) {
        MStorageOnHand storage;
        if (diffQtyOnHand == null || diffQtyOnHand.signum() == 0) {
            return true;
        }
        if (dateMPolicy != null) {
            dateMPolicy = Util.removeTime(dateMPolicy);
        }
        if ((storage = MStorageOnHand.getCreate(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, dateMPolicy, trxName, true, 120)).getM_Locator_ID() != M_Locator_ID && storage.getM_Product_ID() != M_Product_ID && storage.getM_AttributeSetInstance_ID() != M_AttributeSetInstance_ID) {
            s_log.severe("No Storage found - M_Locator_ID=" + M_Locator_ID + ",M_Product_ID=" + M_Product_ID + ",ASI=" + M_AttributeSetInstance_ID);
            return false;
        }
        if (dateLastInventory != null) {
            storage.updateDateLastInventory(dateLastInventory);
        }
        storage.addQtyOnHand(diffQtyOnHand);
        if (s_log.isLoggable(Level.FINE)) {
            StringBuilder diffText = new StringBuilder("(OnHand=").append(diffQtyOnHand).append(") -> ").append(storage.toString());
            s_log.fine(diffText.toString());
        }
        return true;
    }

    public void addQtyOnHand(BigDecimal addition) {
        MWarehouse wh;
        DB.executeUpdateEx("UPDATE M_StorageOnHand SET QtyOnHand=QtyOnHand+?, Updated=getDate(), UpdatedBy=? WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=? AND DateMaterialPolicy=?", new Object[]{addition, Env.getAD_User_ID(Env.getCtx()), this.getM_Product_ID(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID(), this.getDateMaterialPolicy()}, this.get_TrxName());
        this.load(this.get_TrxName(), new String[0]);
        if (this.getQtyOnHand().signum() == -1 && (wh = MWarehouse.get(Env.getCtx(), this.getM_Warehouse_ID())).isDisallowNegativeInv()) {
            throw new NegativeInventoryDisallowedException(this.getCtx(), this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_Locator_ID(), this.getQtyOnHand().subtract(addition), addition.negate());
        }
    }

    public void updateDateLastInventory(Timestamp dateLastInv) {
        DB.executeUpdateEx("UPDATE M_StorageOnHand SET DateLastInventory=? WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=? AND DateMaterialPolicy=?", new Object[]{dateLastInv, this.getM_Product_ID(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID(), this.getDateMaterialPolicy()}, this.get_TrxName());
        this.load(this.get_TrxName(), new String[0]);
    }

    public static int getM_Locator_ID(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal Qty, String trxName) {
        int firstM_Locator_ID;
        int M_Locator_ID;
        block11: {
            M_Locator_ID = 0;
            firstM_Locator_ID = 0;
            Object sql = "SELECT s.M_Locator_ID, s.QtyOnHand FROM M_StorageOnHand s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) ";
            if (M_AttributeSetInstance_ID >= 0) {
                sql = (String)sql + " LEFT OUTER JOIN M_AttributeSet mas ON (p.M_AttributeSet_ID=mas.M_AttributeSet_ID) ";
            }
            sql = (String)sql + "WHERE l.M_Warehouse_ID=?  AND s.M_Product_ID=? ";
            if (M_AttributeSetInstance_ID >= 0) {
                sql = (String)sql + " AND (mas.IsInstanceAttribute IS NULL OR mas.IsInstanceAttribute='N' OR s.M_AttributeSetInstance_ID=?) ";
            }
            sql = (String)sql + " AND l.IsActive='Y' ORDER BY l.PriorityNo DESC, s.QtyOnHand DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, trxName);
                    pstmt.setInt(1, M_Warehouse_ID);
                    pstmt.setInt(2, M_Product_ID);
                    if (M_AttributeSetInstance_ID >= 0) {
                        pstmt.setInt(3, M_AttributeSetInstance_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal QtyOnHand = rs.getBigDecimal(2);
                        if (QtyOnHand != null && Qty.compareTo(QtyOnHand) <= 0) {
                            M_Locator_ID = rs.getInt(1);
                            break;
                        }
                        if (firstM_Locator_ID != 0) continue;
                        firstM_Locator_ID = rs.getInt(1);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, (String)sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (M_Locator_ID != 0) {
            return M_Locator_ID;
        }
        return firstM_Locator_ID;
    }

    public MStorageOnHand(Properties ctx, String M_StorageOnHand_UU, String trxName) {
        super(ctx, M_StorageOnHand_UU, trxName);
        if (Util.isEmpty(M_StorageOnHand_UU)) {
            this.setInitialDefaults();
        }
    }

    public MStorageOnHand(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setInitialDefaults();
    }

    private void setInitialDefaults() {
        this.setQtyOnHand(Env.ZERO);
    }

    public MStorageOnHand(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MStorageOnHand(MLocator locator, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp dateMPolicy) {
        this(locator.getCtx(), 0, locator.get_TrxName());
        this.setClientOrg(locator);
        this.setM_Locator_ID(locator.getM_Locator_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        dateMPolicy = Util.removeTime(dateMPolicy);
        this.setDateMaterialPolicy(dateMPolicy);
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            MLocator loc = MLocator.get(this.getCtx(), this.getM_Locator_ID(), this.get_TrxName());
            this.m_M_Warehouse_ID = loc.getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MWarehouse wh;
        if ((newRecord || this.is_ValueChanged("QtyOnHand")) && (wh = new MWarehouse(this.getCtx(), this.getM_Warehouse_ID(), this.get_TrxName())).isDisallowNegativeInv()) {
            String sql = "SELECT SUM(QtyOnHand) FROM M_StorageOnHand s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) WHERE s.M_Product_ID=? AND l.M_Warehouse_ID=? AND l.M_Locator_ID=? AND s.M_AttributeSetInstance_ID<>?";
            BigDecimal QtyOnHand = DB.getSQLValueBDEx(this.get_TrxName(), sql, this.getM_Product_ID(), this.getM_Warehouse_ID(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID());
            if (QtyOnHand == null) {
                QtyOnHand = Env.ZERO;
            }
            QtyOnHand = QtyOnHand.add(this.getQtyOnHand());
            if (this.getQtyOnHand().compareTo(BigDecimal.ZERO) < 0 || QtyOnHand.compareTo(Env.ZERO) < 0) {
                this.log.saveError("Error", new NegativeInventoryDisallowedException(this.getCtx(), this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_Locator_ID(), QtyOnHand.subtract(this.getQtyOnHand()), this.getQtyOnHand().negate()));
                return false;
            }
        }
        return true;
    }

    public static BigDecimal getQtyOnHand(int M_Product_ID, int M_Warehouse_ID, int M_AttributeSetInstance_ID, String trxName) {
        BigDecimal qty;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(QtyOnHand) FROM M_StorageOnHand oh JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID)").append(" WHERE oh.M_Product_ID=?").append(" AND loc.M_Warehouse_ID=?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND oh.M_AttributeSetInstance_ID=?");
            params.add(M_AttributeSetInstance_ID);
        }
        if ((qty = DB.getSQLValueBD(trxName, sql.toString(), params)) == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandWithASIZero(int M_Product_ID, int M_Warehouse_ID, String trxName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(QtyOnHand) FROM M_StorageOnHand oh JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID)").append(" WHERE oh.M_Product_ID=?").append(" AND loc.M_Warehouse_ID=?").append(" AND oh.M_AttributeSetInstance_ID=0");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        BigDecimal qty = DB.getSQLValueBD(trxName, sql.toString(), params);
        if (qty == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandForReservation(int M_Product_ID, int M_Warehouse_ID, int M_AttributeSetInstance_ID, String trxName) {
        BigDecimal qty;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(QtyOnHand) FROM M_StorageOnHand oh JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID) LEFT JOIN M_LocatorType lt ON (loc.M_LocatorType_ID=lt.M_LocatorType_ID)").append(" WHERE oh.M_Product_ID=?").append(" AND loc.M_Warehouse_ID=? AND COALESCE(lt.IsAvailableForReservation,'Y')='Y'");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND oh.M_AttributeSetInstance_ID=?");
            params.add(M_AttributeSetInstance_ID);
        }
        if ((qty = DB.getSQLValueBDEx(trxName, sql.toString(), params)) == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandForReservationWithASIZero(int M_Product_ID, int M_Warehouse_ID, String trxName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(QtyOnHand) FROM M_StorageOnHand oh JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID) LEFT JOIN M_LocatorType lt ON (loc.M_LocatorType_ID=lt.M_LocatorType_ID)").append(" WHERE oh.M_Product_ID=?").append(" AND loc.M_Warehouse_ID=? AND COALESCE(lt.IsAvailableForReservation,'Y')='Y'").append(" AND oh.M_AttributeSetInstance_ID=0");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        BigDecimal qty = DB.getSQLValueBDEx(trxName, sql.toString(), params);
        if (qty == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandForShipping(int M_Product_ID, int M_Warehouse_ID, int M_AttributeSetInstance_ID, String trxName) {
        BigDecimal qty;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(QtyOnHand) FROM M_StorageOnHand oh JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID)").append(" LEFT JOIN M_LocatorType lt ON (loc.M_LocatorType_ID=lt.M_LocatorType_ID)").append(" WHERE oh.M_Product_ID=?").append(" AND loc.M_Warehouse_ID=? AND COALESCE(lt.IsAvailableForShipping,'Y')='Y'");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND oh.M_AttributeSetInstance_ID=?");
            params.add(M_AttributeSetInstance_ID);
        }
        if ((qty = DB.getSQLValueBDEx(trxName, sql.toString(), params)) == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandForShippingWithASIZero(int M_Product_ID, int M_Warehouse_ID, String trxName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(QtyOnHand) FROM M_StorageOnHand oh JOIN M_Locator loc ON (oh.M_Locator_ID=loc.M_Locator_ID)").append(" LEFT JOIN M_LocatorType lt ON (loc.M_LocatorType_ID=lt.M_LocatorType_ID)").append(" WHERE oh.M_Product_ID=?").append(" AND loc.M_Warehouse_ID=? AND COALESCE(lt.IsAvailableForShipping,'Y')='Y'").append(" AND oh.M_AttributeSetInstance_ID=0");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Warehouse_ID);
        BigDecimal qty = DB.getSQLValueBDEx(trxName, sql.toString(), params);
        if (qty == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandForLocator(int M_Product_ID, int M_Locator_ID, int M_AttributeSetInstance_ID, String trxName) {
        BigDecimal qty;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(oh.QtyOnHand) FROM M_StorageOnHand oh").append(" WHERE oh.M_Product_ID=?").append(" AND oh.M_Locator_ID=?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Locator_ID);
        if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND oh.M_AttributeSetInstance_ID=?");
            params.add(M_AttributeSetInstance_ID);
        }
        if ((qty = DB.getSQLValueBD(trxName, sql.toString(), params)) == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    public static BigDecimal getQtyOnHandForLocatorWithASIZero(int M_Product_ID, int M_Locator_ID, String trxName) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT SUM(oh.QtyOnHand) FROM M_StorageOnHand oh").append(" WHERE oh.M_Product_ID=?").append(" AND oh.M_Locator_ID=?").append(" AND oh.M_AttributeSetInstance_ID=0");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(M_Product_ID);
        params.add(M_Locator_ID);
        BigDecimal qty = DB.getSQLValueBD(trxName, sql.toString(), params);
        if (qty == null) {
            qty = Env.ZERO;
        }
        return qty;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MStorageOnHand[").append("M_Locator_ID=").append(this.getM_Locator_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(",DateMaterialPolicy=").append(this.getDateMaterialPolicy()).append(": OnHand=").append(this.getQtyOnHand()).append("]");
        return sb.toString();
    }

    public static Timestamp getDateMaterialPolicy(int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        block8: {
            if (M_Product_ID <= 0 || M_AttributeSetInstance_ID <= 0) {
                return null;
            }
            String sql = "SELECT dateMaterialPolicy FROM M_StorageOnHand WHERE M_Product_ID=? and M_AttributeSetInstance_ID=? ORDER BY QtyOnHand DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, M_Product_ID);
                pstmt.setInt(2, M_AttributeSetInstance_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp(1);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return timestamp;
                }
            }
            catch (SQLException ex) {
                s_log.log(Level.SEVERE, sql, ex);
                break block8;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return null;
    }

    public static Timestamp getDateMaterialPolicy(int M_Product_ID, int M_AttributeSetInstance_ID, int M_Locator_ID, String trxName) {
        block8: {
            if (M_Product_ID <= 0 || M_AttributeSetInstance_ID <= 0) {
                return null;
            }
            String sql = "SELECT dateMaterialPolicy FROM M_StorageOnHand WHERE M_Product_ID=? and M_AttributeSetInstance_ID=? AND M_Locator_ID=? ORDER BY QtyOnHand DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, M_Product_ID);
                pstmt.setInt(2, M_AttributeSetInstance_ID);
                pstmt.setInt(3, M_Locator_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp(1);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return timestamp;
                }
            }
            catch (SQLException ex) {
                s_log.log(Level.SEVERE, sql, ex);
                break block8;
            }
            finally {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return null;
    }
}

