/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.X_C_RfQLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MRfQLine
extends X_C_RfQLine {
    private static final long serialVersionUID = -387372215148731148L;
    private MRfQLineQty[] m_qtys = null;

    public static MRfQLine get(int C_RfQLine_ID) {
        return MRfQLine.get(C_RfQLine_ID, null);
    }

    public static MRfQLine get(int C_RfQLine_ID, String trxName) {
        return MRfQLine.get(Env.getCtx(), C_RfQLine_ID, trxName);
    }

    public static MRfQLine get(Properties ctx, int C_RfQLine_ID, String trxName) {
        MRfQLine retValue = new MRfQLine(ctx, C_RfQLine_ID, trxName);
        if (retValue.get_ID() == C_RfQLine_ID) {
            return retValue;
        }
        return null;
    }

    public MRfQLine(Properties ctx, String C_RfQLine_UU, String trxName) {
        super(ctx, C_RfQLine_UU, trxName);
        if (Util.isEmpty(C_RfQLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRfQLine(Properties ctx, int C_RfQLine_ID, String trxName) {
        super(ctx, C_RfQLine_ID, trxName);
        if (C_RfQLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setLine(0);
    }

    public MRfQLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQLine(MRfQ rfq) {
        this(rfq.getCtx(), 0, rfq.get_TrxName());
        this.setClientOrg(rfq);
        this.setC_RfQ_ID(rfq.getC_RfQ_ID());
    }

    public MRfQLine(MRfQLine copy) {
        this(Env.getCtx(), copy);
    }

    public MRfQLine(Properties ctx, MRfQLine copy) {
        this(ctx, copy, null);
    }

    public MRfQLine(Properties ctx, MRfQLine copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_qtys = copy.m_qtys != null ? (MRfQLineQty[])Arrays.stream(copy.m_qtys).map(e -> new MRfQLineQty(ctx, (MRfQLineQty)e, trxName)).toArray(MRfQLineQty[]::new) : null;
    }

    public MRfQLineQty[] getQtys() {
        return this.getQtys(false);
    }

    public MRfQLineQty[] getQtys(boolean requery) {
        ArrayList<MRfQLineQty> list;
        block8: {
            if (this.m_qtys != null && !requery) {
                return this.m_qtys;
            }
            list = new ArrayList<MRfQLineQty>();
            String sql = "SELECT * FROM C_RfQLineQty WHERE C_RfQLine_ID=? AND IsActive='Y' ORDER BY Qty";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_RfQLine_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRfQLineQty(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            MRfQLineQty qty = new MRfQLineQty(this);
            qty.saveEx();
            list.add(qty);
        }
        this.m_qtys = new MRfQLineQty[list.size()];
        list.toArray(this.m_qtys);
        return this.m_qtys;
    }

    public String getProductDetailHTML() {
        if (this.getM_Product_ID() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        sb.append(product.getName());
        if (product.getDescription() != null && product.getDescription().length() > 0) {
            sb.append("<br><i>").append(product.getDescription()).append("</i>");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRfQLine[");
        sb.append(this.get_ID()).append(",").append(this.getLine()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays(this.getDateWorkStart(), this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween(this.getDateWorkStart(), this.getDateWorkComplete()));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays(this.getDateWorkComplete(), this.getDeliveryDays() * -1));
        }
        return true;
    }
}

