/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MDocType;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_C_DepositBatch;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MDepositBatch
extends X_C_DepositBatch {
    private static final long serialVersionUID = 7691820074981291939L;
    private String m_processMsg = null;

    public MDepositBatch(Properties ctx, String C_DepositBatch_UU, String trxName) {
        super(ctx, C_DepositBatch_UU, trxName);
        if (Util.isEmpty(C_DepositBatch_UU)) {
            this.setInitialDefaults();
        }
    }

    public MDepositBatch(Properties ctx, int C_DepositBatch_ID, String trxName) {
        super(ctx, C_DepositBatch_ID, trxName);
        if (C_DepositBatch_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDocStatus("DR");
        this.setProcessed(false);
        this.setProcessing(false);
        this.setDepositAmt(Env.ZERO);
    }

    public MDepositBatch(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDepositBatch(MDepositBatch original) {
        this(original.getCtx(), 0, original.get_TrxName());
        this.setClientOrg(original);
        this.setC_DepositBatch_ID(original.getC_DepositBatch_ID());
        this.setDescription(original.getDescription());
        this.setC_DocType_ID(original.getC_DocType_ID());
        this.setDateDoc(original.getDateDoc());
        this.setDateDeposit(original.getDateDeposit());
        this.setDepositAmt(original.getDepositAmt());
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setDateAcct(Timestamp DateAcct) {
        super.setDateDeposit(DateAcct);
        if (DateAcct == null) {
            return;
        }
    }

    @Deprecated
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Deprecated
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return true;
    }

    @Deprecated
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDepositBatch[");
        sb.append(this.get_ID()).append(",").append(this.getDescription()).append(",Amount=").append(this.getDepositAmt()).append("]");
        return sb.toString();
    }

    @Deprecated
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Deprecated
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    @Deprecated
    public File createPDF(File file) {
        return null;
    }

    @Deprecated
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Deprecated
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Deprecated
    public BigDecimal getApprovalAmt() {
        return this.getDepositAmt();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (this.getC_DepositBatch_ID() != 0) {
            String sql = "UPDATE C_Payment p SET C_DepositBatch_ID= 0  WHERE p.C_DepositBatch_ID=?";
            DB.executeUpdateEx(sql, new Object[]{this.getC_DepositBatch_ID()}, this.get_TrxName());
        }
        return success;
    }

    public MDepositBatchLine[] getLines() {
        ArrayList<MDepositBatchLine> list;
        block6: {
            list = new ArrayList<MDepositBatchLine>();
            String sql = "SELECT * FROM C_DepositBatchLine WHERE C_DepositBatch_ID=? ORDER BY Line,C_DepositBatchLine_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_DepositBatch_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MDepositBatchLine(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (SQLException ex) {
                    this.log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        MDepositBatchLine[] retValue = new MDepositBatchLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Deprecated
    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

