/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.internet.InternetAddress;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MMailText;
import org.compiere.model.MSMTP;
import org.compiere.model.MStorageProvider;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTree_Base;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Client;
import org.compiere.model.X_AD_UserMail;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MClient
extends X_AD_Client
implements ImmutablePOSupport {
    private static final long serialVersionUID = 2479547777642328967L;
    private static CLogger s_log = CLogger.getCLogger(MClient.class);
    private static ImmutableIntPOCache<Integer, MClient> s_cache = new ImmutableIntPOCache("AD_Client", 3, 0, false, 0);
    private MClientInfo m_info = null;
    private Language m_language = null;
    private boolean m_createNew = false;
    private int m_AD_Tree_Account_ID;
    private static final String CLIENT_ACCOUNTING_QUEUE = "Q";
    private static final String CLIENT_ACCOUNTING_IMMEDIATE = "I";
    private ArrayList<Integer> m_fieldAccess = null;
    private static final String MAIL_SEND_CREDENTIALS_USER = "U";
    private static final String MAIL_SEND_CREDENTIALS_CLIENT = "C";
    private static final String MAIL_SEND_CREDENTIALS_SYSTEM = "S";

    public static MClient get(int AD_Client_ID) {
        return MClient.get(Env.getCtx(), AD_Client_ID);
    }

    public static MClient get(Properties ctx, int AD_Client_ID) {
        Integer key = AD_Client_ID;
        MClient client = s_cache.get(ctx, key, e -> new MClient(ctx, (MClient)e));
        if (client != null) {
            return client;
        }
        client = new MClient(ctx, AD_Client_ID, null);
        s_cache.put(key, client, e -> new MClient(Env.getCtx(), (MClient)e));
        return client;
    }

    public static MClient[] getAll(Properties ctx) {
        return MClient.getAll(ctx, "");
    }

    public static MClient[] getAll(Properties ctx, String orderBy) {
        List<MClient> list = null;
        try {
            PO.setCrossTenantSafe();
            list = new Query(ctx, "AD_Client", null, null).setOrderBy(orderBy).list();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        for (MClient client : list) {
            s_cache.put(client.getAD_Client_ID(), client, e -> new MClient(Env.getCtx(), (MClient)e));
        }
        MClient[] retValue = new MClient[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MClient getByLoginPrefix(String loginPrefix) {
        Integer key;
        MClient client = null;
        try {
            PO.setCrossTenantSafe();
            client = (MClient)new Query(Env.getCtx(), "AD_Client", "LoginPrefix=?", null).setOnlyActiveRecords(true).setParameters(loginPrefix).first();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        if (client != null && !s_cache.containsKey(key = Integer.valueOf(client.getAD_Client_ID()))) {
            s_cache.put(client.getAD_Client_ID(), client, e -> new MClient(Env.getCtx(), (MClient)e));
        }
        return client;
    }

    public static MClient get(Properties ctx) {
        return MClient.get(ctx, Env.getAD_Client_ID(ctx));
    }

    public MClient(Properties ctx, int AD_Client_ID, boolean createNew, String trxName) {
        super(ctx, AD_Client_ID, trxName);
        this.m_createNew = createNew;
        if (AD_Client_ID == 0) {
            if (this.m_createNew) {
                this.setAD_Org_ID(0);
                this.setIsMultiLingualDocument(false);
                this.setIsSmtpAuthorization(false);
                this.setIsUseBetaFunctions(true);
                this.setAD_Language(Language.getBaseAD_Language());
                this.setAutoArchive("N");
                this.setMMPolicy("F");
                this.setIsPostImmediate(false);
            } else {
                this.load(this.get_TrxName(), new String[0]);
            }
        }
    }

    public MClient(Properties ctx, String AD_Client_UU, String trxName) {
        super(ctx, AD_Client_UU, trxName);
    }

    public MClient(Properties ctx, int AD_Client_ID, String trxName) {
        this(ctx, AD_Client_ID, false, trxName);
    }

    public MClient(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MClient(Properties ctx, String trxName) {
        this(ctx, Env.getAD_Client_ID(ctx), trxName);
    }

    public MClient(MClient copy) {
        this(Env.getCtx(), copy);
    }

    public MClient(Properties ctx, MClient copy) {
        this(ctx, copy, null);
    }

    public MClient(Properties ctx, MClient copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_info = copy.m_info != null ? new MClientInfo(ctx, copy.m_info, trxName) : null;
        this.m_AD_Tree_Account_ID = copy.m_AD_Tree_Account_ID;
        this.m_fieldAccess = copy.m_fieldAccess != null ? new ArrayList<Integer>(copy.m_fieldAccess) : null;
    }

    public MClientInfo getInfo() {
        if (this.m_info == null) {
            this.m_info = this.is_Immutable() ? MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName()) : MClientInfo.getCopy(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        }
        return this.m_info;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MClient[").append(this.get_ID()).append("-").append(this.getValue()).append("]");
        return sb.toString();
    }

    public int getC_Currency_ID() {
        if (this.m_info == null) {
            this.getInfo();
        }
        if (this.m_info != null) {
            return this.m_info.getC_Currency_ID();
        }
        return 0;
    }

    public Language getLanguage() {
        if (this.m_language == null) {
            this.m_language = Language.getLanguage(this.getAD_Language());
            Env.verifyLanguage(this.getCtx(), this.m_language);
        }
        return this.m_language;
    }

    @Override
    public void setAD_Language(String AD_Language) {
        this.m_language = null;
        super.setAD_Language(AD_Language);
    }

    @Override
    public String getAD_Language() {
        String s = super.getAD_Language();
        if (s == null) {
            return Language.getBaseAD_Language();
        }
        return s;
    }

    public Locale getLocale() {
        Language lang = this.getLanguage();
        if (lang != null) {
            return lang.getLocale();
        }
        return Locale.getDefault();
    }

    public boolean setupClientInfo(String language) {
        boolean success;
        int AD_Tree_Activity_ID;
        int AD_Tree_Campaign_ID;
        int AD_Tree_Product_ID;
        int AD_Tree_SalesRegion_ID;
        int AD_Tree_Project_ID;
        int AD_Tree_BPartner_ID;
        int AD_Tree_Org_ID;
        block26: {
            StringBuilder sql = null;
            sql = Env.isBaseLanguage(language, "AD_Ref_List") ? new StringBuilder("SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=120 AND IsActive='Y'") : new StringBuilder("SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t ").append("WHERE l.AD_Reference_ID=120 AND l.AD_Ref_List_ID=t.AD_Ref_List_ID AND l.IsActive='Y'").append(" AND t.AD_Language=").append(DB.TO_STRING(language));
            AD_Tree_Org_ID = 0;
            AD_Tree_BPartner_ID = 0;
            AD_Tree_Project_ID = 0;
            AD_Tree_SalesRegion_ID = 0;
            AD_Tree_Product_ID = 0;
            AD_Tree_Campaign_ID = 0;
            AD_Tree_Activity_ID = 0;
            success = false;
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                    rs = stmt.executeQuery();
                    MTree_Base tree = null;
                    while (rs.next()) {
                        String value = rs.getString(1);
                        StringBuilder name = new StringBuilder().append(this.getName()).append(" ").append(rs.getString(2));
                        if (value.equals("OO")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_Org_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("BP")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_BPartner_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("PJ")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_Project_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("SR")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_SalesRegion_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("PR")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_Product_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("EV")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            this.m_AD_Tree_Account_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("MC")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_Campaign_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("AY")) {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                            AD_Tree_Activity_ID = tree.getAD_Tree_ID();
                        } else if (value.equals("MM") || value.equals("TL") || value.equals("U1") || value.equals("U2") || value.equals("U3") || value.equals("U4")) {
                            success = true;
                        } else {
                            tree = new MTree_Base(this, name.toString(), value);
                            success = tree.save();
                        }
                        if (success) continue;
                        this.log.log(Level.SEVERE, "Tree NOT created: " + String.valueOf(name));
                        break;
                    }
                }
                catch (SQLException e1) {
                    this.log.log(Level.SEVERE, "Trees", e1);
                    success = false;
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    break block26;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        if (!success) {
            return false;
        }
        MClientInfo clientInfo = new MClientInfo(this, AD_Tree_Org_ID, AD_Tree_BPartner_ID, AD_Tree_Project_ID, AD_Tree_SalesRegion_ID, AD_Tree_Product_ID, AD_Tree_Campaign_ID, AD_Tree_Activity_ID, this.get_TrxName());
        int defaultStorageProvider = MStorageProvider.getDefaultStorageProviderID();
        if (defaultStorageProvider > 0) {
            clientInfo.setAD_StorageProvider_ID(defaultStorageProvider);
            clientInfo.setStorageImage_ID(defaultStorageProvider);
            clientInfo.setStorageArchive_ID(defaultStorageProvider);
        }
        success = clientInfo.save();
        return success;
    }

    public int getSetup_AD_Tree_Account_ID() {
        return this.m_AD_Tree_Account_ID;
    }

    public boolean isAutoArchive() {
        String aa = this.getAutoArchive();
        return aa != null && !aa.equals("N");
    }

    public MAcctSchema getAcctSchema() {
        int C_AcctSchema_ID;
        if (this.m_info == null) {
            this.m_info = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        }
        if (this.m_info != null && (C_AcctSchema_ID = this.m_info.getC_AcctSchema1_ID()) != 0) {
            return MAcctSchema.getCopy(this.getCtx(), C_AcctSchema_ID, this.get_TrxName());
        }
        return null;
    }

    @Override
    public boolean save() {
        if (this.get_ID() == 0 && !this.m_createNew) {
            return this.saveUpdate();
        }
        return super.save();
    }

    public String testEMail() {
        String msg;
        block7: {
            EMail email;
            if (this.getRequestEMail() == null || this.getRequestEMail().length() == 0) {
                StringBuilder msgreturn = new StringBuilder("No Request EMail for ").append(this.getName());
                return msgreturn.toString();
            }
            String systemName = MSystem.get(this.getCtx()).getName();
            StringBuilder subject = new StringBuilder(systemName).append(" EMail Test");
            StringBuilder msgce = new StringBuilder(systemName).append(" EMail Test: ").append(this.toString());
            int mailtextID = MSysConfig.getIntValue("EMAIL_TEST_MAILTEXT_ID", 0, this.getAD_Client_ID());
            if (mailtextID > 0) {
                MMailText mt = new MMailText(this.getCtx(), mailtextID, this.get_TrxName());
                mt.setPO(this);
                subject = new StringBuilder(mt.getMailHeader());
                msgce = new StringBuilder(mt.getMailText(true));
            }
            if ((email = this.createEMail(this.getRequestEMail(), subject.toString(), msgce.toString())) == null) {
                StringBuilder msgreturn = new StringBuilder("Could not create EMail: ").append(this.getName());
                return msgreturn.toString();
            }
            try {
                msg = email.send();
                if (!"OK".equals(msg)) break block7;
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Sent Test EMail to " + this.getRequestEMail());
                }
                return "";
            }
            catch (Exception ex) {
                throw new AdempiereException(ex);
            }
        }
        this.log.warning("Could NOT send Test EMail from " + this.getSMTPHost() + ": " + this.getRequestEMail() + " (" + this.getRequestUser() + ") to " + this.getRequestEMail() + ": " + msg);
        return msg;
    }

    public boolean sendEMail(int AD_User_ID, String subject, String message, File attachment) {
        ArrayList<File> attachments = new ArrayList<File>();
        if (attachment != null) {
            attachments.add(attachment);
        }
        return this.sendEMailAttachments(AD_User_ID, subject, message, attachments);
    }

    public boolean sendEMailAttachments(int AD_User_ID, String subject, String message, Collection<File> attachments) {
        return this.sendEMailAttachments(AD_User_ID, subject, message, attachments, false);
    }

    public boolean sendEMailAttachments(int AD_User_ID, String subject, String message, Collection<File> attachments, boolean html2) {
        MUser to = MUser.get(this.getCtx(), AD_User_ID);
        String toEMail = to.getEMail();
        if (toEMail == null || toEMail.length() == 0) {
            this.log.warning("No EMail for recipient: " + String.valueOf(to));
            return false;
        }
        EMail email = this.createEMail(null, to, subject, message, html2);
        if (email == null) {
            return false;
        }
        email.addAttachments(attachments);
        try {
            return this.sendEmailNow(null, to, email);
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - " + ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean sendEMailAttachments(MUser from, MUser to, String subject, String message, List<File> attachments) {
        return this.sendEMailAttachments(from, to, subject, message, attachments, false);
    }

    public boolean sendEMailAttachments(MUser from, MUser to, String subject, String message, List<File> attachments, boolean isHtml) {
        EMail email = this.createEMail(from, to, subject, message, isHtml);
        if (email == null) {
            return false;
        }
        if (attachments != null && !attachments.isEmpty()) {
            for (File attachment : attachments) {
                email.addAttachment(attachment);
            }
        }
        InternetAddress emailFrom = email.getFrom();
        try {
            return this.sendEmailNow(from, to, email);
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - from " + String.valueOf(emailFrom) + " to " + String.valueOf(to) + ": " + ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean sendEMail(String to, String subject, String message, File attachment) {
        return this.sendEMail(to, subject, message, attachment, false);
    }

    public boolean sendEMail(String to, String subject, String message, File attachment, boolean html2) {
        String msg;
        block6: {
            EMail email = this.createEMail(to, subject, message, html2);
            if (email == null) {
                return false;
            }
            if (attachment != null) {
                email.addAttachment(attachment);
            }
            try {
                msg = email.send();
                if (!"OK".equals(msg)) break block6;
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Sent EMail " + subject + " to " + to);
                }
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.log(Level.SEVERE, this.getName() + " - " + ex.getLocalizedMessage(), ex);
                return false;
            }
        }
        this.log.warning("Could NOT Send Email: " + subject + " to " + to + ": " + msg + " (" + this.getName() + ")");
        return false;
    }

    public boolean sendEMail(MUser from, MUser to, String subject, String message, File attachment) {
        return this.sendEMail(from, to, subject, message, attachment, false);
    }

    public boolean sendEMail(MUser from, MUser to, String subject, String message, File attachment, boolean isHtml) {
        EMail email = this.createEMail(from, to, subject, message, isHtml);
        if (email == null) {
            return false;
        }
        if (attachment != null) {
            email.addAttachment(attachment);
        }
        InternetAddress emailFrom = email.getFrom();
        try {
            return this.sendEmailNow(from, to, email);
        }
        catch (Exception ex) {
            this.log.severe(this.getName() + " - from " + String.valueOf(emailFrom) + " to " + String.valueOf(to) + ": " + ex.getLocalizedMessage());
            return false;
        }
    }

    public boolean sendEmailNow(MUser from, MUser to, EMail email) {
        String msg = email.send();
        X_AD_UserMail um = new X_AD_UserMail(this.getCtx(), 0, to.get_TrxName());
        um.setClientOrg(this);
        um.setAD_User_ID(to.getAD_User_ID());
        um.setSubject(email.getSubject());
        um.setMailText(email.getMessageCRLF());
        um.setMailText(email.getMessageCRLF());
        um.setEMailFrom(email.getFrom().toString());
        um.setRecipientTo(MUserMail.getRecipientWithCommaSeparator(email.getTos()));
        um.setRecipientCc(MUserMail.getRecipientWithCommaSeparator(email.getCcs()));
        um.setRecipientBcc(MUserMail.getRecipientWithCommaSeparator(email.getBccs()));
        if (email.isSentOK()) {
            um.setMessageID(email.getMessageID());
        } else {
            um.setMessageID(email.getSentMsg());
            um.setIsDelivered("N");
        }
        um.saveEx();
        if (email.isSentOK()) {
            if (from != null) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Sent Email: " + email.getSubject() + " from " + from.getEMail() + " to " + to.getEMail());
                }
            } else if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Sent Email: " + email.getSubject() + " to " + to.getEMail());
            }
            return true;
        }
        if (from != null) {
            this.log.warning("Could NOT Send Email: " + email.getSubject() + " from " + from.getEMail() + " to " + to.getEMail() + ": " + msg + " (" + this.getName() + ")");
        } else {
            this.log.warning("Could NOT Send Email: " + email.getSubject() + " to " + to.getEMail() + ": " + msg + " (" + this.getName() + ")");
        }
        return false;
    }

    public EMail createEMail(String to, String subject, String message) {
        return this.createEMail(to, subject, message, false);
    }

    public EMail createEMail(String to, String subject, String message, boolean html2) {
        if (to == null || to.length() == 0) {
            this.log.warning("No To");
            return null;
        }
        EMail email = new EMail(this, this.getRequestEMail(), to, subject, message, html2);
        if (this.isSmtpAuthorization()) {
            email.createAuthenticator(this.getRequestUser(), this.getRequestUserPW());
        }
        return email;
    }

    public EMail createEMailFrom(String from, String to, String subject, String message, boolean html2) {
        if (from == null || from.length() == 0) {
            this.log.warning("No From");
            return null;
        }
        if (to == null || to.length() == 0) {
            this.log.warning("No To");
            return null;
        }
        EMail email = new EMail(this, from, to, subject, message, html2);
        MSMTP smtp = MSMTP.get(this.getCtx(), this.getAD_Client_ID(), from, this.get_TrxName());
        if (smtp != null && smtp.isSmtpAuthorization()) {
            email.createAuthenticator(smtp.getRequestUser(), smtp.getRequestUserPW());
        } else if (this.isSmtpAuthorization()) {
            email.createAuthenticator(this.getRequestUser(), this.getRequestUserPW());
        }
        return email;
    }

    public EMail createEMail(MUser from, MUser to, String subject, String message) {
        return this.createEMail(from, to, subject, message, false);
    }

    public EMail createEMail(MUser from, MUser to, String subject, String message, boolean html2) {
        if (to == null) {
            this.log.warning("No To user");
            return null;
        }
        if (to.getEMail() == null || to.getEMail().length() == 0) {
            this.log.warning("No To address: " + String.valueOf(to));
            return null;
        }
        return this.createEMail(from, to.getEMail(), subject, message, html2);
    }

    public EMail createEMail(MUser from, String to, String subject, String message) {
        return this.createEMail(from, to, subject, message, false);
    }

    public EMail createEMail(MUser from, String to, String subject, String message, boolean html2) {
        if (to == null || to.length() == 0) {
            this.log.warning("No To address");
            return null;
        }
        if (from == null) {
            return this.createEMail(to, subject, message, html2);
        }
        if (from.getEMail() == null || from.getEMailUser() == null || this.isSmtpAuthorization() && from.getEMailUserPW() == null) {
            this.log.warning("From EMail incomplete: " + String.valueOf(from) + " (" + this.getName() + ")");
            return null;
        }
        EMail email = new EMail(this, from.getEMail(), to, subject, message, html2);
        if (this.isSmtpAuthorization()) {
            email.createAuthenticator(from.getEMailUser(), from.getEMailUserPW());
        }
        if (from.getEMail() != null && !from.getEMail().equalsIgnoreCase(from.getEMailUser())) {
            email.setReplyTo(from.getEMail());
        }
        return email;
    }

    public static boolean isClientAccounting() {
        String ca = MSysConfig.getValue("CLIENT_ACCOUNTING", CLIENT_ACCOUNTING_QUEUE, Env.getAD_Client_ID(Env.getCtx()));
        return ca.equalsIgnoreCase(CLIENT_ACCOUNTING_IMMEDIATE) || ca.equalsIgnoreCase(CLIENT_ACCOUNTING_QUEUE);
    }

    public static boolean isClientAccountingQueue() {
        String ca = MSysConfig.getValue("CLIENT_ACCOUNTING", CLIENT_ACCOUNTING_QUEUE, Env.getAD_Client_ID(Env.getCtx()));
        return ca.equalsIgnoreCase(CLIENT_ACCOUNTING_QUEUE);
    }

    public static boolean isClientAccountingImmediate() {
        String ca = MSysConfig.getValue("CLIENT_ACCOUNTING", CLIENT_ACCOUNTING_QUEUE, Env.getAD_Client_ID(Env.getCtx()));
        return ca.equalsIgnoreCase(CLIENT_ACCOUNTING_IMMEDIATE);
    }

    public boolean isDisplayField(int aDFieldID) {
        block8: {
            if (!this.isUseASP()) {
                return true;
            }
            if (this.m_fieldAccess == null) {
                this.m_fieldAccess = new ArrayList(11000);
                StringBuilder sqlvalidate = new StringBuilder("SELECT AD_Field_ID ").append("  FROM AD_Field ").append(" WHERE (   AD_Field_ID NOT IN ( ").append("              SELECT f.AD_Field_ID ").append("                FROM ASP_Field f, ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl ").append("               WHERE w.ASP_Level_ID = l.ASP_Level_ID ").append("                 AND cl.AD_Client_ID = ").append(this.getAD_Client_ID()).append("                 AND cl.ASP_Level_ID = l.ASP_Level_ID ").append("                 AND f.ASP_Tab_ID = t.ASP_Tab_ID ").append("                 AND t.ASP_Window_ID = w.ASP_Window_ID ").append("                 AND f.IsActive = 'Y' ").append("                 AND t.IsActive = 'Y' ").append("                 AND w.IsActive = 'Y' ").append("                 AND l.IsActive = 'Y' ").append("                 AND cl.IsActive = 'Y' ").append("                 AND f.ASP_Status = 'H' ").append("                  AND f.AD_Field_ID NOT IN (").append(" \t\t\t\t SELECT AD_Field_ID").append(" \t\t\t\t FROM ASP_ClientException ce").append(" \t\t\t\t WHERE ce.AD_Client_ID =").append(this.getAD_Client_ID()).append(" \t\t\t\t AND ce.IsActive = 'Y'").append("                  AND ce.AD_Field_ID IS NOT NULL").append(" \t\t\t\t AND ce.ASP_Status <> 'H')").append("   UNION ALL ").append("          SELECT AD_Field_ID ").append("            FROM ASP_ClientException ce ").append("           WHERE ce.AD_Client_ID = ").append(this.getAD_Client_ID()).append("             AND ce.IsActive = 'Y' ").append("             AND ce.AD_Field_ID IS NOT NULL ").append("             AND ce.ASP_Status = 'H'))").append(" ORDER BY AD_Field_ID");
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sqlvalidate.toString(), this.get_TrxName());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            this.m_fieldAccess.add(rs.getInt(1));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sqlvalidate.toString(), e);
                        DB.close(rs, pstmt);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
        }
        return Collections.binarySearch(this.m_fieldAccess, aDFieldID) > 0;
    }

    @Override
    public String getRequestUser() {
        if (this.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.getRequestUser();
        }
        return super.getRequestUser();
    }

    @Override
    public String getRequestUserPW() {
        if (this.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.getRequestUserPW();
        }
        return super.getRequestUserPW();
    }

    @Override
    public boolean isSmtpAuthorization() {
        if (this.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.isSmtpAuthorization();
        }
        return super.isSmtpAuthorization();
    }

    @Override
    public int getSMTPPort() {
        if (this.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.getSMTPPort();
        }
        return super.getSMTPPort();
    }

    @Override
    public boolean isSecureSMTP() {
        if (this.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.isSecureSMTP();
        }
        return super.isSecureSMTP();
    }

    @Override
    public String getSMTPHost() {
        String s = null;
        if (this.getAD_Client_ID() != 0 && MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            s = sysclient.getSMTPHost();
        } else {
            s = super.getSMTPHost();
        }
        if (s == null) {
            s = "localhost";
        }
        return s;
    }

    @Override
    public MClient markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_info != null) {
            this.m_info.markImmutable();
        }
        return this;
    }

    public static boolean isSendCredentialsClient() {
        String msc = MSysConfig.getValue("MAIL_SEND_CREDENTIALS", MAIL_SEND_CREDENTIALS_USER, Env.getAD_Client_ID(Env.getCtx()));
        return MAIL_SEND_CREDENTIALS_CLIENT.equalsIgnoreCase(msc);
    }

    public static boolean isSendCredentialsSystem() {
        String msc = MSysConfig.getValue("MAIL_SEND_CREDENTIALS", MAIL_SEND_CREDENTIALS_USER, Env.getAD_Client_ID(Env.getCtx()));
        return MAIL_SEND_CREDENTIALS_SYSTEM.equalsIgnoreCase(msc);
    }
}

