/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event.delegate;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.adempiere.base.annotation.EventTopicDelegate;
import org.adempiere.base.annotation.ModelEventTopic;
import org.adempiere.base.event.annotations.ModelEventDelegate;
import org.adempiere.base.event.annotations.doc.BeforeComplete;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.osgi.service.event.Event;

@EventTopicDelegate
@ModelEventTopic(modelClass=MInOut.class)
public class AutoProduceEventDelegate
extends ModelEventDelegate<MInOut> {
    public AutoProduceEventDelegate(MInOut po, Event event) {
        super(po, event);
    }

    @BeforeComplete
    public void onBeforeComplete() {
        String msg;
        boolean isGenerateProduction;
        MInOut mInOut = (MInOut)this.getModel();
        boolean bl = isGenerateProduction = !"C+".equals(mInOut.getMovementType()) && !"V-".equals(mInOut.getMovementType());
        if (mInOut.isSOTrx() && isGenerateProduction && (msg = this.processShipment(mInOut)) != null) {
            throw new RuntimeException(msg);
        }
    }

    private String processShipment(MInOut mInOut) {
        HashMap<String, BigDecimal> qtyUsedMap = new HashMap<String, BigDecimal>();
        MInOutLine[] mInOutLineArray = mInOut.getLines(false);
        int n = mInOutLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MInOutLine line = mInOutLineArray[n2];
            MProduct product = new MProduct(mInOut.getCtx(), line.getM_Product_ID(), mInOut.get_TrxName());
            if (product.isBOM() && product.isVerified() && product.isAutoProduce() && product.isStocked()) {
                BigDecimal qtyOnHand = MStorageOnHand.getQtyOnHand(line.getM_Product_ID(), line.getM_Warehouse_ID(), line.getM_AttributeSetInstance_ID(), mInOut.get_TrxName());
                String key = mInOut.getM_InOut_ID() + "_" + line.getM_Product_ID();
                BigDecimal qty = (BigDecimal)qtyUsedMap.get(key);
                if (qty == null) {
                    qty = line.getQtyEntered();
                } else {
                    qtyOnHand = qtyOnHand.subtract(qty);
                    qty = qty.add(line.getQtyEntered());
                }
                qtyUsedMap.put(key, qty);
                if (qtyOnHand.signum() < 0) {
                    qtyOnHand = BigDecimal.ZERO;
                }
                if (qtyOnHand == null || qtyOnHand.compareTo(line.getQtyEntered()) < 0) {
                    String msg = this.createProduction(mInOut, line, line.getQtyEntered(), qtyOnHand, line.getM_Product_ID(), new int[1], qtyUsedMap);
                    if (msg != null) {
                        return msg;
                    }
                    line.setIsAutoProduce(true);
                    line.saveEx();
                }
            }
            ++n2;
        }
        return null;
    }

    private String createProduction(MInOut mInOut, MInOutLine mInOutLine, BigDecimal qtyEntered, BigDecimal qtyOnHand, int endProductID, int[] productionCount, Map<String, BigDecimal> qtyUsedMap) {
        MProduct endProduct;
        String description = Msg.getElement(Env.getCtx(), "M_InOut_ID", true) + " " + mInOut.getDocumentNo();
        int M_Locator_ID = 0;
        M_Locator_ID = endProductID == mInOutLine.getM_Product_ID() ? mInOutLine.getM_Locator_ID() : ((endProduct = MProduct.get(Env.getCtx(), endProductID)).getM_Locator_ID() > 0 ? endProduct.getM_Locator_ID() : mInOutLine.getM_Locator_ID());
        BigDecimal productionQty = qtyOnHand.signum() > 0 ? qtyEntered.subtract(qtyOnHand) : qtyEntered;
        MProduction production = new MProduction(mInOut.getCtx(), 0, mInOut.get_TrxName());
        production.setDescription(description);
        production.setAD_Org_ID(mInOut.getAD_Org_ID());
        String productionName = Msg.getElement(Env.getCtx(), "M_InOut_ID", true) + " " + mInOut.getDocumentNo();
        productionName = productionCount[0] > 0 ? productionName + " #" + (productionCount[0] + 1) : productionName + " #1";
        production.setName(productionName);
        production.setMovementDate(mInOut.getMovementDate());
        production.setPosted(false);
        production.setProcessed(false);
        production.setM_Product_ID(endProductID);
        production.setM_Locator_ID(M_Locator_ID);
        production.setProductionQty(productionQty);
        production.setIsCreated("N");
        production.setIsUseProductionPlan(false);
        if (endProductID == mInOutLine.getM_Product_ID()) {
            production.setM_InOutLine_ID(mInOutLine.getM_InOutLine_ID());
        }
        production.saveEx();
        MProductionLine productionline = new MProductionLine(mInOut.getCtx(), 0, mInOut.get_TrxName());
        productionline.setM_Production_ID(production.getM_Production_ID());
        productionline.setLine(10);
        productionline.setAD_Org_ID(mInOut.getAD_Org_ID());
        productionline.setM_Product_ID(endProductID);
        productionline.setMovementQty(productionQty);
        productionline.setQtyUsed(BigDecimal.ZERO);
        productionline.setM_Locator_ID(M_Locator_ID);
        productionline.setDescription(Msg.getElement(Env.getCtx(), "M_InOutLine_ID", true) + " #" + mInOutLine.getLine());
        productionline.setIsEndProduct(true);
        productionline.saveEx();
        MPPProductBOM bom = MPPProductBOM.getDefault(MProduct.get(Env.getCtx(), endProductID), mInOut.get_TrxName());
        if (bom == null) {
            return "Shipment: " + mInOut.getDocumentNo() + " Line: " + mInOutLine.getLine() + " doesn't contain a valid BOM";
        }
        MPPProductBOMLine[] bomLines = bom.getLines();
        int lineNo = 10;
        MPPProductBOMLine[] mPPProductBOMLineArray = bomLines;
        int n = bomLines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPProductBOMLine bomLine = mPPProductBOMLineArray[n2];
            BigDecimal bomQty = bomLine.getQtyBOM();
            MProduct component = new MProduct(mInOut.getCtx(), bomLine.getM_Product_ID(), mInOut.get_TrxName());
            productionline = new MProductionLine(mInOut.getCtx(), 0, mInOut.get_TrxName());
            productionline.setM_Production_ID(production.getM_Production_ID());
            productionline.setLine(lineNo += 10);
            productionline.setM_Product_ID(bomLine.getM_Product_ID());
            productionline.setAD_Org_ID(mInOut.getAD_Org_ID());
            productionline.setQtyUsed(productionQty.multiply(bomQty));
            M_Locator_ID = MStorageOnHand.getM_Locator_ID(mInOut.getM_Warehouse_ID(), bomLine.getM_Product_ID(), -1, productionQty.multiply(bomQty), mInOut.get_TrxName());
            M_Locator_ID = M_Locator_ID > 0 ? M_Locator_ID : (component.getM_Locator_ID() > 0 ? component.getM_Locator_ID() : production.getM_Locator_ID());
            productionline.setM_Locator_ID(M_Locator_ID);
            productionline.setIsEndProduct(false);
            productionline.saveEx();
            if (component.isBOM() && component.isVerified()) {
                BigDecimal onHandComponent = MStorageOnHand.getQtyOnHand(bomLine.getM_Product_ID(), mInOutLine.getM_Warehouse_ID(), 0, mInOut.get_TrxName());
                String key = mInOut.getM_InOut_ID() + "_" + bomLine.getM_Product_ID();
                BigDecimal qty = qtyUsedMap.get(key);
                if (qty != null) {
                    onHandComponent = onHandComponent.subtract(qty);
                }
                if (onHandComponent.compareTo(productionQty.multiply(bomQty)) < 0) {
                    boolean produceNestedBOM;
                    boolean bl = produceNestedBOM = component.isBOM() && component.isVerified() && component.isAutoProduce();
                    if (produceNestedBOM) {
                        productionCount[0] = productionCount[0] + 1;
                        String error = this.createProduction(mInOut, mInOutLine, productionQty.multiply(bomQty), onHandComponent, bomLine.getM_Product_ID(), productionCount, qtyUsedMap);
                        if (!Util.isEmpty(error)) {
                            return error;
                        }
                    }
                }
            }
            ++n2;
        }
        production.setIsCreated("Y");
        production.saveEx();
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow(production, "CO");
        if (pi.isError()) {
            StringBuilder msgError = new StringBuilder();
            if (!Util.isEmpty(pi.getSummary())) {
                msgError.append(pi.getSummary());
            }
            if (!Util.isEmpty(production.getProcessMsg())) {
                msgError.append(" - ").append(production.getProcessMsg());
            }
            if (msgError.length() == 0) {
                msgError.append("Error completing auto-produce production");
            }
            return msgError.toString();
        }
        return null;
    }
}

