/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.GridTab;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CCache;
import org.compiere.util.CacheChangeListener;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;

public class DefaultEvaluatee
implements Evaluatee {
    private GridTab m_GridTab;
    private int m_WindowNo;
    private int m_TabNo;
    private static final ReferenceCache s_ReferenceCache = new ReferenceCache("DefaultEvaluatee_ReferenceCache", 100, 1, 2000);

    public DefaultEvaluatee(GridTab gridTab, int windowNo, int tabNo) {
        this.m_GridTab = gridTab;
        this.m_WindowNo = windowNo;
        this.m_TabNo = tabNo;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        return this.get_ValueAsString(Env.getCtx(), variableName);
    }

    public String get_ValueAsString(Properties ctx, String variableName) {
        String foreignColumn = "";
        int f = variableName.indexOf(46);
        if (f > 0) {
            foreignColumn = variableName.substring(f + 1, variableName.length());
            variableName = variableName.substring(0, f);
        }
        String value = null;
        if (this.m_TabNo == 0) {
            value = Env.getContext(ctx, this.m_WindowNo, variableName, true);
        } else {
            boolean tabOnly = false;
            if (variableName.startsWith("~")) {
                variableName = variableName.substring(1);
                tabOnly = true;
            }
            value = Env.getContext(ctx, this.m_WindowNo, this.m_TabNo, variableName, tabOnly, true);
        }
        if (!Util.isEmpty(value) && !Util.isEmpty(foreignColumn) && variableName.endsWith("_ID")) {
            int id = 0;
            try {
                id = Integer.parseInt(value);
            }
            catch (Exception exception) {}
            if (id > 0) {
                String refValue = "";
                MColumn column = null;
                if (this.m_GridTab != null && (column = MColumn.get(ctx, this.m_GridTab.getTableName(), variableName)) == null) {
                    GridTab parent = this.m_GridTab.getParentTab();
                    while (column == null && parent != null) {
                        column = MColumn.get(ctx, parent.getTableName(), variableName);
                        parent = parent.getParentTab();
                    }
                }
                if (column != null) {
                    foreignTable = column.getReferenceTableName();
                    MTable table2 = MTable.get(Env.getCtx(), foreignTable);
                    if (table2 != null) {
                        return this.getColumnValue(table2, foreignTable, foreignColumn, id, refValue);
                    }
                } else {
                    foreignTable = variableName.substring(0, variableName.length() - 3);
                    MTable table3 = MTable.get(ctx, foreignTable);
                    if (table3 != null) {
                        return this.getColumnValue(table3, foreignTable, foreignColumn, id, refValue);
                    }
                }
            }
        }
        return value;
    }

    private String getColumnValue(MTable table2, String foreignTable, String foreignColumn, int id, String refValue) {
        Object value;
        String key = foreignTable + "|" + id;
        PO po = null;
        if (s_ReferenceCache.containsKey(key)) {
            po = (PO)s_ReferenceCache.get(key);
            if (po != null && po.get_ID() == id) {
                value = po.get_Value(foreignColumn);
                refValue = value == null ? "" : (value instanceof Boolean ? ((Boolean)value != false ? "Y" : "N") : value.toString());
            } else {
                po = null;
            }
        }
        if (po == null && (po = table2.getPO(id, null)) != null && po.get_ID() == id) {
            s_ReferenceCache.put(key, po);
            value = po.get_Value(foreignColumn);
            refValue = value == null ? "" : (value instanceof Boolean ? ((Boolean)value != false ? "Y" : "N") : value.toString());
        }
        return refValue;
    }

    private static final class ReferenceCache
    extends CCache<String, PO>
    implements CacheChangeListener {
        private static final long serialVersionUID = 6884795644185015913L;

        private ReferenceCache(String name, int initialCapacity, int expireMinutes, int maxSize) {
            super(null, name, initialCapacity, expireMinutes, false, maxSize);
        }

        @Override
        public void reset(String tableName) {
            String filter = tableName + "|";
            List keys = this.keySet().stream().filter(e -> e.startsWith(filter)).collect(Collectors.toList());
            if (!keys.isEmpty()) {
                for (String key : keys) {
                    this.remove(key);
                }
            }
        }

        @Override
        public void reset(String tableName, int recordId) {
            String key = tableName + "|" + recordId;
            this.remove(key);
        }
    }
}

