/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Hashtable;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;

@Process
public class ExportFormatGenerator
extends SvrProcess {
    private int p_AD_Window_ID = 0;
    private boolean p_IsMandatory = false;
    private boolean p_IsInsertRecord = false;
    private Hashtable<String, MEXPFormat> m_formats = new Hashtable();
    private String version = "3.2.0";
    private String m_parent_table = null;
    private String m_format_value = null;
    private int m_level = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] paras;
        ProcessInfoParameter[] processInfoParameterArray = paras = this.getParameter();
        int n = paras.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals("AD_Window_ID")) {
                    this.p_AD_Window_ID = para.getParameterAsInt();
                } else if (name.equals("IsMandatory")) {
                    this.p_IsMandatory = "Y".equals(para.getParameter());
                } else if (name.equals("IsInsertRecord")) {
                    this.p_IsInsertRecord = "Y".equals(para.getParameter());
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MTab[] tabs;
        MWindow window = new MWindow(this.getCtx(), this.p_AD_Window_ID, this.get_TrxName());
        MTab[] mTabArray = tabs = window.getTabs(true, this.get_TrxName());
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String format;
                MTable table2;
                MTab tab;
                block7: {
                    block6: {
                        tab = mTabArray[n2];
                        table2 = null;
                        format = null;
                        if (!tab.isActive()) break block5;
                        if (!this.p_IsInsertRecord || !tab.isInsertRecord()) break block6;
                        table2 = new MTable(this.getCtx(), tab.getAD_Table_ID(), this.get_TrxName());
                        format = this.createFormat(table2);
                        break block7;
                    }
                    if (this.p_IsInsertRecord) break block5;
                    table2 = new MTable(this.getCtx(), tab.getAD_Table_ID(), this.get_TrxName());
                    format = this.createFormat(table2);
                }
                if (tab.getTabLevel() > this.m_level) {
                    this.m_parent_table = table2.getTableName();
                    this.m_format_value = format;
                }
            }
            ++n2;
        }
        return "ok";
    }

    private String createFormat(MTable table2) throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Table Name:" + table2.getTableName());
        }
        MColumn[] cols = table2.getColumns(true);
        String unique = null;
        MColumn[] mColumnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn col = mColumnArray[n2];
            if (col.isIdentifier() && col.getSeqNo() == 1) {
                unique = col.getColumnName();
                if (!this.log.isLoggable(Level.INFO)) break;
                this.log.info("Unique Key" + unique);
                break;
            }
            ++n2;
        }
        if (unique == null) {
            unique = "Name";
        }
        MEXPFormat format = null;
        String formatValue = table2.getTableName();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Export Format Value:" + formatValue);
        }
        if ((format = this.m_formats.get(formatValue)) != null) {
            return format.getValue();
        }
        String where = " value = ? ";
        Query sql = new Query(this.getCtx(), "EXP_Format", where, this.get_TrxName()).setParameters(formatValue);
        if (sql.match()) {
            format = (MEXPFormat)sql.first();
            this.m_formats.put(format.getValue(), format);
            return format.getValue();
        }
        format = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(this.getCtx(), formatValue, this.getAD_Client_ID(), this.version, this.get_TrxName());
        if (format == null) {
            format = new MEXPFormat(this.getCtx(), 0, this.get_TrxName());
        }
        format.setAD_Org_ID(0);
        format.setValue(formatValue);
        format.setName(table2.getName());
        format.setAD_Table_ID(table2.getAD_Table_ID());
        format.setDescription(table2.getDescription());
        format.setHelp(table2.getHelp());
        format.setVersion(this.version);
        format.saveEx();
        if (format != null) {
            this.m_formats.put(format.getValue(), format);
        }
        int position = 10;
        MColumn[] mColumnArray2 = cols;
        int n3 = cols.length;
        int n4 = 0;
        while (n4 < n3) {
            MColumn col = mColumnArray2[n4];
            if (this.p_IsMandatory) {
                if (col.isMandatory()) {
                    this.createFormatLine(format, table2, col, position, false);
                }
            } else {
                this.createFormatLine(format, table2, col, position, false);
            }
            ++position;
            ++n4;
        }
        return format.getValue();
    }

    private int createFormatLine(MEXPFormat format, MTable table2, MColumn col, int position, boolean force) throws Exception {
        int AD_Table_ID;
        MEXPFormatLine formatLine = null;
        String formatlinevalue = col.getColumnName();
        formatLine = MEXPFormatLine.getFormatLineByValue(this.getCtx(), formatlinevalue, format.getEXP_Format_ID(), this.get_TrxName());
        if (formatLine == null) {
            formatLine = new MEXPFormatLine(this.getCtx(), 0, this.get_TrxName());
        }
        formatLine.setAD_Org_ID(0);
        formatLine.setEXP_Format_ID(format.getEXP_Format_ID());
        formatLine.setValue(formatlinevalue);
        formatLine.setName(col.getName());
        formatLine.setDescription(col.getDescription());
        formatLine.setHelp(col.getHelp());
        formatLine.setPosition(position);
        formatLine.setIsMandatory(col.isMandatory());
        if (force || col.isIdentifier() && !col.isKey()) {
            formatLine.setIsPartUniqueIndex(true);
            formatLine.setIsActive(true);
        } else {
            formatLine.setIsActive(false);
        }
        MTable tabledir = null;
        if (col.getColumnName().equals(this.m_parent_table + "_ID") && DisplayType.isID(col.getAD_Reference_ID())) {
            MEXPFormat referenceFormat = null;
            referenceFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(this.getCtx(), this.m_parent_table + "_Key", this.getAD_Client_ID(), this.version, this.get_TrxName());
            if (referenceFormat == null) {
                referenceFormat = new MEXPFormat(this.getCtx(), 0, this.get_TrxName());
            }
            referenceFormat.setAD_Org_ID(0);
            referenceFormat.setValue(this.m_parent_table + "_Key");
            referenceFormat.setName(this.m_parent_table + "_Key");
            referenceFormat.setAD_Table_ID(MTable.getTable_ID(this.m_parent_table));
            referenceFormat.setDescription(table2.getDescription());
            referenceFormat.setHelp(table2.getHelp());
            referenceFormat.setVersion(this.version);
            referenceFormat.saveEx();
            int AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='DOCUMENTNO'", this.m_parent_table);
            if (AD_Column_ID > 0) {
                this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 10, true);
                AD_Column_ID = 0;
                AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='C_DOCTYPE_ID'", this.m_parent_table);
                if (AD_Column_ID > 0) {
                    this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 20, true);
                }
                formatLine.setValue(this.m_parent_table + "_Key");
                formatLine.setName("Key DocumentNo_C_DocType");
                formatLine.setAD_Column_ID(col.getAD_Column_ID());
                formatLine.setType("R");
                formatLine.setEXP_EmbeddedFormat_ID(referenceFormat.getEXP_Format_ID());
                formatLine.saveEx();
                if (this.m_parent_table != null && col.isParent() && col.getColumnName().contains(this.m_parent_table)) {
                    int reference = this.m_formats.get(this.m_format_value).getEXP_Format_ID();
                    MEXPFormatLine embededformatLine = new MEXPFormatLine(this.getCtx(), 0, this.get_TrxName());
                    embededformatLine.setAD_Org_ID(0);
                    embededformatLine.setValue(format.getValue() + "_Embedded");
                    embededformatLine.setName("Embedded " + format.getName());
                    embededformatLine.setEXP_EmbeddedFormat_ID(formatLine.getEXP_Format_ID());
                    embededformatLine.setEXP_Format_ID(reference);
                    embededformatLine.setType("M");
                    embededformatLine.setAD_Column_ID(col.getAD_Column_ID());
                    embededformatLine.saveEx();
                }
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Export Format Line:" + formatLine.getName());
                }
                return formatLine.getEXP_FormatLine_ID();
            }
            AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='NAME'", this.m_parent_table);
            if (AD_Column_ID > 0) {
                this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 10, true);
            } else {
                AD_Column_ID = DB.getSQLValue(this.get_TrxName(), "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID=(SELECT AD_Table_ID FROM AD_Table WHERE TableName=?) AND UPPER(ColumnName)='VALUE'", this.m_parent_table);
                if (AD_Column_ID > 0) {
                    this.createFormatLine(referenceFormat, table2, new MColumn(this.getCtx(), AD_Column_ID, this.get_TrxName()), 10, true);
                } else {
                    throw new AdempiereException("Table without name or value column");
                }
            }
            formatLine.setValue(this.m_parent_table + "_Key");
            formatLine.setName("Key " + col.getColumnName());
            formatLine.setAD_Column_ID(col.getAD_Column_ID());
            formatLine.setType("R");
            formatLine.setEXP_EmbeddedFormat_ID(referenceFormat.getEXP_Format_ID());
            formatLine.saveEx();
            return formatLine.getEXP_FormatLine_ID();
        }
        if (DisplayType.isID(col.getAD_Reference_ID()) && col.getAD_Reference_Value_ID() > 0 && (AD_Table_ID = DB.getSQLValue(this.get_TrxName(), "SELECT rt.AD_Table_ID FROM AD_Reference r INNER JOIN AD_Ref_Table rt ON (r.AD_Reference_ID=rt.AD_Reference_ID)  WHERE r.AD_Reference_ID=?", col.getAD_Reference_Value_ID())) > 0) {
            tabledir = MTable.get(this.getCtx(), AD_Table_ID);
            formatLine.setValue(col.getColumnName() + "_Reference");
            formatLine.setName("Referenced " + tabledir.getTableName());
            formatLine.setAD_Column_ID(col.getAD_Column_ID());
            String format_value = this.createFormat(tabledir);
            int embedded = this.m_formats.get(format_value).getEXP_Format_ID();
            formatLine.setType("R");
            formatLine.setEXP_EmbeddedFormat_ID(embedded);
            formatLine.saveEx();
            return formatLine.getEXP_FormatLine_ID();
        }
        if (DisplayType.isID(col.getAD_Reference_ID()) && !col.isKey() && 13 != col.getAD_Reference_ID() && 32 != col.getAD_Reference_ID()) {
            String tableName;
            String string = tableName = col.getColumnName().lastIndexOf("_ID") == -1 ? null : col.getColumnName().substring(0, col.getColumnName().lastIndexOf("_ID"));
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Table Name:" + tableName);
            }
            if (tableName == null) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Table Name: null");
                }
                return 0;
            }
            tabledir = MTable.get(this.getCtx(), tableName);
            if (tabledir == null) {
                return 0;
            }
            formatLine.setValue(tabledir.getTableName() + "_Reference");
            formatLine.setName("Referenced " + tabledir.getTableName());
            String format_value = this.createFormat(tabledir);
            int embedded = this.m_formats.get(format_value).getEXP_Format_ID();
            formatLine.setType("R");
            formatLine.setEXP_EmbeddedFormat_ID(embedded);
        }
        formatLine.setAD_Column_ID(col.getAD_Column_ID());
        formatLine.saveEx();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Export Format Line:" + formatLine.getName());
        }
        return formatLine.getEXP_FormatLine_ID();
    }
}

