/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.event.annotations;

import java.lang.reflect.Field;
import java.util.function.BiFunction;
import org.adempiere.base.Model;
import org.adempiere.base.event.EventHelper;
import org.adempiere.base.event.annotations.BaseEventHandler;
import org.adempiere.base.event.annotations.EventDelegate;
import org.adempiere.base.event.annotations.ModelEventDelegate;
import org.compiere.model.PO;
import org.osgi.service.event.Event;

public final class ModelEventHandler<T extends PO>
extends BaseEventHandler {
    private Class<T> modelClassType;
    private String tableName;
    private BiFunction<T, Event, ? extends ModelEventDelegate<T>> supplier;

    public ModelEventHandler(Class<T> modelClassType, Class<? extends ModelEventDelegate<T>> delegateClass, BiFunction<T, Event, ? extends ModelEventDelegate<T>> supplier) {
        super(delegateClass);
        this.supplier = supplier;
        this.modelClassType = modelClassType;
        this.findTableName();
    }

    private void findTableName() {
        try {
            Model model = this.modelClassType.getSuperclass().getAnnotation(Model.class);
            if (model != null) {
                this.tableName = model.table();
            } else {
                Field field = this.modelClassType.getField("Table_Name");
                this.tableName = (String)field.get(null);
            }
            this.setEventPropertyFilter("tableName", this.tableName);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleEvent(Event event) {
        PO po = EventHelper.getPO(event);
        if (po == null || this.modelClassType == null) {
            return;
        }
        if (!this.modelClassType.isAssignableFrom(po.getClass())) {
            return;
        }
        super.handleEvent(event);
    }

    @Override
    protected EventDelegate newEventDelegate(Event event) {
        PO po = EventHelper.getPO(event);
        return this.supplier.apply(po, event);
    }
}

