/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.ValueNamePair;

@Process
public class ColumnSync
extends SvrProcess {
    private int p_AD_Column_ID = 0;
    private Timestamp p_DateFrom = null;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            ProcessInfoParameter para = processInfoParameterArray[n2];
            switch (name = para.getParameterName()) {
                case "DateFrom": {
                    this.p_DateFrom = para.getParameterAsTimestamp();
                    break;
                }
                default: {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String whereClause;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Column_ID=" + this.p_AD_Column_ID);
        }
        if (this.p_AD_Column_ID == 0) {
            throw new AdempiereUserError("@No@ @AD_Column_ID@");
        }
        MColumn columnCalled = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        if (columnCalled.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Column_ID@ " + this.p_AD_Column_ID);
        }
        MTable table = new MTable(this.getCtx(), columnCalled.getAD_Table_ID(), this.get_TrxName());
        if (table.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @AD_Table_ID@ " + columnCalled.getAD_Table_ID());
        }
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        if (this.p_DateFrom == null) {
            whereClause = "AD_Column_ID=?";
            params.add(Integer.valueOf(this.p_AD_Column_ID));
        } else {
            whereClause = "(AD_Column_ID=? OR (AD_Table_ID=? AND Updated>?))";
            params.add(Integer.valueOf(this.p_AD_Column_ID));
            params.add(Integer.valueOf(table.getAD_Table_ID()));
            params.add(this.p_DateFrom);
        }
        StringBuilder allSql = new StringBuilder();
        List columns = new Query(this.getCtx(), "AD_Column", whereClause, this.get_TrxName()).setParameters(params).list();
        for (MColumn column : columns) {
            ResultSet rs;
            Connection conn;
            block35: {
                conn = null;
                rs = null;
                try {
                    boolean isNoTable;
                    conn = DB.getConnection();
                    DatabaseMetaData md = conn.getMetaData();
                    String catalog = DB.getDatabase().getCatalog();
                    String schema = DB.getDatabase().getSchema();
                    String tableName = table.getTableName();
                    if (md.storesUpperCaseIdentifiers()) {
                        tableName = tableName.toUpperCase();
                    } else if (md.storesLowerCaseIdentifiers()) {
                        tableName = tableName.toLowerCase();
                    }
                    int noColumns = 0;
                    Object sql = null;
                    rs = md.getColumns(catalog, schema, tableName, null);
                    while (rs.next()) {
                        ++noColumns;
                        String columnName = rs.getString("COLUMN_NAME");
                        if (!columnName.equalsIgnoreCase(column.getColumnName())) continue;
                        boolean notNull = rs.getInt("NULLABLE") == 0;
                        sql = column.getSQLModify(table, column.isMandatory() ^ notNull);
                        if (!DB.isOracle()) break;
                        int actualType = rs.getInt("DATA_TYPE");
                        if (actualType == 2005) {
                            if (!((String)sql).contains(" MODIFY " + column.getColumnName() + " CLOB")) break;
                            sql = ((String)sql).replaceFirst(" MODIFY " + column.getColumnName() + " CLOB", " MODIFY " + column.getColumnName());
                            break;
                        }
                        if (actualType != 2004 || !((String)sql).contains(" MODIFY " + column.getColumnName() + " BLOB")) break;
                        sql = ((String)sql).replaceFirst(" MODIFY " + column.getColumnName() + " BLOB", " MODIFY " + column.getColumnName());
                        break;
                    }
                    DB.close((ResultSet)rs);
                    rs = null;
                    boolean bl = isNoTable = noColumns == 0;
                    if (isNoTable) {
                        sql = table.getSQLCreate();
                    } else if (sql == null) {
                        sql = column.getSQLAdd(table);
                    }
                    if (isNoTable) {
                        MColumn[] cols;
                        MColumn[] mColumnArray = cols = table.getColumns(false);
                        int n = cols.length;
                        int n2 = 0;
                        while (n2 < n) {
                            MColumn col = mColumnArray[n2];
                            String fkConstraintSql = MColumn.getForeignKeyConstraintSql((DatabaseMetaData)md, (String)catalog, (String)schema, (String)tableName, (MTable)table, (MColumn)col, (boolean)false);
                            if (fkConstraintSql != null && fkConstraintSql.length() > 0) {
                                sql = (String)sql + fkConstraintSql;
                            }
                            ++n2;
                        }
                    } else {
                        String fkConstraintSql = MColumn.getForeignKeyConstraintSql((DatabaseMetaData)md, (String)catalog, (String)schema, (String)tableName, (MTable)table, (MColumn)column, (boolean)false);
                        if (fkConstraintSql != null && fkConstraintSql.length() > 0) {
                            sql = (String)sql + fkConstraintSql;
                        }
                    }
                    int no = 0;
                    if (((String)sql).indexOf("; ") == -1) {
                        no = DB.executeUpdate((String)sql, (boolean)false, (String)this.get_TrxName());
                        this.addLog(0, null, new BigDecimal(no), (String)sql);
                    } else {
                        String[] statements = ((String)sql).split("; ");
                        int i = 0;
                        while (i < statements.length) {
                            int count = DB.executeUpdateEx((String)statements[i], (String)this.get_TrxName());
                            this.addLog(0, null, new BigDecimal(count), statements[i]);
                            no += count;
                            ++i;
                        }
                    }
                    if (no == -1) {
                        StringBuilder msg = new StringBuilder("@Error@ ");
                        ValueNamePair pp = CLogger.retrieveError();
                        if (pp != null) {
                            msg = new StringBuilder(pp.getName()).append(" - ");
                        }
                        msg.append((String)sql);
                        throw new AdempiereUserError(msg.toString());
                    }
                    allSql.append((String)sql);
                    if (!isNoTable) break block35;
                }
                catch (Throwable throwable) {
                    DB.close(rs);
                    rs = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                DB.close((ResultSet)rs);
                rs = null;
                if (conn == null) break;
                try {
                    conn.close();
                }
                catch (Exception exception) {}
                break;
            }
            this.commitEx();
            DB.close((ResultSet)rs);
            rs = null;
            if (conn == null) continue;
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        return allSql.toString();
    }
}

