/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;

@Process
public class MatchPODelete
extends SvrProcess {
    private int p_M_MatchPO_ID = 0;

    protected void prepare() {
        this.p_M_MatchPO_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_MatchPO_ID=" + this.p_M_MatchPO_ID);
        }
        Object msg = "";
        MMatchPO po = new MMatchPO(this.getCtx(), this.p_M_MatchPO_ID, this.get_TrxName());
        if (po.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @M_MatchPO_ID@ " + this.p_M_MatchPO_ID);
        }
        int reversalId = po.getReversal_ID();
        if (!this.deleteMatchPO(po)) {
            return "@Error@";
        }
        msg = (String)msg + "@Deleted@";
        if (reversalId > 0) {
            MMatchPO porev = new MMatchPO(this.getCtx(), reversalId, this.get_TrxName());
            if (porev.get_ID() == 0) {
                throw new AdempiereUserError("@NotFound@ @M_MatchPO_ID@ " + reversalId);
            }
            if (!this.deleteMatchPO(porev)) {
                return "@Error@ @Reversal_ID@";
            }
            msg = (String)msg + " + @Deleted@ @Reversal_ID@";
        }
        return msg;
    }

    private boolean deleteMatchPO(MMatchPO po) {
        boolean isMatchReceipt;
        MOrderLine orderLine = null;
        boolean bl = isMatchReceipt = po.getM_InOutLine_ID() != 0;
        if (isMatchReceipt) {
            orderLine = new MOrderLine(this.getCtx(), po.getC_OrderLine_ID(), this.get_TrxName());
            orderLine.setQtyReserved(orderLine.getQtyReserved().add(po.getQty()));
        }
        if (po.delete(true)) {
            if (isMatchReceipt && !orderLine.save(this.get_TrxName())) {
                throw new AdempiereUserError("Delete MatchPO failed to restore PO's On Ordered Qty");
            }
            return true;
        }
        po.saveEx();
        return false;
    }
}

