/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MProcessPara;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

@Process
public class AllocationReset
extends SvrProcess {
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_C_AllocationHdr_ID = 0;
    private boolean p_AllAllocations = false;
    private Trx m_trx = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("prepare - " + String.valueOf(para[i]));
            }
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null || para[i].getParameter_To() != null) {
                if (name.equals("C_BP_Group_ID")) {
                    this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_AllocationHdr_ID")) {
                    this.p_C_AllocationHdr_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateAcct")) {
                    this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                    this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AllAllocations")) {
                    this.p_AllAllocations = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (!this.p_AllAllocations && this.getTable_ID() == 735 && this.getRecord_ID() > 0) {
            this.p_C_AllocationHdr_ID = this.getRecord_ID();
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", DateAcct= " + String.valueOf(this.p_DateAcct_From) + " - " + String.valueOf(this.p_DateAcct_To) + ", C_AllocationHdr_ID=" + this.p_C_AllocationHdr_ID + ", AllAllocations=" + this.p_AllAllocations);
        }
        if (this.p_C_AllocationHdr_ID == 0 && !this.p_AllAllocations) {
            throw new AdempiereUserError(Msg.parseTranslation((Properties)this.getCtx(), (String)"@Mandatory@: @C_AllocationHdr_ID@"));
        }
        this.m_trx = Trx.get((String)Trx.createTrxName((String)"AllocReset"), (boolean)true);
        this.m_trx.setDisplayName(((Object)((Object)this)).getClass().getName() + "_doIt");
        int count = 0;
        if (this.p_C_AllocationHdr_ID != 0) {
            block23: {
                try {
                    MAllocationHdr hdr = new MAllocationHdr(this.getCtx(), this.p_C_AllocationHdr_ID, this.m_trx.getTrxName());
                    if (this.delete(hdr)) {
                        break block23;
                    }
                    throw new AdempiereException("Cannot delete");
                }
                finally {
                    this.m_trx.close();
                }
            }
            StringBuilder msgreturn = new StringBuilder("@Deleted@ #").append(++count);
            return msgreturn.toString();
        }
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        StringBuilder where = new StringBuilder("EXISTS (SELECT * FROM C_AllocationLine al WHERE C_AllocationHdr.C_AllocationHdr_ID=al.C_AllocationHdr_ID");
        if (this.p_C_BPartner_ID != 0) {
            where.append(" AND al.C_BPartner_ID=?");
            params.add(Integer.valueOf(this.p_C_BPartner_ID));
        } else if (this.p_C_BP_Group_ID != 0) {
            where.append(" AND EXISTS (SELECT * FROM C_BPartner bp WHERE bp.C_BPartner_ID=al.C_BPartner_ID AND bp.C_BP_Group_ID=?)");
            params.add(Integer.valueOf(this.p_C_BP_Group_ID));
        } else {
            where.append(" AND AD_Client_ID=?");
            params.add(Integer.valueOf(this.getAD_Client_ID()));
        }
        if (this.p_DateAcct_From != null) {
            where.append(" AND TRUNC(C_AllocationHdr.DateAcct) >= ?");
            params.add(this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            where.append(" AND TRUNC(C_AllocationHdr.DateAcct) <= ?");
            params.add(this.p_DateAcct_To);
        }
        where.append(" AND al.C_CashLine_ID IS NULL)");
        where.append(" AND EXISTS (SELECT * FROM C_Period p").append(" INNER JOIN C_PeriodControl pc ON (p.C_Period_ID=pc.C_Period_ID AND pc.DocBaseType='CMA') ").append("WHERE C_AllocationHdr.DateAcct BETWEEN p.StartDate AND p.EndDate)");
        Throwable throwable = null;
        Object var5_8 = null;
        try (POResultSet pors = new Query(this.getCtx(), "C_AllocationHdr", where.toString(), this.get_TrxName()).setClient_ID().setParameters(params).scroll();){
            while (pors.hasNext()) {
                MAllocationHdr hdr = (MAllocationHdr)pors.next();
                if (!this.delete(hdr)) continue;
                ++count;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        StringBuilder msgreturn = new StringBuilder("@Deleted@ #").append(count);
        return msgreturn.toString();
    }

    private boolean delete(MAllocationHdr hdr) {
        boolean success = false;
        if (hdr.delete(true, this.m_trx.getTrxName())) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(hdr.toString());
            }
            success = true;
        }
        if (success) {
            success = this.m_trx.commit();
        } else {
            this.m_trx.rollback();
        }
        return success;
    }
}

