/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.InvoiceFullyMatchedException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

@Process
public class InvoiceCreateInOut
extends SvrProcess {
    public static final String PARAM_M_Warehouse_ID = "M_Warehouse_ID";
    private int p_M_Warehouse_ID = 0;
    private int p_C_Invoice_ID = 0;
    private MInOut m_inout = null;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals(PARAM_M_Warehouse_ID)) {
                    this.p_M_Warehouse_ID = para.getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
                }
            }
            ++n2;
        }
        this.p_C_Invoice_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Invoice_ID=" + this.p_C_Invoice_ID + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID);
        }
        if (this.p_C_Invoice_ID <= 0) {
            throw new FillMandatoryException(new String[]{"C_Invoice_ID"});
        }
        if (this.p_M_Warehouse_ID == 0) {
            throw new FillMandatoryException(new String[]{PARAM_M_Warehouse_ID});
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, null);
        if (invoice.get_ID() <= 0) {
            throw new AdempiereException("@NotFound@ @C_Invoice_ID@");
        }
        if (!"CO".equals(invoice.getDocStatus())) {
            throw new AdempiereException("@InvoiceCreateDocNotCompleted@");
        }
        MInvoiceLine[] mInvoiceLineArray = invoice.getLines(false);
        int n = mInvoiceLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceLine invoiceLine = mInvoiceLineArray[n2];
            this.createLine(invoice, invoiceLine);
            ++n2;
        }
        if (this.m_inout == null) {
            throw new InvoiceFullyMatchedException();
        }
        this.addLog(this.m_inout.getM_InOut_ID(), this.m_inout.getMovementDate(), null, this.m_inout.getDocumentNo(), this.m_inout.get_Table_ID(), this.m_inout.getM_InOut_ID());
        return this.m_inout.getDocumentNo();
    }

    private MInOut getCreateHeader(MInvoice invoice) {
        if (this.m_inout != null) {
            return this.m_inout;
        }
        this.m_inout = new MInOut(invoice, 0, null, this.p_M_Warehouse_ID);
        this.m_inout.saveEx();
        return this.m_inout;
    }

    private MInOutLine createLine(MInvoice invoice, MInvoiceLine invoiceLine) {
        BigDecimal qtyMatched = invoiceLine.getMatchedQty();
        BigDecimal qtyInvoiced = invoiceLine.getQtyInvoiced();
        BigDecimal qtyNotMatched = qtyInvoiced.subtract(qtyMatched);
        if (qtyNotMatched.signum() == 0) {
            return null;
        }
        MInOut inout = this.getCreateHeader(invoice);
        MInOutLine sLine = new MInOutLine(inout);
        sLine.setInvoiceLine(invoiceLine, 0, invoice.isSOTrx() ? qtyNotMatched : Env.ZERO);
        sLine.setQtyEntered(qtyNotMatched);
        sLine.setMovementQty(qtyNotMatched);
        if (invoice.isCreditMemo()) {
            sLine.setQtyEntered(sLine.getQtyEntered().negate());
            sLine.setMovementQty(sLine.getMovementQty().negate());
        }
        sLine.saveEx();
        invoiceLine.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        invoiceLine.saveEx();
        return sLine;
    }
}

