/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.compiere.model.MColumn;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Column;
import org.compiere.model.X_AD_Element;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ColumnElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String entitytype = this.getStringValue(element, "EntityType");
        if (this.isProcessElement(ctx.ctx, entitytype)) {
            boolean recreateColumn;
            if (this.isParentDefer(element, "AD_Table")) {
                element.defer = true;
                return;
            }
            List excludes = this.defaultExcludeList("AD_Column");
            String columnName = this.getStringValue(element, "ColumnName", excludes);
            MColumn mColumn = (MColumn)this.findPO(ctx, element);
            if (mColumn == null) {
                mColumn = new MColumn(ctx.ctx, 0, this.getTrxName(ctx));
            }
            mColumn.setColumnName(columnName);
            mColumn.setIsSyncDatabase(this.getStringValue(element, "IsSyncDatabase", excludes));
            PoFiller filler = new PoFiller(ctx, (PO)mColumn, element, (AbstractElementHandler)this);
            List notfounds = filler.autoFill(excludes);
            if (notfounds.size() > 0) {
                element.defer = true;
                element.unresolved = notfounds.toString();
                return;
            }
            if (!mColumn.is_new() && mColumn.is_ValueChanged("FieldLength") && mColumn.getFieldLength() < mColumn.get_ValueOldAsInt("FieldLength")) {
                mColumn.setFieldLength(mColumn.get_ValueOldAsInt("FieldLength"));
            }
            if (!mColumn.is_new() && !mColumn.is_Changed()) {
                boolean syncDatabase = "Y".equalsIgnoreCase(this.getStringValue(element, "IsSyncDatabase"));
                if (syncDatabase) {
                    this.deferFK(element, mColumn);
                    this.syncColumn(ctx, mColumn, "Sync", false);
                }
                return;
            }
            X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Column", 101);
            String action = null;
            if (!mColumn.is_new()) {
                this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Column", (PO)mColumn);
                action = "Update";
            } else {
                action = "New";
            }
            if (mColumn.getAD_Element_ID() == 0) {
                X_AD_Element adElement = new X_AD_Element(ctx.ctx, 0, this.getTrxName(ctx));
                adElement.setColumnName(mColumn.getColumnName());
                adElement.setEntityType(mColumn.getEntityType());
                adElement.setPrintName(mColumn.getColumnName());
                adElement.setName(mColumn.getColumnName());
                adElement.saveEx();
                X_AD_Package_Imp_Detail eleDetail = this.createImportDetail(ctx, "Element", "AD_Element", 276);
                this.logImportDetail(ctx, eleDetail, 1, mColumn.getColumnName(), adElement.getAD_Element_ID(), "New");
                mColumn.setAD_Element_ID(adElement.getAD_Element_ID());
            }
            boolean bl = recreateColumn = mColumn.is_new() || mColumn.is_ValueChanged("AD_Reference_ID") || mColumn.is_ValueChanged("FieldLength") || mColumn.is_ValueChanged("ColumnName") || mColumn.is_ValueChanged("FKConstraintName") || mColumn.is_ValueChanged("FKConstraintType") || mColumn.is_ValueChanged("IsMandatory");
            if (!mColumn.is_ValueChanged("AD_Reference_ID") && mColumn.is_ValueChanged("FieldLength") && DisplayType.isLOB((int)mColumn.getAD_Reference_ID())) {
                recreateColumn = false;
            }
            if (!recreateColumn) {
                String oldDefault = (String)mColumn.get_ValueOld("DefaultValue");
                String newDefault = mColumn.getDefaultValue();
                if (oldDefault != null && oldDefault.length() == 0) {
                    oldDefault = null;
                }
                if (newDefault != null && newDefault.length() == 0) {
                    newDefault = null;
                }
                if (oldDefault == null && newDefault != null || oldDefault != null && newDefault == null) {
                    recreateColumn = true;
                } else if (oldDefault != null && newDefault != null && !oldDefault.equals(newDefault)) {
                    recreateColumn = true;
                }
            }
            boolean syncDatabase = "Y".equalsIgnoreCase(this.getStringValue(element, "IsSyncDatabase"));
            if (recreateColumn && (mColumn.isVirtualColumn() || !syncDatabase)) {
                recreateColumn = false;
            }
            if (!mColumn.save(this.getTrxName(ctx))) {
                this.logImportDetail(ctx, impDetail, 0, mColumn.getName(), mColumn.get_ID(), action);
                throw new POSaveFailedException("Failed to save column " + mColumn.getName());
            }
            this.logImportDetail(ctx, impDetail, 1, mColumn.getName(), mColumn.get_ID(), action);
            element.recordId = mColumn.getAD_Column_ID();
            if (mColumn.isActive() && (recreateColumn || syncDatabase)) {
                this.deferFK(element, mColumn);
                this.syncColumn(ctx, mColumn, action, recreateColumn);
            }
        } else {
            element.skip = true;
        }
    }

    private void deferFK(Element element, MColumn mColumn) {
        try {
            String foreignTable = mColumn.getReferenceTableName();
            if (foreignTable != null && !"AD_Ref_List".equals(foreignTable)) {
                element.deferFKColumnID = mColumn.getAD_Column_ID();
            }
        }
        catch (AdempiereException adempiereException) {
            element.deferFKColumnID = mColumn.getAD_Column_ID();
        }
    }

    private void syncColumn(PIPOContext ctx, MColumn mColumn, String action, boolean recreateColumn) throws SAXException {
        int success = 0;
        MTable table = new MTable(ctx.ctx, mColumn.getAD_Table_ID(), this.getTrxName(ctx));
        if (!table.isView() && !mColumn.isVirtualColumn() && (success = this.createColumn(ctx, table, mColumn, recreateColumn)) != 0) {
            X_AD_Package_Imp_Detail dbDetail = this.createImportDetail(ctx, "dbColumn", "AD_Column", 101);
            if (success == 1) {
                this.logImportDetail(ctx, dbDetail, 1, mColumn.getColumnName(), mColumn.get_ID(), action);
            } else {
                this.logImportDetail(ctx, dbDetail, 0, mColumn.getColumnName(), mColumn.get_ID(), action);
                throw new DatabaseAccessException("Failed to create column or related constraint for " + mColumn.getColumnName());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int createColumn(PIPOContext ctx, MTable table, MColumn column, boolean doAlter) {
        ResultSet rsc;
        ResultSet rst;
        block25: {
            block26: {
                block24: {
                    block23: {
                        String sql = null;
                        rst = null;
                        rsc = null;
                        Connection conn = null;
                        Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)true);
                        try {
                            block28: {
                                block29: {
                                    String columnName;
                                    String tableName;
                                    String schema;
                                    String catalog;
                                    DatabaseMetaData md;
                                    block27: {
                                        conn = trx.getConnection();
                                        md = conn.getMetaData();
                                        catalog = DB.getDatabase().getCatalog();
                                        schema = DB.getDatabase().getSchema();
                                        tableName = table.getTableName();
                                        columnName = column.getColumnName();
                                        if (md.storesUpperCaseIdentifiers()) {
                                            tableName = tableName.toUpperCase();
                                            columnName = columnName.toUpperCase();
                                        } else if (md.storesLowerCaseIdentifiers()) {
                                            tableName = tableName.toLowerCase();
                                            columnName = columnName.toLowerCase();
                                        }
                                        rst = md.getTables(catalog, schema, tableName, new String[]{"TABLE"});
                                        if (rst.next()) break block27;
                                        sql = table.getSQLCreate();
                                        break block28;
                                    }
                                    rsc = md.getColumns(catalog, schema, tableName, columnName);
                                    if (!rsc.next()) break block29;
                                    if (!doAlter) break block28;
                                    boolean notNull = rsc.getInt("NULLABLE") == 0;
                                    sql = column.getSQLModify(table, column.isMandatory() ^ notNull);
                                    if (!DB.isOracle()) break block28;
                                    int actualType = rsc.getInt("DATA_TYPE");
                                    if (actualType == 2005) {
                                        if (sql.contains(" MODIFY " + column.getColumnName() + " CLOB")) {
                                            sql = sql.replaceFirst(" MODIFY " + column.getColumnName() + " CLOB", " MODIFY " + column.getColumnName());
                                        }
                                        break block28;
                                    } else if (actualType == 2004 && sql.contains(" MODIFY " + column.getColumnName() + " BLOB")) {
                                        sql = sql.replaceFirst(" MODIFY " + column.getColumnName() + " BLOB", " MODIFY " + column.getColumnName());
                                    }
                                    break block28;
                                }
                                sql = column.getSQLAdd(table);
                            }
                            if (sql != null && sql.trim().length() > 0) {
                                this.log.info(sql);
                                if (MSysConfig.getBooleanValue((String)"2PACK_COMMIT_DDL", (boolean)false) && !trx.commit()) {
                                    DB.close((ResultSet)rsc);
                                    rsc = null;
                                    break block23;
                                }
                                if (sql.indexOf("; ") == -1) {
                                    int ret = DB.executeUpdate((String)sql, (boolean)false, (String)trx.getTrxName());
                                    if (ret == -1) {
                                        DB.close((ResultSet)rsc);
                                        break block24;
                                    }
                                } else {
                                    String[] statements = sql.split("; ");
                                    int i = 0;
                                    while (i < statements.length) {
                                        int ret;
                                        if (!"null".equals(statements[i]) && (ret = DB.executeUpdate((String)statements[i], (boolean)false, (String)trx.getTrxName())) == -1) {
                                            DB.close((ResultSet)rsc);
                                            rsc = null;
                                            DB.close((ResultSet)rst);
                                            return -1;
                                        }
                                        ++i;
                                    }
                                }
                                if (MSysConfig.getBooleanValue((String)"2PACK_COMMIT_DDL", (boolean)false)) {
                                    trx.commit(true);
                                }
                                break block25;
                            }
                            DB.close((ResultSet)rsc);
                            break block26;
                        }
                        catch (SQLException e) {
                            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                            trx.rollback();
                            return -1;
                        }
                    }
                    DB.close((ResultSet)rst);
                    return -1;
                }
                rsc = null;
                DB.close((ResultSet)rst);
                return -1;
            }
            rsc = null;
            DB.close((ResultSet)rst);
            return 0;
            finally {
                DB.close(rsc);
                rsc = null;
                DB.close(rst);
                rst = null;
            }
        }
        DB.close((ResultSet)rsc);
        rsc = null;
        DB.close((ResultSet)rst);
        return 1;
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        int AD_Column_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Column_ID");
        if (ctx.packOut.isExported("AD_Column_ID|" + AD_Column_ID)) {
            return;
        }
        AttributesImpl atts = new AttributesImpl();
        X_AD_Column m_Column = new X_AD_Column(ctx.ctx, AD_Column_ID, this.getTrxName(ctx));
        if (!this.isPackOutElement(ctx, (PO)m_Column)) {
            return;
        }
        this.verifyPackOutRequirement((PO)m_Column);
        this.addTypeName(atts, "table");
        document.startElement("", "", "AD_Column", atts);
        this.createColumnBinding(ctx, document, m_Column);
        document.endElement("", "", "AD_Column");
    }

    private void createColumnBinding(PIPOContext ctx, TransformerHandler document, X_AD_Column m_Column) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Column);
        List excludes = this.defaultExcludeList("AD_Column");
        if (m_Column.getAD_Column_ID() <= 999999) {
            filler.add("AD_Column_ID", new AttributesImpl());
        }
        filler.addString("IsSyncDatabase", "Y", new AttributesImpl());
        filler.addTableReference("AD_Table_ID", "AD_Table", new AttributesImpl());
        filler.addTableReference("AD_Reference_Value_ID", "AD_Reference", new AttributesImpl());
        excludes.add("IsSyncDatabase");
        excludes.add("AD_Table_ID");
        excludes.add("AD_Reference_Value_ID");
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Column_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Column_ID");
    }
}

