/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDistributionRun;
import org.compiere.model.MDistributionRunDetail;
import org.compiere.model.MDistributionRunLine;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

@Process
public class DistributionRun
extends SvrProcess {
    private int p_M_DistributionRun_ID = 0;
    private Timestamp p_DatePromised = null;
    private int p_C_DocType_ID = 0;
    private boolean p_IsTest = false;
    private int p_M_Warehouse_ID = 0;
    private boolean p_ConsolidateDocument = false;
    private int p_M_DistributionList_ID = 0;
    private boolean p_BasedInDamnd = false;
    private MDistributionRun m_run = null;
    private MDistributionRunLine[] m_runLines = null;
    private MDistributionRunDetail[] m_details = null;
    private Timestamp m_DateOrdered = null;
    private int m_counter = 0;
    private MDocType m_docType = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_DocType_ID")) {
                    this.p_C_DocType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                    this.m_docType = new MDocType(this.getCtx(), this.p_C_DocType_ID, this.get_TrxName());
                } else if (name.equals("DatePromised")) {
                    this.p_DatePromised = (Timestamp)para[i].getParameter();
                } else if (name.equals("IsTest")) {
                    this.p_IsTest = "Y".equals(para[i].getParameter());
                } else if (this.m_docType.getDocBaseType().equals("DOO") && name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (this.m_docType.getDocBaseType().equals("DOO") && name.equals("ConsolidateDocument")) {
                    this.p_ConsolidateDocument = "Y".equals((String)para[i].getParameter());
                } else if (this.m_docType.getDocBaseType().equals("DOO") && name.equals("M_DistributionList_ID")) {
                    this.p_M_DistributionList_ID = para[i].getParameterAsInt();
                } else if (this.m_docType.getDocBaseType().equals("DOO") && name.equals("IsRequiredDRP")) {
                    this.p_BasedInDamnd = "Y".equals((String)para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_M_DistributionRun_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + ", C_DocType_ID=" + this.p_C_DocType_ID + ", DatePromised=" + String.valueOf(this.p_DatePromised) + ", Test=" + this.p_IsTest);
        }
        if (this.p_M_DistributionRun_ID == 0) {
            throw new IllegalArgumentException("No Distribution Run ID");
        }
        this.m_run = new MDistributionRun(this.getCtx(), this.p_M_DistributionRun_ID, this.get_TrxName());
        if (this.m_run.get_ID() == 0) {
            throw new Exception("Distribution Run not found -  M_DistributionRun_ID=" + this.p_M_DistributionRun_ID);
        }
        this.m_runLines = this.m_run.getLines(true);
        if (this.m_runLines == null || this.m_runLines.length == 0) {
            throw new Exception("No active, non-zero Distribution Run Lines found");
        }
        if (this.p_C_DocType_ID == 0) {
            throw new IllegalArgumentException("No Document Type ID");
        }
        this.m_docType = new MDocType(this.getCtx(), this.p_C_DocType_ID, null);
        if (this.m_docType.get_ID() == 0) {
            throw new Exception("Document Type not found -  C_DocType_ID=" + this.p_C_DocType_ID);
        }
        this.m_DateOrdered = new Timestamp(System.currentTimeMillis());
        if (this.p_DatePromised == null) {
            this.p_DatePromised = this.m_DateOrdered;
        }
        if (this.m_docType.getDocBaseType().equals("DOO") && this.p_M_Warehouse_ID > 0 ? (this.p_BasedInDamnd ? this.insertDetailsDistributionDemand() == 0 : this.insertDetailsDistribution() == 0) : this.insertDetails() == 0) {
            throw new Exception("No Lines");
        }
        this.m_details = MDistributionRunDetail.get((Properties)this.getCtx(), (int)this.p_M_DistributionRun_ID, (boolean)false, (String)this.get_TrxName());
        this.addAllocations();
        int loops = 0;
        while (!this.isAllocationEqTotal()) {
            this.adjustAllocation();
            this.addAllocations();
            if (++loops <= 10) continue;
            throw new Exception("Loop detected - more than 10 Allocation attempts");
        }
        this.m_details = MDistributionRunDetail.get((Properties)this.getCtx(), (int)this.p_M_DistributionRun_ID, (boolean)true, (String)this.get_TrxName());
        if (this.m_docType.getDocBaseType().equals("DOO")) {
            this.distributionOrders();
        } else {
            this.createOrders();
        }
        StringBuilder msgreturn = new StringBuilder("@Created@ #").append(this.m_counter);
        return msgreturn.toString();
    }

    private int insertDetails() {
        String sql = "UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL AND M_DistributionRun_ID=?";
        int no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.p_M_DistributionRun_ID}, (String)this.get_TrxName());
        sql = "UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL";
        no = DB.executeUpdateEx((String)sql, (String)this.get_TrxName());
        sql = "UPDATE M_DistributionList l SET RatioTotal = (SELECT SUM(Ratio) FROM M_DistributionListLine ll  WHERE l.M_DistributionList_ID=ll.M_DistributionList_ID) WHERE EXISTS (SELECT * FROM M_DistributionRunLine rl WHERE l.M_DistributionList_ID=rl.M_DistributionList_ID AND rl.M_DistributionRun_ID=?)";
        no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.p_M_DistributionRun_ID}, (String)this.get_TrxName());
        sql = "DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=?";
        no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.p_M_DistributionRun_ID}, (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("insertDetails - deleted #" + no);
        }
        sql = "INSERT INTO T_DistributionRunDetail (M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,Ratio, MinQty, Qty) SELECT rl.M_DistributionRun_ID, rl.M_DistributionRunLine_ID,ll.M_DistributionList_ID, ll.M_DistributionListLine_ID, rl.AD_Client_ID,rl.AD_Org_ID, rl.IsActive, rl.Created,rl.CreatedBy, rl.Updated,rl.UpdatedBy,ll.C_BPartner_ID, ll.C_BPartner_Location_ID, rl.M_Product_ID, ll.Ratio, CASE WHEN rl.MinQty > ll.MinQty THEN rl.MinQty ELSE ll.MinQty END, (ll.Ratio/l.RatioTotal*rl.TotalQty)FROM M_DistributionRunLine rl INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) WHERE rl.M_DistributionRun_ID=? AND l.RatioTotal<>0 AND rl.IsActive='Y' AND ll.IsActive='Y'";
        no = DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.p_M_DistributionRun_ID}, (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("inserted #" + no);
        }
        return no;
    }

    private void addAllocations() {
        MDistributionRunLine runLine;
        int j = 0;
        while (j < this.m_runLines.length) {
            runLine = this.m_runLines[j];
            runLine.resetCalculations();
            ++j;
        }
        int i = 0;
        while (i < this.m_details.length) {
            MDistributionRunDetail detail = this.m_details[i];
            int j2 = 0;
            while (j2 < this.m_runLines.length) {
                MDistributionRunLine runLine2 = this.m_runLines[j2];
                if (runLine2.getM_DistributionRunLine_ID() == detail.getM_DistributionRunLine_ID()) {
                    detail.round(runLine2.getUOMPrecision());
                    runLine2.addActualMin(detail.getMinQty());
                    runLine2.addActualQty(detail.getQty());
                    runLine2.addActualAllocation(detail.getActualAllocation());
                    runLine2.setMaxAllocation(detail.getActualAllocation(), false);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("RunLine=" + runLine2.getLine() + ": BP_ID=" + detail.getC_BPartner_ID() + ", Min=" + String.valueOf(detail.getMinQty()) + ", Qty=" + String.valueOf(detail.getQty()) + ", Allocation=" + String.valueOf(detail.getActualAllocation()));
                    }
                }
                ++j2;
            }
            ++i;
        }
        j = 0;
        while (j < this.m_runLines.length) {
            runLine = this.m_runLines[j];
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Run - " + runLine.getInfo());
            }
            ++j;
        }
    }

    private boolean isAllocationEqTotal() throws Exception {
        boolean allocationEqTotal = true;
        int j = 0;
        while (j < this.m_runLines.length) {
            MDistributionRunLine runLine = this.m_runLines[j];
            if (runLine.isActualMinGtTotal()) {
                StringBuilder msg = new StringBuilder("Line ").append(runLine.getLine()).append(" Sum of Min Qty=").append(runLine.getActualMin()).append(" is greater than Total Qty=").append(runLine.getTotalQty());
                throw new Exception(msg.toString());
            }
            if (allocationEqTotal && !runLine.isActualAllocationEqTotal()) {
                allocationEqTotal = false;
            }
            ++j;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("=" + allocationEqTotal);
        }
        return allocationEqTotal;
    }

    private void adjustAllocation() throws Exception {
        int j = 0;
        while (j < this.m_runLines.length) {
            this.adjustAllocation(j);
            ++j;
        }
    }

    private void adjustAllocation(int index) throws Exception {
        MDistributionRunDetail detail;
        boolean adjustBiggest;
        MDistributionRunLine runLine = this.m_runLines[index];
        BigDecimal difference = runLine.getActualAllocationDiff();
        if (difference.compareTo(Env.ZERO) == 0) {
            return;
        }
        boolean bl = adjustBiggest = difference.abs().compareTo(Env.ONE) <= 0 || difference.abs().compareTo(runLine.getLastDifference().abs()) == 0;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Line=" + runLine.getLine() + ", Diff=" + String.valueOf(difference) + ", Adjust=" + adjustBiggest);
        }
        if (adjustBiggest) {
            int i = 0;
            while (i < this.m_details.length) {
                MDistributionRunDetail detail2 = this.m_details[i];
                if (runLine.getM_DistributionRunLine_ID() == detail2.getM_DistributionRunLine_ID()) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Biggest - DetailAllocation=" + String.valueOf(detail2.getActualAllocation()) + ", MaxAllocation=" + String.valueOf(runLine.getMaxAllocation()) + ", Qty Difference=" + String.valueOf(difference));
                    }
                    if (detail2.getActualAllocation().compareTo(runLine.getMaxAllocation()) == 0 && detail2.isCanAdjust()) {
                        detail2.adjustQty(difference);
                        detail2.saveEx();
                        return;
                    }
                }
                ++i;
            }
            StringBuilder msgexc = new StringBuilder("Cannot adjust Difference = ").append(difference).append(" - You need to change Total Qty or Min Qty");
            throw new Exception(msgexc.toString());
        }
        BigDecimal ratioTotal = Env.ZERO;
        int i = 0;
        while (i < this.m_details.length) {
            detail = this.m_details[i];
            if (runLine.getM_DistributionRunLine_ID() == detail.getM_DistributionRunLine_ID() && detail.isCanAdjust()) {
                ratioTotal = ratioTotal.add(detail.getRatio());
            }
            ++i;
        }
        if (ratioTotal.compareTo(Env.ZERO) == 0) {
            StringBuilder msgexc = new StringBuilder("Cannot distribute Difference = ").append(difference).append(" - You need to change Total Qty or Min Qty");
            throw new Exception(msgexc.toString());
        }
        i = 0;
        while (i < this.m_details.length) {
            detail = this.m_details[i];
            if (runLine.getM_DistributionRunLine_ID() == detail.getM_DistributionRunLine_ID() && detail.isCanAdjust()) {
                BigDecimal diffRatio = detail.getRatio().multiply(difference).divide(ratioTotal, RoundingMode.HALF_UP);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Detail=" + detail.toString() + ", Allocation=" + String.valueOf(detail.getActualAllocation()) + ", DiffRatio=" + String.valueOf(diffRatio));
                }
                detail.adjustQty(diffRatio);
                detail.saveEx();
            }
            ++i;
        }
        runLine.setLastDifference(difference);
    }

    private boolean createOrders() {
        MBPartner runBPartner;
        int runAD_Org_ID = this.m_run.getAD_Org_ID();
        if (runAD_Org_ID == 0) {
            runAD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx());
        }
        MOrg runOrg = MOrg.get((Properties)this.getCtx(), (int)runAD_Org_ID);
        int runC_BPartner_ID = runOrg.getLinkedC_BPartner_ID(this.get_TrxName());
        boolean counter = !this.m_run.isCreateSingleOrder() && runC_BPartner_ID > 0 && !this.m_docType.isSOTrx();
        MBPartner mBPartner = runBPartner = counter ? new MBPartner(this.getCtx(), runC_BPartner_ID, this.get_TrxName()) : null;
        if (!counter || runBPartner == null || runBPartner.get_ID() != runC_BPartner_ID) {
            counter = false;
        }
        if (counter && this.log.isLoggable(Level.INFO)) {
            this.log.info("RunBP=" + String.valueOf(runBPartner) + " - " + String.valueOf(this.m_docType));
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Single=" + this.m_run.isCreateSingleOrder() + " - " + String.valueOf(this.m_docType) + ",SO=" + this.m_docType.isSOTrx());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Counter=" + counter + ",C_BPartner_ID=" + runC_BPartner_ID + "," + String.valueOf(runBPartner));
        }
        MBPartner bp = null;
        MOrder singleOrder = null;
        MProduct product = null;
        if (this.m_run.isCreateSingleOrder()) {
            bp = new MBPartner(this.getCtx(), this.m_run.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new IllegalArgumentException("Business Partner not found - C_BPartner_ID=" + this.m_run.getC_BPartner_ID());
            }
            if (!this.p_IsTest) {
                singleOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
                singleOrder.setC_DocTypeTarget_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setIsSOTrx(this.m_docType.isSOTrx());
                singleOrder.setBPartner(bp);
                if (this.m_run.getC_BPartner_Location_ID() != 0) {
                    singleOrder.setC_BPartner_Location_ID(this.m_run.getC_BPartner_Location_ID());
                }
                singleOrder.setDateOrdered(this.m_DateOrdered);
                singleOrder.setDatePromised(this.p_DatePromised);
                if (!singleOrder.save()) {
                    this.log.log(Level.SEVERE, "Order not saved");
                    return false;
                }
                ++this.m_counter;
            }
        }
        int lastC_BPartner_ID = 0;
        int lastC_BPartner_Location_ID = 0;
        MOrder order = null;
        int i = 0;
        while (i < this.m_details.length) {
            MDistributionRunDetail detail = this.m_details[i];
            if (this.m_run.isCreateSingleOrder()) {
                order = singleOrder;
            } else if (lastC_BPartner_ID != detail.getC_BPartner_ID() || lastC_BPartner_Location_ID != detail.getC_BPartner_Location_ID()) {
                order = null;
            }
            lastC_BPartner_ID = detail.getC_BPartner_ID();
            lastC_BPartner_Location_ID = detail.getC_BPartner_Location_ID();
            if (order == null) {
                bp = new MBPartner(this.getCtx(), detail.getC_BPartner_ID(), this.get_TrxName());
                if (!this.p_IsTest) {
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setC_DocTypeTarget_ID(this.m_docType.getC_DocType_ID());
                    order.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                    order.setIsSOTrx(this.m_docType.isSOTrx());
                    if (counter && bp.getAD_OrgBP_ID() > 0) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("Counter - From_BPOrg=" + bp.getAD_OrgBP_ID() + "-" + String.valueOf(bp) + ", To_BP=" + String.valueOf(runBPartner));
                        }
                        order.setAD_Org_ID(bp.getAD_OrgBP_ID());
                        MOrgInfo oi = MOrgInfo.get((Properties)this.getCtx(), (int)bp.getAD_OrgBP_ID(), (String)this.get_TrxName());
                        if (oi.getM_Warehouse_ID() > 0) {
                            order.setM_Warehouse_ID(oi.getM_Warehouse_ID());
                        }
                        order.setBPartner(runBPartner);
                    } else {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("From_Org=" + runAD_Org_ID + ", To_BP=" + String.valueOf(bp));
                        }
                        order.setAD_Org_ID(runAD_Org_ID);
                        order.setBPartner(bp);
                        if (detail.getC_BPartner_Location_ID() != 0) {
                            order.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                        }
                    }
                    order.setDateOrdered(this.m_DateOrdered);
                    order.setDatePromised(this.p_DatePromised);
                    if (!order.save()) {
                        this.log.log(Level.SEVERE, "Order not saved");
                        return false;
                    }
                }
            }
            if (product == null || product.getM_Product_ID() != detail.getM_Product_ID()) {
                product = MProduct.get((Properties)this.getCtx(), (int)detail.getM_Product_ID());
            }
            if (this.p_IsTest) {
                StringBuilder msglog = new StringBuilder().append(bp.getName()).append(" - ").append(product.getName());
                this.addLog(0, null, detail.getActualAllocation(), msglog.toString());
            } else {
                MOrderLine line = new MOrderLine(order);
                if (!counter || bp.getAD_OrgBP_ID() <= 0) {
                    line.setC_BPartner_ID(detail.getC_BPartner_ID());
                    if (detail.getC_BPartner_Location_ID() != 0) {
                        line.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                    }
                }
                line.setProduct(product);
                line.setQty(detail.getActualAllocation());
                line.setPrice();
                if (!line.save()) {
                    this.log.log(Level.SEVERE, "OrderLine not saved");
                    return false;
                }
                StringBuilder msglog = new StringBuilder().append(order.getDocumentNo()).append(": ").append(bp.getName()).append(" - ").append(product.getName());
                this.addLog(0, null, detail.getActualAllocation(), msglog.toString());
            }
            ++i;
        }
        order = null;
        return true;
    }

    private int insertDetailsDistributionDemand() {
        StringBuilder sql = new StringBuilder("UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=").append(this.p_M_DistributionRun_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("insertDetails - deleted #" + no);
        }
        sql = new StringBuilder("INSERT INTO T_DistributionRunDetail ").append("(M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,").append("AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,").append("C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,").append("Ratio, MinQty, Qty) ").append("SELECT MAX(rl.M_DistributionRun_ID), MAX(rl.M_DistributionRunLine_ID),MAX(ll.M_DistributionList_ID), MAX(ll.M_DistributionListLine_ID), ").append("MAX(rl.AD_Client_ID),MAX(rl.AD_Org_ID), MAX(rl.IsActive), MAX(rl.Created),MAX(rl.CreatedBy), MAX(rl.Updated),MAX(rl.UpdatedBy), ").append("MAX(ll.C_BPartner_ID), MAX(ll.C_BPartner_Location_ID), MAX(rl.M_Product_ID),").append("COALESCE (SUM(ol.QtyOrdered-ol.QtyDelivered-TargetQty), 0) , ").append(" 0 , 0 FROM M_DistributionRunLine rl ").append("INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) ").append("INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) ").append("INNER JOIN DD_Order o ON (o.C_BPartner_ID=ll.C_BPartner_ID AND o.DocStatus IN ('DR','IN')) ").append("INNER JOIN DD_OrderLine ol ON (ol.DD_Order_ID=o.DD_Order_ID AND ol.M_Product_ID=rl.M_Product_ID) ").append("INNER JOIN M_Locator loc ON (loc.M_Locator_ID=ol.M_Locator_ID AND loc.M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(") ").append("WHERE rl.M_DistributionRun_ID=").append(this.p_M_DistributionRun_ID).append(" AND rl.IsActive='Y' AND ll.IsActive='Y' AND ol.DatePromised <= ").append(DB.TO_DATE((Timestamp)this.p_DatePromised)).append(" GROUP BY o.M_Shipper_ID , ll.C_BPartner_ID, ol.M_Product_ID");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        List records = new Query(this.getCtx(), "T_DistributionRunDetail", "M_DistributionRun_ID=?", this.get_TrxName()).setParameters(new Object[]{this.p_M_DistributionRun_ID}).list();
        for (MDistributionRunDetail record : records) {
            MDistributionRunLine drl = (MDistributionRunLine)MTable.get((Properties)this.getCtx(), (int)713).getPO(record.getM_DistributionRunLine_ID(), this.get_TrxName());
            MProduct product = MProduct.get((Properties)this.getCtx(), (int)record.getM_Product_ID());
            BigDecimal ration = record.getRatio();
            BigDecimal totalration = this.getQtyDemand(record.getM_Product_ID());
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Value:" + product.getValue());
                this.log.info("Product:" + product.getName());
                this.log.info("Qty To Deliver:" + String.valueOf(record.getRatio()));
                this.log.info("Qty Target:" + String.valueOf(record.getMinQty()));
                this.log.info("Qty Total Available:" + String.valueOf(drl.getTotalQty()));
                this.log.info("Qty Total Demand:" + String.valueOf(totalration));
            }
            BigDecimal factor = ration.divide(totalration, 12, RoundingMode.HALF_UP);
            record.setQty(drl.getTotalQty().multiply(factor));
            record.saveEx();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("inserted #" + no);
        }
        return no;
    }

    private BigDecimal getQtyDemand(int M_Product_ID) {
        String sql = "SELECT SUM (QtyOrdered-QtyDelivered-TargetQty) FROM DD_OrderLine ol INNER JOIN M_Locator l ON (l.M_Locator_ID=ol.M_Locator_ID) INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID)  WHERE o.DocStatus IN ('DR','IN') AND ol.DatePromised <= ? AND l.M_Warehouse_ID=? AND ol.M_Product_ID=? GROUP BY M_Product_ID, l.M_Warehouse_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setTimestamp(1, this.p_DatePromised);
            pstmt.setInt(2, this.p_M_Warehouse_ID);
            pstmt.setInt(3, M_Product_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                BigDecimal bigDecimal = rs.getBigDecimal(1);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return bigDecimal;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "doIt - " + sql, (Throwable)e);
            BigDecimal bigDecimal = Env.ZERO;
            return bigDecimal;
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return Env.ZERO;
    }

    private int insertDetailsDistribution() {
        StringBuilder sql = new StringBuilder("UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL");
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        sql = new StringBuilder("DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=").append(this.p_M_DistributionRun_ID);
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("insertDetails - deleted #" + no);
        }
        sql = new StringBuilder("INSERT INTO T_DistributionRunDetail ").append("(M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,").append("AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,").append("C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,").append("Ratio, MinQty, Qty) ").append("SELECT rl.M_DistributionRun_ID, rl.M_DistributionRunLine_ID,ll.M_DistributionList_ID, ll.M_DistributionListLine_ID, ").append("rl.AD_Client_ID,rl.AD_Org_ID, rl.IsActive, rl.Created,rl.CreatedBy, rl.Updated,rl.UpdatedBy, ").append("ll.C_BPartner_ID, ll.C_BPartner_Location_ID, rl.M_Product_ID, 0 , ").append("ol.TargetQty AS MinQty , 0 FROM M_DistributionRunLine rl ").append("INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) ").append("INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) ").append("INNER JOIN DD_Order o ON (o.C_BPartner_ID=ll.C_BPartner_ID) ").append("INNER JOIN DD_OrderLine ol ON (ol.DD_Order_ID=o.DD_Order_ID AND ol.M_Product_ID=rl.M_Product_ID) AND ol.DatePromised").append("<=").append(DB.TO_DATE((Timestamp)this.p_DatePromised)).append(" INNER JOIN M_Locator loc ON (loc.M_Locator_ID=ol.M_Locator_ID AND loc.M_Warehouse_ID=").append(this.p_M_Warehouse_ID).append(") ").append(" WHERE rl.M_DistributionRun_ID=").append(this.p_M_DistributionRun_ID).append(" AND l.RatioTotal<>0 AND rl.IsActive='Y' AND ll.IsActive='Y'");
        no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        Query query = MTable.get((Properties)this.getCtx(), (int)714).createQuery("M_DistributionRun_ID=?", this.get_TrxName());
        query.setParameters(new Object[]{this.p_M_DistributionRun_ID});
        List records = query.list();
        for (MDistributionRunDetail record : records) {
            BigDecimal total_ration = DB.getSQLValueBD((String)this.get_TrxName(), (String)"SELECT SUM(Ratio) FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=? AND M_Product_ID=? GROUP BY  M_Product_ID", (Object[])new Object[]{this.p_M_DistributionRun_ID, record.getM_Product_ID()});
            MDistributionRunLine drl = (MDistributionRunLine)MTable.get((Properties)this.getCtx(), (int)713).getPO(record.getM_DistributionRunLine_ID(), this.get_TrxName());
            BigDecimal ration = record.getRatio();
            BigDecimal factor = ration.divide(total_ration, RoundingMode.HALF_UP);
            record.setQty(factor.multiply(drl.getTotalQty()));
            record.saveEx();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("inserted #" + no);
        }
        return no;
    }

    private boolean distributionOrders() {
        MBPartner runBPartner;
        if (this.p_BasedInDamnd) {
            int M_Warehouse_ID = 0;
            if (this.p_M_Warehouse_ID <= 0) {
                MOrgInfo oi_source = MOrgInfo.get((Properties)this.getCtx(), (int)this.m_run.getAD_Org_ID(), (String)this.get_TrxName());
                MWarehouse m_source = MWarehouse.get((Properties)this.getCtx(), (int)oi_source.getM_Warehouse_ID());
                if (m_source == null) {
                    throw new AdempiereException("Do not exist Defautl Warehouse Source");
                }
                M_Warehouse_ID = m_source.getM_Warehouse_ID();
            } else {
                M_Warehouse_ID = this.p_M_Warehouse_ID;
            }
            int i = 0;
            while (i < this.m_details.length) {
                MDistributionRunDetail detail = this.m_details[i];
                Object sql = "SELECT * FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID)  INNER JOIN M_Locator l ON (l.M_Locator_ID=ol.M_Locator_ID) ";
                sql = (String)sql + " WHERE o.DocStatus IN ('DR','IN') AND o.C_BPartner_ID = ? AND M_Product_ID=? AND  l.M_Warehouse_ID=?  AND ol.DatePromised <=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement((String)((String)sql).toString(), (String)this.get_TrxName());
                        pstmt.setInt(1, detail.getC_BPartner_ID());
                        pstmt.setInt(2, detail.getM_Product_ID());
                        pstmt.setInt(3, M_Warehouse_ID);
                        pstmt.setTimestamp(4, this.p_DatePromised);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            MDDOrderLine line = new MDDOrderLine(this.getCtx(), rs, this.get_TrxName());
                            line.setM_Product_ID(detail.getM_Product_ID());
                            line.setConfirmedQty(line.getTargetQty().add(detail.getActualAllocation()));
                            if (this.p_M_Warehouse_ID > 0) {
                                line.setDescription(Msg.translate((Properties)this.getCtx(), (String)"PlannedQty"));
                            } else {
                                line.setDescription(this.m_run.getName());
                            }
                            line.saveEx();
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "doIt - " + (String)sql, (Throwable)e);
                        DB.close(rs, (Statement)pstmt);
                        rs = null;
                        pstmt = null;
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                ++i;
            }
            return true;
        }
        int runAD_Org_ID = this.m_run.getAD_Org_ID();
        if (runAD_Org_ID == 0) {
            runAD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx());
        }
        MOrg runOrg = MOrg.get((Properties)this.getCtx(), (int)runAD_Org_ID);
        int runC_BPartner_ID = runOrg.getLinkedC_BPartner_ID(this.get_TrxName());
        boolean counter = !this.m_run.isCreateSingleOrder() && runC_BPartner_ID > 0 && !this.m_docType.isSOTrx();
        MBPartner mBPartner = runBPartner = counter ? new MBPartner(this.getCtx(), runC_BPartner_ID, this.get_TrxName()) : null;
        if (!counter || runBPartner == null || runBPartner.get_ID() != runC_BPartner_ID) {
            counter = false;
        }
        if (counter && this.log.isLoggable(Level.INFO)) {
            this.log.info("RunBP=" + String.valueOf(runBPartner) + " - " + String.valueOf(this.m_docType));
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Single=" + this.m_run.isCreateSingleOrder() + " - " + String.valueOf(this.m_docType) + ",SO=" + this.m_docType.isSOTrx());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Counter=" + counter + ",C_BPartner_ID=" + runC_BPartner_ID + "," + String.valueOf(runBPartner));
        }
        MBPartner bp = null;
        MDDOrder singleOrder = null;
        MProduct product = null;
        MWarehouse m_source = null;
        MLocator m_locator = null;
        MWarehouse m_target = null;
        MLocator m_locator_to = null;
        MWarehouse[] ws = null;
        MOrgInfo oi_source = MOrgInfo.get((Properties)this.getCtx(), (int)this.m_run.getAD_Org_ID(), (String)this.get_TrxName());
        m_source = MWarehouse.get((Properties)this.getCtx(), (int)oi_source.getM_Warehouse_ID());
        if (m_source == null) {
            throw new AdempiereException("Do not exist Defautl Warehouse Source");
        }
        m_locator = MLocator.getDefault((MWarehouse)m_source);
        ws = MWarehouse.getInTransitForOrg((Properties)this.getCtx(), (int)m_source.getAD_Org_ID());
        if (ws == null) {
            throw new AdempiereException("Warehouse Intransit do not found");
        }
        if (this.m_run.isCreateSingleOrder()) {
            bp = new MBPartner(this.getCtx(), this.m_run.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new IllegalArgumentException("Business Partner not found - C_BPartner_ID=" + this.m_run.getC_BPartner_ID());
            }
            if (!this.p_IsTest) {
                singleOrder = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                singleOrder.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setIsSOTrx(this.m_docType.isSOTrx());
                singleOrder.setBPartner(bp);
                if (this.m_run.getC_BPartner_Location_ID() != 0) {
                    singleOrder.setC_BPartner_Location_ID(this.m_run.getC_BPartner_Location_ID());
                }
                singleOrder.setDateOrdered(this.m_DateOrdered);
                singleOrder.setDatePromised(this.p_DatePromised);
                singleOrder.setM_Warehouse_ID(ws[0].getM_Warehouse_ID());
                if (!singleOrder.save()) {
                    this.log.log(Level.SEVERE, "Order not saved");
                    return false;
                }
                ++this.m_counter;
            }
        }
        int lastC_BPartner_ID = 0;
        int lastC_BPartner_Location_ID = 0;
        MDDOrder order = null;
        int i = 0;
        while (i < this.m_details.length) {
            MDistributionRunDetail detail = this.m_details[i];
            if (this.m_run.isCreateSingleOrder()) {
                order = singleOrder;
            } else if (lastC_BPartner_ID != detail.getC_BPartner_ID() || lastC_BPartner_Location_ID != detail.getC_BPartner_Location_ID()) {
                order = null;
            }
            lastC_BPartner_ID = detail.getC_BPartner_ID();
            lastC_BPartner_Location_ID = detail.getC_BPartner_Location_ID();
            bp = new MBPartner(this.getCtx(), detail.getC_BPartner_ID(), this.get_TrxName());
            MOrgInfo oi_target = MOrgInfo.get((Properties)this.getCtx(), (int)bp.getAD_OrgBP_ID(), (String)this.get_TrxName());
            m_target = MWarehouse.get((Properties)this.getCtx(), (int)oi_target.getM_Warehouse_ID());
            if (m_target == null) {
                throw new AdempiereException("Do not exist Default Warehouse Target");
            }
            m_locator_to = MLocator.getDefault((MWarehouse)m_target);
            if (m_locator == null || m_locator_to == null) {
                throw new AdempiereException("Do not exist default Locator for Warehouses");
            }
            if (this.p_ConsolidateDocument) {
                StringBuilder whereClause = new StringBuilder("DocStatus IN ('DR','IN') AND AD_Org_ID=").append(bp.getAD_OrgBP_ID()).append(" AND ").append("C_BPartner_ID").append("=? AND ").append("M_Warehouse_ID").append("=?  AND ").append("DatePromised").append("<=? ");
                order = (MDDOrder)new Query(this.getCtx(), "DD_Order", whereClause.toString(), this.get_TrxName()).setParameters(new Object[]{lastC_BPartner_ID, ws[0].getM_Warehouse_ID(), this.p_DatePromised}).setOrderBy("DatePromised DESC").first();
            }
            if (order == null && !this.p_IsTest) {
                order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                order.setAD_Org_ID(bp.getAD_OrgBP_ID());
                order.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                order.setIsSOTrx(this.m_docType.isSOTrx());
                if (counter && bp.getAD_OrgBP_ID() > 0) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Counter - From_BPOrg=" + bp.getAD_OrgBP_ID() + "-" + String.valueOf(bp) + ", To_BP=" + String.valueOf(runBPartner));
                    }
                    order.setAD_Org_ID(bp.getAD_OrgBP_ID());
                    if (ws[0].getM_Warehouse_ID() > 0) {
                        order.setM_Warehouse_ID(ws[0].getM_Warehouse_ID());
                    }
                    order.setBPartner(runBPartner);
                } else {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("From_Org=" + runAD_Org_ID + ", To_BP=" + String.valueOf(bp));
                    }
                    order.setAD_Org_ID(bp.getAD_OrgBP_ID());
                    order.setBPartner(bp);
                    if (detail.getC_BPartner_Location_ID() != 0) {
                        order.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                    }
                }
                order.setM_Warehouse_ID(ws[0].getM_Warehouse_ID());
                order.setDateOrdered(this.m_DateOrdered);
                order.setDatePromised(this.p_DatePromised);
                order.setIsInDispute(false);
                order.setIsInTransit(false);
                if (!order.save()) {
                    this.log.log(Level.SEVERE, "Order not saved");
                    return false;
                }
            }
            if (product == null || product.getM_Product_ID() != detail.getM_Product_ID()) {
                product = MProduct.get((Properties)this.getCtx(), (int)detail.getM_Product_ID());
            }
            if (this.p_IsTest) {
                msglog = new StringBuilder().append(bp.getName()).append(" - ").append(product.getName());
                this.addLog(0, null, detail.getActualAllocation(), msglog.toString());
            } else {
                if (this.p_ConsolidateDocument) {
                    String sql = "SELECT DD_OrderLine_ID FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) WHERE o.DocStatus IN ('DR','IN') AND o.C_BPartner_ID = ? AND M_Product_ID=? AND  ol.M_Locator_ID=?  AND ol.DatePromised <= ?";
                    int DD_OrderLine_ID = DB.getSQLValueEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{detail.getC_BPartner_ID(), product.getM_Product_ID(), m_locator.getM_Locator_ID(), this.p_DatePromised});
                    if (DD_OrderLine_ID <= 0) {
                        line = new MDDOrderLine(order);
                        line.setAD_Org_ID(bp.getAD_OrgBP_ID());
                        line.setM_Locator_ID(m_locator.getM_Locator_ID());
                        line.setM_LocatorTo_ID(m_locator_to.getM_Locator_ID());
                        line.setIsInvoiced(false);
                        line.setProduct(product);
                        QtyAllocation = detail.getActualAllocation();
                        if (QtyAllocation == null) {
                            QtyAllocation = Env.ZERO;
                        }
                        line.setQty(QtyAllocation);
                        line.setQtyEntered(QtyAllocation);
                        line.setTargetQty(Env.ZERO);
                        Description = "";
                        if (this.m_run.getName() != null) {
                            Description = Description.concat(this.m_run.getName());
                        }
                        msgline = new StringBuilder(Description).append(" ").append(Msg.translate((Properties)this.getCtx(), (String)"Qty")).append(" = ").append(QtyAllocation).append(" ");
                        line.setDescription(msgline.toString());
                        line.saveEx();
                    } else {
                        line = new MDDOrderLine(this.getCtx(), DD_OrderLine_ID, this.get_TrxName());
                        QtyAllocation = detail.getActualAllocation();
                        if (QtyAllocation == null) {
                            QtyAllocation = Env.ZERO;
                        }
                        if ((Description = line.getDescription()) == null) {
                            Description = "";
                        }
                        if (this.m_run.getName() != null) {
                            Description = Description.concat(this.m_run.getName());
                        }
                        msgline = new StringBuilder(Description).append(" ").append(Msg.translate((Properties)this.getCtx(), (String)"Qty")).append(" = ").append(QtyAllocation).append(" ");
                        line.setDescription(msgline.toString());
                        line.setQty(line.getQtyEntered().add(QtyAllocation));
                        line.saveEx();
                    }
                } else {
                    MDDOrderLine line = new MDDOrderLine(order);
                    if (!counter || bp.getAD_OrgBP_ID() > 0) {
                        // empty if block
                    }
                    line.setAD_Org_ID(bp.getAD_OrgBP_ID());
                    line.setM_Locator_ID(m_locator.getM_Locator_ID());
                    line.setM_LocatorTo_ID(m_locator_to.getM_Locator_ID());
                    line.setIsInvoiced(false);
                    line.setProduct(product);
                    line.setQty(detail.getActualAllocation());
                    line.setQtyEntered(detail.getActualAllocation());
                    line.setTargetQty(Env.ZERO);
                    String Description = "";
                    if (this.m_run.getName() != null) {
                        Description = Description.concat(this.m_run.getName());
                    }
                    StringBuilder msgline = new StringBuilder(Description).append(" ").append(Msg.translate((Properties)this.getCtx(), (String)"Qty")).append(" = ").append(detail.getActualAllocation()).append(" ");
                    line.setDescription(msgline.toString());
                    line.saveEx();
                }
                msglog = new StringBuilder().append(order.getDocumentNo()).append(": ").append(bp.getName()).append(" - ").append(product.getName());
                this.addLog(0, null, detail.getActualAllocation(), msglog.toString());
            }
            ++i;
        }
        order = null;
        return true;
    }
}

