/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.jettison.mapped;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.codehaus.jettison.Node;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;

public class CustomMappedNamespaceConvention
extends MappedNamespaceConvention {
    private Map<String, String> namespacePrefix = new HashMap<String, String>();
    private Map<String, String> namespacePrefixReversed = new HashMap<String, String>();

    public CustomMappedNamespaceConvention(Configuration config) {
        super(config);
    }

    public void addNamespacePrefix(String prefix, String uri) {
        this.namespacePrefix.put(uri, prefix);
        this.namespacePrefixReversed.put(prefix, uri);
    }

    public QName createQName(String rootName, Node node) {
        int dot = rootName.lastIndexOf(46);
        QName qname = null;
        String local = rootName;
        if (dot == -1) {
            dot = 0;
        } else {
            local = local.substring(dot + 1);
        }
        String jns = rootName.substring(0, dot);
        String xns = this.getNamespaceURI(jns);
        if (xns == null) {
            qname = new QName(rootName);
        } else {
            String prefix = this.namespacePrefix.get(xns);
            if (prefix != null && prefix.trim().length() > 0) {
                qname = new QName(xns, local, prefix);
                if (node.getObject() != null && this.namespacePrefixReversed.isEmpty()) {
                    node.setNamespace(prefix, xns);
                }
            } else {
                qname = new QName(xns, local);
            }
        }
        if (!this.namespacePrefixReversed.isEmpty()) {
            node.setNamespaces(this.namespacePrefixReversed);
        }
        return qname;
    }
}

