/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MRole;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Trx;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.LoginDetails;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;

@ExtendWith(value={MyBeforeAllCallback.class})
public abstract class AbstractTestCase {
    private Trx trx;
    private LoginDetails loginDetails;
    protected final int GARDEN_WORLD_CLIENT;
    protected final int GARDEN_WORLD_HQ_ORG;
    protected final int GARDEN_WORLD_ADMIN_USER;
    protected final int GARDEN_WORLD_ADMIN_ROLE;
    protected final int GARDEN_WORLD_HQ_WAREHOUSE;

    public AbstractTestCase() {
        this.GARDEN_WORLD_CLIENT = DictionaryIDs.AD_Client.GARDEN_WORLD.id;
        this.GARDEN_WORLD_HQ_ORG = DictionaryIDs.AD_Org.HQ.id;
        this.GARDEN_WORLD_ADMIN_USER = DictionaryIDs.AD_User.GARDEN_ADMIN.id;
        this.GARDEN_WORLD_ADMIN_ROLE = DictionaryIDs.AD_Role.GARDEN_WORLD_ADMIN.id;
        this.GARDEN_WORLD_HQ_WAREHOUSE = DictionaryIDs.M_Warehouse.HQ.id;
    }

    @BeforeEach
    protected void init(TestInfo testInfo) {
        StringBuilder builder = new StringBuilder("Running ");
        Optional optional = testInfo.getTestClass();
        if (optional.isPresent()) {
            builder.append(((Class)optional.get()).getName()).append(".");
        }
        builder.append(testInfo.getDisplayName());
        System.out.println(builder.toString());
        ServerContext.setCurrentInstance((Properties)new Properties());
        String trxName = Trx.createTrxName((String)(this.getClass().getName() + "_"));
        this.trx = Trx.get((String)trxName, (boolean)true);
        this.trx.start();
        this.initContext(testInfo);
    }

    protected LoginDetails newLoginDetails(TestInfo testInfo) {
        return new LoginDetails(this.GARDEN_WORLD_CLIENT, this.GARDEN_WORLD_HQ_ORG, this.GARDEN_WORLD_ADMIN_USER, this.GARDEN_WORLD_ADMIN_ROLE, this.GARDEN_WORLD_HQ_WAREHOUSE, new Timestamp(System.currentTimeMillis()), Language.getLanguage((String)"en_US"));
    }

    protected void initContext(TestInfo testInfo) {
        this.loginDetails = this.newLoginDetails(testInfo);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)this.loginDetails.getClientId());
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Org_ID", (int)this.loginDetails.getOrganizationId());
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)this.loginDetails.getUserId());
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Role_ID", (int)this.loginDetails.getRoleId());
        Env.setContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID", (int)this.loginDetails.getWarehouseId());
        Env.setContext((Properties)Env.getCtx(), (String)"#LanguageName", (String)this.loginDetails.getLoginLanguage().getName());
        Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)this.loginDetails.getLoginDate());
        Env.verifyLanguage((Properties)Env.getCtx(), (Language)this.getLanguage());
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Language", (String)this.getLanguage().getAD_Language());
        Env.setContext((Properties)Env.getCtx(), (String)"#Locale", (String)this.getLanguage().getLocale().toString());
        Env.setContext((Properties)Env.getCtx(), (String)"#RUNNING_UNIT_TESTING_TEST_CASE", (boolean)true);
        if (this.loginDetails.getRoleId() > 0) {
            if (MRole.getDefault((Properties)Env.getCtx(), (boolean)false).isShowAcct()) {
                Env.setContext((Properties)Env.getCtx(), (String)"#ShowAcct", (String)"Y");
            } else {
                Env.setContext((Properties)Env.getCtx(), (String)"#ShowAcct", (String)"N");
            }
        }
        if (this.loginDetails.getClientId() > 0) {
            MAcctSchema[] ass;
            if (MClientInfo.get((Properties)Env.getCtx(), (int)this.loginDetails.getClientId()).getC_AcctSchema1_ID() > 0) {
                MAcctSchema primary = MAcctSchema.get((Properties)Env.getCtx(), (int)MClientInfo.get((Properties)Env.getCtx(), (int)this.loginDetails.getClientId()).getC_AcctSchema1_ID());
                Env.setContext((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID", (int)primary.getC_AcctSchema_ID());
                Env.setContext((Properties)Env.getCtx(), (String)"$C_Currency_ID", (int)primary.getC_Currency_ID());
                Env.setContext((Properties)Env.getCtx(), (String)"$HasAlias", (boolean)primary.isHasAlias());
            }
            if ((ass = MAcctSchema.getClientAcctSchema((Properties)Env.getCtx(), (int)this.loginDetails.getClientId())) != null && ass.length > 1) {
                MAcctSchema[] mAcctSchemaArray = ass;
                int n = ass.length;
                int n2 = 0;
                while (n2 < n) {
                    MAcctSchema as = mAcctSchemaArray[n2];
                    if (as.getAD_OrgOnly_ID() != 0 && !as.isSkipOrg(this.loginDetails.getOrganizationId())) {
                        Env.setContext((Properties)Env.getCtx(), (String)"$C_AcctSchema_ID", (int)as.getC_AcctSchema_ID());
                        Env.setContext((Properties)Env.getCtx(), (String)"$C_Currency_ID", (int)as.getC_Currency_ID());
                        Env.setContext((Properties)Env.getCtx(), (String)"$HasAlias", (boolean)as.isHasAlias());
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    @AfterEach
    protected void tearDown() {
        if (this.trx != null) {
            if (this.trx.isActive()) {
                this.trx.rollback();
            }
            this.trx.close();
        }
    }

    protected Trx getTrx() {
        return this.trx;
    }

    protected void commit() {
        if (this.trx != null && this.trx.isActive()) {
            try {
                this.trx.commit(true);
            }
            catch (SQLException e) {
                Assertions.fail((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void rollback() {
        if (this.trx != null && this.trx.isActive()) {
            this.trx.rollback();
        }
    }

    protected int getAD_Client_ID() {
        return this.loginDetails.getClientId();
    }

    protected int getAD_Org_ID() {
        return this.loginDetails.getOrganizationId();
    }

    protected int getAD_User_ID() {
        return this.loginDetails.getUserId();
    }

    protected int getAD_Role_ID() {
        return this.loginDetails.getRoleId();
    }

    protected int getM_Warehouse_ID() {
        return this.loginDetails.getWarehouseId();
    }

    protected Language getLanguage() {
        return this.loginDetails.getLoginLanguage();
    }

    protected Timestamp getLoginDate() {
        return this.loginDetails.getLoginDate();
    }

    protected String getTrxName() {
        return this.trx.getTrxName();
    }

    @AfterAll
    static void shutdown() {
    }

    private static final class MyBeforeAllCallback
    implements BeforeAllCallback {
        private MyBeforeAllCallback() {
        }

        public void beforeAll(ExtensionContext context) throws Exception {
            Adempiere.startup((boolean)false);
        }
    }
}

