/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Base;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.MTree_NodePR;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class TreeMaintenance {
    public int m_WindowNo = 0;
    public MTree m_tree;
    public static final CLogger log = CLogger.getCLogger(TreeMaintenance.class);

    public KeyNamePair[] getTreeData() {
        return DB.getKeyNamePairs((String)MRole.getDefault().addAccessSQL("SELECT AD_Tree_ID, Name FROM AD_Tree WHERE IsActive='Y' AND TreeType NOT IN ('BB','PC') ORDER BY 2", "AD_Tree", false, true), (boolean)false);
    }

    public ArrayList<ListItem> getTreeItemData() {
        ArrayList<ListItem> data;
        block8: {
            data = new ArrayList<ListItem>();
            String fromClause = this.m_tree.getSourceTableName(false);
            String columnNameX = this.m_tree.getSourceTableName(true);
            String actionColor = this.m_tree.getActionColorName();
            String fieldName = null;
            String fieldDescription = null;
            Object join = null;
            if (this.m_tree.getTreeType().equals("MM") && !Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Menu")) {
                fieldName = "trl.Name";
                fieldDescription = "trl.Description";
                join = " LEFT JOIN AD_Menu_Trl trl ON (t.AD_Menu_ID = trl.AD_Menu_ID AND trl.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "')";
            } else {
                fieldName = "t.Name";
                fieldDescription = "t.Description";
                join = "";
            }
            StringBuilder sqlb = new StringBuilder("SELECT t.").append(columnNameX).append("_ID,").append(fieldName).append(",").append(fieldDescription).append(",t.IsSummary,").append(actionColor).append(" FROM ").append(fromClause).append((String)join).append(" ORDER BY 2");
            String sql = MRole.getDefault().addAccessSQL(sqlb.toString(), "t", true, false);
            log.config(sql);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ListItem item = new ListItem(rs.getInt(1), rs.getString(2), rs.getString(3), "Y".equals(rs.getString(4)), rs.getString(5));
                        data.add(item);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void addNode(ListItem item) {
        if (item != null) {
            if (this.m_tree.isProduct()) {
                MTree_NodePR node = new MTree_NodePR((MTree_Base)this.m_tree, item.id);
                node.saveEx();
            } else if (this.m_tree.isBPartner()) {
                MTree_NodeBP node = new MTree_NodeBP((MTree_Base)this.m_tree, item.id);
                node.saveEx();
            } else if (this.m_tree.isMenu()) {
                MTree_NodeMM node = new MTree_NodeMM((MTree_Base)this.m_tree, item.id);
                node.saveEx();
            } else {
                MTree_Node node = new MTree_Node((MTree_Base)this.m_tree, item.id);
                node.saveEx();
            }
        }
    }

    public void deleteNode(ListItem item) {
        if (item != null) {
            if (this.m_tree.isProduct()) {
                MTree_NodePR node = MTree_NodePR.get((MTree_Base)this.m_tree, (int)item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else if (this.m_tree.isBPartner()) {
                MTree_NodeBP node = MTree_NodeBP.get((MTree_Base)this.m_tree, (int)item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else if (this.m_tree.isMenu()) {
                MTree_NodeMM node = MTree_NodeMM.get((MTree_Base)this.m_tree, (int)item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else {
                MTree_Node node = MTree_Node.get((MTree_Base)this.m_tree, (int)item.id);
                if (node != null) {
                    node.delete(true);
                }
            }
        }
    }

    public static class ListItem {
        public int id;
        public String name;
        public String description;
        public boolean isSummary;
        public String imageIndicator;

        public ListItem(int ID, String Name, String Description, boolean summary, String ImageIndicator) {
            this.id = ID;
            this.name = Name;
            this.description = Description;
            this.isSummary = summary;
            this.imageIndicator = ImageIndicator;
        }

        public String toString() {
            Object retValue = this.name;
            if (this.description != null && this.description.length() > 0) {
                retValue = (String)retValue + " (" + this.description + ")";
            }
            return retValue;
        }
    }
}

