/******************************************************************************
 * Product: Adempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 2008 SC ARHIPAC SERVICE SRL. All Rights Reserved.            *
 * This program is free software; you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program; if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 *****************************************************************************/
package org.compiere.print.layout;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;

import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MQuery;
import org.compiere.model.X_AD_PInstance_Log;
import org.compiere.print.MPrintTableFormat;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

/**
 * Print element for instance log
 * @author Teo Sarca, SC ARHIPAC SERVICE SRL
 * 			<li>FR [ 1966406 ] Report Engine: AD_PInstance_Logs should be displayed
 */
public class PInstanceLogElement extends GridElement {
	/**
	 * generated serial id
	 */
	private static final long serialVersionUID = 8315529954507023182L;
	private int m_effectiveRowCount = 0;
	
	/**
	 * @param ctx
	 * @param query
	 * @param tFormat
	 */
	public PInstanceLogElement(Properties ctx, MQuery query, MPrintTableFormat tFormat)
	{
		super (calculateRowCount(query, ctx), 4);
		//
		int AD_PInstance_ID = query.getAD_PInstance_ID();
		if (AD_PInstance_ID > 0) {
			MPInstance instance = new MPInstance(ctx, AD_PInstance_ID, null);
			MPInstanceLog[] logs = instance.getLog();
			for (int r = 0; r < logs.length; r++) {
				int col = 0;
				String msg = logs[r].getP_Msg();
				if (!Util.isEmpty(msg, true)) {
					String s = Msg.parseTranslation(ctx, msg);
					setData (r, col++, s, tFormat.getParameter_Font(), tFormat.getParameter_Color());
				}
				BigDecimal num = logs[r].getP_Number();
				if (num != null) {
					String s = num.toString();
					setData (r, col++, s, tFormat.getParameter_Font(), tFormat.getParameter_Color());
				}
				Timestamp date = logs[r].getP_Date();
				if (date != null) {
					String s = date.toString();
					setData (r, col++, s, tFormat.getParameter_Font(), tFormat.getParameter_Color());
				}
				//
				if (col > 0)
					m_effectiveRowCount++;
			}
		}
	}
	
	/**
	 * Get effective row count
	 * @return number of rows effectively added
	 */
	public int getEffectiveRowCount() {
		return m_effectiveRowCount;
	}
	
	/**
	 * Get number of row for instance log
	 * @param query
	 * @param ctx
	 * @return number of row
	 */
	private static int calculateRowCount(MQuery query, Properties ctx) {
		int AD_PInstance_ID = query.getAD_PInstance_ID();
		if (AD_PInstance_ID > 0) {
			String sql = "SELECT COUNT(*) FROM "+X_AD_PInstance_Log.Table_Name
							+" WHERE "+X_AD_PInstance_Log.COLUMNNAME_AD_PInstance_ID+"=?";
			int no = DB.getSQLValue(null, sql, AD_PInstance_ID);
			if (no > 0) {
				return no;
			}
		}
		return 0;
	}
}
