/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ChosenSearchBox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.InfoListSubModel;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.South;

public class WChosenboxSearchEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick", "onSelect"};
    private Lookup lookup;
    private String m_tableName = null;
    private String m_keyColumnName = null;
    private String columnName;
    private String value;
    private InfoPanel infoPanel = null;
    private String imageUrl;
    private MyListModel model = new MyListModel();
    private InfoListSubModel subModel = null;
    private static final CLogger log = CLogger.getCLogger(WChosenboxSearchEditor.class);
    private static final int DEFAULT_MAX_AUTO_COMPLETE_ROWS = 500;
    private boolean onselecting;

    public WChosenboxSearchEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WChosenboxSearchEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new ChosenSearchBox(), gridField, tableEditor, editorConfiguration);
        this.lookup = gridField.getLookup();
        if (this.lookup != null) {
            this.columnName = this.lookup.getColumnName();
        }
        this.init();
    }

    public ChosenSearchBox getComponent() {
        return (ChosenSearchBox)super.getComponent();
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    public WChosenboxSearchEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new ChosenSearchBox(), label, description, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = lookup.getColumnName();
        super.setColumnName(this.columnName);
        this.init();
    }

    public WChosenboxSearchEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, Lookup lookup) {
        super((Component)new ChosenSearchBox(), null, null, mandatory, readonly, updateable);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.columnName = columnName;
        super.setColumnName(columnName);
        this.init();
    }

    private void init() {
        this.columnName = this.getColumnName();
        this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-More" : ThemeManager.getThemeResource("images/PickOpen16.png");
        if (this.lookup instanceof MLookup) {
            MLookup mlookup = (MLookup)this.lookup;
            if ("C_BPartner_ID".equals(mlookup.getLookupInfo().KeyColumn) || mlookup.getLookupInfo().KeyColumn != null && mlookup.getLookupInfo().KeyColumn.endsWith(".C_BPartner_ID")) {
                this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-BPartner" : ThemeManager.getThemeResource("images/BPartner16.png");
            } else if ("M_Product_ID".equals(mlookup.getLookupInfo().KeyColumn) || mlookup.getLookupInfo().KeyColumn != null && mlookup.getLookupInfo().KeyColumn.endsWith(".M_Product_ID")) {
                this.imageUrl = ThemeManager.isUseFontIconForImage() ? "z-icon-Product" : ThemeManager.getThemeResource("images/Product16.png");
            }
        }
        this.popupMenu = new WEditorPopupMenu(false, true, this.isShowPreference(), false, false, false, this.lookup);
        this.popupMenu.removeNewUpdateMenu();
        Menuitem editor = new Menuitem();
        editor.setAttribute("EVENT", (Object)"ASSISTANT");
        editor.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Assistant"));
        if (ThemeManager.isUseFontIconForImage()) {
            editor.setIconSclass("z-icon-Wizard");
        } else {
            editor.setImage(ThemeManager.getThemeResource("images/Wizard16.png"));
        }
        editor.addEventListener("onClick", (EventListener)this.popupMenu);
        this.popupMenu.appendChild((Component)editor);
        if (ThemeManager.isUseFontIconForImage()) {
            this.getComponent().getButton().setIconSclass(this.imageUrl);
        } else {
            this.getComponent().getButton().setImage(this.imageUrl);
        }
        this.setTableAndKeyColumn();
        this.subModel = new InfoListSubModel(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName);
        this.getComponent().getChosenbox().setModel(this.model);
        this.addChangeLogMenu(this.popupMenu);
    }

    @Override
    public void setValue(Object value) {
        if (this.onselecting) {
            return;
        }
        if (value != null && value instanceof Integer) {
            value = value.toString();
        }
        if (value != null && value instanceof String && !Util.isEmpty((String)((String)value), (boolean)true)) {
            String[] values = ((String)value).split("[,]");
            LinkedHashSet<ValueNamePair> selected = new LinkedHashSet<ValueNamePair>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (!Util.isEmpty((String)key)) {
                    if (key.startsWith("\"") && key.endsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    String name = this.lookup.getDisplay((Object)key);
                    ValueNamePair pair = new ValueNamePair(key, name);
                    selected.add(pair);
                }
                ++n2;
            }
            this.model.clear();
            this.model.addAll(selected);
            this.getComponent().getChosenbox().setSelectedObjects(selected);
            this.value = (String)value;
        } else {
            this.model.clear();
            this.getComponent().getChosenbox().setSelectedObjects(new LinkedHashSet());
            this.value = null;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    private String getValueFromComponent() {
        StringBuilder retVal = new StringBuilder();
        LinkedHashSet<ValueNamePair> selected = this.getComponent().getChosenbox().getSelectedObjects();
        if (selected != null && selected.size() > 0) {
            for (ValueNamePair pair : selected) {
                StringBuilder builder;
                if (retVal.length() > 0) {
                    retVal.append(",");
                }
                if ((builder = new StringBuilder(pair.getValue())).indexOf(",") >= 0) {
                    builder.insert(0, "\"");
                    builder.append("\"");
                }
                retVal.append(builder.toString());
            }
        }
        return retVal.length() > 0 ? retVal.toString() : null;
    }

    @Override
    public String getDisplay() {
        StringBuilder display = new StringBuilder();
        LinkedHashSet<ValueNamePair> selected = this.getComponent().getChosenbox().getSelectedObjects();
        if (selected != null && selected.size() > 0) {
            for (ValueNamePair pair : selected) {
                if (display.length() > 0) {
                    display.append(", ");
                }
                display.append(pair.getName());
            }
        }
        return display.toString();
    }

    public void onEvent(Event e) {
        block12: {
            if ("onClick".equals(e.getName())) {
                if (this.infoPanel != null) {
                    this.infoPanel.detach();
                    this.infoPanel = null;
                }
                this.actionButton();
            } else if ("onSelect".equalsIgnoreCase(e.getName())) {
                try {
                    this.onselecting = true;
                    String newValue = this.getValueFromComponent();
                    if (!this.isValueChange(newValue)) break block12;
                    try {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(true);
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.value, newValue);
                        super.fireValueChange(changeEvent);
                        this.value = newValue;
                    }
                    finally {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(false);
                        }
                    }
                }
                finally {
                    this.onselecting = false;
                }
            }
        }
    }

    private boolean isValueChange(Object newValue) {
        return this.value == null && newValue != null || this.value != null && newValue == null || this.value != null && newValue != null && !this.value.equals(newValue);
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("ASSISTANT".equals(evt.getContextEvent())) {
            final WChosenboxSearchAssistant wdc = new WChosenboxSearchAssistant();
            wdc.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    String newValue = wdc.getNewValue();
                    WChosenboxSearchEditor.this.updateValue(newValue);
                    WChosenboxSearchEditor.this.setValue(newValue.toString());
                }
            });
            AEnv.showWindow(wdc);
        }
    }

    private void updateValue(Object newValue) {
        block8: {
            try {
                this.onselecting = true;
                if (!this.isValueChange(newValue)) break block8;
                try {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(true);
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), "", newValue);
                    super.fireValueChange(changeEvent);
                    this.value = newValue.toString();
                }
                finally {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(false);
                    }
                }
            }
            finally {
                this.onselecting = false;
            }
        }
    }

    private void processSelectedKeys(Object value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Value=" + String.valueOf(value));
        }
        try {
            Object newValue;
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(true);
            }
            if ((newValue = this.value) == null) {
                if (value instanceof Object[]) {
                    if (((Object[])value).length > 0) {
                        builder = new StringBuilder();
                        Object[] objectArray = (Object[])value;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object obj = objectArray[n2];
                            if (obj != null) {
                                if (builder.length() > 0) {
                                    builder.append(",");
                                }
                                builder.append(obj.toString());
                            }
                            ++n2;
                        }
                        newValue = builder.toString();
                    }
                } else {
                    newValue = value != null ? value.toString() : null;
                }
            } else if (value != null) {
                if (value instanceof Object[]) {
                    if (((Object[])value).length > 0) {
                        builder = new StringBuilder((String)newValue);
                        Object[] objectArray = (Object[])value;
                        int n = objectArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object obj = objectArray[n3];
                            if (obj != null && !((String)newValue).contains(obj.toString())) {
                                if (builder.length() > 0) {
                                    builder.append(",");
                                }
                                builder.append(obj.toString());
                            }
                            ++n3;
                        }
                        newValue = builder.toString();
                    }
                } else if (!((String)newValue).contains(value.toString())) {
                    newValue = (String)newValue + "," + value.toString();
                }
            }
            this.fireValueChangeEvent(newValue);
            boolean updated = false;
            if (newValue == null && this.getValue() == null) {
                updated = true;
            } else if (newValue != null && ((String)newValue).equals(this.getValue())) {
                updated = true;
            }
            if (!updated) {
                this.setValue(newValue);
            }
        }
        finally {
            if (this.gridField != null) {
                this.gridField.setLookupEditorSettingValue(false);
            }
        }
    }

    protected void fireValueChangeEvent(Object newValue) {
        ValueChangeEvent evt = new ValueChangeEvent(this, this.getColumnName(), this.getValue(), newValue);
        this.fireValueChange(evt);
    }

    private void actionButton() {
        InfoPanel ip;
        if (this.lookup == null) {
            return;
        }
        String whereClause = this.getWhereClause();
        if (this.m_tableName == null) {
            this.setTableAndKeyColumn();
        }
        if ((ip = InfoManager.create(this.lookup, this.gridField, this.m_tableName, this.m_keyColumnName, null, true, whereClause)) != null) {
            this.showInfoPanel(ip);
        }
    }

    protected void showInfoPanel(final InfoPanel ip) {
        ip.setVisible(true);
        ip.setStyle("border: 2px");
        ip.setClosable(true);
        this.infoPanel = ip;
        ip.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Component component = SessionManager.getAppDesktop().getActiveWindow();
                if (component instanceof IHelpContext) {
                    Events.sendEvent((Event)new Event("onWindowContainerSelectionChanged", component));
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
                boolean cancelled = ip.isCancelled();
                Object[] result = ip.getSelectedKeys();
                WChosenboxSearchEditor.this.infoPanel = null;
                if (!cancelled && result != null && result.length > 0) {
                    if (result.length > 1) {
                        WChosenboxSearchEditor.this.processSelectedKeys(result);
                    } else {
                        WChosenboxSearchEditor.this.processSelectedKeys(result[0]);
                    }
                }
                WChosenboxSearchEditor.this.getComponent().getChosenbox().focus();
            }
        });
        ip.setId(ip.getTitle() + "_" + ip.getWindowNo());
        AEnv.showWindow(ip);
    }

    private void setTableAndKeyColumn() {
        if (this.lookup != null && this.lookup instanceof MLookup) {
            this.m_keyColumnName = ((MLookup)this.lookup).getColumnName();
            if (this.m_keyColumnName.contains(".")) {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.indexOf("."));
                this.m_keyColumnName = this.m_keyColumnName.substring(this.m_keyColumnName.indexOf(".") + 1);
            } else {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
            }
        } else if (this.getGridField() != null && this.getGridField().getGridTab() != null && this.getGridField().getAD_Column_ID() > 0) {
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)this.getGridField().getAD_Column_ID());
            this.m_tableName = column.getReferenceTableName();
            MTable table2 = MTable.get((Properties)Env.getCtx(), (String)this.m_tableName);
            this.m_keyColumnName = table2.getKeyColumns()[0];
        } else {
            this.m_keyColumnName = this.getColumnName();
            this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
        }
        if (this.m_keyColumnName.equals("M_Product_ID")) {
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Product_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_AttributeSetInstance_ID", (String)"0");
            Env.setContext((Properties)Env.getCtx(), (int)this.lookup.getWindowNo(), (int)1113, (String)"M_Locator_ID", (String)"0");
        }
    }

    private String getWhereClause() {
        Object whereClause = "";
        if (this.lookup == null) {
            return "";
        }
        String validation = this.lookup.getValidation();
        if (validation == null) {
            validation = "";
        }
        if (((String)whereClause).length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = (String)whereClause + " AND " + validation;
        }
        if (((String)whereClause).indexOf(64) != -1) {
            Properties ctx = this.lookup instanceof MLookup ? ((MLookup)this.lookup).getLookupInfo().ctx : Env.getCtx();
            String validated = Env.parseContext((Properties)ctx, (int)this.lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(this.getColumnName() + " - Cannot Parse=" + (String)whereClause);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getColumnName() + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void setTableEditor(boolean b) {
        super.setTableEditor(b);
        this.getComponent().setTableEditorMode(b);
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        super.dynamicDisplay(ctx);
    }

    private class MyListModel
    extends ListModelList<ValueNamePair>
    implements ListSubModel<ValueNamePair> {
        private static final long serialVersionUID = -1210525428410505409L;

        private MyListModel() {
        }

        public ListModel<ValueNamePair> getSubModel(Object value, int nRows) {
            WChosenboxSearchEditor.this.subModel.setWhereClause(WChosenboxSearchEditor.this.getWhereClause());
            int maxRows = MSysConfig.getIntValue((String)"ZK_SEARCH_AUTO_COMPLETE_MAX_ROWS", (int)500, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            ListModel<ValueNamePair> model = WChosenboxSearchEditor.this.subModel.getSubModel(value, maxRows);
            WChosenboxSearchEditor.this.getComponent().getChosenbox().setSubListModel(model);
            return model;
        }
    }

    private class WChosenboxSearchAssistant
    extends Window
    implements EventListener<Event> {
        private static final long serialVersionUID = 1043859495570181469L;
        private Button bRemoveAll;
        private Button bUp;
        private Button bDown;
        private SimpleListModel selectedModel = new SimpleListModel();
        private Listbox selectedList = new Listbox();
        private Hlayout hlayout;
        private Button bOk;
        private Button bCancel;
        private String m_newValue = "";

        public WChosenboxSearchAssistant() {
            this.setTitle(WChosenboxSearchEditor.this.gridField.getHeader() + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Assistant"));
            this.init();
            this.load();
            this.setClosable(true);
            this.setBorder("normal");
            this.setShadow(true);
            this.setMaximizable(true);
            this.setSizable(true);
            if (!ThemeManager.isUseCSSForWindowSize()) {
                ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 600);
                ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 700);
            } else {
                this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                    ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                    ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
                });
            }
            this.setSclass("chosenbox-assistant-dialog");
            this.addCallback("afterPageDetached", (Callback & Serializable)t -> WChosenboxSearchEditor.this.getComponent().getChosenbox().focus());
        }

        private void init() {
            this.m_newValue = WChosenboxSearchEditor.this.getValue() != null ? WChosenboxSearchEditor.this.getValue().toString() : "";
            Borderlayout mainLayout = new Borderlayout();
            this.appendChild((Component)mainLayout);
            Center center = new Center();
            mainLayout.appendChild((Component)center);
            center.setAutoscroll(true);
            EventListener<Event> actionListenerUpDown = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WChosenboxSearchAssistant.this.migrateValueWithinSelectedList(event);
                }
            };
            EventListener<Event> actionListenerRemoveAll = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WChosenboxSearchAssistant.this.deleteAllValuesList(event);
                }
            };
            EventListener<Event> mouseListener = new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if ("onDoubleClick".equals(event.getName())) {
                        WChosenboxSearchAssistant.this.deleteValueList(event);
                    }
                }
            };
            DragListener crossListMouseListener = new DragListener();
            this.bUp = this.createButton("MoveUp16", actionListenerUpDown);
            this.bDown = this.createButton("MoveDown16", actionListenerUpDown);
            Hlayout yesButtonLayout = this.createHlayoutBtn(new Button[]{this.bUp, this.bDown});
            boolean isEditable = WChosenboxSearchEditor.this.gridField.isEditable(true);
            this.initListboxAndModel(this.selectedList, this.selectedModel, mouseListener, crossListMouseListener, isEditable, Msg.getMsg((Properties)Env.getCtx(), (String)"SelectedItems"), yesButtonLayout);
            this.hlayout = this.createHlayoutLine(new Component[]{this.selectedList});
            center.appendChild((Component)this.hlayout);
            ConfirmPanel confirmPanel = new ConfirmPanel(true, false, true, false, false, false);
            this.bOk = confirmPanel.getOKButton();
            this.bOk.addEventListener("onClick", this);
            this.bCancel = confirmPanel.getButton("Cancel");
            this.bCancel.addEventListener("onClick", this);
            this.bRemoveAll = confirmPanel.getButton("Reset");
            this.bRemoveAll.addEventListener("onClick", (EventListener)actionListenerRemoveAll);
            South south = new South();
            south.setSclass("dialog-footer");
            mainLayout.appendChild((Component)south);
            south.appendChild((Component)confirmPanel);
            if (!isEditable) {
                this.bUp.setVisible(false);
                this.bDown.setVisible(false);
                this.bRemoveAll.setVisible(false);
            }
        }

        private void load() {
            this.selectedModel.removeAllElements();
            Object values = WChosenboxSearchEditor.this.getValue();
            ArrayList<String> listSelected = new ArrayList<String>();
            if (values != null && !Util.isEmpty((String)((String)values))) {
                String[] stringArray = ((String)values).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    String name = WChosenboxSearchEditor.this.lookup.getDisplay((Object)value);
                    this.selectedModel.addElement(new ValueNamePair(value, name));
                    listSelected.add(value);
                    ++n2;
                }
            }
        }

        public void onEvent(Event event) throws Exception {
            if (event.getTarget() == this.bOk) {
                StringBuilder value = new StringBuilder("");
                for (Listitem le : this.selectedList.getItems()) {
                    int index = this.selectedList.getIndexOfItem(le);
                    ValueNamePair selObject = (ValueNamePair)this.selectedModel.getElementAt(index);
                    value.append(selObject.getID()).append(",");
                }
                if (value.length() > 0) {
                    value = value.deleteCharAt(value.length() - 1);
                }
                this.m_newValue = value.toString();
                this.detach();
            } else if (event.getTarget() == this.bCancel) {
                this.detach();
            }
        }

        private void deleteAllValuesList(Event event) {
            this.selectedModel.removeAllElements();
        }

        private void deleteValueList(Event event) {
            Component source = event.getTarget();
            if (source instanceof ListItem) {
                ListItem listItem = (ListItem)source;
                int index = listItem.getIndex();
                this.selectedModel.removeElement(this.selectedModel.getElementAt(index));
            }
        }

        private Button createButton(String image, EventListener<Event> actionListener) {
            Button btn = ButtonFactory.createButton(null, ThemeManager.getThemeResource("images/" + image + ".png"), null);
            LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)btn);
            LayoutUtils.addSclass("btn-sorttab small-img-btn", (HtmlBasedComponent)btn);
            if (actionListener != null) {
                btn.addEventListener("onClick", actionListener);
            }
            return btn;
        }

        private void initListboxAndModel(Listbox lb, SimpleListModel model, EventListener<Event> mouseListener, EventListener<Event> crossListMouseListener, boolean isItemDraggable, String headerLabel, Hlayout buttonsLayout) {
            lb.addEventListener("onRightClick", this);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)lb, "1");
            ZKUpdateUtil.setVflex(lb, true);
            if (mouseListener != null && isItemDraggable) {
                lb.addDoubleClickListener(mouseListener);
            }
            if (crossListMouseListener != null && isItemDraggable) {
                lb.addOnDropListener(crossListMouseListener);
            }
            lb.setItemDraggable(isItemDraggable);
            lb.setItemRenderer(model);
            lb.setModel((ListModel)model);
            model.setMultiple(true);
            ListHead listHead = new ListHead();
            listHead.setParent((Component)lb);
            ListHeader listHeader = new ListHeader();
            listHeader.appendChild((Component)new Label(headerLabel));
            listHeader.setParent((Component)listHead);
            listHeader.appendChild((Component)buttonsLayout);
        }

        private Hlayout createHlayoutBtn(Button[] btns) {
            Hlayout hl = new Hlayout();
            Button[] buttonArray = btns;
            int n = btns.length;
            int n2 = 0;
            while (n2 < n) {
                Button btn = buttonArray[n2];
                hl.appendChild((Component)btn);
                ++n2;
            }
            hl.setStyle("display: inline-block; float: right;");
            return hl;
        }

        private Hlayout createHlayoutLine(Component[] comps) {
            Hlayout hl = new Hlayout();
            hl.setValign("middle");
            Component[] componentArray = comps;
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                hl.appendChild(comp);
                ++n2;
            }
            hl.setVflex("1");
            hl.setStyle("margin-bottom: 5px;");
            return hl;
        }

        private SimpleListModel getModel(Listbox listbox) {
            SimpleListModel retValue = null;
            if (listbox == this.selectedList) {
                retValue = this.selectedModel;
            }
            return retValue;
        }

        private void migrateValueWithinSelectedList(SimpleListModel selModel, Listbox selListbox, int endIndex, List<ValueNamePair> selObjects) {
            int iniIndex = 0;
            Arrays.sort(selObjects.toArray());
            ValueNamePair selObject = null;
            ValueNamePair endObject = (ValueNamePair)selModel.getElementAt(endIndex);
            for (ValueNamePair selected : selObjects) {
                iniIndex = selModel.indexOf(selected);
                selObject = (ValueNamePair)selModel.getElementAt(iniIndex);
                selModel.removeElement(selObject);
                endIndex = selModel.indexOf(endObject);
                selModel.add(endIndex, selObject);
            }
            selListbox.removeAllItems();
            int i = 0;
            while (i < selModel.getSize()) {
                ValueNamePair pp = (ValueNamePair)selModel.getElementAt(i);
                selListbox.addItem(new ValueNamePair(pp.getID(), pp.getName()));
                ++i;
            }
        }

        private void migrateValueWithinSelectedList(Event event) {
            Object[] selObjects = this.selectedList.getSelectedItems().toArray();
            if (selObjects == null) {
                return;
            }
            int length = selObjects.length;
            if (length == 0) {
                return;
            }
            int[] indices = this.selectedList.getSelectedIndices();
            boolean change = false;
            Component source = event.getTarget();
            if (source == this.bUp) {
                i = 0;
                while (i < length) {
                    int index = indices[i];
                    if (index != 0) {
                        ValueNamePair selObject = (ValueNamePair)this.selectedModel.getElementAt(index);
                        ValueNamePair newObject = (ValueNamePair)this.selectedModel.getElementAt(index - 1);
                        this.selectedModel.setElementAt(newObject, index);
                        this.selectedModel.setElementAt(selObject, index - 1);
                        indices[i] = index - 1;
                        change = true;
                        ++i;
                        continue;
                    }
                    break;
                }
            } else if (source == this.bDown) {
                i = length - 1;
                while (i >= 0) {
                    int index = indices[i];
                    if (index < this.selectedModel.getSize() - 1) {
                        ValueNamePair selObject = (ValueNamePair)this.selectedModel.getElementAt(index);
                        ValueNamePair newObject = (ValueNamePair)this.selectedModel.getElementAt(index + 1);
                        this.selectedModel.setElementAt(newObject, index);
                        this.selectedModel.setElementAt(selObject, index + 1);
                        this.selectedList.setSelectedIndex(index + 1);
                        indices[i] = index + 1;
                        change = true;
                        --i;
                        continue;
                    }
                    break;
                }
            }
            if (change) {
                this.selectedList.setSelectedIndices(indices);
                if (this.selectedList.getSelectedItem() != null) {
                    AuFocus focus = new AuFocus((Component)this.selectedList.getSelectedItem());
                    Clients.response((AuResponse)focus);
                }
            }
        }

        private String getNewValue() {
            return this.m_newValue;
        }

        private class DragListener
        implements EventListener<Event> {
            public void onEvent(Event event) throws Exception {
                if (event instanceof DropEvent) {
                    int endIndex = 0;
                    DropEvent me = (DropEvent)event;
                    ListItem endItem = (ListItem)me.getTarget();
                    ListItem startItem = (ListItem)me.getDragged();
                    if (!startItem.isSelected()) {
                        startItem.setSelected(true);
                    }
                    Listbox selListbox = WChosenboxSearchAssistant.this.selectedList;
                    SimpleListModel selModel = WChosenboxSearchAssistant.this.getModel(selListbox);
                    if (startItem.getListbox() == endItem.getListbox() && startItem.getListbox() == selListbox) {
                        ArrayList<ValueNamePair> selObjects = new ArrayList<ValueNamePair>();
                        endIndex = selListbox.getIndexOfItem(endItem);
                        for (Object obj : selListbox.getSelectedItems()) {
                            ListItem listItem = (ListItem)((Object)obj);
                            int index = selListbox.getIndexOfItem(listItem);
                            ValueNamePair selObject = (ValueNamePair)selModel.getElementAt(index);
                            selObjects.add(selObject);
                        }
                        WChosenboxSearchAssistant.this.migrateValueWithinSelectedList(selModel, selListbox, endIndex, selObjects);
                    }
                }
            }
        }
    }
}

