/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBankStatement;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.X_C_BankStatementLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MBankStatementLine
extends X_C_BankStatementLine {
    private static final long serialVersionUID = 2604381588523683439L;
    protected MBankStatement m_parent = null;

    public MBankStatementLine(Properties ctx, String C_BankStatementLine_UU, String trxName) {
        super(ctx, C_BankStatementLine_UU, trxName);
        if (Util.isEmpty(C_BankStatementLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MBankStatementLine(Properties ctx, int C_BankStatementLine_ID, String trxName) {
        super(ctx, C_BankStatementLine_ID, trxName);
        if (C_BankStatementLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setStmtAmt(Env.ZERO);
        this.setTrxAmt(Env.ZERO);
        this.setInterestAmt(Env.ZERO);
        this.setChargeAmt(Env.ZERO);
        this.setIsReversal(false);
    }

    public MBankStatementLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatementLine(MBankStatement statement) {
        this(statement.getCtx(), 0, statement.get_TrxName());
        this.setClientOrg(statement);
        this.setC_BankStatement_ID(statement.getC_BankStatement_ID());
        this.setStatementLineDate(statement.getStatementDate());
    }

    public MBankStatementLine(MBankStatement statement, int lineNo) {
        this(statement);
        this.setLine(lineNo);
    }

    public MBankStatementLine(Properties ctx, int C_BankStatementLine_ID, String trxName, String ... virtualColumns) {
        super(ctx, C_BankStatementLine_ID, trxName, virtualColumns);
    }

    @Override
    public void setStatementLineDate(Timestamp StatementLineDate) {
        super.setStatementLineDate(StatementLineDate);
        this.setValutaDate(StatementLineDate);
        this.setDateAcct(StatementLineDate);
    }

    public void setPayment(MPayment payment) {
        BigDecimal interestAmt;
        this.setC_Payment_ID(payment.getC_Payment_ID());
        this.setC_Currency_ID(payment.getC_Currency_ID());
        BigDecimal amt = payment.getPayAmt(true);
        BigDecimal chargeAmt = this.getChargeAmt();
        if (chargeAmt == null) {
            chargeAmt = Env.ZERO;
        }
        if ((interestAmt = this.getInterestAmt()) == null) {
            interestAmt = Env.ZERO;
        }
        this.setTrxAmt(amt);
        this.setStmtAmt(amt.add(chargeAmt).add(interestAmt));
        this.setDescription(payment.getDescription());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgsd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgsd.toString());
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_BankStatement_ID"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("DateAcct")) && !this.isDateConsistentIfUsedForPosting()) {
            this.log.saveError("SaveError", Msg.getMsg(this.getCtx(), "BankStatementLinePeriodNotSameAsHeader", new Object[]{this.getLine()}));
            return false;
        }
        BigDecimal amt = this.getStmtAmt();
        amt = amt.subtract(this.getTrxAmt());
        if ((amt = amt.subtract(this.getInterestAmt())).compareTo(this.getChargeAmt()) != 0) {
            this.setChargeAmt(amt);
        }
        if (this.getChargeAmt().signum() != 0 && this.getC_Charge_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "C_Charge_ID"));
            return false;
        }
        if (this.getTrxAmt().signum() == 0 && this.getC_Payment_ID() > 0) {
            this.setC_Payment_ID(I_ZERO);
            this.setC_Invoice_ID(I_ZERO);
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM C_BankStatementLine WHERE C_BankStatement_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_BankStatement_ID());
            this.setLine(ii);
        }
        if (this.getC_Payment_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            this.setC_BPartner_ID(payment.getC_BPartner_ID());
            if (payment.getC_Invoice_ID() != 0) {
                this.setC_Invoice_ID(payment.getC_Invoice_ID());
            }
        }
        if (this.getC_Invoice_ID() != 0 && this.getC_BPartner_ID() == 0) {
            MInvoice invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            this.setC_BPartner_ID(invoice.getC_BPartner_ID());
        }
        return true;
    }

    public MBankStatement getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MBankStatement(this.getCtx(), this.getC_BankStatement_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeader();
    }

    protected boolean updateHeader() {
        StringBuilder sql = new StringBuilder("UPDATE C_BankStatement bs").append(" SET StatementDifference=(SELECT COALESCE(SUM(StmtAmt),0) FROM C_BankStatementLine bsl ").append("WHERE bsl.C_BankStatement_ID=bs.C_BankStatement_ID AND bsl.IsActive='Y') ").append("WHERE C_BankStatement_ID=").append(this.getC_BankStatement_ID());
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 1) {
            this.log.warning("StatementDifference #" + no);
            return false;
        }
        sql = new StringBuilder("UPDATE C_BankStatement bs").append(" SET EndingBalance=BeginningBalance+StatementDifference ").append("WHERE C_BankStatement_ID=").append(this.getC_BankStatement_ID());
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 1) {
            this.log.warning("Balance #" + no);
            return false;
        }
        return true;
    }

    public boolean isDateConsistentIfUsedForPosting() {
        return this.isDateConsistentIfUsedForPosting(this.getParent().getDateAcct());
    }

    public boolean isDateConsistentIfUsedForPosting(Timestamp headerDateAcct) {
        if (MBankStatement.isPostWithDateFromLine(this.getAD_Client_ID())) {
            MPeriod headerPeriod = MPeriod.get(this.getCtx(), headerDateAcct, this.getParent().getAD_Org_ID(), this.get_TrxName());
            MPeriod linePeriod = MPeriod.get(this.getCtx(), this.getDateAcct(), this.getParent().getAD_Org_ID(), this.get_TrxName());
            return headerPeriod != null && linePeriod != null && headerPeriod.getC_Period_ID() == linePeriod.getC_Period_ID();
        }
        return true;
    }
}

