/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.converter.sys;

import java.io.Serializable;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.ext.TreeSelectableModel;

public class TreeSelectedItemConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 201109261823L;

    public Object coerceToUi(Object val, Component comp, BindContext ctx) {
        Tree tree = (Tree)comp;
        TreeModel model = tree.getModel();
        if (model != null && !(model instanceof TreeSelectableModel)) {
            throw new UiException("model doesn't implement TreeSelectableModel");
        }
        TreeSelectableModel smodel = (TreeSelectableModel)model;
        if (smodel != null && !smodel.isSelectionEmpty()) {
            smodel.clearSelection();
        }
        if (val != null) {
            int[] path;
            if (model != null && (path = model.getPath(val)) != null && smodel != null) {
                smodel.addSelectionPath(path);
                return IGNORED_VALUE;
            }
            for (Treeitem ti : tree.getItems()) {
                Object bean = ti.getValue();
                if (!val.equals(bean)) continue;
                return ti;
            }
        }
        if (smodel != null) {
            if (smodel.getSelectionCount() > 0) {
                smodel.clearSelection();
            }
            return IGNORED_VALUE;
        }
        return null;
    }

    public Object coerceToBean(Object val, Component comp, BindContext ctx) {
        if (val != null) {
            Tree tree = (Tree)comp;
            TreeModel model = tree.getModel();
            if (model != null && !(model instanceof TreeSelectableModel)) {
                throw new UiException("model doesn't implement TreeSelectableModel");
            }
            if (model != null) {
                int[] path = ((TreeSelectableModel)model).getSelectionPath();
                if (path == null) {
                    return null;
                }
                return model.getChild(path);
            }
            return ((Treeitem)val).getValue();
        }
        return null;
    }
}

