/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.device;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.zkoss.idom.Element;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.io.Files;
import org.zkoss.lang.Classes;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.DeviceConfig;
import org.zkoss.zk.device.DeviceNotFoundException;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApps;

public class Devices {
    private static final Map<String, Object> _devmap = new LinkedHashMap<String, Object>(4);
    private static Device[] _devs = new Device[0];

    private Devices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Device getDevice(String deviceType) throws DeviceNotFoundException {
        Object o;
        Map<String, Object> map = _devmap;
        synchronized (map) {
            o = _devmap.get(deviceType);
        }
        if (o instanceof Device) {
            return (Device)o;
        }
        if (o == null) {
            throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
        }
        Device device = ((DeviceInfo)o).newDevice(deviceType);
        LinkedList<Device> devs = new LinkedList<Device>();
        Map<String, Object> map2 = _devmap;
        synchronized (map2) {
            Object old = _devmap.put(deviceType, device);
            if (old != o) {
                _devmap.put(deviceType, old);
            }
            for (Object d : _devmap.values()) {
                if (!(d instanceof Device)) continue;
                devs.add((Device)d);
            }
        }
        _devs = devs.toArray(new Device[devs.size()]);
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Device getDeviceByClient(String userAgent) throws DeviceNotFoundException {
        String[] devTypes;
        Map<String, Object> map = _devmap;
        synchronized (map) {
            Set<String> c = _devmap.keySet();
            devTypes = c.toArray(new String[c.size()]);
        }
        Device device = null;
        for (int j = 0; j < devTypes.length; ++j) {
            Boolean b;
            Device dev;
            try {
                dev = Devices.getDevice(devTypes[j]);
            }
            catch (Throwable ex) {
                continue;
            }
            try {
                b = dev.isCompatible(userAgent);
            }
            catch (Throwable ex) {
                b = null;
            }
            if (b != null) {
                if (!b.booleanValue()) continue;
                return dev;
            }
            if (device != null && !"ajax".equals(devTypes[j]) && !"xml".equals(device.getType())) continue;
            device = dev;
        }
        if (device == null) {
            throw new DeviceNotFoundException(userAgent, MZk.NOT_FOUND, userAgent);
        }
        return device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean exists(String deviceType) {
        Object o;
        if (deviceType == null) {
            return false;
        }
        Map<String, Object> map = _devmap;
        synchronized (map) {
            o = _devmap.get(deviceType);
        }
        return o instanceof Device || o != null && ((DeviceInfo)o).isValid();
    }

    public static final void add(Element config) {
        String deviceType = IDOMs.getRequiredElementValue((Element)config, (String)"device-type");
        String s = config.getElementValue("device-class", true);
        if (s != null) {
            Devices.add(deviceType, s);
        }
        if ((s = config.getElementValue("unavailable-message", true)) != null) {
            Devices.setUnavailableMessage(deviceType, s);
        }
        if ((s = config.getElementValue("server-push-class", true)) != null) {
            Devices.setServerPushClass(deviceType, s);
        }
        Iterator it = config.getElements("embed").iterator();
        while (it.hasNext()) {
            Devices.addEmbedded(deviceType, ((Element)it.next()).getText(true));
        }
    }

    public static final String add(String deviceType, String clsnm) {
        return Devices.add0(deviceType, clsnm);
    }

    public static final String add(String deviceType, Class cls) {
        return Devices.add0(deviceType, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String add0(String deviceType, Object cls) {
        if (deviceType == null || deviceType.length() == 0 || cls == null) {
            throw new IllegalArgumentException();
        }
        Map<String, Object> map = _devmap;
        synchronized (map) {
            Object o = _devmap.get(deviceType);
            if (o instanceof DeviceInfo) {
                return ((DeviceInfo)o).setDeviceClass(cls);
            }
            if (o instanceof Device) {
                Device device = (Device)o;
                _devmap.put(deviceType, new DeviceInfo(cls, device.getUnavailableMessage(), device.getServerPushClass()));
                return device.getClass().getName();
            }
            _devmap.put(deviceType, new DeviceInfo(cls));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getUnavailableMessage(String deviceType) {
        Object o;
        Map<String, Object> map = _devmap;
        synchronized (map) {
            o = _devmap.get(deviceType);
        }
        return o instanceof Device ? ((Device)o).getUnavailableMessage() : (o instanceof DeviceInfo ? ((DeviceInfo)o).getUnavailableMessage() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String setUnavailableMessage(String deviceType, String msg) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (msg != null && msg.length() == 0) {
            msg = null;
        }
        Map<String, Object> map = _devmap;
        synchronized (map) {
            Object o = _devmap.get(deviceType);
            if (o instanceof Device) {
                return ((Device)o).setUnavailableMessage(msg);
            }
            if (o instanceof DeviceInfo) {
                return ((DeviceInfo)o).setUnavailableMessage(msg);
            }
            DeviceInfo info = new DeviceInfo();
            _devmap.put(deviceType, info);
            info.setUnavailableMessage(msg);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEmbedded(String deviceType) {
        Object o;
        Map<String, Object> map = _devmap;
        synchronized (map) {
            o = _devmap.get(deviceType);
        }
        return o instanceof Device ? ((Device)o).getEmbedded() : (o instanceof DeviceInfo ? ((DeviceInfo)o).getEmbedded() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEmbedded(String deviceType, String content) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (content == null || content.length() == 0) {
            return;
        }
        Map<String, Object> map = _devmap;
        synchronized (map) {
            Object o = _devmap.get(deviceType);
            if (o instanceof Device) {
                ((Device)o).addEmbedded(content);
            } else if (o instanceof DeviceInfo) {
                ((DeviceInfo)o).addEmbedded(content);
            } else {
                DeviceInfo info = new DeviceInfo();
                _devmap.put(deviceType, info);
                info.addEmbedded(content);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getServerPushClass(String deviceType) {
        Object o;
        Map<String, Object> map = _devmap;
        synchronized (map) {
            o = _devmap.get(deviceType);
        }
        if (o instanceof Device) {
            Class cls = ((Device)o).getServerPushClass();
            return cls != null ? cls.getName() : null;
        }
        return o instanceof DeviceInfo ? ((DeviceInfo)o).getServerPushClassName() : null;
    }

    public static final String setServerPushClass(String deviceType, String clsnm) {
        return Devices.setServerPushClass0(deviceType, clsnm);
    }

    public static final String setServerPushClass(String deviceType, Class cls) {
        return Devices.setServerPushClass0(deviceType, cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String setServerPushClass0(String deviceType, Object cls) {
        if (deviceType == null || deviceType.length() == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Map<String, Object> map = _devmap;
            synchronized (map) {
                Object o = _devmap.get(deviceType);
                if (o instanceof Device) {
                    Class old = ((Device)o).setServerPushClass(cls instanceof Class ? (Class)cls : (cls != null ? Classes.forNameByThread((String)((String)cls)) : null));
                    return old != null ? old.getName() : null;
                }
                if (o instanceof DeviceInfo) {
                    return ((DeviceInfo)o).setServerPushClass(cls);
                }
                DeviceInfo info = new DeviceInfo();
                _devmap.put(deviceType, info);
                info.setServerPushClass(cls);
                return null;
            }
        }
        catch (ClassNotFoundException ex) {
            throw new UiException("Class not found: " + cls);
        }
    }

    public static final Object[] matches(String userAgent) {
        for (int j = 0; j < _devs.length; ++j) {
            Object[] inf = _devs[j].matches(userAgent);
            if (inf == null) continue;
            return inf;
        }
        return null;
    }

    public static String loadJavaScript(Execution exec, String path) throws IOException {
        return Devices.loadFileContentAsString(exec, path);
    }

    public static String loadFileContentAsString(Execution exec, String path) throws IOException {
        path = exec.locate(path);
        InputStream is = WebApps.getCurrent().getResourceAsStream(path);
        if (is == null) {
            throw new UiException("Unable to load " + path);
        }
        byte[] bs = Files.readAll((InputStream)is);
        Files.close((InputStream)is);
        return new String(bs, "UTF-8");
    }

    private static class DeviceInfo
    implements DeviceConfig {
        private Object _dvcls;
        private String _uamsg;
        private Object _spushcls;
        private String _embed;

        private DeviceInfo() {
        }

        private DeviceInfo(Object deviceClass) {
            this._dvcls = deviceClass;
        }

        private DeviceInfo(Object deviceClass, String unavailable, Class spushcls) {
            this._dvcls = deviceClass;
            this._uamsg = unavailable;
            this._spushcls = spushcls;
        }

        private boolean isValid() {
            return this._dvcls != null;
        }

        private String setDeviceClass(Object cls) {
            Object old = this._dvcls;
            this._dvcls = cls;
            return old instanceof Class ? ((Class)old).getName() : (String)old;
        }

        @Override
        public String getUnavailableMessage() {
            return this._uamsg;
        }

        public String setUnavailableMessage(String msg) {
            String old = this._uamsg;
            this._uamsg = msg != null && msg.length() > 0 ? msg : null;
            return old;
        }

        public String setServerPushClass(Object cls) {
            Object old = this._spushcls;
            this._spushcls = cls;
            return old instanceof Class ? ((Class)old).getName() : (String)old;
        }

        public String getServerPushClassName() {
            return this._spushcls instanceof Class ? ((Class)this._spushcls).getName() : (String)this._spushcls;
        }

        @Override
        public Class getServerPushClass() {
            try {
                return this._spushcls instanceof Class ? (Class)this._spushcls : (this._spushcls != null ? Classes.forNameByThread((String)((String)this._spushcls)) : null);
            }
            catch (ClassNotFoundException ex) {
                throw new UiException("Class not found: " + this._spushcls);
            }
        }

        public void addEmbedded(String content) {
            if (content != null && content.length() > 0) {
                this._embed = this._embed != null ? this._embed + "\n" + content : content;
            }
        }

        @Override
        public String getEmbedded() {
            return this._embed;
        }

        private Device newDevice(String deviceType) {
            if (this._dvcls == null) {
                throw new DeviceNotFoundException(deviceType, MZk.NOT_FOUND, deviceType);
            }
            try {
                Class cls;
                if (this._dvcls instanceof Class) {
                    cls = (Class)this._dvcls;
                } else {
                    cls = Classes.forNameByThread((String)((String)this._dvcls));
                    if (!Device.class.isAssignableFrom(cls)) {
                        throw new IllegalArgumentException(cls + " must implements " + Device.class);
                    }
                }
                Device device = (Device)cls.newInstance();
                device.init(deviceType, this);
                return device;
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to create " + this._dvcls);
            }
        }
    }
}

