/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.LegacyLogicEvaluator;
import org.compiere.util.TimeUtil;
import org.idempiere.expression.logic.LogicEvaluator;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogicExpressionTest
extends AbstractTestCase {
    private static final DefaultEvaluatee evaluatee = new DefaultEvaluatee();

    @Test
    public void testEqual() {
        String expr = "@$Element_AY@='Y'";
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"Y");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"N");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"N");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        expr = "@$Element_AY@=Y";
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"Y");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"N");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_AY", (String)"N");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        expr = "@LineType@=\"C\"&@CalculationType@='A,R,S'";
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", (String)"C");
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"B");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"A");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"A,R,S");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testAnd() {
        String expr = "@$Element_BP@=Y & @AnyBPartner@=N";
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_BP", null);
        Env.setContext((Properties)Env.getCtx(), (String)"AnyBPartner", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_BP", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"AnyBPartner", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"AnyBPartner", (String)"N");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_BP", (String)"N");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_BP", null);
        Env.setContext((Properties)Env.getCtx(), (String)"AnyBPartner", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_BP", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"AnyBPartner", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"AnyBPartner", (String)"N");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"$Element_BP", (String)"N");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testIn() {
        String expr = "@LineType@=C&@CalculationType@=A,R,S";
        this.testInARS(expr);
        expr = "@LineType@='C'&@CalculationType@='A','R','S'";
        this.testInARS(expr);
        expr = "@LineType@=\"C\"&@CalculationType@=\"A\",\"R\",\"S\"";
        this.testInARS(expr);
        expr = "@Name@='Name 1','Name 2','Name 3'";
        this.testInName123(expr);
        expr = "@Name@=\"Name 1\",\"Name 2\",\"Name 3\"";
        this.testInName123(expr);
    }

    private void testInName123(String expr) {
        Env.setContext((Properties)Env.getCtx(), (String)"Name", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Name", (String)"Name 2");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Name", (String)"Name 4");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Name", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Name", (String)"Name 2");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Name", (String)"Name 4");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    private void testInARS(String expr) {
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", null);
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", (String)"C");
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"B");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"A");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"R");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"S");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", (String)"D");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", null);
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", (String)"C");
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"B");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"A");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"R");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"CalculationType", (String)"S");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"LineType", (String)"D");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testNotEqual() {
        String expr = "@C_Bpartner_ID@!0";
        Env.setContext((Properties)Env.getCtx(), (String)"C_Bpartner_ID", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Bpartner_ID", (String)"0");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Bpartner_ID", (String)"100");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Bpartner_ID", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Bpartner_ID", (String)"0");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Bpartner_ID", (String)"100");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        expr = "@IsOverUnderPayment@=Y & @C_Invoice_ID@^0";
        Env.setContext((Properties)Env.getCtx(), (String)"IsOverUnderPayment", null);
        Env.setContext((Properties)Env.getCtx(), (String)"C_Invoice_ID", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsOverUnderPayment", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Invoice_ID", (String)"0");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Invoice_ID", (String)"100");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsOverUnderPayment", null);
        Env.setContext((Properties)Env.getCtx(), (String)"C_Invoice_ID", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsOverUnderPayment", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Invoice_ID", (String)"0");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"C_Invoice_ID", (String)"100");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testOrAnd() {
        String expr = "@IsSold@='Y' | @IsPurchased@='Y' & @IsSummary@='N'";
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", null);
        Env.setContext((Properties)Env.getCtx(), (String)"IsPurchased", null);
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"N");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsPurchased", (String)"Y");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", (String)"N");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", null);
        Env.setContext((Properties)Env.getCtx(), (String)"IsPurchased", null);
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"N");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsPurchased", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", (String)"N");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testAndOr() {
        String expr = "@IsSummary@='N' & @ProductType@=I | @ProductType@=S";
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", null);
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", null);
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"N");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", (String)"I");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", (String)"S");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"Y");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", null);
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", null);
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"N");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", (String)"I");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", (String)"S");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testAndOrGroup() {
        String expr = "@IsSummary@='N' & (@ProductType@=I | @ProductType@=S)";
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", null);
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", null);
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"N");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", (String)"I");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ProductType", (String)"S");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testOrAndGroup() {
        String expr = "@IsSold@='Y' | (@IsPurchased@='Y' & @IsSummary@='N')";
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", null);
        Env.setContext((Properties)Env.getCtx(), (String)"IsPurchased", null);
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"N");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsPurchased", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSold", (String)"N");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSummary", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testGT() {
        String expr = "@IsLot@=Y& @M_LotCtl_ID@ > 0";
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", null);
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"0");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"101");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", (String)"N");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", null);
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"0");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"101");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", (String)"N");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testGE() {
        String expr = "@IsLot@=Y& @M_LotCtl_ID@ >= 100";
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", null);
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"0");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"100");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"99");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testLT() {
        String expr = "@A_Asset_ID@<1&@A_CreateAsset@='Y'";
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", null);
        Env.setContext((Properties)Env.getCtx(), (String)"A_CreateAsset", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", (String)"1");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_CreateAsset", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", (String)"0");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", null);
        Env.setContext((Properties)Env.getCtx(), (String)"A_CreateAsset", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", (String)"1");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_CreateAsset", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", (String)"0");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testLE() {
        String expr = "@A_Asset_ID@<=1&@A_CreateAsset@='Y'";
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", null);
        Env.setContext((Properties)Env.getCtx(), (String)"A_CreateAsset", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", (String)"2");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_CreateAsset", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"A_Asset_ID", (String)"1");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testNegate() {
        String expr = "$!(@IsLot@=Y & @M_LotCtl_ID@ > 0)";
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", null);
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", null);
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsLot", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"1");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"M_LotCtl_ID", (String)"0");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testRE() {
        String expr = "@Identifier@ ~ '^([a-zA-Z_$][a-zA-Z\\d_$]*)$'";
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"validIdentifier");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"$validIdentifier");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"~inValidIdentifier");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"_validIdentifier");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"0inValidIdentifier");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"validIdentifier0");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        expr = "@Identifier@ ~ '.*\\b1\\b.*'";
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"0");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"1");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"1,2");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"2,1");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"1,2");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"1,2,3");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"Identifier", (String)"2,3");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testValidation() {
        Exception ex = null;
        String expr = "@IsSummary@='N' & (@ProductType@=I | @ProductType@=S)";
        try {
            LogicEvaluator.validate((String)expr);
        }
        catch (Exception e) {
            ex = e;
        }
        Assertions.assertNull((Object)ex);
        expr = expr.substring(0, expr.length() - 1);
        try {
            LogicEvaluator.validate((String)expr);
        }
        catch (Exception e) {
            ex = e;
        }
        Assertions.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
    }

    @Test
    public void testConditionalVariable() {
        String expr = "@IsSOTrx:N@=N | @+IgnoreIsSOTrxInBPInfo:N@=Y";
        Env.setContext((Properties)Env.getCtx(), (String)"IsSOTrx", null);
        Env.setContext((Properties)Env.getCtx(), (String)"+IgnoreIsSOTrxInBPInfo", null);
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSOTrx", (String)"Y");
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"+IgnoreIsSOTrxInBPInfo", (String)"Y");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSOTrx", null);
        Env.setContext((Properties)Env.getCtx(), (String)"+IgnoreIsSOTrxInBPInfo", null);
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"IsSOTrx", (String)"Y");
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"+IgnoreIsSOTrxInBPInfo", (String)"Y");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testValidateAD() {
        String[] columns = new String[]{"MandatoryLogic", "DocValueLogic", "ReadOnlyLogic", "DisplayLogic", "ZoomLogic"};
        Query query = new Query(Env.getCtx(), "AD_Column", "AD_Column_ID < 1000000 AND ColumnName=?", this.getTrxName());
        query.setOnlyActiveRecords(true);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            List list = query.setParameters(new Object[]{column}).list();
            for (MColumn mc : list) {
                MTable table = MTable.get((int)mc.getAD_Table_ID());
                if (!table.isActive() || table.getAD_Table_ID() >= 1000000) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("SELECT * ").append(" FROM ").append(table.getTableName()).append(" WHERE ").append(mc.getColumnName()).append(" IS NOT NULL");
                try {
                    Throwable throwable = null;
                    Object var14_16 = null;
                    try (CPreparedStatement stmt = DB.prepareStatement((String)builder.toString(), (String)this.getTrxName());){
                        ResultSet rs = stmt.executeQuery();
                        while (rs.next()) {
                            String expr = rs.getString(mc.getColumnName());
                            if (expr.startsWith("@SQL=") || expr.startsWith("SQL=")) continue;
                            try {
                                LogicEvaluator.validate((String)expr);
                            }
                            catch (Exception e) {
                                PO po = table.getPO(rs, this.getTrxName());
                                System.out.println(po.toString() + ", " + table.getTableName() + "." + mc.getColumnName() + " = " + expr);
                                exceptions.add(e);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    Assertions.fail((String)e.getMessage(), (Throwable)e);
                }
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)exceptions.isEmpty(), (String)("Found " + exceptions.size() + " logic expression with invalid syntax in AD"));
    }

    @Test
    public void testDateExpression() {
        String expr = "@DateAcct@<@DateOrdered@";
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        Env.setContext((Properties)Env.getCtx(), (String)"DateAcct", null);
        Env.setContext((Properties)Env.getCtx(), (String)"DateOrdered", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateAcct", (Timestamp)today);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateOrdered", (Timestamp)today);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateAcct", (Timestamp)TimeUtil.addDays((Timestamp)today, (int)-1));
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateAcct", null);
        Env.setContext((Properties)Env.getCtx(), (String)"DateOrdered", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateAcct", (Timestamp)today);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateOrdered", (Timestamp)today);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"DateAcct", (Timestamp)TimeUtil.addDays((Timestamp)today, (int)-1));
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testNumericExpression() {
        String expr = "@QtyReserved@=0";
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", (int)1);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", (int)0);
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", (String)"0.00");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", (int)1);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", (int)0);
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"QtyReserved", (String)"0.00");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        expr = "1.50>1.00";
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testEmptyStringExpression() {
        String expr = "@ColumnSQL@=''";
        Env.setContext((Properties)Env.getCtx(), (String)"ColumnSQL", null);
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ColumnSQL", null);
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        expr = "@ColumnSQL@!''";
        Env.setContext((Properties)Env.getCtx(), (String)"ColumnSQL", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ColumnSQL", (String)"now()");
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ColumnSQL", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
        Env.setContext((Properties)Env.getCtx(), (String)"ColumnSQL", (String)"now()");
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testOSEnvVariable() {
        String username = System.getenv("USER");
        if (username == null) {
            username = "";
        }
        String expr = "@$env.USER@='" + username + "'";
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr));
    }

    @Test
    public void testNestedProperty() {
        String expr = "@Processed@=Y & @M_Product_ID.IsBOM@=Y";
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"Processed", null);
        Assertions.assertFalse((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)new DefaultEvaluatee(null, 1, 0), (String)expr));
        int pchair = 133;
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"Processed", (String)"Y");
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"M_Product_ID", (int)pchair);
        Assertions.assertTrue((boolean)LegacyLogicEvaluator.evaluateLogic((Evaluatee)new DefaultEvaluatee(null, 1, 0), (String)expr));
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"Processed", null);
        Assertions.assertFalse((boolean)LogicEvaluator.evaluateLogic((Evaluatee)new DefaultEvaluatee(null, 1, 0), (String)expr));
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"Processed", (String)"Y");
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"M_Product_ID", (int)pchair);
        Assertions.assertTrue((boolean)LogicEvaluator.evaluateLogic((Evaluatee)new DefaultEvaluatee(null, 1, 0), (String)expr));
    }
}

