/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Evaluatee;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;

public class GridRowCtx
extends Properties
implements Evaluatee {
    private static final long serialVersionUID = 8163657930039348267L;
    private final Properties ctx;
    private final GridTab gridTab;
    private final int windowNo;
    private final int row;

    public GridRowCtx(Properties ctx, GridTab tab) {
        this(ctx, tab, -1);
    }

    public GridRowCtx(Properties ctx, GridTab tab, int row) {
        this.ctx = ctx;
        this.gridTab = tab;
        this.windowNo = tab.getWindowNo();
        this.row = row;
    }

    private String getColumnName(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String keyStr = (String)key;
        String windowStr = this.windowNo + "|";
        if (!keyStr.startsWith(windowStr)) {
            return null;
        }
        String columnName = keyStr.substring(windowStr.length()).trim();
        if (columnName.indexOf("|") > 0) {
            columnName = columnName.substring(columnName.indexOf("|") + 1);
        }
        return columnName;
    }

    @Override
    public synchronized Object get(Object key) {
        String columnName = this.getColumnName(key);
        if (columnName == null) {
            return this.ctx.get(key);
        }
        GridTable gridTable = this.gridTab.getTableModel();
        int col = gridTable.findColumn(columnName);
        if (col == -1) {
            return this.ctx.get(key);
        }
        Object value = gridTable.getValueAt(this.getRow(), col);
        if (value == null) {
            value = "";
        } else if (value instanceof KeyNamePair) {
            value = ((KeyNamePair)value).getKey();
        } else if (value instanceof ValueNamePair) {
            value = ((ValueNamePair)value).getID();
        } else if (value instanceof Boolean) {
            value = (Boolean)value != false ? "Y" : "N";
        }
        return value.toString();
    }

    private int getRow() {
        return this.row >= 0 ? this.row : this.gridTab.getCurrentRow();
    }

    @Override
    public synchronized void clear() {
        this.ctx.clear();
    }

    @Override
    public synchronized Object clone() {
        GridRowCtx grc = new GridRowCtx((Properties)this.ctx.clone(), this.gridTab, this.row);
        return grc;
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        GridTable gridTable = this.gridTab.getTableModel();
        String columnName = this.getColumnName(key);
        if (columnName != null && gridTable.findColumn(columnName) != -1) {
            return true;
        }
        return this.ctx.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            GridField[] fields;
            GridField[] gridFieldArray = fields = this.gridTab.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                GridField field = gridFieldArray[n2];
                Object fieldValue = this.gridTab.getValue(this.getRow(), field.getColumnName());
                if (fieldValue != null && fieldValue.equals(value)) {
                    return true;
                }
                ++n2;
            }
        }
        return this.ctx.containsValue(value);
    }

    @Override
    public synchronized Enumeration<Object> elements() {
        GridField[] fields;
        Vector<Object> list = new Vector<Object>(this.ctx.values());
        GridField[] gridFieldArray = fields = this.gridTab.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            Object fieldValue = this.gridTab.getValue(this.getRow(), field.getColumnName());
            if (fieldValue != null) {
                list.add(fieldValue);
            }
            ++n2;
        }
        return list.elements();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        HashSet<Map.Entry<Object, Object>> set = new HashSet<Map.Entry<Object, Object>>(this.ctx.entrySet());
        GridField[] fields = this.gridTab.getFields();
        LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
        GridField[] gridFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            Object fieldValue = this.gridTab.getValue(this.getRow(), field.getColumnName());
            fieldMap.put(field.getColumnName(), fieldValue);
            ++n2;
        }
        set.addAll(fieldMap.entrySet());
        return set;
    }

    @Override
    public synchronized boolean isEmpty() {
        return false;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        GridField[] fields;
        Vector<Object> list = new Vector<Object>(this.ctx.keySet());
        GridField[] gridFieldArray = fields = this.gridTab.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            list.add(field.getColumnName());
            ++n2;
        }
        return list.elements();
    }

    @Override
    public Set<Object> keySet() {
        GridField[] fields;
        HashSet<Object> set = new HashSet<Object>(this.ctx.keySet());
        GridField[] gridFieldArray = fields = this.gridTab.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField field = gridFieldArray[n2];
            set.add(field.getColumnName());
            ++n2;
        }
        return set;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.ctx.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        for (Map.Entry<? extends Object, ? extends Object> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.ctx.remove(key);
    }

    @Override
    public synchronized int size() {
        return this.ctx.size() + this.gridTab.getFieldCount();
    }

    @Override
    public synchronized String toString() {
        StringBuilder builder = new StringBuilder(this.ctx.toString());
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
            if (builder.length() > 1) {
                builder.append(", ");
            }
        } else {
            builder.append("{");
        }
        GridField[] fields = this.gridTab.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            builder.append(fields[i2].getColumnName()).append("=");
            Object value = this.gridTab.getValue(this.getRow(), fields[i2].getColumnName());
            builder.append(value == null ? "" : value.toString());
            if (i2 == fields.length - 1) {
                builder.append("}");
            } else {
                builder.append(", ");
            }
            ++i2;
        }
        return builder.toString();
    }

    @Override
    public Collection<Object> values() {
        return this.ctx.values();
    }

    @Override
    public String getProperty(String key) {
        Object oval = this.get(key);
        return oval == null ? null : oval.toString();
    }

    @Override
    public String get_ValueAsString(String variableName) {
        DefaultEvaluatee evaluatee = new DefaultEvaluatee(this.gridTab, this.windowNo, -1);
        return evaluatee.get_ValueAsString(this, variableName);
    }
}

