/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import com.lowagie.text.pdf.CMYKColor;
import java.awt.Color;
import java.awt.color.ColorSpace;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;

public class ClassicPdfUtils {
    public static int toPdfAlignment(PdfTextAlignment alignment) {
        int pdfAlign;
        switch (alignment) {
            case LEFT: {
                pdfAlign = 0;
                break;
            }
            case RIGHT: {
                pdfAlign = 2;
                break;
            }
            case CENTER: {
                pdfAlign = 1;
                break;
            }
            case JUSTIFIED: {
                pdfAlign = 3;
                break;
            }
            case JUSTIFIED_ALL: {
                pdfAlign = 8;
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown paragraph alignment " + (Object)((Object)alignment));
            }
        }
        return pdfAlign;
    }

    public static Color convertColor(ColorSpace targetColorSpace, Color color) {
        if (color != null && targetColorSpace != null) {
            float[] cmykColor = targetColorSpace.fromRGB(color.getRGBComponents(null));
            color = new CMYKColor(cmykColor[0], cmykColor[1], cmykColor[2], cmykColor[3]);
        }
        return color;
    }
}

