/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.adempiere.process.UUIDGenerator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaDefault;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

@Process
public class AcctSchemaDefaultCopy
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private boolean p_CopyOverwriteAcct = false;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                } else if (name.equals("CopyOverwriteAcct")) {
                    this.p_CopyOverwriteAcct = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + ", CopyOverwriteAcct=" + this.p_CopyOverwriteAcct);
        }
        if (this.p_C_AcctSchema_ID == 0) {
            throw new AdempiereSystemError("C_AcctSchema_ID=0");
        }
        MAcctSchema as = MAcctSchema.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
        if (as.get_ID() == 0) {
            throw new AdempiereSystemError("Not Found - C_AcctSchema_ID=" + this.p_C_AcctSchema_ID);
        }
        MAcctSchemaDefault acct = MAcctSchemaDefault.get((Properties)this.getCtx(), (int)this.p_C_AcctSchema_ID);
        if (acct == null || acct.get_ID() == 0) {
            throw new AdempiereSystemError("Default Not Found - C_AcctSchema_ID=" + this.p_C_AcctSchema_ID);
        }
        StringBuilder sql = null;
        int updated = 0;
        int created = 0;
        int updatedTotal = 0;
        int createdTotal = 0;
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE M_Product_Category_Acct pa ").append("SET P_Revenue_Acct=").append(acct.getP_Revenue_Acct()).append(", P_Expense_Acct=").append(acct.getP_Expense_Acct()).append(", P_CostAdjustment_Acct=").append(acct.getP_CostAdjustment_Acct()).append(", P_InventoryClearing_Acct=").append(acct.getP_InventoryClearing_Acct()).append(", P_Asset_Acct=").append(acct.getP_Asset_Acct()).append(", P_COGS_Acct=").append(acct.getP_COGS_Acct()).append(", P_PurchasePriceVariance_Acct=").append(acct.getP_PurchasePriceVariance_Acct()).append(", P_InvoicePriceVariance_Acct=").append(acct.getP_InvoicePriceVariance_Acct()).append(", P_AverageCostVariance_Acct=").append(acct.getP_AverageCostVariance_Acct()).append(", P_TradeDiscountRec_Acct=").append(acct.getP_TradeDiscountRec_Acct()).append(", P_TradeDiscountGrant_Acct=").append(acct.getP_TradeDiscountGrant_Acct()).append(", P_RateVariance_Acct=").append(acct.getP_RateVariance_Acct()).append(", P_LandedCostClearing_Acct=").append(acct.getP_LandedCostClearing_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE pa.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM M_Product_Category p ").append("WHERE p.M_Product_Category_ID=pa.M_Product_Category_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @M_Product_Category_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO M_Product_Category_Acct ").append("(M_Product_Category_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" P_Revenue_Acct, P_Expense_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_Asset_Acct, P_CoGs_Acct,").append(" P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_AverageCostVariance_Acct,").append(" P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct,").append(" P_RateVariance_Acct, P_LandedCostClearing_Acct) ").append(" SELECT p.M_Product_Category_ID, acct.C_AcctSchema_ID,").append(" p.AD_Client_ID, p.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.P_Revenue_Acct, acct.P_Expense_Acct, acct.P_CostAdjustment_Acct, acct.P_InventoryClearing_Acct, acct.P_Asset_Acct, acct.P_CoGs_Acct,").append(" acct.P_PurchasePriceVariance_Acct, acct.P_InvoicePriceVariance_Acct, acct.P_AverageCostVariance_Acct,").append(" acct.P_TradeDiscountRec_Acct, acct.P_TradeDiscountGrant_Acct,").append(" acct.P_RateVariance_Acct, acct.P_LandedCostClearing_Acct ").append("FROM M_Product_Category p").append(" INNER JOIN C_AcctSchema_Default acct ON (p.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM M_Product_Category_Acct pa ").append("WHERE pa.M_Product_Category_ID=p.M_Product_Category_ID").append(" AND pa.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE M_Product_Category_Acct SET M_Product_Category_Acct_UU=generate_uuid() WHERE M_Product_Category_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"M_Product_Category_Acct", (String)PO.getUUIDColumnName((String)"M_Product_Category_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @M_Product_Category_ID@");
        createdTotal += created;
        if (!this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("INSERT INTO M_Product_Acct ").append("(M_Product_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" P_Revenue_Acct, P_Expense_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_Asset_Acct, P_CoGs_Acct,").append(" P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_AverageCostVariance_Acct,").append(" P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct, ").append(" P_RateVariance_Acct, P_LandedCostClearing_Acct) ").append("SELECT p.M_Product_ID, acct.C_AcctSchema_ID,").append(" p.AD_Client_ID, p.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.P_Revenue_Acct, acct.P_Expense_Acct, acct.P_CostAdjustment_Acct, acct.P_InventoryClearing_Acct, acct.P_Asset_Acct, acct.P_CoGs_Acct,").append(" acct.P_PurchasePriceVariance_Acct, acct.P_InvoicePriceVariance_Acct, acct.P_AverageCostVariance_Acct,").append(" acct.P_TradeDiscountRec_Acct, acct.P_TradeDiscountGrant_Acct,").append(" acct.P_RateVariance_Acct, acct.P_LandedCostClearing_Acct ").append("FROM M_Product p").append(" INNER JOIN M_Product_Category_Acct acct ON (acct.M_Product_Category_ID=p.M_Product_Category_ID)").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND p.M_Product_Category_ID=acct.M_Product_Category_ID").append(" AND NOT EXISTS (SELECT * FROM M_Product_Acct pa ").append("WHERE pa.M_Product_ID=p.M_Product_ID").append(" AND pa.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
            created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (DB.isGenerateUUIDSupported()) {
                DB.executeUpdateEx((String)"UPDATE M_Product_Acct SET M_Product_Acct_UU=generate_uuid() WHERE M_Product_Acct_UU IS NULL", (String)this.get_TrxName());
            } else {
                UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"M_Product_Acct", (String)PO.getUUIDColumnName((String)"M_Product_Acct")), (String)this.get_TrxName());
            }
            this.addLog(0, null, new BigDecimal(created), "@Created@ @M_Product_ID@");
            createdTotal += created;
        }
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE C_BP_Group_Acct a ").append("SET C_Receivable_Acct=").append(acct.getC_Receivable_Acct()).append(", C_Receivable_Services_Acct=").append(acct.getC_Receivable_Services_Acct()).append(", C_Prepayment_Acct=").append(acct.getC_Prepayment_Acct()).append(", V_Liability_Acct=").append(acct.getV_Liability_Acct()).append(", V_Liability_Services_Acct=").append(acct.getV_Liability_Services_Acct()).append(", V_Prepayment_Acct=").append(acct.getV_Prepayment_Acct()).append(", PayDiscount_Exp_Acct=").append(acct.getPayDiscount_Exp_Acct()).append(", PayDiscount_Rev_Acct=").append(acct.getPayDiscount_Rev_Acct()).append(", WriteOff_Acct=").append(acct.getWriteOff_Acct()).append(", NotInvoicedReceipts_Acct=").append(acct.getNotInvoicedReceipts_Acct()).append(", UnEarnedRevenue_Acct=").append(acct.getUnEarnedRevenue_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM C_BP_Group_Acct x ").append("WHERE x.C_BP_Group_ID=a.C_BP_Group_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @C_BP_Group_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO C_BP_Group_Acct ").append("(C_BP_Group_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" C_Receivable_Acct, C_Receivable_Services_Acct, C_PrePayment_Acct,").append(" V_Liability_Acct, V_Liability_Services_Acct, V_PrePayment_Acct,").append(" PayDiscount_Exp_Acct, PayDiscount_Rev_Acct, WriteOff_Acct,").append(" NotInvoicedReceipts_Acct, UnEarnedRevenue_Acct) ").append("SELECT x.C_BP_Group_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.C_Receivable_Acct, acct.C_Receivable_Services_Acct, acct.C_PrePayment_Acct,").append(" acct.V_Liability_Acct, acct.V_Liability_Services_Acct, acct.V_PrePayment_Acct,").append(" acct.PayDiscount_Exp_Acct, acct.PayDiscount_Rev_Acct, acct.WriteOff_Acct,").append(" acct.NotInvoicedReceipts_Acct, acct.UnEarnedRevenue_Acct ").append("FROM C_BP_Group x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM C_BP_Group_Acct a ").append("WHERE a.C_BP_Group_ID=x.C_BP_Group_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE C_BP_Group_Acct SET C_BP_Group_Acct_UU=generate_uuid() WHERE C_BP_Group_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_BP_Group_Acct", (String)PO.getUUIDColumnName((String)"C_BP_Group_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @C_BP_Group_ID@");
        createdTotal += created;
        if (!this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("INSERT INTO C_BP_Customer_Acct ").append("(C_BPartner_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" C_Receivable_Acct, C_Receivable_Services_Acct, C_PrePayment_Acct) ").append("SELECT p.C_BPartner_ID, acct.C_AcctSchema_ID,").append(" p.AD_Client_ID, p.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.C_Receivable_Acct, acct.C_Receivable_Services_Acct, acct.C_PrePayment_Acct ").append("FROM C_BPartner p").append(" INNER JOIN C_BP_Group_Acct acct ON (acct.C_BP_Group_ID=p.C_BP_Group_ID)").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND p.C_BP_Group_ID=acct.C_BP_Group_ID").append(" AND NOT EXISTS (SELECT * FROM C_BP_Customer_Acct ca ").append("WHERE ca.C_BPartner_ID=p.C_BPartner_ID").append(" AND ca.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
            created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (DB.isGenerateUUIDSupported()) {
                DB.executeUpdateEx((String)"UPDATE C_BP_Customer_Acct SET C_BP_Customer_Acct_UU=generate_uuid() WHERE C_BP_Customer_Acct_UU IS NULL", (String)this.get_TrxName());
            } else {
                UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_BP_Customer_Acct", (String)PO.getUUIDColumnName((String)"C_BP_Customer_Acct")), (String)this.get_TrxName());
            }
            this.addLog(0, null, new BigDecimal(created), "@Created@ @C_BPartner_ID@ @IsCustomer@");
            createdTotal += created;
            sql = new StringBuilder("INSERT INTO C_BP_Vendor_Acct ").append("(C_BPartner_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" V_Liability_Acct, V_Liability_Services_Acct, V_PrePayment_Acct) ").append("SELECT p.C_BPartner_ID, acct.C_AcctSchema_ID,").append(" p.AD_Client_ID, p.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.V_Liability_Acct, acct.V_Liability_Services_Acct, acct.V_PrePayment_Acct ").append("FROM C_BPartner p").append(" INNER JOIN C_BP_Group_Acct acct ON (acct.C_BP_Group_ID=p.C_BP_Group_ID)").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND p.C_BP_Group_ID=acct.C_BP_Group_ID").append(" AND NOT EXISTS (SELECT * FROM C_BP_Vendor_Acct va ").append("WHERE va.C_BPartner_ID=p.C_BPartner_ID AND va.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
            created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            if (DB.isGenerateUUIDSupported()) {
                DB.executeUpdateEx((String)"UPDATE C_BP_Vendor_Acct SET C_BP_Vendor_Acct_UU=generate_uuid() WHERE C_BP_Vendor_Acct_UU IS NULL", (String)this.get_TrxName());
            } else {
                UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_BP_Vendor_Acct", (String)PO.getUUIDColumnName((String)"C_BP_Vendor_Acct")), (String)this.get_TrxName());
            }
            this.addLog(0, null, new BigDecimal(created), "@Created@ @C_BPartner_ID@ @IsVendor@");
            createdTotal += created;
        }
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE M_Warehouse_Acct a ").append("SET W_Differences_Acct=").append(acct.getW_Differences_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM M_Warehouse_Acct x ").append("WHERE x.M_Warehouse_ID=a.M_Warehouse_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @M_Warehouse_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO M_Warehouse_Acct ").append("(M_Warehouse_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" W_Differences_Acct) ").append("SELECT x.M_Warehouse_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.W_Differences_Acct ").append("FROM M_Warehouse x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM M_Warehouse_Acct a ").append("WHERE a.M_Warehouse_ID=x.M_Warehouse_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE M_Warehouse_Acct SET M_Warehouse_Acct_UU=generate_uuid() WHERE M_Warehouse_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"M_Warehouse_Acct", (String)PO.getUUIDColumnName((String)"M_Warehouse_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @M_Warehouse_ID@");
        createdTotal += created;
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE C_Project_Acct a ").append("SET PJ_Asset_Acct=").append(acct.getPJ_Asset_Acct()).append(", PJ_WIP_Acct=").append(acct.getPJ_Asset_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM C_Project_Acct x ").append("WHERE x.C_Project_ID=a.C_Project_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @C_Project_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO C_Project_Acct ").append("(C_Project_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" PJ_Asset_Acct, PJ_WIP_Acct) ").append("SELECT x.C_Project_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.PJ_Asset_Acct, acct.PJ_WIP_Acct ").append("FROM C_Project x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM C_Project_Acct a ").append("WHERE a.C_Project_ID=x.C_Project_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE C_Project_Acct SET C_Project_Acct_UU=generate_uuid() WHERE C_Project_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_Project_Acct", (String)PO.getUUIDColumnName((String)"C_Project_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @C_Project_ID@");
        createdTotal += created;
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE C_Tax_Acct a ").append("SET T_Due_Acct=").append(acct.getT_Due_Acct()).append(", T_Credit_Acct=").append(acct.getT_Credit_Acct()).append(", T_Expense_Acct=").append(acct.getT_Expense_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM C_Tax_Acct x ").append("WHERE x.C_Tax_ID=a.C_Tax_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @C_Tax_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO C_Tax_Acct ").append("(C_Tax_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" T_Due_Acct, T_Credit_Acct, T_Expense_Acct) ").append("SELECT x.C_Tax_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.T_Due_Acct, acct.T_Credit_Acct, acct.T_Expense_Acct ").append("FROM C_Tax x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM C_Tax_Acct a ").append("WHERE a.C_Tax_ID=x.C_Tax_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE C_Tax_Acct SET C_Tax_Acct_UU=generate_uuid() WHERE C_Tax_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_Tax_Acct", (String)PO.getUUIDColumnName((String)"C_Tax_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @C_Tax_ID@");
        createdTotal += created;
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE C_BankAccount_Acct a ").append("SET B_InTransit_Acct=").append(acct.getB_InTransit_Acct()).append(", B_Asset_Acct=").append(acct.getB_Asset_Acct()).append(", B_InterestRev_Acct=").append(acct.getB_InterestRev_Acct()).append(", B_InterestExp_Acct=").append(acct.getB_InterestExp_Acct()).append(", B_UnallocatedCash_Acct=").append(acct.getB_UnallocatedCash_Acct()).append(", B_PaymentSelect_Acct=").append(acct.getB_PaymentSelect_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM C_BankAccount_Acct x ").append("WHERE x.C_BankAccount_ID=a.C_BankAccount_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @C_BankAccount_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO C_BankAccount_Acct ").append("(C_BankAccount_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" B_InTransit_Acct, B_Asset_Acct, B_InterestRev_Acct, B_InterestExp_Acct,").append(" B_UnallocatedCash_Acct, B_PaymentSelect_Acct) ").append("SELECT x.C_BankAccount_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.B_InTransit_Acct, acct.B_Asset_Acct, acct.B_InterestRev_Acct, acct.B_InterestExp_Acct,").append(" acct.B_UnallocatedCash_Acct, acct.B_PaymentSelect_Acct ").append("FROM C_BankAccount x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM C_BankAccount_Acct a ").append("WHERE a.C_BankAccount_ID=x.C_BankAccount_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE C_BankAccount_Acct SET C_BankAccount_Acct_UU=generate_uuid() WHERE C_BankAccount_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_BankAccount_Acct", (String)PO.getUUIDColumnName((String)"C_BankAccount_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @C_BankAccount_ID@");
        createdTotal += created;
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE C_Charge_Acct a ").append("SET Ch_Expense_Acct=").append(acct.getCh_Expense_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM C_Charge_Acct x ").append("WHERE x.C_Charge_ID=a.C_Charge_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @C_Charge_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO C_Charge_Acct ").append("(C_Charge_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" Ch_Expense_Acct) ").append("SELECT x.C_Charge_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.Ch_Expense_Acct ").append("FROM C_Charge x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM C_Charge_Acct a ").append("WHERE a.C_Charge_ID=x.C_Charge_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE C_Charge_Acct SET C_Charge_Acct_UU=generate_uuid() WHERE C_Charge_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_Charge_Acct", (String)PO.getUUIDColumnName((String)"C_Charge_Acct")), (String)this.get_TrxName());
        }
        this.addLog(0, null, new BigDecimal(created), "@Created@ @C_Charge_ID@");
        createdTotal += created;
        if (this.p_CopyOverwriteAcct) {
            sql = new StringBuilder("UPDATE C_Cashbook_Acct a ").append("SET CB_Asset_Acct=").append(acct.getCB_Asset_Acct()).append(", CB_Differences_Acct=").append(acct.getCB_Differences_Acct()).append(", CB_CashTransfer_Acct=").append(acct.getCB_CashTransfer_Acct()).append(", CB_Expense_Acct=").append(acct.getCB_Expense_Acct()).append(", CB_Receipt_Acct=").append(acct.getCB_Receipt_Acct()).append(", Updated=getDate(), UpdatedBy=0 ").append("WHERE a.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND EXISTS (SELECT * FROM C_Cashbook_Acct x ").append("WHERE x.C_Cashbook_ID=a.C_Cashbook_ID)");
            updated = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(updated), "@Updated@ @C_Cashbook_ID@");
            updatedTotal += updated;
        }
        sql = new StringBuilder("INSERT INTO C_Cashbook_Acct ").append("(C_Cashbook_ID, C_AcctSchema_ID,").append(" AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,").append(" CB_Asset_Acct, CB_Differences_Acct, CB_CashTransfer_Acct,").append(" CB_Expense_Acct, CB_Receipt_Acct) ").append("SELECT x.C_Cashbook_ID, acct.C_AcctSchema_ID,").append(" x.AD_Client_ID, x.AD_Org_ID, 'Y', getDate(), 0, getDate(), 0,").append(" acct.CB_Asset_Acct, acct.CB_Differences_Acct, acct.CB_CashTransfer_Acct,").append(" acct.CB_Expense_Acct, acct.CB_Receipt_Acct ").append("FROM C_Cashbook x").append(" INNER JOIN C_AcctSchema_Default acct ON (x.AD_Client_ID=acct.AD_Client_ID) ").append("WHERE acct.C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND NOT EXISTS (SELECT * FROM C_Cashbook_Acct a ").append("WHERE a.C_Cashbook_ID=x.C_Cashbook_ID").append(" AND a.C_AcctSchema_ID=acct.C_AcctSchema_ID)");
        created = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(created), "@Created@ @C_Cashbook_ID@");
        if (DB.isGenerateUUIDSupported()) {
            DB.executeUpdateEx((String)"UPDATE C_Cashbook_Acct SET C_Cashbook_Acct_UU=generate_uuid() WHERE C_Cashbook_Acct_UU IS NULL", (String)this.get_TrxName());
        } else {
            UUIDGenerator.updateUUID((MColumn)MColumn.get((Properties)this.getCtx(), (String)"C_CashBook_Acct", (String)PO.getUUIDColumnName((String)"C_CashBook_Acct")), (String)this.get_TrxName());
        }
        StringBuilder msgreturn = new StringBuilder("@Created@=").append(createdTotal += created).append(", @Updated@=").append(updatedTotal);
        return msgreturn.toString();
    }
}

