/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MStyleLine;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Style;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MStyle
extends X_AD_Style
implements ImmutablePOSupport {
    private static final long serialVersionUID = 5409686715292148171L;
    private static ImmutableIntPOCache<Integer, MStyle> s_cache = new ImmutableIntPOCache("AD_Style", 30, 60);
    private MStyleLine[] m_lines = null;
    public static final String SCLASS_PREFIX = "@sclass=";
    public static final String ZCLASS_PREFIX = "@zclass=";

    public MStyle(Properties ctx, String AD_Style_UU, String trxName) {
        super(ctx, AD_Style_UU, trxName);
    }

    public MStyle(Properties ctx, int AD_Style_ID, String trxName) {
        super(ctx, AD_Style_ID, trxName);
    }

    public MStyle(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MStyle(MStyle copy) {
        this(Env.getCtx(), copy);
    }

    public MStyle(Properties ctx, MStyle copy) {
        this(ctx, copy, null);
    }

    public MStyle(Properties ctx, MStyle copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_lines = copy.m_lines != null ? (MStyleLine[])Arrays.stream(copy.m_lines).map(e -> new MStyleLine(ctx, (MStyleLine)e, trxName)).toArray(MStyleLine[]::new) : null;
    }

    public static MStyle get(int AD_Style_ID) {
        return MStyle.get(Env.getCtx(), AD_Style_ID);
    }

    public static MStyle get(Properties ctx, int AD_Style_ID) {
        Integer key = AD_Style_ID;
        MStyle retValue = s_cache.get(ctx, key, e -> new MStyle(ctx, (MStyle)e));
        if (retValue == null) {
            retValue = new MStyle(ctx, AD_Style_ID, null);
            if (retValue.get_ID() == AD_Style_ID) {
                s_cache.put(key, retValue, e -> new MStyle(Env.getCtx(), (MStyle)e));
                return retValue;
            }
            return null;
        }
        return retValue;
    }

    public MStyleLine[] getStyleLines() {
        if (this.m_lines == null) {
            Query query = new Query(Env.getCtx(), "AD_StyleLine", "AD_Style_ID=? AND InlineStyle IS NOT NULL", null);
            List<MStyleLine> lines = query.setParameters(this.getAD_Style_ID()).setOnlyActiveRecords(true).setOrderBy("Line").list();
            if (lines.size() > 0 && this.is_Immutable()) {
                for (MStyleLine line : lines) {
                    line.markImmutable();
                }
            }
            this.m_lines = lines.toArray(new MStyleLine[0]);
        }
        return this.m_lines;
    }

    public String buildStyle(String defaultTheme, Evaluatee evaluatee) {
        return this.buildStyle(defaultTheme, evaluatee, true);
    }

    public String buildStyle(String defaultTheme, Evaluatee evaluatee, boolean inline) {
        MStyleLine[] lines = this.getStyleLines();
        StringBuilder styleBuilder = new StringBuilder();
        MStyleLine[] mStyleLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MStyleLine line = mStyleLineArray[n2];
            String styleText = line.getInlineStyle().trim();
            if (this.checkStyleType(styleText, inline)) {
                String displayLogic = line.getDisplayLogic();
                String theme = line.getTheme();
                if ((Util.isEmpty(theme) || theme.equals(defaultTheme)) && (Util.isEmpty(displayLogic) || Evaluator.evaluateLogic(evaluatee, displayLogic))) {
                    if (inline) {
                        if (styleBuilder.length() > 0 && styleBuilder.charAt(styleBuilder.length() - 1) != ';') {
                            styleBuilder.append("; ");
                        }
                    } else if (styleBuilder.length() > 0) {
                        styleBuilder.append("\n");
                    }
                    styleBuilder.append(styleText);
                }
            }
            ++n2;
        }
        return styleBuilder.toString();
    }

    private boolean checkStyleType(String styleText, boolean inline) {
        boolean cssType;
        boolean bl = cssType = styleText.indexOf("{") > 0 && styleText.endsWith("}");
        return inline && !cssType || !inline && cssType;
    }

    @Override
    public MStyle markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_lines != null && this.m_lines.length > 0) {
            Arrays.stream(this.m_lines).forEach(e -> {
                MStyleLine mStyleLine = e.markImmutable();
            });
        }
        return this;
    }
}

