/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MGoalRestriction;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MQuery;
import org.compiere.model.MRequest;
import org.compiere.model.MRole;
import org.compiere.model.MStatusCategory;
import org.compiere.model.Query;
import org.compiere.model.X_R_RequestType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MRequestType
extends X_R_RequestType
implements ImmutablePOSupport {
    private static final long serialVersionUID = -1772516764599702671L;
    private static CLogger s_log = CLogger.getCLogger(MRequestType.class);
    private static ImmutableIntPOCache<Integer, MRequestType> s_cache = new ImmutableIntPOCache("R_RequestType", 10);
    private long m_nextStats = 0L;
    private int m_openNo = 0;
    private int m_totalNo = 0;
    private int m_new30No = 0;
    private int m_closed30No = 0;

    public static MRequestType get(int R_RequestType_ID) {
        return MRequestType.get(Env.getCtx(), R_RequestType_ID);
    }

    public static MRequestType get(Properties ctx, int R_RequestType_ID) {
        Integer key = R_RequestType_ID;
        MRequestType retValue = s_cache.get(ctx, key, e -> new MRequestType(ctx, (MRequestType)e));
        if (retValue == null) {
            retValue = new MRequestType(ctx, R_RequestType_ID, null);
            if (retValue.get_ID() == R_RequestType_ID) {
                s_cache.put(key, retValue, e -> new MRequestType(Env.getCtx(), (MRequestType)e));
                return retValue;
            }
            return null;
        }
        return retValue;
    }

    public static MRequestType getCopy(Properties ctx, int R_RequestType_ID, String trxName) {
        MRequestType rt = MRequestType.get(R_RequestType_ID);
        if (rt != null) {
            rt = new MRequestType(ctx, rt, trxName);
        }
        return rt;
    }

    public static MRequestType getDefault(Properties ctx) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        String whereClause = "AD_Client_ID IN (0," + AD_Client_ID + ")";
        MRequestType retValue = (MRequestType)new Query(ctx, "R_RequestType", whereClause, null).setOrderBy("IsDefault DESC, AD_Client_ID DESC").first();
        if (retValue != null && !retValue.isDefault()) {
            retValue = null;
        }
        return retValue;
    }

    public MRequestType(Properties ctx, String R_RequestType_UU, String trxName) {
        super(ctx, R_RequestType_UU, trxName);
        if (Util.isEmpty(R_RequestType_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRequestType(Properties ctx, int R_RequestType_ID, String trxName) {
        super(ctx, R_RequestType_ID, trxName);
        if (R_RequestType_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDueDateTolerance(7);
        this.setIsDefault(false);
        this.setIsEMailWhenDue(false);
        this.setIsEMailWhenOverdue(false);
        this.setIsSelfService(true);
        this.setAutoDueDateDays(0);
        this.setConfidentialType("A");
        this.setIsAutoChangeRequest(false);
        this.setIsConfidentialInfo(false);
        this.setIsIndexed(true);
        this.setIsInvoiced(false);
    }

    public MRequestType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequestType(MRequestType copy) {
        this(Env.getCtx(), copy);
    }

    public MRequestType(Properties ctx, MRequestType copy) {
        this(ctx, copy, null);
    }

    public MRequestType(Properties ctx, MRequestType copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    private synchronized void updateStatistics() {
        block7: {
            if (System.currentTimeMillis() < this.m_nextStats) {
                return;
            }
            String sql = "SELECT (SELECT COUNT(*) FROM R_Request r INNER JOIN R_Status s ON (r.R_Status_ID=s.R_Status_ID AND s.IsOpen='Y') WHERE r.R_RequestType_ID=x.R_RequestType_ID) AS OpenNo, (SELECT COUNT(*) FROM R_Request r WHERE r.R_RequestType_ID=x.R_RequestType_ID) AS TotalNo, (SELECT COUNT(*) FROM R_Request r WHERE r.R_RequestType_ID=x.R_RequestType_ID AND Created>addDays(getDate(),-30)) AS New30No, (SELECT COUNT(*) FROM R_Request r INNER JOIN R_Status s ON (r.R_Status_ID=s.R_Status_ID AND s.IsClosed='Y') WHERE r.R_RequestType_ID=x.R_RequestType_ID AND r.Updated>addDays(getDate(),-30)) AS Closed30No FROM R_RequestType x WHERE R_RequestType_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getR_RequestType_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_openNo = rs.getInt(1);
                        this.m_totalNo = rs.getInt(2);
                        this.m_new30No = rs.getInt(3);
                        this.m_closed30No = rs.getInt(4);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_nextStats = System.currentTimeMillis() + 3600000L;
    }

    public synchronized int getTotalNo() {
        this.updateStatistics();
        return this.m_totalNo;
    }

    public synchronized int getOpenNo() {
        this.updateStatistics();
        return this.m_openNo;
    }

    public synchronized int getClosed30No() {
        this.updateStatistics();
        return this.m_closed30No;
    }

    public synchronized int getNew30No() {
        this.updateStatistics();
        return this.m_new30No;
    }

    public MRequest[] getRequests(boolean selfService, int C_BPartner_ID) {
        ArrayList<MRequest> list;
        block7: {
            Object sql = "SELECT * FROM R_Request WHERE R_RequestType_ID=?";
            if (selfService) {
                sql = (String)sql + " AND IsSelfService='Y'";
            }
            sql = C_BPartner_ID == 0 ? (String)sql + " AND ConfidentialType='A'" : (String)sql + " AND (ConfidentialType='A' OR C_BPartner_ID=" + C_BPartner_ID + ")";
            sql = (String)sql + " ORDER BY DocumentNo DESC";
            list = new ArrayList<MRequest>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.getR_RequestType_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRequest(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRequest[] retValue = new MRequest[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRequest[] getRequests() {
        return this.getRequests(true, 0);
    }

    public int getDefaultR_Status_ID() {
        MStatusCategory sc;
        if (this.getR_StatusCategory_ID() == 0) {
            sc = MStatusCategory.getDefault(this.getCtx());
            if (sc == null) {
                sc = MStatusCategory.createDefault(this.getCtx());
            }
            if (sc != null && sc.getR_StatusCategory_ID() != 0) {
                this.setR_StatusCategory_ID(sc.getR_StatusCategory_ID());
            }
        }
        if (this.getR_StatusCategory_ID() != 0) {
            sc = MStatusCategory.get(this.getCtx(), this.getR_StatusCategory_ID());
            return sc.getDefaultR_Status_ID();
        }
        return 0;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MStatusCategory sc;
        if (this.getR_StatusCategory_ID() == 0 && (sc = MStatusCategory.getDefault(this.getCtx())) != null && sc.getR_StatusCategory_ID() != 0) {
            this.setR_StatusCategory_ID(sc.getR_StatusCategory_ID());
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRequestType[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public String getSqlPI(MGoalRestriction[] restrictions, String MeasureScope, String MeasureDataType, Timestamp reportDate, MRole role) {
        String dateColumn = "Created";
        String orgColumn = "AD_Org_ID";
        String bpColumn = "C_BPartner_ID";
        String pColumn = "M_Product_ID";
        StringBuilder sb = new StringBuilder("SELECT COUNT(*) FROM R_Request WHERE R_RequestType_ID=" + this.getR_RequestType_ID() + " AND Processed<>'Y'");
        if ("T".equals(MeasureDataType) && !"0".equals(MeasureScope)) {
            if (reportDate == null) {
                reportDate = new Timestamp(System.currentTimeMillis());
            }
            DB.TO_DATE(reportDate);
            String trunc = "D";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "W";
            }
            sb.append(" AND TRUNC(").append(dateColumn).append(",'").append(trunc).append("')=TRUNC(").append(DB.TO_DATE(reportDate)).append(",'").append(trunc).append("')");
        }
        String sql = MMeasureCalc.addRestrictions(sb.toString(), false, restrictions, role, "R_Request", orgColumn, bpColumn, pColumn);
        this.log.fine(sql);
        return sql;
    }

    public String getSqlBarChart(MGoalRestriction[] restrictions, String MeasureDisplay, String MeasureDataType, Timestamp startDate, MRole role) {
        String dateColumn = "Created";
        String orgColumn = "AD_Org_ID";
        String bpColumn = "C_BPartner_ID";
        String pColumn = "M_Product_ID";
        StringBuilder sb = new StringBuilder("SELECT COUNT(*), ");
        Object groupBy = null;
        Object orderBy = null;
        if ("T".equals(MeasureDataType) && !"0".equals(MeasureDisplay)) {
            String trunc = "D";
            if ("1".equals(MeasureDisplay)) {
                trunc = "Y";
            } else if ("3".equals(MeasureDisplay)) {
                trunc = "Q";
            } else if ("5".equals(MeasureDisplay)) {
                trunc = "MM";
            } else if ("7".equals(MeasureDisplay)) {
                trunc = "W";
            }
            orderBy = "TRUNC(" + dateColumn + ",'" + trunc + "')";
            groupBy = (String)orderBy + ", 3 ";
            sb.append((String)orderBy).append(", 0 as StatusID ").append("FROM R_Request ");
        } else {
            orderBy = "s.SeqNo";
            groupBy = "NVL(s.Name,'-'), s.R_Status_ID, s.SeqNo ";
            sb.append((String)groupBy).append("FROM R_Request LEFT OUTER JOIN R_Status s ON (R_Request.R_Status_ID=s.R_Status_ID) ");
        }
        sb.append("WHERE R_Request.R_RequestType_ID=").append(this.getR_RequestType_ID()).append(" AND R_Request.Processed<>'Y'");
        if (startDate != null && !"0".equals(MeasureDisplay)) {
            String dateString = DB.TO_DATE(startDate);
            sb.append(" AND ").append(dateColumn).append(">=").append(dateString);
        }
        Object sql = MMeasureCalc.addRestrictions(sb.toString(), false, restrictions, role, "R_Request", orgColumn, bpColumn, pColumn);
        if (groupBy != null) {
            sql = (String)sql + " GROUP BY " + (String)groupBy + " ORDER BY " + (String)orderBy;
        }
        this.log.fine((String)sql);
        return sql;
    }

    public MQuery getQuery(MGoalRestriction[] restrictions, String MeasureDisplay, Timestamp date, int R_Status_ID, MRole role) {
        String dateColumn = "Created";
        String orgColumn = "AD_Org_ID";
        String bpColumn = "C_BPartner_ID";
        String pColumn = "M_Product_ID";
        MQuery query = new MQuery("R_Request");
        query.addRestriction("R_RequestType_ID", "=", this.getR_RequestType_ID());
        String where = null;
        if (R_Status_ID != 0) {
            where = "R_Status_ID=" + R_Status_ID;
        } else {
            String trunc = "D";
            if ("1".equals(MeasureDisplay)) {
                trunc = "Y";
            } else if ("3".equals(MeasureDisplay)) {
                trunc = "Q";
            } else if ("5".equals(MeasureDisplay)) {
                trunc = "MM";
            } else if ("7".equals(MeasureDisplay)) {
                trunc = "W";
            }
            where = "TRUNC(" + dateColumn + ",'" + trunc + "')=TRUNC(" + DB.TO_DATE(date) + ",'" + trunc + "')";
        }
        String whereRestriction = MMeasureCalc.addRestrictions(where + " AND Processed<>'Y' ", true, restrictions, role, "R_Request", orgColumn, bpColumn, pColumn);
        query.addRestriction(whereRestriction);
        query.setRecordCount(1);
        return query;
    }

    @Override
    public MRequestType markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

