/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:
        
    Description:
        
    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/box/Box.ts":
/*!******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/box/Box.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Box.ts

    Purpose:

    Description:

    History:
        Wed Nov  5 12:10:53     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

    This program is distributed under LGPL Version 2.1 in the hope that
    it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The box widgets, such as hbox and vbox.
 * @internal
 */
//zk.$package('zul.box');
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Box = void 0;
// Returns if the spacing is 0.
function _spacing0(spacing) {
  return !!spacing && spacing.startsWith('0') && !zk.parseInt(spacing);
}
function _spacingHTML(box, child) {
  var oo = '',
    spacing = box._spacing,
    spacing0 = _spacing0(spacing),
    vert = box.isVertical(),
    spstyle = spacing && spacing != 'auto' ? (vert ? 'height:' : 'width:') + spacing : '';
  oo += '<t' + (vert ? 'r' : 'd') + ' id="' + /*safe*/child.uuid + '-chdex2" class="' + box.$s('separator') + '"';
  var s = spstyle;
  if (spacing0 || !child.isVisible()) s = 'display:none;' + s;
  if (s) oo += ' style="' + s + '"';
  oo += '>' + (vert ? '<td>' : '') + /*safe*/zUtl.img0 + (vert ? '</td></tr>' : '</td>');
  return oo;
}
//notice it is invoked as a member of Box (so no need to pass box as argument
function _fixTd() {
  //when align is stretched must release the children, then must "shrink td" manually
  var vert = this.isVertical();
  if (this._isStretchAlign() || vert && this._nhflex || !vert && this._nvflex) {
    for (var child = this.firstChild; child; child = child.nextSibling) {
      if (child.isVisible()) {
        var c = child.$n();
        if (vert) {
          if (child._nhflex && child._nhflex > 0)
            // B50-ZK-159: skip when min flex
            child.setFlexSize_({
              width: 'auto'
            });else if (c && this._isStretchAlign()) {
            //release width of children might cause wider box
            //bug 2951825, widget not necessary with HTML dom element(<script>)
            //add StretchAlign checking, see revision: 13172
            var oldwidth = c.style.width;
            if (oldwidth) {
              var oldoffwidth = c.offsetWidth;
              c.style.width = ''; //release the width of children so td can shrink
              if (c.offsetWidth > oldoffwidth) c.style.width = oldwidth;
            }
          }
          if (!(child instanceof zul.wgt.Cell) && this._nhflex) {
            var chdex = child.$n('chdex');
            chdex.style.width = '';
          }
        } else {
          if (child._nvflex && child._nvflex > 0)
            // B50-ZK-159: skip when min flex
            child.setFlexSize_({
              height: 'auto'
            });else if (c && this._isStretchAlign()) {
            //release height of children might cause higher box
            //bug 2951825, widget not necessary with HTML dom element(<script>)
            //add StretchAlign checking, see revision: 13172
            var oldheight = c.style.height;
            if (oldheight) {
              var oldoffheight = c.offsetHeight;
              c.style.height = ''; //release the height of children so td can shrink
              if (c.offsetHeight > oldoffheight) c.style.height = oldheight;
            }
          }
          if (!(child instanceof zul.wgt.Cell) && this._nvflex) {
            var chdex = child.$n('chdex');
            chdex.style.height = '';
          }
        }
      }
    }
  }
  //Safari/chrome will not extend the height of td to as tr (B30-2088496.zul)
  //but cannot always give pixels if size determined by contents (big gap in B30-1769047.zul)
  var nh;
  if (zk.webkit && !vert && (nh = this.$n().style.height)) {
    var td = this.$n('frame');
    td.style.height = '';
    td.style.height = nh.indexOf('%') > 0 ? jq.px0(td.offsetHeight) : nh; // B50-ZK-559
  }
}
var Box = /** @class */function (_super) {
  __extends(Box, _super);
  function Box() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._mold = 'vertical';
    /** @internal */
    _this._align = 'start';
    /** @internal */
    _this._pack = 'start';
    /** @internal */
    _this._sizedByContent = true;
    /** @internal */
    _this._splitterKid = false;
    return _this;
  }
  /**
   * Sets the alignment of cells of this box in the 'opposite' direction
   * (<i>start</i>, center, end, stretch).
   *
   * @param align - the alignment in the 'opposite' direction.
   * Allowed values: start, center, end, stretch.
   * If empty or null, the browser's default is used
   * (IE center and FF left, if vertical).
   */
  Box.prototype.setAlign = function (align, opts) {
    var o = this._align;
    this._align = align;
    if (o !== align || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender(); //TODO: a better algoithm
    }
    return this;
  };
  /**
   * @returns the alignment of cells of a box in the 'opposite' direction
   * (<i>null</i>, start, center, end).
   *
   * <p>The align attribute specifies how child elements of the box are aligned,
   * when the size of the box is larger than the total size of the children. For
   * boxes that have horizontal orientation, it specifies how its children will
   * be aligned vertically. For boxes that have vertical orientation, it is used
   * to specify how its children are aligned horizontally. The pack attribute
   * ({@link getPack}) is
   * related to the alignment but is used to specify the position in the
   * opposite direction.
   *
   * <dl>
   * <dt>start</dt>
   * <dd>Child elements are aligned starting from the left or top edge of
   * the box. If the box is larger than the total size of the children, the
   * extra space is placed on the right or bottom side.</dd>
   * <dt>center</dt>
   * <dd>Extra space is split equally along each side of the child
   * elements, resulting in the children being placed in the center of the box.</dd>
   * <dt>end</dt>
   * <dd>Child elements are placed on the right or bottom edge of the box. If
   * the box is larger than the total size of the children, the extra space is
   * placed on the left or top side.</dd>
   * <dt>stretch</dt>
   * <dd>Child elements are stretched to fill the box.</dd>
   * </dl>
   *
   * @defaultValue start
   */
  Box.prototype.getAlign = function () {
    return this._align;
  };
  /**
   * Sets the alignment of cells of this box
   * (start, center, end) plus an <i>stretch</i> option.
   *
   * @param pack - the alignment. Allowed values: (start, center, end) plus an
   * <i>stretch</i> option. If empty or null, it defaults to "stretch,start".
   * @see {@link getPack}
   */
  Box.prototype.setPack = function (pack, opts) {
    var o = this._pack;
    this._pack = pack;
    if (o !== pack || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender(); //TODO: a better algoithm
    }
    return this;
  };
  /**
   * @returns the pack alignment of cells of this box
   * (start, center, end) plus an indication <i>stretch</i> option.
   *
   * <p>The pack attribute specifies where child elements of the box are placed
   * when the box is larger that the size of the children. For boxes with
   * horizontal orientation, it is used to indicate the position of children
   * horizontally. For boxes with vertical orientation, it is used to indicate
   * the position of children vertically. The align attribute
   * ({@link getAlign})is used to specify
   * the position in the opposite direction.
   *
   * <dl>
   * <dt>start</dt>
   * <dd>Child elements are aligned starting from the left or top edge of
   * the box. If the box is larger than the total size of the children, the
   * Extra space is placed on the right or bottom side.</dd>
   * <dt>center</dt>
   * <dd>Extra space is split equally along each side of the child
   * elements, resulting in the children being placed in the center of the box.</dd>
   * <dt>end</dt>
   * <dd>Child elements are placed on the right or bottom edge of the box. If
   * the box is larger than the total size of the children, the extra space is
   * placed on the left or top side.</dd>
   * <dt>stretch</dt>
   * <dd>This is an extra option in addition to the (start, center, end) options.
   * When add this extra option in the pack attribute, the Extra space is placed
   * proportionally and evenly along each child elements. If you specify
   * "stretch,start", then the Extra proportionally and evenly allocated space
   * for each child is placed on the right or bottom side of the child.
   * If you specify "stretch,center", then the Extra proportionally and evenly
   * allocated space for each child is split equally along each side of the
   * child. If you specify "stretch,end", then the Extra proportionally and
   * evenly allocated space for each child is placed on the left or top side of
   * the child. Note that if there are {@link Splitter} child inside this Box,
   * then this Box behaves as if the pack attribute has been set the "stretch"
   * option; no matter you really specify "stretch" in pack attribute or not.
   * If given null or simply "stretch" to this pack attribute then it is the
   * same as "stretch,start"</dd>
   * </dl>
   *
   * @defaultValue start.
   */
  Box.prototype.getPack = function () {
    return this._pack;
  };
  /**
   * Sets the spacing between adjacent children.
   * @param spacing - the spacing (such as "0", "5px", "3pt" or "1em"),
   * or null to use the default spacing
   * @see {@link getSpacing}
   */
  Box.prototype.setSpacing = function (spacing, opts) {
    var o = this._spacing;
    this._spacing = spacing;
    if (o !== spacing || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender(); //TODO: a better algoithm
    }
    return this;
  };
  /**
   * @returns the spacing between adjacent children, or null if the default
   * spacing is used.
   *
   * <p>The default spacing depends on the definition of the style class
   * called "xxx-sp", where xxx is
   *
   * <ol>
   *  <li>{@link getSclass} if it is not null.</li>
   *  <li>hbox if {@link getSclass} is null and it is a horizontal box.</li>
   *  <li>vbox if {@link getSclass} is null and it is a vertical box.</li>
   * </ol>
   *
   * @defaultValue `null` (means to use the default spacing).
   */
  Box.prototype.getSpacing = function () {
    return this._spacing;
  };
  /**
   * Sets whether sizing the cell's size by its content.
   * @defaultValue `true`. It means the cell's size is depended on its content.
   *
   * <p> With {@link Splitter}, you can specify the sizedByContent to be false
   * for resizing smoothly
   * @since 5.0.4
   */
  Box.prototype.setSizedByContent = function (sizedByContent, opts) {
    var o = this._sizedByContent;
    this._sizedByContent = sizedByContent;
    if (o !== sizedByContent || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender(); //TODO: a better algoithm
    }
    return this;
  };
  /**
   * @returns whether sizing the cell's size by its content.
   * @defaultValue `true`.
   * @since 5.0.4
   */
  Box.prototype.isSizedByContent = function () {
    return this._sizedByContent;
  };
  Box.prototype.getWidths = function () {
    return this._widths;
  };
  Box.prototype.setWidths = function (widths, opts) {
    var o = this._widths;
    this._widths = widths;
    if (o !== widths || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._sizes = widths;
      this.rerender();
    }
    return this;
  };
  Box.prototype.setHeights = function (heights) {
    return this.setWidths(heights);
  };
  Box.prototype.getHeights = function () {
    return this.getWidths();
  };
  /**
   * @returns whether it is a vertical box.
   */
  Box.prototype.isVertical = function () {
    return 'vertical' == this._mold;
  };
  /**
   * @returns the orient.
   */
  Box.prototype.getOrient = function () {
    return this._mold;
  };
  Box.prototype.getZclass = function () {
    var zcs = this._zclass;
    return zcs != null ? zcs : this.isVertical() ? 'z-vbox' : 'z-hbox';
  };
  /** @internal */
  Box.prototype.onChildVisible_ = function (child) {
    _super.prototype.onChildVisible_.call(this, child);
    if (this.desktop) this._fixChildDomVisible(child, child._visible);
  };
  /** @internal */
  Box.prototype.replaceChildHTML_ = function (child, en, desktop, skipper, _trim_) {
    _super.prototype.replaceChildHTML_.call(this, child, en, desktop, skipper, _trim_);
    this._fixChildDomVisible(child, child._visible);
    if (child instanceof zul.box.Splitter) {
      var n = this._chdextr(child);
      if (n) {
        n.style.height = '';
        n.style.width = '';
      }
      zUtl.fireSized(this, -1); //no beforeSize
    }
  };
  /** @internal */
  Box.prototype._fixChildDomVisible = function (child, visible) {
    var n = this._chdextr(child);
    if (n) n.style.display = visible ? '' : 'none';
    n = child.$n('chdex2');
    if (n) n.style.display = visible && !_spacing0(this._spacing) ? '' : 'none';
    if (this.lastChild == child) {
      n = child.previousSibling;
      if (n) {
        n = n.$n('chdex2');
        if (n) n.style.display = visible ? '' : 'none';
      }
    }
  };
  /** @internal */
  Box.prototype._chdextr = function (child) {
    return child.$n('chdex') || child.$n();
  };
  /** @internal */
  Box.prototype.insertChildHTML_ = function (child, before, desktop) {
    if (before) {
      jq(this._chdextr(before)).before( /*safe*/this.encloseChildHTML_(child));
    } else {
      var n = this.$n('real'),
        tbs = n.tBodies;
      if (!tbs || !tbs.length) n.appendChild(document.createElement('tbody'));
      jq(this.isVertical() ? tbs[0] : tbs[0].rows[0]).append( /*safe*/this.encloseChildHTML_(child, true));
    }
    child.bind(desktop);
  };
  /** @internal */
  Box.prototype.removeChildHTML_ = function (child, ignoreDom) {
    _super.prototype.removeChildHTML_.call(this, child, ignoreDom);
    jq(child.uuid + '-chdex', zk).remove();
    jq(child.uuid + '-chdex2', zk).remove();
    var sib;
    if (this.lastChild == child && (sib = child.previousSibling))
      //child is last
      jq(sib.uuid + '-chdex2', zk).remove();
  };
  /**
   * Enclose child with HTML tag such as TR or TD,
   * and return a HTML code or add HTML fragments in out array.
   * @param child - the child which will be enclosed
   * @param prefixSpace - if true the previousSibling of the child
   * will put in front of child.
   * @param out - an array of HTML fragments.
   * @internal
   */
  Box.prototype.encloseChildHTML_ = function (child, prefixSpace, out) {
    var oo = [],
      isCell = child instanceof zul.wgt.Cell;
    if (this.isVertical()) {
      /*safe*/oo.push('<tr id="', /*safe*/child.uuid, '-chdex"', /*safe*/this._childOuterAttrs(child), '>');
      if (!isCell) {
        /*safe*/oo.push('<td', /*safe*/this._childInnerAttrs(child));
        //follow xul vbox spec.
        var v = this.getAlign();
        if (v && v != 'stretch') oo.push(' align="', zul.box.Box._toHalign(v), '"');
        oo.push('>');
      }
      child.redraw(oo);
      if (!isCell) oo.push('</td>');
      oo.push('</tr>');
    } else {
      if (!isCell) {
        /*safe*/oo.push('<td id="', /*safe*/child.uuid, '-chdex"', /*safe*/this._childOuterAttrs(child), /*safe*/this._childInnerAttrs(child), '>');
      }
      child.redraw(oo);
      if (!isCell) oo.push('</td>');
    }
    var next = child.nextSibling; //Bug ZK-1526: popup should not consider spacing
    if (next && !(next instanceof zul.wgt.Popup)) oo.push(_spacingHTML(this, child));else if (prefixSpace) {
      var pre = child.previousSibling;
      if (pre) oo.unshift(_spacingHTML(this, pre));
    }
    if (!out) return oo.join('');
    for (var j = 0, len = oo.length; j < len; ++j) out.push( /*safe*/oo[j]);
  };
  /** @internal */
  Box.prototype._resetBoxSize = function (vert) {
    var vert = this.isVertical(),
      k = -1,
      szes = this._sizes;
    if (!zk.mounting) {
      // ignore for the loading time
      if (vert) {
        for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
          if (szes && !(kid instanceof zul.box.Splitter) && !(kid instanceof zul.wgt.Cell)) ++k;
          if (kid._nvflex && kid.getVflex() != 'min') {
            kid.setFlexSize_({
              height: '',
              width: ''
            });
            var chdex = kid.$n('chdex');
            if (chdex) {
              var n;
              if ((n = kid.$n()) && (n.scrollTop || n.scrollLeft)) {// keep the scroll status
                // do nothing Bug ZK-1885: scrollable div (with vflex) and tooltip
              } else {
                chdex.style.height = szes && k < szes.length ? szes[k] : '';
                chdex.style.width = '';
              }
            }
          }
        }
      } else {
        for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
          if (szes && !(kid instanceof zul.box.Splitter) && !(kid instanceof zul.wgt.Cell)) ++k;
          if (kid._nhflex && kid.getHflex() != 'min') {
            kid.setFlexSize_({
              height: '',
              width: ''
            });
            var chdex = kid.$n('chdex');
            if (chdex) {
              var n;
              if ((n = kid.$n()) && (n.scrollTop || n.scrollLeft)) {// keep the scroll status
                // do nothing Bug ZK-1885: scrollable div (with vflex) and tooltip
              } else {
                chdex.style.width = szes && k < szes.length ? szes[k] : '';
                chdex.style.height = '';
              }
            }
          }
        }
      }
    }
  };
  //Bug ZK-1569: add minium 1px width on <td> to pass isWatchable_
  /** @internal */
  Box.prototype.afterResetChildSize_ = function () {
    for (var kid = this.firstChild, vert = this.isVertical(); kid; kid = kid.nextSibling) {
      // ZK-2231: kid may not bind to desktop yet (client rod enabled)
      if (kid.desktop) {
        var chdex = vert ? kid.$n('chdex').firstChild : kid.$n('chdex');
        if (chdex) chdex.style.minWidth = '1px';
      }
    }
  };
  //bug#3042306
  /** @internal */
  Box.prototype.resetSize_ = function (orient) {
    _super.prototype.resetSize_.call(this, orient);
    // B85-ZK-3516: remove size of frame
    var n = this.$n();
    if (!n.scrollTop && !n.scrollLeft) this.$n('frame').style[orient == 'w' ? 'width' : 'height'] = '';
    var vert = this.isVertical(),
      k = -1,
      szes = this._sizes;
    if (vert) {
      for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
        if (szes && !(kid instanceof zul.box.Splitter) && !(kid instanceof zul.wgt.Cell)) ++k;
        if (kid._nvflex && kid.getVflex() != 'min') {
          var chdex = kid.$n('chdex');
          if (chdex) {
            if (orient == 'h') chdex.style.height = szes && k < szes.length ? szes[k] : '';
            if (orient == 'w') chdex.style.width = '';
          }
        }
      }
    } else {
      for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
        if (szes && !(kid instanceof zul.box.Splitter) && !(kid instanceof zul.wgt.Cell)) ++k;
        if (kid._nhflex && kid.getHflex() != 'min') {
          var chdex = kid.$n('chdex');
          if (chdex) {
            if (orient == 'w') chdex.style.width = szes && k < szes.length ? szes[k] : '';
            if (orient == 'h') chdex.style.height = '';
          }
        }
      }
    }
  };
  /** @internal */
  Box.prototype._getContentSize = function () {
    //bug 3010663: boxes do not resize when browser window is resized
    var p = this.$n(),
      zkp = zk(p),
      hgh = this._vflexsz !== undefined ? this._vflexsz - zkp.padBorderHeight() - zkp.marginHeight()
      // B50-ZK-286: subtract scroll bar width
      : zkp.contentHeight(true),
      wdh = this._hflexsz !== undefined ? this._hflexsz - zkp.padBorderWidth() - zkp.marginWidth()
      // B50-ZK-286: subtract scroll bar width
      : zkp.contentWidth(true);
    return zkp ? {
      height: hgh,
      width: wdh
    } : {
      height: 0,
      width: 0
    };
  };
  /** @internal */
  Box.prototype.beforeChildrenFlex_ = function (child) {
    var _a;
    child._flexFixed = true;
    var vert = this.isVertical(),
      vflexs = [],
      vflexsz = vert ? 0 : 1,
      hflexs = [],
      hflexsz = !vert ? 0 : 1,
      chdex = child.$n('chdex'),
      p = chdex ? chdex.parentNode : child.$n().parentNode,
      n = this.$n(),
      zkp = zk(n),
      psz = this._getContentSize(),
      hgh = psz.height,
      wdh = psz.width,
      xc = p.firstChild,
      k = -1,
      szes = this._sizes,
      scrWdh;
    if (!zk.mounting) {
      // ignore for the loading time
      this._resetBoxSize(vert);
    }
    // Bug 3185686, B50-ZK-452
    if (zkp.hasVScroll())
      //with vertical scrollbar
      wdh -= scrWdh = jq.scrollbarWidth();
    // B50-3312936.zul
    if (zkp.hasHScroll())
      //with horizontal scrollbar
      hgh -= scrWdh || jq.scrollbarWidth();
    for (; xc; xc = xc.nextSibling) {
      // eslint-disable-next-line @typescript-eslint/no-unnecessary-condition
      var c = ((_a = xc.id) === null || _a === void 0 ? void 0 : _a.endsWith('-chdex')) ? vert ? xc.firstChild.id ? xc.firstChild : xc.firstChild.firstChild : xc.firstChild : xc;
      // B70-ZK-2390
      for (; c; c = c.nextSibling) if (c.nodeType == 1) break; //until a element node
      var zkc = zk(c),
        fixedSize = false;
      if (zkc.isVisible()) {
        var j_1 = c.id ? c.id.indexOf('-') : 1,
          cwgt = j_1 < 0 ? zk.Widget.$(c.id) : undefined,
          boxFlexSize = this._hflexsz,
          clearWidth = zk.chrome && boxFlexSize;
        if (szes && cwgt && !(cwgt instanceof zul.box.Splitter) && !(cwgt instanceof zul.wgt.Cell)) {
          ++k;
          if (k < szes.length && szes[k] && (vert && !cwgt._nvflex || !vert && !cwgt._nhflex)) {
            c = xc;
            zkc = zk(c);
            fixedSize = szes[k].endsWith('px');
          }
        }
        if (clearWidth) n.style.width = '';
        var offhgh = fixedSize && vert ? zk.parseInt(szes[k]) : zkc.offsetHeight(),
          offwdh = fixedSize && !vert ? zk.parseInt(szes[k]) : zkc.offsetWidth(),
          cwdh = offwdh + zkc.marginWidth(),
          chgh = offhgh + zkc.marginHeight();
        if (clearWidth) n.style.width = jq.px0(boxFlexSize);
        //vertical size
        if (cwgt && cwgt._nvflex) {
          if (cwgt !== child) cwgt._flexFixed = true; //tell other vflex siblings I have done it.
          if (cwgt._vflex == 'min') {
            cwgt.fixMinFlex_(c, 'h');
            if (vert) hgh -= chgh;
          } else {
            vflexs.push(cwgt);
            if (vert) vflexsz += cwgt._nvflex;
          }
        } else if (vert) hgh -= chgh;
        //horizontal size
        if (cwgt && cwgt._nhflex) {
          if (cwgt !== child) cwgt._flexFixed = true; //tell other hflex siblings I have done it.
          if (cwgt._hflex == 'min') {
            cwgt.fixMinFlex_(c, 'w');
            if (!vert) wdh -= cwdh;
          } else {
            hflexs.push(cwgt);
            if (!vert) hflexsz += cwgt._nhflex;
          }
        } else if (!vert) wdh -= cwdh;
      }
    }
    //setup the height for the vflex child
    //avoid floating number calculation error(TODO: shall distribute error evenly)
    var lastsz = hgh > 0 ? hgh : 0;
    for (var j = vflexs.length - 1; j > 0; --j) {
      var cwgt = vflexs.shift(),
        vsz = cwgt._nvflex * hgh / vflexsz | 0,
        //cast to integer
        //B50-3014664.zul offtop = cwgt.$n().offsetTop,
        isz = vsz,
        chdex_1 = cwgt.$n('chdex'),
        $chdex = zk(chdex_1),
        minus = $chdex.padBorderHeight();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        height: isz - minus
      });
      cwgt._vflexsz = vsz - minus;
      if (!(cwgt instanceof zul.wgt.Cell)) {
        // no need to subtract padding and border for border-box mode
        chdex_1.style.height = jq.px0(vsz - $chdex.marginHeight());
      }
      if (vert) lastsz -= vsz;
    }
    //last one with vflex
    if (vflexs.length) {
      var cwgt = vflexs.shift(),
        // B50-3014664.zul offtop = cwgt.$n().offsetTop,
        isz = lastsz,
        chdex_2 = cwgt.$n('chdex'),
        $chdex = zk(chdex_2),
        minus = $chdex.padBorderHeight();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        height: isz - minus
      });
      cwgt._vflexsz = lastsz - minus;
      if (!(cwgt instanceof zul.wgt.Cell)) {
        // no need to subtract padding and border for border-box mode
        chdex_2.style.height = jq.px0(lastsz - $chdex.marginHeight());
      }
    }
    //setup the width for the hflex child
    //avoid floating number calculation error(TODO: shall distribute error evenly)
    lastsz = wdh > 0 ? wdh : 0;
    for (var j = hflexs.length - 1; j > 0; --j) {
      var cwgt = hflexs.shift(),
        //{n: node, f: hflex}
        hsz = cwgt._nhflex * wdh / hflexsz | 0,
        //cast to integer
        chdex_3 = cwgt.$n('chdex'),
        $chdex = zk(chdex_3),
        minus = $chdex.padBorderWidth();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        width: hsz - minus
      });
      cwgt._hflexsz = hsz - minus;
      if (!(cwgt instanceof zul.wgt.Cell)) {
        // no need to subtract padding and border for border-box mode
        chdex_3.style.width = jq.px0(hsz - $chdex.marginWidth());
      }
      if (!vert) lastsz -= hsz;
    }
    //last one with hflex
    if (hflexs.length) {
      var cwgt = hflexs.shift(),
        chdex_4 = cwgt.$n('chdex'),
        $chdex = zk(chdex_4),
        minus = $chdex.padBorderWidth();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        width: lastsz - minus
      });
      cwgt._hflexsz = lastsz - minus;
      if (!(cwgt instanceof zul.wgt.Cell)) {
        // no need to subtract padding and border for border-box mode
        chdex_4.style.width = jq.px0(lastsz - $chdex.marginWidth());
      }
    }
    //notify all of children with xflex is done.
    child.parent.afterChildrenFlex_(child);
    child._flexFixed = false;
    return false; //to skip original _fixFlex
  };
  /** @internal */
  Box.prototype._childOuterAttrs = function (child) {
    var html = '';
    if (child instanceof zul.box.Splitter) html = ' class="' + child.$s('outer') + '"';else if (this.isVertical()) {
      if (this._isStretchPack()) {
        var v = this._pack2;
        html = ' valign="' + (v ? /*safe*/zul.box.Box._toValign(v) : 'top') + '"';
      } else html = ' valign="top"';
    } else return ''; //if hoz and not splitter, display handled in _childInnerAttrs
    if (!child.isVisible()) html += ' style="display:none"';
    return DOMPurify.sanitize(html);
  };
  /** @internal */
  Box.prototype._childInnerAttrs = function (child) {
    var html = '',
      vert = this.isVertical();
    if (child instanceof zul.box.Splitter) return '';
    //spliter's display handled in _childOuterAttrs
    if (this._isStretchPack()) {
      var v = vert ? this.getAlign() : this._pack2;
      if (v) html += ' align="' + /*safe*/zul.box.Box._toHalign(v) + '"';
    }
    var style = '',
      szes = this._sizes;
    if (szes) {
      for (var j = 0, len = szes.length, c = this.firstChild; c && j < len; c = c.nextSibling) {
        if (child == c) {
          style = (vert ? 'height:' : 'width:') + szes[j];
          break;
        }
        if (!(c instanceof zul.box.Splitter)) ++j;
      }
    }
    if (!vert && !child.isVisible()) style += style ? ';display:none' : 'display:none';
    if (!vert) style += style ? ';height:100%' : 'height:100%';
    return DOMPurify.sanitize(style ? html + ' style="' + style + '"' : html);
  };
  /** @internal */
  Box.prototype._isStretchPack = function () {
    //when pack has specifies 'stretch' or there are splitter kids which
    //implies pack='stretch'
    return !!(this._splitterKid || this._stretchPack);
  };
  /** @internal */
  Box.prototype._isStretchAlign = function () {
    return this._align == 'stretch';
  };
  //called by Splitter
  /** @internal */
  Box.prototype._bindWatch = function () {
    if (!this._watchBound) {
      this._watchBound = true;
      zWatch.listen({
        onSize: this,
        onHide: this
      });
    }
  };
  /** @internal */
  Box.prototype._unbindWatch = function () {
    if (this._watchBound) {
      zWatch.unlisten({
        onSize: this,
        onHide: this
      });
      delete this._watchBound;
    }
  };
  /** @internal */
  Box.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._bindFixTd();
    if (this._isStretchAlign()) this._bindAlign();
    if (this._splitterKid) this._bindWatch();
  };
  /** @internal */
  Box.prototype.unbind_ = function (skipper, after, keepRod) {
    this._unbindWatch();
    this._unbindAlign();
    this._unbindFixTd();
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Box.prototype._bindAlign = function () {
    if (!this._watchAlign) {
      this._watchAlign = true;
      zWatch.listen({
        onSize: [this, this._fixAlign],
        onHide: [this, this._fixAlign]
      });
    }
  };
  /** @internal */
  Box.prototype._unbindAlign = function () {
    if (this._watchAlign) {
      zWatch.unlisten({
        onSize: [this, this._fixAlign],
        onHide: [this, this._fixAlign]
      });
      delete this._watchAlign;
    }
  };
  /** @internal */
  Box.prototype._fixAlign = function () {
    if (this._isStretchAlign()) {
      var vert = this.isVertical(),
        td = this.$n('frame'),
        zktd = zk(td),
        tdsz = vert ? zktd.revisedWidth(td.offsetWidth) : zktd.revisedHeight(td.offsetHeight);
      for (var child = this.firstChild, c; child; child = child.nextSibling) {
        if (child.isVisible() && (c = child.$n())) {
          //20100120, Henri Chen: Strange! After set c.style.height/width, the margin is gone in safari/chrome
          if (vert) c.style.width = zk(c).revisedWidth(tdsz, !zk.webkit) + 'px';else c.style.height = zk(c).revisedHeight(tdsz, !zk.webkit) + 'px';
        }
      }
    }
  };
  /** @internal */
  Box.prototype._bindFixTd = function () {
    if (!this._watchTd) {
      this._watchTd = true;
      zWatch.listen({
        onSize: [this, _fixTd],
        onHide: [this, _fixTd]
      });
    }
  };
  /** @internal */
  Box.prototype._unbindFixTd = function () {
    if (this._watchTd) {
      zWatch.unlisten({
        onSize: [this, _fixTd],
        onHide: [this, _fixTd]
      });
      delete this._watchTd;
    }
  };
  /** @internal */
  Box.prototype._configPack = function () {
    var w = this._pack;
    if (w) {
      var v = w.split(',');
      if (v[0].trim() == 'stretch') {
        this._stretchPack = true;
        this._pack2 = v.length > 1 ? v[1].trim() : undefined;
      } else {
        this._stretchPack = v.length > 1 && v[1].trim() == 'stretch';
        this._pack2 = v[0].trim();
      }
    } else {
      delete this._pack2;
      delete this._stretchPack;
    }
  };
  //watch//
  Box.prototype.onSize = function () {
    if (!this._splitterKid) return; //only when there are splitter kids
    // eslint-disable-next-line @typescript-eslint/non-nullable-type-assertion-style
    var vert = this.isVertical(),
      real = this.$n('real');
    real.style.height = real.style.width = '100%'; //there are splitter kids
    //Note: we have to assign width/height first
    //Otherwise, the first time dragging the splitter won't be moved
    //as expected (since style.width/height might be "")
    var nd = vert ? real.rows : real.rows[0].cells,
      total = vert ? zk(real).revisedHeight(real.offsetHeight) : zk(real).revisedWidth(real.offsetWidth),
      sizes = this._sizes;
    for (var i = nd.length; i--;) {
      var d = nd[i];
      if (zk(d).isVisible()) if (vert) {
        var diff = d.offsetHeight;
        if (d.id && !d.id.endsWith('-chdex2')) {
          //TR
          //Bug 1917905: we have to manipulate height of TD in Safari
          if (d.cells.length) {
            var c = d.cells[0];
            c.style.height = zk(c).revisedHeight(i ? diff : total) + 'px';
            d.style.height = ''; //just-in-case
          } else {
            d.style.height = zk(d).revisedHeight(i ? diff : total) + 'px';
          }
        }
        total -= diff;
      } else {
        var diff = d.offsetWidth;
        //!sizes  B50-ZK-887: hbox's widths properties specified in Chrome is not precise
        //if user set the widths , we freeze the with directly
        if (!sizes && d.id && !d.id.endsWith('-chdex2'))
          //TD
          d.style.width = zk(d).revisedWidth(i ? diff : total) + 'px';
        total -= diff;
      }
    }
  };
  Box.prototype.onHide = function () {
    this.onSize();
  };
  /** @internal */
  Box.prototype.getFlexContainer_ = function () {
    return undefined;
  };
  /** @internal */
  Box._toValign = function (v) {
    return v ? 'start' == v ? 'top' : 'center' == v ? 'middle' : 'end' == v ? 'bottom' : v : undefined;
  };
  /** @internal */
  Box._toHalign = function (v) {
    return v ? 'start' == v ? 'left' : 'end' == v ? 'right' : v : undefined;
  };
  Box = __decorate([zk.WrapClass('zul.box.Box')], Box);
  return Box;
}(zul.Widget);
exports.Box = Box;
if (!window.zul) window.zul = {};
if (!window.zul.box) window.zul.box = {};
if (!window.zul.box.Box) window.zul.box.Box = {};
window.zul.box.Box._ = {
  _spacing0: _spacing0,
  _spacingHTML: _spacingHTML,
  _fixTd: _fixTd,
  Box: Box
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/box/Hlayout.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/box/Hlayout.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Hlayout = void 0;
/* Hlayout.ts

    Purpose:

    Description:

    History:
        Fri Aug  6 11:54:19 TST 2010, Created by jumperchen

Copyright (C) 2010 Potix Corporation. All Rights Reserved.

This program is distributed under GPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A horizontal layout.
 * @defaultValue {@link getZclass}: z-hlayout.
 * @since 5.0.4
 */
var Hlayout = /** @class */function (_super) {
  __extends(Hlayout, _super);
  function Hlayout() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._valign = 'top';
    return _this;
  }
  /**
   * Sets the vertical-align to top or bottom.
   *
   * @param valign - the value of vertical-align property
   * "top", "middle", "bottom".
   * @since 6.0.0
   */
  Hlayout.prototype.setValign = function (valign, opts) {
    var o = this._valign;
    this._valign = valign;
    if (o !== valign || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.updateDomClass_();
    }
    return this;
  };
  Hlayout.prototype.getValign = function () {
    return this._valign;
  };
  /** @internal */
  Hlayout.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      _beforeSizeForRead: this,
      beforeSize: this,
      onFitSize: this
    }); //ZK-4476
  };
  /** @internal */
  Hlayout.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      _beforeSizeForRead: this,
      beforeSize: this,
      onFitSize: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Hlayout.prototype.isVertical_ = function () {
    return false;
  };
  // F60-ZK-537: Hlayout supports valign (top, middle and bottom),
  // set vertical-align to children cause wrong layout on IE6,
  // set it to parent directly
  /** @internal */
  Hlayout.prototype.domClass_ = function (no) {
    var /*safe*/clsnm = _super.prototype.domClass_.call(this, no),
      v;
    if ((v = this._valign) == 'middle') clsnm += ' z-valign-middle';else if (v == 'bottom') clsnm += ' z-valign-bottom';
    return clsnm;
  };
  /** @internal */
  Hlayout.prototype.getFlexDirection_ = function () {
    return 'row';
  };
  //ZK-4476
  /** @internal */
  Hlayout.prototype._beforeSizeForRead = function () {
    var n = this.$n();
    this._beforeSizeWidth = n ? n.offsetWidth : 0;
    for (var xc = this.firstChild; xc; xc = xc.nextSibling) {
      n = xc.$n();
      xc._beforeSizeWidth = n ? n.offsetWidth : 0;
    }
  };
  Hlayout.prototype.beforeSize = function () {
    var xc = this.firstChild,
      totalWdCached = this._beforeSizeWidth,
      totalWd = totalWdCached != null ? totalWdCached : this.$n().offsetWidth,
      flexCnt = 0,
      flexWgts = [];
    for (; xc; xc = xc.nextSibling) {
      if (xc.isVisible() && !zk(xc).hasVParent()) {
        var nhflex = xc._nhflex,
          nXc = xc.$n();
        if (nhflex) {
          flexWgts.push({
            wgt: xc,
            flex: nhflex
          });
          flexCnt += nhflex;
        } else if (nXc) {
          var xcOffsetWidthCached = xc._beforeSizeWidth,
            xcOffsetWidth = xcOffsetWidthCached != null ? xcOffsetWidthCached : nXc.offsetWidth;
          totalWd -= xcOffsetWidth;
          xc.$n('chdex').style.width = jq.px0(xcOffsetWidth);
        }
      }
      delete xc._beforeSizeWidth;
    }
    if (flexCnt > 0) {
      var perWd = totalWd / flexCnt;
      for (var i = 0, l = flexWgts.length; i < l; i++) flexWgts[i].wgt.$n_('chdex').style.width = jq.px0(perWd * flexWgts[i].flex);
    }
    delete this._beforeSizeWidth;
  };
  Hlayout.prototype.onFitSize = function () {
    var xc = this.firstChild;
    for (; xc; xc = xc.nextSibling) {
      if (xc.isVisible() && !zk(xc).hasVParent()) xc.$n('chdex').style.width = '';
    }
  };
  Hlayout = __decorate([zk.WrapClass('zul.box.Hlayout')], Hlayout);
  return Hlayout;
}(zul.box.Layout);
exports.Hlayout = Hlayout;
if (!window.zul) window.zul = {};
if (!window.zul.box) window.zul.box = {};
if (!window.zul.box.Hlayout) window.zul.box.Hlayout = {};
window.zul.box.Hlayout._ = {
  Hlayout: Hlayout
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/box/Layout.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/box/Layout.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Layout = void 0;
/* Layout.ts

    Purpose:

    Description:

    History:
        Fri Aug  6 16:13:00 TST 2010, Created by jumperchen

Copyright (C) 2010 Potix Corporation. All Rights Reserved.

This program is distributed under GPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A skeleton of Vlayout and Hlayout.
 * @since 5.0.4
 */
var Layout = /** @class */function (_super) {
  __extends(Layout, _super);
  function Layout() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._spacing = '5px';
    /** @internal */
    _this._shallSize = false;
    return _this;
  }
  /**
   * Sets the spacing between adjacent children.
   * @param spacing - the spacing (such as "0", "5px", "3pt" or "1em"),
   * or null to use the default spacing. If the spacing is set to "auto",
   * the DOM style is left intact, so the spacing can be customized from
   * CSS.
   * @see {@link getSpacing}
   */
  Layout.prototype.setSpacing = function (spacing, opts) {
    var o = this._spacing;
    this._spacing = spacing;
    if (o !== spacing || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n(),
        vert = this.isVertical_(),
        spc = this._spacing;
      if (n) jq(n).children('div:not(:last-child)').css('padding-' + (vert ? 'bottom' : 'right'), spc && spc != 'auto' ? spc : '');
    }
    return this;
  };
  /**
   * @returns the spacing between adjacent children, or null if the default
   * spacing is used.
   * @defaultValue `0.3em` (means to use the default spacing).
   */
  Layout.prototype.getSpacing = function () {
    return this._spacing;
  };
  /** @internal */
  Layout.prototype._chdextr = function (child) {
    return child.$n('chdex') || child.$n();
  };
  /** @internal */
  Layout.prototype.insertChildHTML_ = function (child, before, desktop) {
    if (before) jq(this._chdextr(before)).before( /*safe*/this.encloseChildHTML_(child));else {
      var jqn = jq(this.$n()),
        spc = this._spacing;
      jqn.children('div:last-child').css('padding-' + (this.isVertical_() ? 'bottom' : 'right'), spc && spc != 'auto' ? spc : '');
      jqn.append( /*safe*/this.encloseChildHTML_(child));
    }
    child.bind(desktop);
  };
  /** @internal */
  Layout.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onResponse: this
    });
  };
  /** @internal */
  Layout.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /**
   * Synchronizes the size immediately.
   * This method is called automatically if the widget is created
   * at the server (i.e., {@link inServer} is true).
   * You have to invoke this method only if you create this widget
   * at client and add or remove children from this widget.
   * @since 5.0.8
   */
  Layout.prototype.syncSize = function () {
    this._shallSize = false;
    if (this.desktop) {
      // only fire when child has h/vflex
      for (var w = this.firstChild; w; w = w.nextSibling) {
        if (w._nvflex || w._nhflex) {
          zUtl.fireSized(this);
          break;
        }
      }
    }
  };
  Layout.prototype.onResponse = function () {
    if (this._shallSize) this.syncSize();
  };
  //Bug ZK-1579: should resize if child's visible state changed.
  /** @internal */
  Layout.prototype.onChildVisible_ = function (child) {
    _super.prototype.onChildVisible_.call(this, child);
    if (this.desktop) {
      var n = child.$n('chdex');
      this._shallSize = true;
      //Bug ZK-1650: change chdex display style according to child widget
      if (n) n.style.display = child.isVisible() ? '' : 'none';
    }
  };
  /** @internal */
  Layout.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.desktop) {
      var n = child.$n('chdex');
      this._shallSize = true;
      //Bug ZK-1732: change chdex display style according to child widget
      if (n) n.style.display = child.isVisible() ? '' : 'none';
    }
  };
  /** @internal */
  Layout.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (this.desktop) this._shallSize = true;
  };
  /** @internal */
  Layout.prototype.removeChildHTML_ = function (child, ignoreDom) {
    _super.prototype.removeChildHTML_.call(this, child, ignoreDom);
    jq(child.uuid + '-chdex', zk).remove();
    if (this._spacing != 'auto' && this.lastChild == child) jq(this.$n()).children('div:last-child').css('padding-' + (this.isVertical_() ? 'bottom' : 'right'), '');
  };
  /**
   * Enclose child with HTML tag such as DIV,
   * and return a HTML code or add HTML fragments in out array.
   * @param child - the child which will be enclosed
   * @param out - an array of HTML fragments.
   * @internal
   */
  Layout.prototype.encloseChildHTML_ = function (child, out) {
    var oo = new zk.Buffer(),
      vert = this.isVertical_(),
      spc = this._spacing;
    oo.push('<div id="' + /*safe*/child.uuid + '-chdex" class="' + this.$s('inner') + '"');
    if (spc && spc != 'auto') {
      oo.push(' style="', !child.isVisible() ? 'display:none;' : ''); //Bug ZK-1650: set chdex display style according to child widget
      var next = child.nextSibling; //Bug ZK-1526: popup should not consider spacing
      if (next && !(next instanceof zul.wgt.Popup) && !(child instanceof zul.wgt.Popup)) oo.push('padding-', vert ? 'bottom:' : 'right:', spc);
      oo.push('"');
    }
    oo.push('>');
    child.redraw(oo);
    oo.push('</div>');
    if (!out) {
      return oo.join('');
    } else {
      var output = oo.join('');
      out.push( /*safe*/output);
      return output;
    }
  };
  /**
   * @returns whether the layout is vertical
   * @internal
   */
  Layout.prototype.isVertical_ = function () {
    return false;
  };
  /** @internal */
  Layout.prototype._resetBoxSize = function (vert) {
    for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
      var chdex = kid.$n('chdex');
      // ZK-1861: Js error when flex + visible = false
      if (chdex) {
        //ZK-1679: clear height only vflex != min, clear width only hflex != min
        if (vert && kid._nvflex && kid.getVflex() != 'min') {
          var n;
          if ((n = kid.$n()) && (n.scrollTop || n.scrollLeft)) {// keep the scroll status
            // do nothing Bug ZK-1885: scrollable div (with vflex) and tooltip
          } else {
            kid.setFlexSize_({
              height: '',
              width: ''
            });
          }
          if (chdex) chdex.style.height = '';
        }
        if (!vert && kid._nhflex && kid.getHflex() != 'min') {
          var n;
          if ((n = kid.$n()) && (n.scrollTop || n.scrollLeft)) {// keep the scroll status
            // do nothing Bug ZK-1885: scrollable div (with vflex) and tooltip
          } else {
            kid.setFlexSize_({
              height: '',
              width: ''
            });
          }
          if (chdex) chdex.style.width = '';
        }
      }
    }
  };
  //bug#3296056
  /** @internal */
  Layout.prototype.afterResetChildSize_ = function (orient) {
    for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
      var chdex = kid.$n('chdex');
      if (chdex) {
        if (orient == 'h') chdex.style.height = '';
        if (orient == 'w') chdex.style.width = '';
        chdex.style.minWidth = '1px'; //Bug ZK-1509: add minium 1px width to pass isWatchable_
      }
    }
  };
  //bug#3042306
  /** @internal */
  Layout.prototype.resetSize_ = function (orient) {
    _super.prototype.resetSize_.call(this, orient);
    var vert = this.isVertical_();
    for (var kid = this.firstChild; kid; kid = kid.nextSibling) {
      if (vert ? kid._nvflex && kid.getVflex() != 'min' : kid._nhflex && kid.getHflex() != 'min') {
        var chdex = kid.$n('chdex');
        if (chdex) {
          if (orient == 'h') chdex.style.height = '';
          if (orient == 'w') chdex.style.width = '';
        }
      }
    }
  };
  /** @internal */
  Layout.prototype.getChildMinSize_ = function (attr, wgt) {
    var el = wgt.$n(); //Bug ZK-1578: should get child size instead of chdex size
    //If child uses hflex="1" when parent has hflex="min"
    //   Find max sibling width and apply on the child
    if (attr == 'w' && wgt._hflex && this.isVertical_()) {
      for (var w = wgt.nextSibling, max = 0, width; w; w = w.nextSibling) {
        if (!w._hflex) {
          width = zjq.minWidth(w.$n_());
          max = width > max ? width : max;
        }
      }
      return max;
    }
    if (attr == 'h') {
      // if display is not block the offsetHeight is wrong
      return zk(el.parentNode).contentHeight();
    } else {
      return zjq.minWidth(el); //See also bug ZK-483
    }
  };
  //Bug ZK-1577: should consider spacing size of all chdex node
  /** @internal */
  Layout.prototype.getContentEdgeHeight_ = function (height) {
    var h = 0;
    for (var kid = this.firstChild; kid; kid = kid.nextSibling) h += zk(kid.$n('chdex')).paddingHeight();
    return h;
  };
  //Bug ZK-1577: should consider spacing size of all chdex node
  /** @internal */
  Layout.prototype.getContentEdgeWidth_ = function (width) {
    var w = 0;
    for (var kid = this.firstChild; kid; kid = kid.nextSibling) w += zk(kid.$n('chdex')).paddingWidth();
    return w;
  };
  /** @internal */
  Layout.prototype.beforeChildrenFlex_ = function (child) {
    // optimized for performance
    this._shallSize = false;
    child._flexFixed = true;
    var vert = this.isVertical_(),
      vflexs = [],
      vflexsz = vert ? 0 : 1,
      hflexs = [],
      hflexsz = !vert ? 0 : 1,
      p = this.$n(),
      psz = child.getParentSize_(p),
      zkp = zk(p),
      hgh = psz.height,
      wdh = psz.width,
      xc = this.firstChild,
      scrWdh;
    if (!zk.mounting) {
      // ignore for the loading time
      this._resetBoxSize(vert);
    }
    // Bug 3185686, B50-ZK-452
    if (zkp.hasVScroll())
      //with vertical scrollbar
      wdh -= scrWdh = jq.scrollbarWidth();
    // B50-3312936.zul
    if (zkp.hasHScroll())
      //with horizontal scrollbar
      hgh -= scrWdh || jq.scrollbarWidth();
    for (; xc; xc = xc.nextSibling) {
      //Bug ZK-2434: not considering the element with vparent (like popup)
      var zkc;
      if (xc.getMold() == 'nodom') {
        //ZK-4354: a nodom sibling causes hflex=1 calculate the wrong size
        var fc = xc.firstChild;
        if (fc) {
          var xcp = fc.$n().parentNode,
            zkxcp = zk(xcp);
          if (vert) hgh -= zkxcp.offsetHeightDoubleValue() + zkxcp.marginHeight();else wdh -= xcp.offsetWidth + zkxcp.marginWidth();
        }
        continue;
      }
      if (xc.isVisible() && !(zkc = zk(xc)).hasVParent()) {
        var cwgt = xc,
          c = cwgt.$n(),
          cp = c.parentNode,
          zkxc = zk(cp);
        //vertical size
        if (xc && xc._nvflex) {
          if (cwgt !== child) cwgt._flexFixed = true; //tell other vflex siblings I have done it.
          if (cwgt._vflex == 'min') {
            cwgt.fixMinFlex_(c, 'h');
            //Bug ZK-1577: should consider padding size
            var h = c.offsetHeight + zkc.marginHeight() + zkxc.padBorderHeight();
            cp.style.height = jq.px0(h);
            if (vert) hgh -= cp.offsetHeight + zkxc.marginHeight();
          } else {
            vflexs.push(cwgt);
            if (vert) {
              vflexsz += cwgt._nvflex;
              //bug#3157031: remove chdex's padding, border, margin
              hgh = hgh - zkxc.marginHeight();
            }
          }
        } else if (vert) {
          hgh -= zkxc.offsetHeightDoubleValue() + zkxc.marginHeight();
        }
        //horizontal size
        if (cwgt && cwgt._nhflex) {
          if (cwgt !== child) cwgt._flexFixed = true; //tell other hflex siblings I have done it.
          if (cwgt._hflex == 'min') {
            cwgt.fixMinFlex_(c, 'w');
            //Bug ZK-1577: should consider padding size
            var w = c.offsetWidth + zkc.marginWidth() + zkxc.padBorderWidth();
            cp.style.width = jq.px0(zkxc.revisedWidth(w));
            if (!vert) wdh -= cp.offsetWidth + zkxc.marginWidth();
          } else {
            hflexs.push(cwgt);
            if (!vert) {
              hflexsz += cwgt._nhflex;
              //bug#3157031: remove chdex's padding, border, margin
              wdh = wdh - zkxc.marginWidth();
            }
          }
        } else if (!vert) wdh -= cp.offsetWidth + zkxc.marginWidth();
      }
    }
    //setup the height for the vflex child
    //avoid floating number calculation error(TODO: shall distribute error evenly)
    var lastsz = hgh > 0 ? hgh : 0;
    while (vflexs.length > 1) {
      var cwgt = vflexs.shift(),
        vsz = (vert ? cwgt._nvflex * hgh / vflexsz : hgh) | 0,
        //cast to integer
        isz = vsz,
        chdex = cwgt.$n('chdex'),
        minus = zk(chdex).padBorderHeight();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        height: isz - minus
      });
      cwgt._vflexsz = vsz - minus;
      // no need to subtract padding and border for border-box mode
      chdex.style.height = jq.px0(vsz);
      if (vert) lastsz -= vsz;
    }
    //last one with vflex
    if (vflexs.length) {
      var cwgt = vflexs.shift(),
        isz = lastsz,
        chdex = cwgt.$n('chdex'),
        minus = zk(chdex).padBorderHeight();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        height: isz - minus
      });
      cwgt._vflexsz = lastsz - minus;
      // no need to subtract padding and border for border-box mode
      chdex.style.height = jq.px0(lastsz);
    }
    //setup the width for the hflex child
    //avoid floating number calculation error(TODO: shall distribute error evenly)
    lastsz = wdh > 0 ? wdh : 0;
    while (hflexs.length > 1) {
      var cwgt = hflexs.shift(),
        //{n: node, f: hflex}
        hsz = (vert ? wdh : cwgt._nhflex * wdh / hflexsz) | 0,
        //cast to integer
        chdex = cwgt.$n('chdex'),
        minus = zk(chdex).padBorderWidth();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        width: hsz - minus
      });
      cwgt._hflexsz = hsz - minus;
      // no need to subtract padding and border for border-box mode
      chdex.style.width = jq.px0(hsz);
      if (!vert) lastsz -= hsz;
    }
    //last one with hflex
    if (hflexs.length) {
      var cwgt = hflexs.shift(),
        chdex = cwgt.$n('chdex'),
        minus = zk(chdex).padBorderWidth();
      // we need to remove the chdex padding and border for border-box mode
      cwgt.setFlexSize_({
        width: lastsz - minus
      });
      cwgt._hflexsz = lastsz - minus;
      // no need to subtract padding and border for border-box mode
      chdex.style.width = jq.px0(lastsz);
    }
    //notify all of children with xflex is done.
    child.parent.afterChildrenFlex_(child);
    child._flexFixed = false;
    return false; //to skip original _fixFlex
  };
  /** @internal */
  Layout.prototype.afterChildrenMinFlex_ = function (opts) {
    var n = this.$n();
    if (opts == 'h') {
      if (this.isVertical_()) {
        var total = 0;
        for (var w = n.firstChild; w; w = w.nextSibling) {
          var fchd = w.firstChild;
          if (fchd.style.height) {
            var hgh = fchd.offsetHeight + zk(w).padBorderHeight() + zk(fchd).marginHeight();
            w.style.height = jq.px0(hgh);
            total += hgh;
          } else total += w.offsetHeight;
        }
        n.style.height = jq.px0(total);
      } else {
        var max = 0;
        for (var w = n.firstChild; w; w = w.nextSibling) {
          // use w.offsetHeight instead of w.firstChild.offsetHeight
          // for avoiding span's special gap when using HTML5 doctype
          var h = w.offsetHeight + zk(w.firstChild).marginHeight();
          if (h > max) max = h;
        }
        n.style.height = jq.px0(max);
      }
    } else {
      if (!this.isVertical_()) {
        var total = 0;
        for (var w = n.firstChild; w; w = w.nextSibling) {
          var fchd = w.firstChild;
          if (fchd.style.width) {
            var wdh = fchd.offsetWidth + zk(w).padBorderWidth() + zk(fchd).marginWidth();
            w.style.width = jq.px0(wdh);
            total += wdh;
          } else total += w.offsetWidth;
        }
        n.style.width = jq.px0(total);
      } else {
        var max = 0;
        for (var w = n.firstChild; w; w = w.nextSibling) {
          var wd = w.firstChild.offsetWidth + zk(w.firstChild).marginWidth();
          if (wd > max) max = wd;
        }
        n.style.width = jq.px0(max);
      }
    }
  };
  Layout = __decorate([zk.WrapClass('zul.box.Layout')], Layout);
  return Layout;
}(zul.Widget);
exports.Layout = Layout;
if (!window.zul) window.zul = {};
if (!window.zul.box) window.zul.box = {};
if (!window.zul.box.Layout) window.zul.box.Layout = {};
window.zul.box.Layout._ = {
  Layout: Layout
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/box/Splitter.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/box/Splitter.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Splitter.ts

Purpose:

Description:

History:
    Sun Nov  9 17:15:35     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Splitter = void 0;
function _setOpen(wgt, open, opts) {
  var colps = wgt.getCollapse();
  if (!colps || 'none' == colps) return; //nothing to do
  var nd = wgt.$n_('chdex'),
    vert = wgt.isVertical(),
    before = colps == 'before',
    sib = before ? Splitter._prev(nd) : Splitter._next(nd),
    sibwgt = zk.Widget.$(sib),
    fd = vert ? 'height' : 'width',
    diff = 0;
  if (sib) {
    if (!open) zWatch.fireDown('onHide', sibwgt);
    sibwgt.setDomVisible_(sib, open);
    sibwgt.parent._fixChildDomVisible(sibwgt, open);
    var c = vert && sib.cells.length ? sib.cells[0] : sib;
    diff = zk.parseInt(c.style[fd]);
    if (!before && sibwgt && !sibwgt.nextSibling) {
      var sp = wgt.$n('chdex2');
      if (sp) {
        sp.style.display = open ? '' : 'none';
        diff += zk.parseInt(sp.style[fd]);
      }
    }
  }
  var sib2 = before ? Splitter._next(nd) : Splitter._prev(nd);
  if (sib2) {
    var c = vert && sib2.cells.length ? sib2.cells[0] : sib2,
      sz = c.style[fd];
    //ZK-1879: set width only if it has width originally
    if (sz && sz.includes('px')) {
      diff = zk.parseInt(c.style[fd]) + (open ? -diff : diff);
      if (diff < 0) diff = 0;
      c.style[fd] = diff + 'px';
    }
  }
  if (sib && open) zUtl.fireShown(sibwgt);
  if (sib2) zUtl.fireSized(zk.Widget.$(sib2), -1); //no beforeSize
  wgt._fixNSDomClass();
  wgt._fixbtn();
  wgt._fixszAll();
  if (!opts || opts.sendOnOpen) wgt.fire('onOpen', {
    open: open
  });
  //if fromServer, opts is true
}
/**
 * An element which should appear before or after an element inside a box
 * ({@link Box}).
 *
 * <p>When the splitter is dragged, the sibling elements of the splitter are
 * resized. If {@link getCollapse} is true, a grippy in placed
 * inside the splitter, and one sibling element of the splitter is collapsed
 * when the grippy is clicked.
 *
 *
 * @defaultValue {@link getZclass}: z-splitter.
 *
 */
var Splitter = /** @class */function (_super) {
  __extends(Splitter, _super);
  function Splitter() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._collapse = 'none';
    /** @internal */
    _this._open = true;
    return _this;
  }
  Splitter_1 = Splitter;
  /**
   * Opens or collapses the splitter.
   * Meaningful only if {@link getCollapse} is not "none".
   */
  Splitter.prototype.setOpen = function (open, opts) {
    var o = this._open;
    this._open = open;
    if (o !== open || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) _setOpen(this, open, opts);
    }
    return this;
  };
  /**
   * @returns whether it is open (i.e., not collapsed.
   * Meaningful only if {@link getCollapse} is not "none".
   * @defaultValue `true`.
   */
  Splitter.prototype.isOpen = function () {
    return this._open;
  };
  /**
   * @returns if it is a vertical box.
   */
  Splitter.prototype.isVertical = function () {
    var p = this.parent;
    return !p || p.isVertical();
  };
  /**
   * @returns the orient.
   * It is the same as the parent's orientation ({@link Box#getOrient}).
   */
  Splitter.prototype.getOrient = function () {
    var p = this.parent;
    return p ? p.getOrient() : 'vertical';
  };
  /**
   * @returns the collapse of this button.
   */
  Splitter.prototype.getCollapse = function () {
    return this._collapse;
  };
  /**
   * Sets the collapse of this button.
   */
  Splitter.prototype.setCollapse = function (collapse) {
    if (this._collapse != collapse) {
      var bOpen = this._open;
      if (!bOpen) this.setOpen(true, {
        sendOnOpen: false
      }); //bug 1939263
      this._collapse = collapse;
      if (this.desktop) {
        this._fixbtn();
        this._fixsz();
      }
      if (!bOpen) this.setOpen(false, {
        sendOnOpen: false
      });
    }
    return this;
  };
  /** @internal */
  Splitter.prototype.domClass_ = function (no) {
    var /*safe*/sc = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      sc += ' ' + this.$s('vertical' == this.getOrient() ? 'vertical' : 'horizontal');
    }
    return sc;
  };
  Splitter.prototype.setZclass = function (zclass) {
    _super.prototype.setZclass.call(this, zclass);
    if (this.desktop) this._fixDomClass(true);
    return this;
  };
  /** @internal */
  Splitter.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var box = this.parent;
    if (box && !box._splitterKid) box._bindWatch();
    zWatch.listen({
      onSize: this,
      beforeSize: this
    });
    this._fixDomClass();
    //Bug 1921830: if spiltter is invalidated...
    var node = this.$n();
    if (!this.$weave) {
      var $btn = jq(this.$n('btn'));
      $btn.on('click', Splitter_1.onclick);
    }
    this._fixbtn();
    this._drag0 = new zk.Draggable(this, node, {
      constraint: this.getOrient(),
      ignoredrag: Splitter_1._ignoresizing,
      ghosting: Splitter_1._ghostsizing,
      overlay: true,
      zIndex: '12000',
      initSensitivity: 0,
      snap: Splitter_1._snap,
      endeffect: Splitter_1._endDrag
    });
    this._shallClose = !this._open;
    //3086452: we have to close it after onSize
    //3077716: next sibling is not bound yet
  };
  /** @internal */
  Splitter.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this,
      beforeSize: this
    });
    var btn = this.$n('btn');
    if (btn) {
      jq(btn).off('click', Splitter_1.onclick);
    }
    this._drag0.destroy();
    this._drag0 = undefined;
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /* Fixed DOM class for the enclosing TR/TD tag. */
  /** @internal */
  Splitter.prototype._fixDomClass = function (inner) {
    var node = this.$n(),
      p = node.parentNode;
    if (p) {
      var vert = this.isVertical();
      if (vert) p = p.parentNode; //TR
      if (p && p.id.endsWith('chdex')) {
        p.className = this.$s('outer');
      }
    }
    if (inner) this._fixbtn();
  };
  /** @internal */
  Splitter.prototype._fixNSDomClass = function () {
    jq(this.$n())[this._open ? 'removeClass' : 'addClass'](this.$s('nosplitter'));
  };
  /** @internal */
  Splitter.prototype._fixbtn = function () {
    var $btn = jq(this.$n('btn')),
      $icon = jq(this.$n('icon')),
      colps = this.getCollapse();
    if (!colps || 'none' == colps) {
      $btn.addClass(this.$s('button-disabled'));
      $icon.hide();
    } else {
      var before = colps == 'before';
      if (!this._open) before = !before;
      if (this.isVertical()) {
        jq(this.$n('icon')).removeClass(before ? 'z-icon-caret-down' : 'z-icon-caret-up').addClass(before ? 'z-icon-caret-up' : 'z-icon-caret-down');
      } else {
        jq(this.$n('icon')).removeClass(before ? 'z-icon-caret-right' : 'z-icon-caret-left').addClass(before ? 'z-icon-caret-left' : 'z-icon-caret-right');
      }
      $btn.removeClass(this.$s('button-disabled'));
      $icon.show();
    }
  };
  /** @internal */
  Splitter.prototype.setBtnPos_ = function (btnPos) {
    var btn = this.$n('btn'),
      node = this.$n();
    if (btnPos) btn.style.marginLeft = (node.offsetWidth - btn.offsetWidth) / 2 + 'px';else btn.style.marginTop = (node.offsetHeight - btn.offsetHeight) / 2 + 'px';
  };
  /** @internal */
  Splitter.prototype._fixsz = function () {
    if (!this.isRealVisible()) return;
    var node = this.$n(),
      pn = node.parentNode;
    if (pn) {
      // B85-ZK-3516: remove width of parent node
      pn.style.width = '';
      if (this.isVertical()) {
        node.style.width = '100%'; // Sandbox-Splitter: the width should be same as parent
        this.setBtnPos_(true);
      } else {
        node.style.height = (zk.webkit ? pn.parentNode.clientHeight : pn.clientHeight) + 'px';
        //Bug 1916332: TR's clientHeight is correct (not TD's) in Safari
        this.setBtnPos_();
      }
    }
    if (this._shallClose) {
      //set in bind_
      delete this._shallClose;
      _setOpen(this, false, {
        sendOnOpen: false
      });
    }
  };
  Splitter.prototype.onSize = function () {
    this._fixsz();
  };
  Splitter.prototype.beforeSize = function () {
    this.$n().style[this.isVertical() ? 'width' : 'height'] = '';
    this.$n('btn').style[this.isVertical() ? 'margin-left' : 'margin-top'] = '';
  };
  /** @internal */
  Splitter.prototype._fixszAll = function () {
    //1. find the topmost box
    var box;
    for (var p = this; p = p.parent;) if (p instanceof zul.box.Box) box = p;
    if (box) Splitter_1._fixKidSplts(box);else this._fixsz();
  };
  Splitter.onclick = function (evt) {
    var wgt = zk.Widget.$(evt),
      colps = wgt.getCollapse();
    if (!colps || 'none' == colps) return; //nothing to do
    wgt.setOpen(!wgt._open);
  };
  //drag
  /** @internal */
  Splitter._ignoresizing = function (draggable, pointer, evt) {
    var wgt = draggable.control;
    if (!wgt._open || wgt.$n('icon') == evt.domTarget) return true;
    var run = draggable.run = {},
      node = wgt.$n(),
      nd = wgt.$n('chdex');
    run.prev = Splitter_1._prev(nd);
    run.next = Splitter_1._next(nd);
    if (!run.prev || !run.next) return true; // splitter as first or last child
    run.prevwgt = wgt.previousSibling;
    run.nextwgt = wgt.nextSibling;
    run.z_offset = zk(node).cmOffset();
    return false;
  };
  /** @internal */
  Splitter._ghostsizing = function (draggable, ofs, evt) {
    var $node = zk(draggable.node.parentNode);
    jq(document.body).append( /*safe*/'<div id="zk_ddghost" class="z-splitter-ghost" style="font-size:0;line-height:0;background:#AAA;position:absolute;top:' + jq.px(ofs[1]) + ';left:' + jq.px(ofs[0]) + ';width:' + jq.px($node.offsetWidth()) + ';height:' + jq.px($node.offsetHeight()) + ';"></div>');
    return jq('#zk_ddghost')[0];
  };
  /** @internal */
  Splitter._endDrag = function (draggable) {
    var wgt = draggable.control,
      vert = wgt.isVertical(),
      flInfo = Splitter_1._fixLayout(wgt),
      bfcolps = 'before' == wgt.getCollapse(),
      run = draggable.run,
      diff,
      runNext = run.next,
      runPrev = run.prev;
    if (vert) {
      diff = run.z_point[1];
      //We adjust height of TD if vert
      if (run.next && run.next.cells.length) runNext = run.next.cells[0];
      if (run.prev && run.prev.cells.length) runPrev = run.prev.cells[0];
    } else {
      diff = run.z_point[0];
    }
    //B70-ZK-2514: make runNext always the same block with the dragging direction, ex. drag to up, up is runNext
    var runNextWgt = run.nextwgt,
      runPrevWgt = run.prevwgt;
    if (diff < 0) {
      // Swap `runNext` and `runPrev`. Unfortunately, ie11 doesn't support *destructuring assignment*.
      var tmp = runNext;
      runNext = runPrev;
      runPrev = tmp;
      diff = -diff;
      bfcolps = !bfcolps;
    }
    if (!diff) return; //nothing to do
    //B70-ZK-2514: assign fd to each block separately and count on clientFd in the end
    if (runNext && runPrev) Splitter_1._doDragEndResize(vert, [runNextWgt, runPrevWgt], runPrev, runNext, diff, bfcolps);
    Splitter_1._unfixLayout(flInfo);
    //Stange (not know the cause yet): we have to put it
    //befor _fixszAll and after onSize
    wgt._fixszAll();
    //fix all splitter's size because table might be with %
    draggable.run = undefined; //free memory
  };
  /** @internal */
  Splitter._doDragEndResize = function (vert, wgts,
  // loop requires exactly 2 elements
  runPrev, runNext, diff, bfcolps) {
    var upperFdArr = [],
      hflexReset = [],
      vflexReset = [],
      fdArr = ['width', 'height'];
    for (var i = 0; i < 2; i++) {
      upperFdArr[i] = fdArr[i].charAt(0).toUpperCase() + fdArr[i].slice(1);
    }
    var upperFd = vert ? upperFdArr[1] : upperFdArr[0],
      s = runNext['client' + upperFd],
      s2 = runPrev['client' + upperFd],
      totalFd = s + s2;
    //F70-ZK-112: clear flex once splitter is moved, that is, make splitter resizeable
    for (var i = 0, w; i < 2; i++) {
      if (w = wgts[i]) {
        if (w.getHflex()) {
          w.setHflex('false');
          hflexReset[i] = true;
        }
        if (w.getVflex()) {
          w.setVflex('false');
          vflexReset[i] = true;
        }
        zWatch.fireDown('_preBeforeSizeReadOnly', w);
        zWatch.fireDown('beforeSize', w);
      }
    }
    s -= diff;
    if (s < 0) s = 0;
    var minusS = totalFd - s,
      fd = vert ? fdArr[1] : fdArr[0];
    runNext.style[fd] = s + 'px';
    runPrev.style[fd] = minusS + 'px';
    if (!bfcolps) runNext.style.overflow = 'hidden';else runPrev.style.overflow = 'hidden';
    for (var i = 0, w; i < 2; i++) {
      w = wgts[i];
      if (w && hflexReset[i]) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        w['set' + upperFdArr[0]]('100%');
      }
      if (w && vflexReset[i]) {
        // eslint-disable-next-line @typescript-eslint/no-unsafe-call
        w['set' + upperFdArr[1]]('100%');
      }
      if (w) {
        zUtl.fireSized(w, -1); //no beforeSize
      }
    }
    var nextClientFd = runNext['client' + upperFd],
      prevClientFd = totalFd - nextClientFd;
    if (nextClientFd != s) runNext.style[fd] = nextClientFd + 'px'; //count on clientFd
    if (prevClientFd != minusS) runPrev.style[fd] = prevClientFd + 'px'; //count on clientFd
  };
  /** @internal */
  Splitter._snap = function (draggable, pos) {
    var run = draggable.run,
      wgt = draggable.control,
      x = pos[0],
      y = pos[1];
    if (wgt.isVertical()) {
      if (y <= run.z_offset[1] - run.prev.offsetHeight) {
        y = run.z_offset[1] - run.prev.offsetHeight;
      } else {
        var max = run.z_offset[1] + run.next.offsetHeight - wgt.$n().offsetHeight;
        if (y > max) y = max;
      }
    } else {
      if (x <= run.z_offset[0] - run.prev.offsetWidth) {
        x = run.z_offset[0] - run.prev.offsetWidth;
      } else {
        var max = run.z_offset[0] + run.next.offsetWidth - wgt.$n().offsetWidth;
        if (x > max) x = max;
      }
    }
    run.z_point = [x - run.z_offset[0], y - run.z_offset[1]];
    return [x, y];
  };
  /** @internal */
  Splitter._next = function (n) {
    return jq(n).next().next()[0];
  };
  /** @internal */
  Splitter._prev = function (n) {
    return jq(n).prev().prev()[0];
  };
  /** @internal */
  Splitter._fixKidSplts = function (wgt) {
    if (wgt && wgt.isVisible()) {
      //n might not be an element
      if (wgt instanceof Splitter_1) wgt._fixsz();
      for (wgt = wgt.firstChild; wgt; wgt = wgt.nextSibling) Splitter_1._fixKidSplts(wgt);
    }
  };
  /** @internal */
  Splitter._fixLayout = function (wgt) {
    if (!zk.opera) {
      return false;
    }
    var box = wgt.parent.$n();
    if (box.style.tableLayout != 'fixed') {
      var fl = [box, box.style.tableLayout];
      box.style.tableLayout = 'fixed';
      return fl;
    }
  };
  /** @internal */
  Splitter._unfixLayout = function (fl) {
    if (!zk.opera) {
      return false;
    }
    if (fl) fl[0].style.tableLayout = fl[1];
  };
  var Splitter_1;
  Splitter = Splitter_1 = __decorate([zk.WrapClass('zul.box.Splitter')], Splitter);
  return Splitter;
}(zul.Widget);
exports.Splitter = Splitter;
if (!window.zul) window.zul = {};
if (!window.zul.box) window.zul.box = {};
if (!window.zul.box.Splitter) window.zul.box.Splitter = {};
window.zul.box.Splitter._ = {
  _setOpen: _setOpen,
  Splitter: Splitter
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/box/Vlayout.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/box/Vlayout.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Vlayout = void 0;
/* Vlayout.ts

    Purpose:

    Description:

    History:
        Fri Aug  6 12:37:19 TST 2010, Created by jumperchen

Copyright (C) 2010 Potix Corporation. All Rights Reserved.

This program is distributed under GPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A vertical layout.
 * @defaultValue {@link getZclass}: z-vlayout.
 * @since 5.0.4
 */
var Vlayout = /** @class */function (_super) {
  __extends(Vlayout, _super);
  function Vlayout() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /** @internal */
  Vlayout.prototype.isVertical_ = function () {
    return true;
  };
  /** @internal */
  Vlayout.prototype.getFlexDirection_ = function () {
    return 'column';
  };
  Vlayout = __decorate([zk.WrapClass('zul.box.Vlayout')], Vlayout);
  return Vlayout;
}(zul.box.Layout);
exports.Vlayout = Vlayout;
if (!window.zul) window.zul = {};
if (!window.zul.box) window.zul.box = {};
if (!window.zul.box.Vlayout) window.zul.box.Vlayout = {};
window.zul.box.Vlayout._ = {
  Vlayout: Vlayout
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/box/index.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/box/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./Layout */ "./zul/src/main/resources/web/js/zul/box/Layout.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Box */ "./zul/src/main/resources/web/js/zul/box/Box.ts"), exports);
__exportStar(__webpack_require__(/*! ./Splitter */ "./zul/src/main/resources/web/js/zul/box/Splitter.ts"), exports);
__exportStar(__webpack_require__(/*! ./Hlayout */ "./zul/src/main/resources/web/js/zul/box/Hlayout.ts"), exports);
__exportStar(__webpack_require__(/*! ./Vlayout */ "./zul/src/main/resources/web/js/zul/box/Vlayout.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/box/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;