/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.URLs;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ResourceInfo;
import org.zkoss.web.util.resource.ServletContextLocator;

public abstract class ResourceLoader<V>
implements Loader<ResourceInfo, V> {
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);

    protected ResourceLoader() {
    }

    protected abstract V parse(String var1, File var2, Object var3) throws Exception;

    protected abstract V parse(String var1, URL var2, Object var3) throws Exception;

    public boolean shallCheck(ResourceInfo src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(ResourceInfo src) {
        if (src.url != null) {
            URLConnection conn = null;
            try {
                URL url = src.url;
                url = URLs.sanitizeURL((URL)url);
                conn = url.openConnection();
                long v = conn.getLastModified();
                long l = v != -1L ? v : 0L;
                return l;
            }
            catch (Throwable ex) {
                long l = -1L;
                return l;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.getInputStream().close();
                    }
                    catch (Throwable e) {
                        log.warn("The connection cannot be closed", e);
                    }
                }
            }
        }
        long v = src.file.lastModified();
        return v == -1L ? 0L : (v == 0L ? -1L : v);
    }

    public V load(ResourceInfo src) throws Exception {
        if (src.url != null) {
            return this.parse(src.path, src.url, src.extra);
        }
        if (!src.file.exists() && src.extra != null && ((ServletContextLocator)src.extra).getResourceAsStream(src.path) == null) {
            if (log.isDebugEnabled()) {
                log.debug("Not found: " + src.file);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading " + src.file);
        }
        try {
            return this.parse(src.path, src.file, src.extra);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }
}

