/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.Callback;
import org.adempiere.webui.component.FavoriteSimpleTreeModel;
import org.adempiere.webui.dashboard.DPFavourites;
import org.compiere.model.MMenu;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavorite;
import org.compiere.model.MTreeFavoriteNode;
import org.compiere.model.MTreeNode;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Session;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Tree;

public class FavouriteController {
    private static final String DESKTOP_FAVOURITE_CONTROLLER = "desktop.FavouriteController";
    private Map<Integer, MTreeNode> nodeMap;
    private int m_AD_Tree_Favorite_ID;
    private MTreeNode rootNode;
    private List<Callback<Integer>> deletedCallbacks;
    private List<Callback<MTreeNode>> insertedCallbacks;
    private Tree tree;
    private FavoriteSimpleTreeModel treeModel;

    private FavouriteController() {
        this.init();
    }

    private void init() {
        this.nodeMap = new LinkedHashMap<Integer, MTreeNode>();
        this.deletedCallbacks = new ArrayList<Callback<Integer>>();
        this.insertedCallbacks = new ArrayList<Callback<MTreeNode>>();
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        MTreeFavorite vTree = null;
        this.m_AD_Tree_Favorite_ID = MTreeFavorite.getFavoriteTreeID((int)AD_User_ID);
        if (this.m_AD_Tree_Favorite_ID <= 0) {
            vTree = (MTreeFavorite)MTable.get((Properties)Env.getCtx(), (int)200220).getPO(0, null);
            MUser user = MUser.get((int)AD_User_ID);
            vTree.set_ValueOfColumn("AD_Client_ID", (Object)user.getAD_Client_ID());
            vTree.setAD_Org_ID(user.getAD_Org_ID());
            vTree.set_ValueNoCheck("AD_User_ID", (Object)AD_User_ID);
            if (!vTree.saveCrossTenantSafe()) {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"FavTreeNotCreate"));
            }
            this.m_AD_Tree_Favorite_ID = vTree.getAD_Tree_Favorite_ID();
        }
        vTree = (MTreeFavorite)MTable.get((Properties)Env.getCtx(), (int)200220).getPO(this.m_AD_Tree_Favorite_ID, null);
        this.rootNode = vTree.getRoot();
        Enumeration enTop = this.rootNode.children();
        while (enTop.hasMoreElements()) {
            MTreeNode ndTop = (MTreeNode)enTop.nextElement();
            Enumeration en = ndTop.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)en.nextElement();
                if (!nd.isOnBar() || nd.getMenu_ID() <= 0) continue;
                this.nodeMap.put(nd.getMenu_ID(), nd);
            }
        }
    }

    public static synchronized FavouriteController getInstance(Session currSess) {
        FavouriteController controller = (FavouriteController)currSess.getAttribute(DESKTOP_FAVOURITE_CONTROLLER);
        if (controller == null) {
            controller = new FavouriteController();
            currSess.setAttribute(DESKTOP_FAVOURITE_CONTROLLER, (Object)controller);
        }
        return controller;
    }

    private boolean barUpdate(boolean add, int Menu_ID) {
        if (add) {
            MTreeFavoriteNode.create((int)Env.getAD_Client_ID((Properties)Env.getCtx()), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Org_ID"), (int)this.m_AD_Tree_Favorite_ID, (int)Menu_ID, (int)0, (int)0, null, (boolean)false, (boolean)true, (boolean)true);
            return true;
        }
        MTreeFavoriteNode favNode = MTreeFavoriteNode.getFavouriteTreeNodeFromMenuID((int)this.m_AD_Tree_Favorite_ID, (int)Menu_ID);
        if (favNode != null) {
            try {
                PO.setCrossTenantSafe();
                boolean bl = favNode.delete(true);
                return bl;
            }
            finally {
                PO.clearCrossTenantSafe();
            }
        }
        return false;
    }

    public boolean addNode(int nodeId) {
        MTreeNode node = this.rootNode.findNode(nodeId);
        if (node != null) {
            return this.addNode(node);
        }
        return false;
    }

    public boolean addNode(MTreeNode node) {
        if (this.barUpdate(true, node.getNode_ID())) {
            this.nodeMap.put(node.getNode_ID(), node);
            if (this.tree != null && this.treeModel != null) {
                MMenu menu = (MMenu)MTable.get((Properties)Env.getCtx(), (int)116).getPO(node.getNode_ID(), null);
                MTreeFavoriteNode favNode = MTreeFavoriteNode.getFavouriteTreeNodeFromMenuID((int)this.m_AD_Tree_Favorite_ID, (int)menu.getAD_Menu_ID());
                DPFavourites.addNodeInTree(this.treeModel, this.tree, this.treeModel.getRoot(), favNode);
            }
            for (Callback<MTreeNode> callback : this.insertedCallbacks) {
                callback.onCallback((Object)node);
            }
            return true;
        }
        return false;
    }

    public boolean removeNode(int nodeId) {
        MTreeFavoriteNode favNode = MTreeFavoriteNode.getFavouriteTreeNodeFromMenuID((int)this.m_AD_Tree_Favorite_ID, (int)nodeId);
        if (favNode != null && this.barUpdate(false, nodeId)) {
            DefaultTreeNode<Object> treeNode;
            if (this.treeModel != null && (treeNode = this.treeModel.find(this.treeModel.getRoot(), favNode.getAD_Tree_Favorite_Node_ID())) != null) {
                this.treeModel.removeNode(treeNode);
            }
            this.nodeMap.remove(nodeId);
            for (Callback<Integer> callback : this.deletedCallbacks) {
                callback.onCallback((Object)nodeId);
            }
            return true;
        }
        return false;
    }

    public boolean hasNode(int nodeId) {
        return this.nodeMap.keySet().contains(nodeId);
    }

    public List<MTreeNode> getFavourites() {
        ArrayList<MTreeNode> list = new ArrayList<MTreeNode>();
        for (int key : this.nodeMap.keySet()) {
            list.add(this.nodeMap.get(key));
        }
        return list;
    }

    public void addInsertedCallback(Callback<MTreeNode> callback) {
        this.insertedCallbacks.add(callback);
    }

    public void addDeletedCallback(Callback<Integer> callback) {
        this.deletedCallbacks.add(callback);
    }

    public int getAD_Tree_Favorite_ID() {
        return this.m_AD_Tree_Favorite_ID;
    }

    public MTreeNode getRootNode() {
        return this.rootNode;
    }

    public void setTreeAndModel(FavoriteSimpleTreeModel treeModel, Tree tree) {
        this.tree = tree;
        this.treeModel = treeModel;
    }
}

