/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DocLine {
    protected PO p_po = null;
    private Doc m_doc = null;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private BigDecimal m_qty = null;
    private BigDecimal m_AmtSourceDr = Env.ZERO;
    private BigDecimal m_AmtSourceCr = Env.ZERO;
    private BigDecimal m_LineNetAmt = null;
    private BigDecimal m_ListAmt = Env.ZERO;
    private BigDecimal m_DiscountAmt = Env.ZERO;
    private BigDecimal m_AmtAcctDr = null;
    private BigDecimal m_AmtAcctCr = null;
    private int m_C_AcctSchema_ID = 0;
    private ProductCost m_productCost = null;
    private boolean m_productionBOM = false;
    private int m_PP_Cost_Collector_ID = 0;
    private MAccount m_account = null;
    private Timestamp m_DateAcct = null;
    private Timestamp m_DateDoc = null;
    private int m_C_SalesRegion_ID = -1;
    private int m_C_BPartner_ID = -1;
    private int m_C_LocFrom_ID = 0;
    private int m_C_LocTo_ID = 0;
    private Boolean m_isItem = null;
    private int m_C_Currency_ID = -1;
    private int m_C_ConversionType_ID = -1;
    private int m_C_Period_ID = -1;
    private BigDecimal m_currencyRate = null;
    private int m_ReversalLine_ID = 0;

    public DocLine(PO po, Doc doc) {
        if (po == null) {
            throw new IllegalArgumentException("PO is null");
        }
        this.p_po = po;
        this.m_doc = doc;
        if (this.p_po.getAD_Org_ID() == 0) {
            this.p_po.setAD_Org_ID(this.m_doc.getAD_Org_ID());
        }
    }

    public int getC_Currency_ID() {
        if (this.m_C_Currency_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_Currency_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_Currency_ID = ii;
            }
            if (this.m_C_Currency_ID <= 0) {
                this.m_C_Currency_ID = this.m_doc.getC_Currency_ID();
            }
        }
        return this.m_C_Currency_ID;
    }

    public int getC_ConversionType_ID() {
        if (this.m_C_ConversionType_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_ConversionType_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_ConversionType_ID = ii;
            }
            if (this.m_C_ConversionType_ID <= 0) {
                this.m_C_ConversionType_ID = this.m_doc.getC_ConversionType_ID();
            }
        }
        return this.m_C_ConversionType_ID;
    }

    protected void setC_ConversionType_ID(int C_ConversionType_ID) {
        this.m_C_ConversionType_ID = C_ConversionType_ID;
    }

    public BigDecimal getCurrencyRate() {
        return this.m_currencyRate;
    }

    protected void setCurrencyRate(BigDecimal currencyRate) {
        this.m_currencyRate = currencyRate;
    }

    public void setAmount(BigDecimal sourceAmt) {
        this.m_AmtSourceDr = sourceAmt == null ? Env.ZERO : sourceAmt;
        this.m_AmtSourceCr = Env.ZERO;
    }

    public void setAmount(BigDecimal amtSourceDr, BigDecimal amtSourceCr) {
        this.m_AmtSourceDr = amtSourceDr == null ? Env.ZERO : amtSourceDr;
        this.m_AmtSourceCr = amtSourceCr == null ? Env.ZERO : amtSourceCr;
    }

    public void setConvertedAmt(int C_AcctSchema_ID, BigDecimal amtAcctDr, BigDecimal amtAcctCr) {
        this.m_C_AcctSchema_ID = C_AcctSchema_ID;
        this.m_AmtAcctDr = amtAcctDr;
        this.m_AmtAcctCr = amtAcctCr;
    }

    public BigDecimal getAmtSource() {
        return this.m_AmtSourceDr.subtract(this.m_AmtSourceCr);
    }

    public BigDecimal getAmtSourceDr() {
        return this.m_AmtSourceDr;
    }

    public BigDecimal getAmtSourceCr() {
        return this.m_AmtSourceCr;
    }

    public BigDecimal getAmtAcctDr() {
        return this.m_AmtAcctDr;
    }

    public BigDecimal getAmtAcctCr() {
        return this.m_AmtAcctCr;
    }

    public BigDecimal getChargeAmt() {
        BigDecimal bd;
        int index = this.p_po.get_ColumnIndex("ChargeAmt");
        if (index != -1 && (bd = (BigDecimal)this.p_po.get_Value(index)) != null) {
            return bd;
        }
        return Env.ZERO;
    }

    public void setAmount(BigDecimal LineNetAmt, BigDecimal PriceList, BigDecimal Qty) {
        BigDecimal bigDecimal = this.m_LineNetAmt = LineNetAmt == null ? Env.ZERO : LineNetAmt;
        if (PriceList != null && Qty != null) {
            this.m_ListAmt = PriceList.multiply(Qty);
        }
        if (this.m_ListAmt.compareTo(Env.ZERO) == 0) {
            this.m_ListAmt = this.m_LineNetAmt;
        }
        this.m_DiscountAmt = this.m_ListAmt.subtract(this.m_LineNetAmt);
        this.setAmount(this.m_ListAmt, this.m_DiscountAmt);
    }

    public BigDecimal getDiscount() {
        return this.m_DiscountAmt;
    }

    public BigDecimal getListAmount() {
        return this.m_ListAmt;
    }

    public void setLineNetAmtDifference(BigDecimal diff) {
        String msg = "Diff=" + String.valueOf(diff) + " - LineNetAmt=" + String.valueOf(this.m_LineNetAmt);
        this.m_LineNetAmt = this.m_LineNetAmt.subtract(diff);
        this.m_DiscountAmt = this.m_ListAmt.subtract(this.m_LineNetAmt);
        this.setAmount(this.m_ListAmt, this.m_DiscountAmt);
        msg = msg + " -> " + String.valueOf(this.m_LineNetAmt);
        this.log.fine(msg);
    }

    public void setDateAcct(Timestamp dateAcct) {
        this.m_DateAcct = dateAcct;
    }

    public Timestamp getDateAcct() {
        if (this.m_DateAcct != null) {
            return this.m_DateAcct;
        }
        int index = this.p_po.get_ColumnIndex("DateAcct");
        if (index != -1) {
            this.m_DateAcct = (Timestamp)this.p_po.get_Value(index);
            if (this.m_DateAcct != null) {
                return this.m_DateAcct;
            }
        }
        this.m_DateAcct = this.m_doc.getDateAcct();
        return this.m_DateAcct;
    }

    public Timestamp getDateConv() {
        Timestamp dateConv = null;
        int index = this.p_po.get_ColumnIndex("DateAcct");
        if (index != -1) {
            dateConv = (Timestamp)this.p_po.get_Value(index);
        }
        if (dateConv == null) {
            dateConv = this.getDateAcct();
        }
        return dateConv;
    }

    public void setDateDoc(Timestamp dateDoc) {
        this.m_DateDoc = dateDoc;
    }

    public Timestamp getDateDoc() {
        if (this.m_DateDoc != null) {
            return this.m_DateDoc;
        }
        int index = this.p_po.get_ColumnIndex("DateDoc");
        if (index != -1) {
            this.m_DateDoc = (Timestamp)this.p_po.get_Value(index);
            if (this.m_DateDoc != null) {
                return this.m_DateDoc;
            }
        }
        this.m_DateDoc = this.m_doc.getDateDoc();
        return this.m_DateDoc;
    }

    public void setAccount(MAccount acct) {
        this.m_account = acct;
    }

    public MAccount getAccount() {
        return this.m_account;
    }

    public MAccount getAccount(int AcctType, MAcctSchema as) {
        if (this.getM_Product_ID() == 0 && this.getC_Charge_ID() != 0) {
            MAccount acct;
            BigDecimal amt = new BigDecimal(-1);
            if (!this.m_doc.isSOTrx()) {
                amt = new BigDecimal(1);
            }
            if ((acct = this.getChargeAccount(as, amt)) != null) {
                return acct;
            }
        }
        return this.getProductCost().getAccount(AcctType, as);
    }

    protected int getC_Charge_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Charge_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public MAccount getChargeAccount(MAcctSchema as, BigDecimal amount) {
        int C_Charge_ID = this.getC_Charge_ID();
        if (C_Charge_ID == 0) {
            return null;
        }
        return MCharge.getAccount(C_Charge_ID, as);
    }

    protected int getC_Period_ID() {
        if (this.m_C_Period_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_Period_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_Period_ID = ii;
            }
            if (this.m_C_Period_ID == -1) {
                this.m_C_Period_ID = 0;
            }
        }
        return this.m_C_Period_ID;
    }

    protected void setC_Period_ID(int C_Period_ID) {
        this.m_C_Period_ID = C_Period_ID;
    }

    public int getC_AcctSchema_ID() {
        return this.m_C_AcctSchema_ID;
    }

    public int get_ID() {
        return this.p_po.get_ID();
    }

    public int getAD_Org_ID() {
        return this.p_po.getAD_Org_ID();
    }

    public int getOrder_Org_ID() {
        String sql;
        int AD_Org_ID;
        int C_OrderLine_ID = this.getC_OrderLine_ID();
        if (C_OrderLine_ID != 0 && (AD_Org_ID = DB.getSQLValue(null, sql = "SELECT AD_Org_ID FROM C_OrderLine WHERE C_OrderLine_ID=?", C_OrderLine_ID)) > 0) {
            return AD_Org_ID;
        }
        return this.getAD_Org_ID();
    }

    public int getM_Product_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Product_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public boolean isItem() {
        MProduct product;
        if (this.m_isItem != null) {
            return this.m_isItem;
        }
        this.m_isItem = Boolean.FALSE;
        if (this.getM_Product_ID() != 0 && (product = MProduct.get(Env.getCtx(), this.getM_Product_ID())).get_ID() == this.getM_Product_ID() && product.isItem()) {
            this.m_isItem = Boolean.TRUE;
        }
        return this.m_isItem;
    }

    public int getM_AttributeSetInstance_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_AttributeSetInstance_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getM_Locator_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Locator_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getM_LocatorTo_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_LocatorTo_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public void setProductionBOM(boolean productionBOM) {
        this.m_productionBOM = productionBOM;
    }

    public boolean isProductionBOM() {
        return this.m_productionBOM;
    }

    public int getM_Production_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("M_Production_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_OrderLine_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_OrderLine_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_LocFrom_ID() {
        return this.m_C_LocFrom_ID;
    }

    public void setC_LocFrom_ID(int C_LocFrom_ID) {
        this.m_C_LocFrom_ID = C_LocFrom_ID;
    }

    public int getPP_Cost_Collector_ID() {
        return this.m_PP_Cost_Collector_ID;
    }

    public int setPP_Cost_Collector_ID(int PP_Cost_Collector_ID) {
        return this.m_PP_Cost_Collector_ID;
    }

    public int getC_LocTo_ID() {
        return this.m_C_LocTo_ID;
    }

    public void setC_LocTo_ID(int C_LocTo_ID) {
        this.m_C_LocTo_ID = C_LocTo_ID;
    }

    public ProductCost getProductCost() {
        if (this.m_productCost == null) {
            this.m_productCost = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.p_po.get_TrxName());
        }
        return this.m_productCost;
    }

    public BigDecimal getProductCosts(MAcctSchema as, int AD_Org_ID, boolean zeroCostsOK, String whereClause) {
        MCostDetail cd;
        if (whereClause != null && !as.getCostingMethod().equals("S") && (cd = MCostDetail.get(Env.getCtx(), whereClause, this.get_ID(), this.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.p_po.get_TrxName())) != null) {
            BigDecimal amt = cd.getAmt();
            BigDecimal pcost = this.getProductCosts(as, AD_Org_ID, zeroCostsOK, cd);
            if (amt.signum() != 0 && pcost.signum() != 0 && amt.signum() != pcost.signum()) {
                return amt.signum() > 0 ? pcost.negate() : pcost;
            }
            return pcost;
        }
        return this.getProductCosts(as, AD_Org_ID, zeroCostsOK);
    }

    public BigDecimal getProductCosts(MAcctSchema as, int AD_Org_ID, boolean zeroCostsOK) {
        return this.getProductCosts(as, AD_Org_ID, zeroCostsOK, (MCostDetail)null);
    }

    public BigDecimal getProductCosts(MAcctSchema as, int AD_Org_ID, boolean zeroCostsOK, MCostDetail costDetail) {
        int C_OrderLine_ID;
        String costingMethod;
        ProductCost pc = this.getProductCost();
        BigDecimal costs = pc.getProductCosts(as, AD_Org_ID, costingMethod = null, C_OrderLine_ID = this.getC_OrderLine_ID(), zeroCostsOK, this.getDateAcct(), costDetail, this.m_doc.isInBackDatePostingProcess());
        if (costs != null) {
            return costs;
        }
        return Env.ZERO;
    }

    public MProduct getProduct() {
        if (this.m_productCost == null) {
            this.m_productCost = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.p_po.get_TrxName());
        }
        if (this.m_productCost != null) {
            return this.m_productCost.getProduct();
        }
        return null;
    }

    public int getC_RevenueRecognition_ID() {
        MProduct product = this.getProduct();
        if (product != null) {
            return product.getC_RevenueRecognition_ID();
        }
        return 0;
    }

    public int getC_UOM_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_UOM_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        MProduct product = this.getProduct();
        if (product != null) {
            return product.getC_UOM_ID();
        }
        return 0;
    }

    public void setQty(BigDecimal qty, boolean isSOTrx) {
        this.m_qty = qty == null ? Env.ZERO : (isSOTrx ? qty.negate() : qty);
        this.getProductCost().setQty(qty);
    }

    public BigDecimal getQty() {
        return this.m_qty;
    }

    public String getDescription() {
        int index = this.p_po.get_ColumnIndex("Description");
        if (index != -1) {
            return (String)this.p_po.get_Value(index);
        }
        return null;
    }

    public int getC_Tax_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Tax_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getLine() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("Line");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_BPartner_ID() {
        if (this.m_C_BPartner_ID == -1) {
            Integer ii;
            int index = this.p_po.get_ColumnIndex("C_BPartner_ID");
            if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
                this.m_C_BPartner_ID = ii;
            }
            if (this.m_C_BPartner_ID <= 0) {
                this.m_C_BPartner_ID = this.m_doc.getC_BPartner_ID();
            }
        }
        return this.m_C_BPartner_ID;
    }

    protected void setC_BPartner_ID(int C_BPartner_ID) {
        this.m_C_BPartner_ID = C_BPartner_ID;
    }

    public int getC_BPartner_Location_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_BPartner_Location_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return this.m_doc.getC_BPartner_Location_ID();
    }

    public int getAD_OrgTrx_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("AD_OrgTrx_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_SalesRegion_ID() {
        if (this.m_C_SalesRegion_ID == -1) {
            if (this.getC_BPartner_Location_ID() != 0) {
                String sql = "SELECT COALESCE(C_SalesRegion_ID,0) FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?";
                this.m_C_SalesRegion_ID = DB.getSQLValue(null, sql, this.getC_BPartner_Location_ID());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("C_SalesRegion_ID=" + this.m_C_SalesRegion_ID + " (from BPL)");
                }
                if (this.m_C_SalesRegion_ID == 0) {
                    this.m_C_SalesRegion_ID = -2;
                }
            } else {
                this.m_C_SalesRegion_ID = -2;
            }
        }
        if (this.m_C_SalesRegion_ID < 0) {
            return 0;
        }
        return this.m_C_SalesRegion_ID;
    }

    public int getC_Project_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Project_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_ProjectPhase_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ProjectPhase_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_ProjectTask_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_ProjectTask_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_Campaign_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Campaign_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getC_Activity_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("C_Activity_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUser1_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User1_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getUser2_ID() {
        Integer ii;
        int index = this.p_po.get_ColumnIndex("User2_ID");
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public int getValue(String ColumnName) {
        Integer ii;
        int index = this.p_po.get_ColumnIndex(ColumnName);
        if (index != -1 && (ii = (Integer)this.p_po.get_Value(index)) != null) {
            return ii;
        }
        return 0;
    }

    public void setReversalLine_ID(int ReversalLine_ID) {
        this.m_ReversalLine_ID = ReversalLine_ID;
    }

    public int getReversalLine_ID() {
        return this.m_ReversalLine_ID;
    }

    public PO getPO() {
        return this.p_po;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DocLine=[");
        sb.append(this.p_po.get_ID());
        if (this.getDescription() != null) {
            sb.append(",").append(this.getDescription());
        }
        if (this.getM_Product_ID() != 0) {
            sb.append(",M_Product_ID=").append(this.getM_Product_ID());
        }
        sb.append(",Qty=").append(this.m_qty).append(",Amt=").append(this.getAmtSource()).append("]");
        return sb.toString();
    }
}

