/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.util;

import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.CreateEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.ComponentActivationListener;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ConventionWires;
import org.zkoss.zk.ui.util.GenericComposer;

public abstract class GenericAutowireComposer<T extends Component>
extends GenericComposer<T>
implements ComponentCloneListener,
ComponentActivationListener {
    private static final long serialVersionUID = 20091006115726L;
    private static final String COMPOSER_CLONE = "COMPOSER_CLONE";
    private static final String ON_CLONE_DO_AFTER_COMPOSE = "onCLONE_DO_AFTER_COMPOSE";
    private static Logger log = LoggerFactory.getLogger(GenericAutowireComposer.class);
    protected transient T self;
    protected transient IdSpace spaceOwner;
    protected transient Page page;
    protected transient Desktop desktop;
    protected transient Session session;
    protected transient WebApp application;
    protected transient Map<String, Object> componentScope;
    protected transient Map<String, Object> spaceScope;
    protected transient Map<String, Object> pageScope;
    protected transient Map<String, Object> desktopScope;
    protected transient Map<String, Object> sessionScope;
    protected transient Map<String, Object> applicationScope;
    protected transient Map<String, Object> requestScope;
    protected transient Execution execution;
    protected transient Map<?, ?> arg;
    protected transient Map<String, String[]> param;
    protected char _separator;
    private boolean _ignoreZScript;
    private boolean _ignoreXel;
    private static boolean _sIgnoreChecked;
    private static boolean _sIgnoreZScript;
    private static boolean _sIgnoreXel;
    private static Method _alert;

    protected GenericAutowireComposer() {
        this('$');
    }

    protected GenericAutowireComposer(char separator) {
        this.initIgnores();
        this._separator = separator;
        this._ignoreZScript = _sIgnoreZScript;
        this._ignoreXel = _sIgnoreXel;
    }

    protected GenericAutowireComposer(char separator, boolean ignoreZScript, boolean ignoreXel) {
        this._separator = separator;
        this._ignoreZScript = ignoreZScript;
        this._ignoreXel = ignoreXel;
    }

    private void initIgnores() {
        if (!_sIgnoreChecked) {
            _sIgnoreZScript = !"true".equals(Library.getProperty((String)"org.zkoss.zk.ui.composer.autowire.zscript"));
            _sIgnoreXel = !"true".equals(Library.getProperty((String)"org.zkoss.zk.ui.composer.autowire.xel"));
            _sIgnoreChecked = true;
        }
    }

    @Override
    protected Page getPage() {
        Page page;
        if (this.self != null && (page = this.self.getPage()) != null) {
            return page;
        }
        return super.getPage();
    }

    @Override
    public void doAfterCompose(T comp) throws Exception {
        super.doAfterCompose(comp);
        ConventionWires.wireVariables(comp, (Object)this, this._separator, this._ignoreZScript, this._ignoreXel);
        comp.addEventListener(1000, "onCreate", new BeforeCreateWireListener());
    }

    protected void alert(String m) {
        if ("ajax".equals(Executions.getCurrent().getDesktop().getDeviceType())) {
            try {
                if (_alert == null) {
                    Class mboxcls = Classes.forNameByThread((String)"org.zkoss.zul.Messagebox");
                    _alert = mboxcls.getMethod("show", String.class);
                }
                _alert.invoke(null, m);
                return;
            }
            catch (Throwable ex) {
                log.debug("Failed to invoke org.zkoss.zul.Messagebox", ex);
            }
        }
        Clients.alert(m);
    }

    @Override
    public Object willClone(Component comp) {
        try {
            Execution exec = Executions.getCurrent();
            int idcode = System.identityHashCode(comp);
            Composer composerClone = (Composer)exec.getAttribute(COMPOSER_CLONE + idcode);
            if (composerClone == null) {
                composerClone = (Composer)Classes.newInstance(this.getClass(), null);
                exec.setAttribute(COMPOSER_CLONE + idcode, composerClone);
                comp.addEventListener(ON_CLONE_DO_AFTER_COMPOSE, new CloneDoAfterCompose());
                Events.postEvent(new Event(ON_CLONE_DO_AFTER_COMPOSE, comp, composerClone));
            }
            return composerClone;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap(ex);
        }
    }

    @Override
    public void didActivate(Component comp) {
        if (comp != null && Objects.equals((Object)comp.getUuid(), (Object)this._applied) && this.self == null) {
            ConventionWires.wireImplicit(comp, this);
        }
        ConventionWires.wireServiceCommand(comp, this);
    }

    @Override
    public void willPassivate(Component comp) {
    }

    private static class CloneDoAfterCompose
    implements SerializableEventListener<Event> {
        private CloneDoAfterCompose() {
        }

        @Override
        public void onEvent(Event event) throws Exception {
            Component clone = event.getTarget();
            GenericAutowireComposer composerClone = (GenericAutowireComposer)event.getData();
            composerClone.doAfterCompose(clone);
            clone.removeEventListener(GenericAutowireComposer.ON_CLONE_DO_AFTER_COMPOSE, this);
        }
    }

    private class BeforeCreateWireListener
    implements SerializableEventListener<CreateEvent> {
        private BeforeCreateWireListener() {
        }

        @Override
        public void onEvent(CreateEvent event) throws Exception {
            ConventionWires.wireVariables(event.getTarget(), (Object)GenericAutowireComposer.this, GenericAutowireComposer.this._separator, GenericAutowireComposer.this._ignoreZScript, GenericAutowireComposer.this._ignoreXel);
            event.getTarget().removeEventListener("onCreate", this);
        }
    }
}

