/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import org.zkoss.mesg.Messages;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Window;

public class MessageboxDlg
extends Window {
    private Messagebox.Button[] _buttons;
    private Messagebox.Button _result;
    private EventListener<Messagebox.ClickEvent> _listener;

    public void onOK() throws Exception {
        if (this.contains(Messagebox.Button.OK)) {
            this.endModal(Messagebox.Button.OK);
        } else if (this.contains(Messagebox.Button.YES)) {
            this.endModal(Messagebox.Button.YES);
        } else if (this.contains(Messagebox.Button.RETRY)) {
            this.endModal(Messagebox.Button.RETRY);
        }
    }

    public void onCancel() throws Exception {
        if (this._buttons.length == 1 && this._buttons[0] == Messagebox.Button.OK) {
            this.endModal(Messagebox.Button.OK);
        } else if (this.contains(Messagebox.Button.CANCEL)) {
            this.endModal(Messagebox.Button.CANCEL);
        } else if (this.contains(Messagebox.Button.NO)) {
            this.endModal(Messagebox.Button.NO);
        } else if (this.contains(Messagebox.Button.ABORT)) {
            this.endModal(Messagebox.Button.ABORT);
        }
    }

    private boolean contains(Messagebox.Button button) {
        for (int j = 0; j < this._buttons.length; ++j) {
            if (this._buttons[j] != button) continue;
            return true;
        }
        return false;
    }

    public void setButtons(Messagebox.Button[] buttons, String[] btnLabels) {
        this._buttons = buttons;
        Component parent = this.getFellowIfAny("buttons");
        if (parent != null && parent.getFirstChild() == null) {
            String sclass = (String)parent.getAttribute("button.sclass");
            for (int j = 0; j < this._buttons.length; ++j) {
                Button mbtn = new Button();
                mbtn.setButton(this._buttons[j], btnLabels != null && j < btnLabels.length ? btnLabels[j] : null);
                mbtn.setSclass(sclass);
                mbtn.setAutodisable("self");
                parent.appendChild((Component)mbtn);
            }
        }
    }

    public void setEventListener(EventListener<Messagebox.ClickEvent> listener) {
        this._listener = listener;
    }

    public void setFocus(Messagebox.Button button) {
        Button btn;
        if (button != null && (btn = (Button)this.getFellowIfAny("btn" + button.id)) != null) {
            btn.focus();
        }
    }

    public void endModal(Messagebox.Button button) throws Exception {
        this._result = button;
        if (this._listener != null) {
            Messagebox.ClickEvent evt = new Messagebox.ClickEvent(button.event, (Component)this, button);
            this._listener.onEvent((Event)evt);
            if (!evt.isPropagatable()) {
                return;
            }
        }
        this.detach();
    }

    public Messagebox.Button getResult() {
        return this._result;
    }

    @Override
    public void onClose() {
        if (this._listener != null) {
            Messagebox.ClickEvent evt = new Messagebox.ClickEvent("onClose", (Component)this, null);
            try {
                this._listener.onEvent((Event)evt);
                if (!evt.isPropagatable()) {
                    return;
                }
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        super.onClose();
    }

    public static class Button
    extends org.zkoss.zul.Button {
        private Messagebox.Button _button;

        public void setButton(Messagebox.Button button, String label) {
            this._button = button;
            this.setLabel(label != null ? label : Messages.get((int)this._button.label));
            this.setId("btn" + this._button.id);
            if (label != null && label.length() > 7) {
                this.setWidth("auto");
            }
        }

        public void setButton(Messagebox.Button button) {
            this.setButton(button, null);
        }

        public void onClick() throws Exception {
            ((MessageboxDlg)this.getSpaceOwner()).endModal(this._button);
        }

        protected String getDefaultMold(Class klass) {
            return super.getDefaultMold(org.zkoss.zul.Button.class);
        }
    }
}

