/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.parser;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.compression.EncodingException;
import org.eclipse.jetty.http.compression.NBitIntegerDecoder;
import org.eclipse.jetty.http.compression.NBitStringDecoder;
import org.eclipse.jetty.http3.qpack.QpackDecoder;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.http3.qpack.internal.QpackContext;
import org.eclipse.jetty.http3.qpack.internal.metadata.MetaDataBuilder;
import org.eclipse.jetty.util.BufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodedFieldSection {
    private static final Logger LOG = LoggerFactory.getLogger(EncodedFieldSection.class);
    private final NBitIntegerDecoder _integerDecoder = new NBitIntegerDecoder();
    private final NBitStringDecoder _stringDecoder = new NBitStringDecoder();
    private final List<EncodedField> _encodedFields = new ArrayList<EncodedField>();
    private final long _streamId;
    private final int _requiredInsertCount;
    private final int _base;
    private final QpackDecoder.Handler _handler;
    private final long _beginNanoTime;

    public EncodedFieldSection(long streamId, QpackDecoder.Handler handler, int requiredInsertCount, int base, ByteBuffer content, long beginNanoTime) throws QpackException {
        this._streamId = streamId;
        this._requiredInsertCount = requiredInsertCount;
        this._base = base;
        this._handler = handler;
        this._beginNanoTime = beginNanoTime;
        try {
            while (content.hasRemaining()) {
                byte firstByte = content.get(content.position());
                EncodedField encodedField = (firstByte & 0x80) != 0 ? this.parseIndexedField(content) : ((firstByte & 0x40) != 0 ? this.parseNameReference(content) : ((firstByte & 0x20) != 0 ? this.parseLiteralField(content) : ((firstByte & 0x10) != 0 ? this.parseIndexedFieldPostBase(content) : this.parseNameReferencePostBase(content))));
                this._encodedFields.add(encodedField);
            }
        }
        catch (EncodingException e) {
            throw new QpackException.SessionException(512L, e.getMessage(), e);
        }
    }

    public long getStreamId() {
        return this._streamId;
    }

    public QpackDecoder.Handler getHandler() {
        return this._handler;
    }

    public int getRequiredInsertCount() {
        return this._requiredInsertCount;
    }

    public MetaData decode(QpackContext context, int maxHeaderSize) throws QpackException {
        if (context.getDynamicTable().getInsertCount() < this._requiredInsertCount) {
            throw new IllegalStateException("Required Insert Count Not Reached");
        }
        MetaDataBuilder metaDataBuilder = new MetaDataBuilder(maxHeaderSize);
        for (EncodedField encodedField : this._encodedFields) {
            HttpField decodedField = encodedField.decode(context);
            metaDataBuilder.emit(decodedField);
        }
        metaDataBuilder.setBeginNanoTime(this._beginNanoTime);
        return metaDataBuilder.build();
    }

    private EncodedField parseIndexedField(ByteBuffer buffer) throws EncodingException {
        byte firstByte = buffer.get(buffer.position());
        boolean dynamicTable = (firstByte & 0x40) == 0;
        this._integerDecoder.setPrefix(6);
        int index = this._integerDecoder.decodeInt(buffer);
        if (index < 0) {
            throw new EncodingException("invalid_index");
        }
        return new IndexedField(dynamicTable, index);
    }

    private EncodedField parseIndexedFieldPostBase(ByteBuffer buffer) throws EncodingException {
        this._integerDecoder.setPrefix(4);
        int index = this._integerDecoder.decodeInt(buffer);
        if (index < 0) {
            throw new EncodingException("Invalid Index");
        }
        return new PostBaseIndexedField(index);
    }

    private EncodedField parseNameReference(ByteBuffer buffer) throws EncodingException {
        byte firstByte;
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseLiteralFieldLineWithNameReference: " + BufferUtil.toDetailString((ByteBuffer)buffer));
        }
        boolean allowEncoding = ((firstByte = buffer.get(buffer.position())) & 0x20) != 0;
        boolean dynamicTable = (firstByte & 0x10) == 0;
        this._integerDecoder.setPrefix(4);
        int nameIndex = this._integerDecoder.decodeInt(buffer);
        if (nameIndex < 0) {
            throw new EncodingException("invalid_name_index");
        }
        this._stringDecoder.setPrefix(8);
        String value = this._stringDecoder.decode(buffer);
        if (value == null) {
            throw new EncodingException("incomplete_value");
        }
        return new IndexedNameField(allowEncoding, dynamicTable, nameIndex, value);
    }

    private EncodedField parseNameReferencePostBase(ByteBuffer buffer) throws EncodingException {
        byte firstByte = buffer.get(buffer.position());
        boolean allowEncoding = (firstByte & 8) != 0;
        this._integerDecoder.setPrefix(3);
        int nameIndex = this._integerDecoder.decodeInt(buffer);
        if (nameIndex < 0) {
            throw new EncodingException("invalid_index");
        }
        this._stringDecoder.setPrefix(8);
        String value = this._stringDecoder.decode(buffer);
        if (value == null) {
            throw new EncodingException("invalid_value");
        }
        return new PostBaseIndexedNameField(allowEncoding, nameIndex, value);
    }

    private EncodedField parseLiteralField(ByteBuffer buffer) throws EncodingException {
        byte firstByte = buffer.get(buffer.position());
        boolean allowEncoding = (firstByte & 0x10) != 0;
        this._stringDecoder.setPrefix(4);
        String name = this._stringDecoder.decode(buffer);
        if (name == null) {
            throw new EncodingException("invalid_name");
        }
        this._stringDecoder.setPrefix(8);
        String value = this._stringDecoder.decode(buffer);
        if (value == null) {
            throw new EncodingException("invalid_value");
        }
        return new LiteralField(allowEncoding, name, value);
    }

    public static interface EncodedField {
        public HttpField decode(QpackContext var1);
    }

    private class IndexedField
    implements EncodedField {
        private final boolean _dynamicTable;
        private final int _index;

        public IndexedField(boolean dynamicTable, int index) {
            this._dynamicTable = dynamicTable;
            this._index = index;
        }

        @Override
        public HttpField decode(QpackContext context) {
            if (this._dynamicTable) {
                return context.getDynamicTable().getRelative(EncodedFieldSection.this._base, this._index).getHttpField();
            }
            return QpackContext.getStaticTable().get(this._index).getHttpField();
        }
    }

    private class PostBaseIndexedField
    implements EncodedField {
        private final int _index;

        public PostBaseIndexedField(int index) {
            this._index = index;
        }

        @Override
        public HttpField decode(QpackContext context) {
            return context.getDynamicTable().getPostBase(EncodedFieldSection.this._base, this._index).getHttpField();
        }
    }

    private class IndexedNameField
    implements EncodedField {
        private final boolean _allowEncoding;
        private final boolean _dynamicTable;
        private final int _nameIndex;
        private final String _value;

        public IndexedNameField(boolean allowEncoding, boolean dynamicTable, int nameIndex, String value) {
            this._allowEncoding = allowEncoding;
            this._dynamicTable = dynamicTable;
            this._nameIndex = nameIndex;
            this._value = value;
        }

        @Override
        public HttpField decode(QpackContext context) {
            HttpField field = this._dynamicTable ? context.getDynamicTable().getRelative(EncodedFieldSection.this._base, this._nameIndex).getHttpField() : QpackContext.getStaticTable().get(this._nameIndex).getHttpField();
            return new HttpField(field.getHeader(), field.getName(), this._value);
        }
    }

    private class PostBaseIndexedNameField
    implements EncodedField {
        private final boolean _allowEncoding;
        private final int _nameIndex;
        private final String _value;

        public PostBaseIndexedNameField(boolean allowEncoding, int nameIndex, String value) {
            this._allowEncoding = allowEncoding;
            this._nameIndex = nameIndex;
            this._value = value;
        }

        @Override
        public HttpField decode(QpackContext context) {
            HttpField field = context.getDynamicTable().getPostBase(EncodedFieldSection.this._base, this._nameIndex).getHttpField();
            return new HttpField(field.getHeader(), field.getName(), this._value);
        }
    }

    private static class LiteralField
    implements EncodedField {
        private final boolean _allowEncoding;
        private final String _name;
        private final String _value;

        public LiteralField(boolean allowEncoding, String name, String value) {
            this._allowEncoding = allowEncoding;
            this._name = name;
            this._value = value;
        }

        @Override
        public HttpField decode(QpackContext context) {
            return new HttpField(this._name, this._value);
        }
    }
}

