/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.i18n;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;

class CombinedEnumeration
implements Enumeration {
    private final Enumeration first;
    private final Enumeration second;
    private final Set seenKeys;
    private Object nextKey;

    CombinedEnumeration(Enumeration first, Enumeration second) {
        this.first = first;
        this.second = second;
        this.seenKeys = new HashSet();
        this.nextKey = this.seek();
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextKey != null;
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        Object result = this.nextKey;
        this.nextKey = this.seek();
        return result;
    }

    private Object seek() {
        Object next;
        while (this.first.hasMoreElements()) {
            next = this.first.nextElement();
            if (this.seenKeys.contains(next)) continue;
            this.seenKeys.add(next);
            return next;
        }
        while (this.second.hasMoreElements()) {
            next = this.second.nextElement();
            if (this.seenKeys.contains(next)) continue;
            this.seenKeys.add(next);
            return next;
        }
        return null;
    }
}

