/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.xel;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.xel.Expression;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.xel.Evaluator;

public class ExValue
implements Serializable {
    private String _value;
    private Class _expected;
    private transient Object _coercedVal = Objects.UNKNOWN;
    private transient Expression _expr;

    public ExValue(String value, Class expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        this._value = value;
        this._expected = expectedType;
    }

    public boolean isExpression() {
        return this._expr == null ? this._value != null && this._value.indexOf("${") >= 0 : this._expr != Expressions.DUMMY_EXPRESSION;
    }

    public final String getRawValue() {
        return this._value;
    }

    public void setRawValue(String value) {
        if (!Objects.equals((Object)value, (Object)this._value)) {
            this._value = value;
            this._expr = null;
            this._coercedVal = Objects.UNKNOWN;
        }
    }

    public final Class getExpectedType() {
        return this._expected;
    }

    public final void setExpectedType(Class expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException();
        }
        if (this._expected != expectedType) {
            this._expected = expectedType;
            if (this._expr != Expressions.DUMMY_EXPRESSION) {
                this._expr = null;
            }
            this._coercedVal = Objects.UNKNOWN;
        }
    }

    public Object getValue(Evaluator eval, Page page) throws XelException {
        if (this._expr == null) {
            this.init(eval);
        }
        return this._expr == Expressions.DUMMY_EXPRESSION ? this.coerce() : eval.evaluate(page, this._expr);
    }

    public Object getValue(Evaluator eval, Component comp) throws XelException {
        if (this._expr == null) {
            this.init(eval);
        }
        return this._expr == Expressions.DUMMY_EXPRESSION ? this.coerce() : eval.evaluate(comp, this._expr);
    }

    private Object coerce() {
        if (this._coercedVal == Objects.UNKNOWN) {
            this._coercedVal = Classes.coerce((Class)this._expected, (Object)this._value);
        }
        return this._coercedVal;
    }

    private void init(Evaluator eval) throws XelException {
        this._expr = this._value != null && this._value.indexOf("${") >= 0 ? eval.parseExpression(this._value, this._expected) : Expressions.DUMMY_EXPRESSION;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._coercedVal = Objects.UNKNOWN;
    }

    public String toString() {
        return this._value;
    }

    public int hashCode() {
        return Objects.hashCode((Object)this._value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExValue) {
            ExValue val = (ExValue)o;
            return Objects.equals((Object)val._value, (Object)this._value) && Objects.equals((Object)val._expected, (Object)this._expected);
        }
        return false;
    }
}

