/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import org.zkoss.io.Serializables;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.EventInterceptor;

public class EventInterceptors
implements Cloneable,
Serializable {
    private transient EventInterceptor[] _eis;

    public void addEventInterceptor(EventInterceptor ei) {
        if (ei == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<EventInterceptor> eilst = new LinkedList<EventInterceptor>();
        EventInterceptor[] eis = this._eis;
        if (eis != null) {
            for (int j = 0; j < eis.length; ++j) {
                eilst.add(eis[j]);
            }
        }
        eilst.add(ei);
        this._eis = eilst.toArray(new EventInterceptor[eilst.size()]);
    }

    public boolean removeEventInterceptor(EventInterceptor ei) {
        if (ei != null && this._eis != null) {
            LinkedList<EventInterceptor> eilst = new LinkedList<EventInterceptor>();
            EventInterceptor[] eis = this._eis;
            boolean found = false;
            for (int j = 0; j < eis.length; ++j) {
                if (!found && eis[j].equals(ei)) {
                    found = true;
                    continue;
                }
                eilst.add(eis[j]);
            }
            if (found) {
                int sz = eilst.size();
                this._eis = sz == 0 ? null : eilst.toArray(new EventInterceptor[sz]);
                return true;
            }
        }
        return false;
    }

    public boolean removeEventInterceptor(Class klass) {
        if (klass != null && this._eis != null) {
            LinkedList<EventInterceptor> eilst = new LinkedList<EventInterceptor>();
            EventInterceptor[] eis = this._eis;
            boolean found = false;
            for (int j = 0; j < eis.length; ++j) {
                if (!found && klass.isInstance(eis[j])) {
                    found = true;
                    continue;
                }
                eilst.add(eis[j]);
            }
            if (found) {
                int sz = eilst.size();
                this._eis = sz == 0 ? null : eilst.toArray(new EventInterceptor[sz]);
                return true;
            }
        }
        return false;
    }

    public Event beforeSendEvent(Event event) {
        EventInterceptor[] eis = this._eis;
        if (eis != null) {
            for (int j = 0; j < eis.length; ++j) {
                if ((event = eis[j].beforeSendEvent(event)) != null) continue;
                return null;
            }
        }
        return event;
    }

    public Event beforePostEvent(Event event) {
        EventInterceptor[] eis = this._eis;
        if (eis != null) {
            for (int j = 0; j < eis.length; ++j) {
                if ((event = eis[j].beforePostEvent(event)) != null) continue;
                return null;
            }
        }
        return event;
    }

    public Event beforeProcessEvent(Event event) {
        EventInterceptor[] eis = this._eis;
        if (eis != null) {
            for (int j = 0; j < eis.length; ++j) {
                if ((event = eis[j].beforeProcessEvent(event)) != null) continue;
                return null;
            }
        }
        return event;
    }

    public void afterProcessEvent(Event event) {
        EventInterceptor[] eis = this._eis;
        if (eis != null) {
            for (int j = 0; j < eis.length; ++j) {
                eis[j].afterProcessEvent(event);
            }
        }
    }

    public Object clone() {
        EventInterceptors clone;
        try {
            clone = (EventInterceptors)super.clone();
            if (clone._eis != null) {
                clone._eis = (EventInterceptor[])clone._eis.clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, (Object[])this._eis);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Collection eilst = Serializables.smartRead((ObjectInputStream)s, (Collection)null);
        if (eilst != null) {
            this._eis = eilst.toArray(new EventInterceptor[eilst.size()]);
        }
    }
}

