/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.hssf.record.cont.ContinuableRecord;
import org.zkoss.poi.hssf.record.cont.ContinuableRecordOutput;
import org.zkoss.poi.util.HexDump;

public final class ThemeRecord
extends ContinuableRecord {
    public static final int DEFAULT_THEME = 124226;
    private FtrHeader futureHeader;
    private int version;
    private byte[] _themedata;
    public static final short sid = 2198;

    public ThemeRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2198);
        this.setVersion(124226);
    }

    public ThemeRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        this.version = in.readInt();
        if (this.version == 0) {
            this._themedata = in.readRemainder();
        }
    }

    @Override
    public short getSid() {
        return 2198;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getThemeData() {
        return this._themedata;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[THEME]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .version    = ").append(Integer.toString(this.version)).append("\n");
        buffer.append("    .themeData  = ");
        if (this.version == 0) {
            buffer.append(HexDump.toHex(this._themedata)).append("\n");
        } else {
            buffer.append("(n/a)\n");
        }
        buffer.append("[/THEME]\n");
        return buffer.toString();
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected void serialize(ContinuableRecordOutput out) {
        this.futureHeader.serialize(out);
        out.writeInt(this.version);
        if (this._themedata != null) {
            out.write(this._themedata);
        }
    }
}

