/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPromotionOperation;
import com.hazelcast.internal.partition.operation.PromotionCommitOperation;
import com.hazelcast.logging.ILogger;

final class BeforePromotionOperation
extends AbstractPromotionOperation {
    private PromotionCommitOperation.PromotionOperationCallback beforePromotionsCallback;

    BeforePromotionOperation() {
        super(null);
    }

    BeforePromotionOperation(MigrationInfo migrationInfo, PromotionCommitOperation.PromotionOperationCallback callback) {
        super(migrationInfo);
        this.beforePromotionsCallback = callback;
    }

    @Override
    public void beforeRun() {
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        PartitionStateManager partitionStateManager = service.getPartitionStateManager();
        if (!partitionStateManager.trySetMigratingFlag(this.getPartitionId())) {
            throw new IllegalStateException("Cannot set migrating flag, probably previous migration's finalization is not completed yet.");
        }
    }

    @Override
    public void run() {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Running before promotion for " + this.getPartitionMigrationEvent());
        }
        PartitionMigrationEvent event = this.getPartitionMigrationEvent();
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.beforeMigration(event);
            }
            catch (Throwable e) {
                logger.warning("While promoting " + this.getPartitionMigrationEvent(), e);
            }
        }
    }

    @Override
    public void afterRun() {
        if (this.beforePromotionsCallback != null) {
            this.beforePromotionsCallback.onComplete(this.migrationInfo);
        }
    }
}

