/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Private_Access;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MPrivateAccess
extends X_AD_Private_Access {
    private static final long serialVersionUID = 1928860386263332639L;
    private static CLogger s_log = CLogger.getCLogger(MPrivateAccess.class);

    public static MPrivateAccess get(Properties ctx, int AD_User_ID, int AD_Table_ID, int Record_ID) {
        return (MPrivateAccess)new Query(ctx, "AD_Private_Access", "AD_User_ID=? AND AD_Table_ID=? AND Record_ID=?", null).setParameters(AD_User_ID, AD_Table_ID, Record_ID).first();
    }

    public static String getLockedRecordWhere(int AD_Table_ID, int AD_User_ID) {
        StringBuilder whereClause = new StringBuilder(" NOT IN (SELECT Record_ID FROM AD_Private_Access WHERE AD_Table_ID=").append(AD_Table_ID).append(" AND AD_User_ID<>").append(AD_User_ID).append(" AND IsActive='Y')");
        return whereClause.toString();
    }

    public MPrivateAccess(Properties ctx, String AD_Private_Access_UU, String trxName) {
        super(ctx, AD_Private_Access_UU, trxName);
    }

    public MPrivateAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MPrivateAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPrivateAccess(Properties ctx, int AD_User_ID, int AD_Table_ID, int Record_ID) {
        super(ctx, 0, null);
        this.setAD_User_ID(AD_User_ID);
        this.setAD_Table_ID(AD_Table_ID);
        this.setRecord_ID(Record_ID);
    }

    @Override
    public String toString() {
        MUser user = MUser.get(this.getAD_User_ID());
        MTable table2 = MTable.get(this.getAD_Table_ID());
        StringBuilder sb = new StringBuilder("Private Access[").append(user.getName()).append(",").append(table2.getName()).append(",").append(this.getRecord_ID()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.canUpdate()) {
            s_log.warning("Denied permission to update AD_Private_Access[" + this.getAD_Private_Access_UU() + "] on session " + Env.getContext(this.p_ctx, "#AD_Session_ID"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (!this.canUpdate()) {
            s_log.warning("Denied permission to delete AD_Private_Access[" + this.getAD_Private_Access_UU() + "] on session " + Env.getContext(this.p_ctx, "#AD_Session_ID"));
            return false;
        }
        return true;
    }

    private boolean canUpdate() {
        if (Env.getAD_User_ID(this.getCtx()) == this.getAD_User_ID()) {
            return true;
        }
        return MRole.getDefault().isPersonalAccess();
    }
}

