/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.calendar.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.zkoss.calendar.api.CalendarEvent;
import org.zkoss.calendar.api.RenderContext;
import org.zkoss.calendar.impl.AbstractCalendarModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCalendarModel
extends AbstractCalendarModel
implements Serializable {
    private static final long serialVersionUID = 20090320175712L;
    protected List<CalendarEvent> _list;

    public SimpleCalendarModel(List<CalendarEvent> list, boolean live) {
        this._list = live ? list : new ArrayList(list);
    }

    public SimpleCalendarModel() {
        this._list = new ArrayList<CalendarEvent>();
    }

    public SimpleCalendarModel(Collection<CalendarEvent> c) {
        this._list = new ArrayList<CalendarEvent>(c);
    }

    public SimpleCalendarModel(CalendarEvent[] array) {
        this._list = Arrays.asList(array);
    }

    public SimpleCalendarModel(int initialCapacity) {
        this._list = new ArrayList<CalendarEvent>(initialCapacity);
    }

    public void add(int index, CalendarEvent e) {
        if (e == null) {
            throw new NullPointerException("CalendarEvent cannot be null!");
        }
        this._list.add(index, e);
        this.fireEvent(1, e);
    }

    public boolean add(CalendarEvent e) {
        if (e == null) {
            throw new NullPointerException("CalendarEvent cannot be null!");
        }
        boolean ret = this._list.add(e);
        this.fireEvent(1, e);
        return ret;
    }

    public boolean update(CalendarEvent e) {
        if (e == null) {
            throw new NullPointerException("CalendarEvent cannot be null!");
        }
        this.fireEvent(0, e);
        boolean ret = this._list.remove(e);
        if (!ret) {
            return ret;
        }
        ret = this._list.add(e);
        return ret;
    }

    public CalendarEvent remove(int index) {
        CalendarEvent ret = this._list.remove(index);
        this.fireEvent(2, ret);
        return ret;
    }

    public int indexOf(CalendarEvent elem) {
        return this._list.indexOf(elem);
    }

    public boolean remove(CalendarEvent e) {
        if (e == null) {
            throw new NullPointerException("CalendarEvent cannot be null!");
        }
        int index = this.indexOf(e);
        if (index >= 0) {
            this.remove(index);
        }
        return false;
    }

    public void clear() {
        if (this._list.isEmpty()) {
            return;
        }
        this._list.clear();
        this.fireEvent(2, null, TimeZone.getDefault());
    }

    public int size() {
        return this._list.size();
    }

    @Override
    public List<CalendarEvent> get(Date beginDate, Date endDate, RenderContext rc) {
        LinkedList<CalendarEvent> list = new LinkedList<CalendarEvent>();
        long begin = beginDate.getTime();
        long end = endDate.getTime();
        for (CalendarEvent ce : this._list) {
            long b = ce.getBeginDate().getTime();
            long e = ce.getEndDate().getTime();
            if (e <= begin || b >= end) continue;
            list.add(ce);
        }
        return list;
    }
}

