/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MProductTest
extends AbstractTestCase {
    private void createPOAndMRForProduct(int productId) {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)productId));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt1 = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt1.setDocStatus("DR");
        receipt1.setDocAction("CO");
        receipt1.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt1);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt1.getDocStatus());
        if (!receipt1.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)receipt1.getAD_Client_ID(), (int)receipt1.get_Table_ID(), (int)receipt1.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertNull((Object)error, (String)error);
        }
    }

    @Test
    public void testIsAndGetMethods() {
        MProduct product = MProduct.get((int)DictionaryIDs.M_Product.TSHIRT_GL.id);
        MAttributeInstance attributeInstance = product.getAttributeInstance("Color (R-G-B)", this.getTrxName());
        Assertions.assertNotNull((Object)attributeInstance);
        Assertions.assertEquals((int)DictionaryIDs.M_Attribute.COLOR.id, (int)attributeInstance.getM_Attribute_ID());
        Assertions.assertEquals((Object)"Green", (Object)attributeInstance.getValue());
        MAcctSchema as = MClient.get((Properties)Env.getCtx()).getAcctSchema();
        String costingLevel = product.getCostingLevel(as);
        Assertions.assertEquals((Object)as.getCostingLevel(), (Object)costingLevel);
        String costingMethod = product.getCostingMethod(as);
        Assertions.assertEquals((Object)as.getCostingMethod(), (Object)costingMethod);
        this.createPOAndMRForProduct(DictionaryIDs.M_Product.MULCH.id);
        product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        MCost mcost = product.getCostingRecord(as, this.getAD_Org_ID(), 0);
        Assertions.assertNotNull((Object)mcost);
        Assertions.assertEquals((int)product.get_ID(), (int)mcost.getM_Product_ID());
        Assertions.assertEquals((Object)mcost.getCostingMethod(), (Object)product.getCostingMethod(as));
        MCost mcost1 = product.getCostingRecord(as, this.getAD_Org_ID(), 0, product.getCostingMethod(as));
        Assertions.assertEquals((Object)mcost.getM_Cost_UU(), (Object)mcost1.getM_Cost_UU());
        product = new MProduct(Env.getCtx(), 0, this.getTrxName());
        product.setC_UOM_ID(DictionaryIDs.C_UOM.HOUR.id);
        product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
        Assertions.assertEquals((int)MUOM.get((int)DictionaryIDs.C_UOM.HOUR.id).getStdPrecision(), (int)product.getUOMPrecision());
        Assertions.assertEquals((Object)MUOM.get((int)DictionaryIDs.C_UOM.HOUR.id).getUOMSymbol(), (Object)product.getUOMSymbol());
        Assertions.assertFalse((boolean)product.isInstanceAttribute());
        product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        Assertions.assertTrue((boolean)product.isInstanceAttribute());
        Assertions.assertFalse((boolean)product.isSerial());
        product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id);
        Assertions.assertTrue((boolean)product.isSerial());
        product.setIsStocked(true);
        product.setProductType("I");
        Assertions.assertTrue((boolean)product.isItem());
        Assertions.assertFalse((boolean)product.isService());
        Assertions.assertTrue((boolean)product.isStocked());
        product.setProductType("S");
        Assertions.assertFalse((boolean)product.isItem());
        Assertions.assertTrue((boolean)product.isService());
        Assertions.assertFalse((boolean)product.isStocked());
        product.setProductType("R");
        Assertions.assertFalse((boolean)product.isItem());
        Assertions.assertTrue((boolean)product.isService());
        Assertions.assertFalse((boolean)product.isStocked());
        MAttributeSet attributeSet = new MAttributeSet(Env.getCtx(), DictionaryIDs.M_AttributeSet.PATIO_CHAIR.id, null);
        String mandatoryType = attributeSet.getMandatoryType();
        try {
            attributeSet.setMandatoryType("N");
            attributeSet.saveEx();
            Assertions.assertFalse((boolean)product.isASIMandatoryFor(null, false));
            Assertions.assertFalse((boolean)product.isASIMandatoryFor(null, true));
            Assertions.assertFalse((boolean)product.isASIMandatoryFor("S", true));
            attributeSet.setMandatoryType("Y");
            attributeSet.saveEx();
            CacheMgt.get().reset("M_AttributeSet", attributeSet.getM_AttributeSet_ID());
            Assertions.assertTrue((boolean)product.isASIMandatoryFor(null, false));
            Assertions.assertTrue((boolean)product.isASIMandatoryFor(null, true));
            Assertions.assertTrue((boolean)product.isASIMandatoryFor("S", true));
            attributeSet.setMandatoryType("S");
            attributeSet.saveEx();
            CacheMgt.get().reset("M_AttributeSet", attributeSet.getM_AttributeSet_ID());
            Assertions.assertFalse((boolean)product.isASIMandatoryFor(null, false));
            Assertions.assertFalse((boolean)product.isASIMandatoryFor(null, true));
            Assertions.assertTrue((boolean)product.isASIMandatoryFor("S", true));
            Assertions.assertFalse((boolean)product.isUseGuaranteeDateForMPolicy());
            attributeSet.setUseGuaranteeDateForMPolicy(true);
            attributeSet.saveEx();
            CacheMgt.get().reset("M_AttributeSet", attributeSet.getM_AttributeSet_ID());
            Assertions.assertTrue((boolean)product.isUseGuaranteeDateForMPolicy());
        }
        finally {
            attributeSet.setMandatoryType(mandatoryType);
            attributeSet.setUseGuaranteeDateForMPolicy(false);
            attributeSet.saveEx();
        }
    }

    @Test
    public void testRemoveStorageRecords() {
        int count = 0;
        MProduct product = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.MULCH.id, this.getTrxName());
        this.createPOAndMRForProduct(product.get_ID());
        Query query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
        count = query.setParameters(new Object[]{product.get_ID()}).count();
        Assertions.assertTrue((count > 0 ? 1 : 0) != 0, (String)"No Storage On Hand Record");
        query = new Query(Env.getCtx(), "M_StorageReservation", "M_Product_ID=?", this.getTrxName());
        count = query.setParameters(new Object[]{product.get_ID()}).count();
        Assertions.assertTrue((count > 0 ? 1 : 0) != 0, (String)"No Storage Reservation Record");
        product.setIsActive(false);
        Assertions.assertThrows(AdempiereException.class, () -> product.saveEx());
        DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET QtyOnHand=0 WHERE M_Product_ID=?", (Object[])new Object[]{product.get_ID()}, (String)this.getTrxName());
        DB.executeUpdateEx((String)"UPDATE M_StorageReservation SET Qty=0 WHERE M_Product_ID=?", (Object[])new Object[]{product.get_ID()}, (String)this.getTrxName());
        product.setIsActive(false);
        product.saveEx();
        query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
        count = query.setParameters(new Object[]{product.get_ID()}).count();
        Assertions.assertEquals((int)0, (int)count, (String)"Storage On Hand Record > 0");
        query = new Query(Env.getCtx(), "M_StorageReservation", "M_Product_ID=?", this.getTrxName());
        count = query.setParameters(new Object[]{product.get_ID()}).count();
        Assertions.assertEquals((int)0, (int)count, (String)"Storage Reservation Record > 0");
    }

    @Test
    public void testDeactivateProductBOMValidation() {
        Query query = new Query(Env.getCtx(), "PP_Product_BOM", "PP_Product_BOM_ID<1000000 AND M_Product_ID NOT IN (SELECT M_Product_ID FROM PP_Product_BOMLine)", this.getTrxName());
        MPPProductBOM bom = (MPPProductBOM)query.setClient_ID().setOnlyActiveRecords(true).first();
        MPPProductBOMLine[] lines = bom.getLines();
        MProduct product = new MProduct(Env.getCtx(), lines[0].getM_Product_ID(), this.getTrxName());
        DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET QtyOnHand=0 WHERE M_Product_ID=?", (Object[])new Object[]{product.get_ID()}, (String)this.getTrxName());
        product.setIsActive(false);
        Assertions.assertThrows(AdempiereException.class, () -> product.saveEx(), (String)"No exception throw for deactivation of product in active BOM");
        MProduct parent = new MProduct(Env.getCtx(), bom.getM_Product_ID(), this.getTrxName());
        DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET QtyOnHand=0 WHERE M_Product_ID=?", (Object[])new Object[]{parent.get_ID()}, (String)this.getTrxName());
        parent.setIsActive(false);
        parent.saveEx();
        bom.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)bom.isActive(), (String)"BOM not auto deactivated after deactivation of parent product");
    }
}

