/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.lang.reflect.Constructor;
import java.util.List;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.factory.DefaultAnnotationBasedFormFactory;
import org.adempiere.webui.factory.IFormFactory;
import org.compiere.model.MForm;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormTest
extends AbstractTestCase {
    @Test
    public void testCoreFormMapping() {
        DefaultAnnotationBasedFormFactory formFactory = null;
        List factories = Service.locator().list(IFormFactory.class).getServiceReferences();
        if (factories != null) {
            for (IServiceReferenceHolder factory : factories) {
                IFormFactory service = (IFormFactory)factory.getService();
                if (service == null || !(service instanceof DefaultAnnotationBasedFormFactory)) continue;
                formFactory = (DefaultAnnotationBasedFormFactory)service;
                break;
            }
        }
        Assertions.assertNotNull(formFactory, (String)"Failed to locate DefaultAnnotationBasedFormFactory");
        Query query = new Query(Env.getCtx(), "AD_Form", "AD_Form_ID < 1000000 AND ClassName IS NOT NULL  AND EXISTS (select 1 from ad_menu where isactive='Y' and ad_form_id=ad_form.ad_form_id)", this.getTrxName());
        List forms = query.setOnlyActiveRecords(true).list();
        for (MForm form : forms) {
            Constructor constructor = formFactory.getConstructor(form.getClassname());
            Assertions.assertNotNull((Object)constructor, (String)("Failed to find class for " + form.toString() + ", " + form.getClassname()));
        }
    }
}

