/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFromInvoice;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFromInvoiceFormTest
extends AbstractTestCase {
    @Test
    public void testCreateFromPurchaseOrder() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.HOLLY_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        invoice.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.AP_INVOICE.id);
        invoice.setIsSOTrx(false);
        invoice.setSalesRep_ID(order.getSalesRep_ID());
        invoice.setC_Currency_ID(order.getC_Currency_ID());
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocAction("CO");
        invoice.setDocStatus("DR");
        invoice.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)183);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Invoice (Vendor)");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_Invoice");
        query.addRestriction("C_Invoice_ID", "=", invoice.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)invoice.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        CreateFromInvoiceImpl form = new CreateFromInvoiceImpl(gridTab);
        form.setTrxName(this.getTrxName());
        ArrayList<KeyNamePair> POs = form.getOrders(order.getC_BPartner_ID());
        Assertions.assertNotNull(POs, (String)"Can't load POs for BP");
        Assertions.assertTrue((POs.size() > 0 ? 1 : 0) != 0, (String)"Can't load POs for BP");
        boolean found = false;
        for (KeyNamePair knp : POs) {
            if (knp.getKey() != order.get_ID()) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)"Fail to load PO");
        form.loadOrderLines(order.get_ID());
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 5);
            if (pp.getKey() == line1.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find order line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        invoice.load(this.getTrxName(), new String[0]);
        MInvoiceLine[] lines = invoice.getLines(true);
        Assertions.assertEquals((int)1, (int)lines.length, (String)"Unexpected number of invoice lines ");
        Assertions.assertEquals((int)lines[0].getM_Product_ID(), (int)line1.getM_Product_ID());
        Assertions.assertEquals((Object)lines[0].getQtyInvoiced().setScale(2, RoundingMode.HALF_UP), (Object)line1.getQtyOrdered().setScale(2, RoundingMode.HALF_UP));
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
    }

    @Test
    public void testCreateFromMaterialReceipt() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.HOLLY_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine1 = new MInOutLine(receipt);
        receiptLine1.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine1.setQty(new BigDecimal("1"));
        receiptLine1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        invoice.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.AP_INVOICE.id);
        invoice.setIsSOTrx(false);
        invoice.setSalesRep_ID(order.getSalesRep_ID());
        invoice.setC_Currency_ID(order.getC_Currency_ID());
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocAction("CO");
        invoice.setDocStatus("DR");
        invoice.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)183);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Invoice (Vendor)");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_Invoice");
        query.addRestriction("C_Invoice_ID", "=", invoice.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)invoice.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        CreateFromInvoiceImpl form = new CreateFromInvoiceImpl(gridTab);
        form.setTrxName(this.getTrxName());
        ArrayList<KeyNamePair> MRs = form.getShipments(order.getC_BPartner_ID());
        Assertions.assertNotNull(MRs, (String)"Can't load MRs for BP");
        Assertions.assertTrue((MRs.size() > 0 ? 1 : 0) != 0, (String)"Can't load MRs for BP");
        boolean found = false;
        for (KeyNamePair knp : MRs) {
            if (knp.getKey() != receipt.get_ID()) continue;
            found = true;
            break;
        }
        Assertions.assertTrue((boolean)found, (String)"Fail to load MR");
        form.loadShipmentLines(receipt.get_ID());
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 6);
            if (pp.getKey() == receiptLine1.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find receipt line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        invoice.load(this.getTrxName(), new String[0]);
        MInvoiceLine[] lines = invoice.getLines(true);
        Assertions.assertEquals((int)1, (int)lines.length, (String)"Unexpected number of invoice lines ");
        Assertions.assertEquals((int)lines[0].getM_Product_ID(), (int)line1.getM_Product_ID());
        Assertions.assertEquals((Object)lines[0].getQtyInvoiced().setScale(2, RoundingMode.HALF_UP), (Object)line1.getQtyOrdered().setScale(2, RoundingMode.HALF_UP));
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
    }

    private static class CreateFromInvoiceImpl
    extends CreateFromInvoice {
        private MiniTableImpl minitable = null;

        public CreateFromInvoiceImpl(GridTab mTab) {
            super(mTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object getWindow() {
            return this;
        }

        protected boolean dynInit() throws Exception {
            super.dynInit();
            this.minitable = new MiniTableImpl();
            for (String column : this.getOISColumnNames()) {
                this.minitable.addColumn(column);
            }
            this.configureMiniTable((IMiniTable)this.minitable);
            return true;
        }

        public ArrayList<KeyNamePair> getOrders(int C_BPartner_ID) {
            return super.loadOrderData(C_BPartner_ID, true, true, false);
        }

        public void loadOrderLines(int C_Order_ID) {
            Vector datas = super.getOrderData(C_Order_ID, true, false);
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }

        public ArrayList<KeyNamePair> getShipments(int C_BPartner_ID) {
            return super.loadShipmentData(C_BPartner_ID);
        }

        public void loadShipmentLines(int M_InOut_ID) {
            Vector datas = super.getShipmentData(M_InOut_ID);
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

