/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPayment;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MStorageReservationLog;
import org.compiere.model.MTax;
import org.compiere.model.MTransaction;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class SalesOrderTest
extends AbstractTestCase {
    @Test
    public void testDatePromisedValidation() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        MOrderLine line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id));
        line2.setQty(new BigDecimal("1"));
        line2.setDatePromised(TimeUtil.addDays((Timestamp)today, (int)1));
        line2.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertTrue((boolean)info.isError());
        Assertions.assertEquals((Object)"IN", (Object)order.getDocStatus());
        this.rollback();
        order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDatePromised(today);
        order.saveEx();
        line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id));
        line2.setQty(new BigDecimal("1"));
        line2.setDatePromised(today);
        line2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        this.rollback();
        order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("A");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDatePromised(today);
        order.saveEx();
        line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.OAK.id));
        line2.setQty(new BigDecimal("1"));
        line2.setDatePromised(TimeUtil.addDays((Timestamp)today, (int)1));
        line2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        this.rollback();
    }

    @Test
    public void testQtyReservedForOverAndNegativeShipment() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("2"));
        shipmentLine.setQty(new BigDecimal("2"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("-1"));
        shipmentLine.setQty(new BigDecimal("-1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
    }

    @Test
    public void testQtyReservedForNegativeOrderAndShipment() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("-1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("-1"));
        shipmentLine.setQty(new BigDecimal("-1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
    }

    @Test
    public void testOnCreditPOSOrder() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MBPartner bpartner = new MBPartner(ctx, DictionaryIDs.C_BPartner.JOE_BLOCK.id, trxName);
        BigDecimal initialBalance = bpartner.getTotalOpenBalance();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("WR");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("P");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyInvoiced().intValue());
        MInOut[] shipments = order.getShipments();
        Assertions.assertEquals((int)1, (int)shipments.length);
        Assertions.assertEquals((Object)"CO", (Object)shipments[0].getDocStatus());
        MInvoice[] invoices = order.getInvoices();
        Assertions.assertEquals((int)1, (int)invoices.length);
        Assertions.assertEquals((Object)"CO", (Object)invoices[0].getDocStatus());
        bpartner.load(trxName, new String[0]);
        BigDecimal actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance.add(order.getGrandTotal())) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCashPOSOrder() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MBPartner bpartner = new MBPartner(ctx, DictionaryIDs.C_BPartner.JOE_BLOCK.id, trxName);
        BigDecimal initialBalance = bpartner.getTotalOpenBalance();
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("WR");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("B");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyInvoiced().intValue());
        MInOut[] shipments = order.getShipments();
        Assertions.assertEquals((int)1, (int)shipments.length);
        Assertions.assertEquals((Object)"CO", (Object)shipments[0].getDocStatus());
        MInvoice[] invoices = order.getInvoices();
        Assertions.assertEquals((int)1, (int)invoices.length);
        Assertions.assertEquals((Object)"CO", (Object)invoices[0].getDocStatus());
        Assertions.assertEquals((Object)true, (Object)invoices[0].isPaid(), (String)"Invoice is not paid");
        MAllocationHdr[] allocs = MAllocationHdr.getOfInvoice((Properties)ctx, (int)invoices[0].getC_Invoice_ID(), (String)trxName);
        Assertions.assertEquals((int)1, (int)allocs.length);
        Assertions.assertEquals((Object)"CO", (Object)allocs[0].getDocStatus());
        int paymentId = allocs[0].getLines(false)[0].getC_Payment_ID();
        MPayment payment = new MPayment(ctx, paymentId, trxName);
        Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus());
        Assertions.assertEquals((Object)true, (Object)payment.isAllocated(), (String)"Payment is not allocated");
        bpartner.load(trxName, new String[0]);
        BigDecimal actualBalance = bpartner.getTotalOpenBalance();
        Assertions.assertTrue((actualBalance.compareTo(initialBalance) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGenerateShipmentDeliveryRule() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        int AD_Process_ID = 199;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order.getC_Order_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        order.getLines();
        this.rollback();
        MOrder order1 = MOrder.copyFrom((MOrder)order, (Timestamp)today, (int)order.getC_DocType_ID(), (boolean)true, (boolean)false, (boolean)false, (String)this.getTrxName());
        order1.setDeliveryRule("R");
        order1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order1, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order1.getDocStatus());
        line1 = order1.getLines()[0];
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order1.getC_Order_ID()}, null);
        pi = new ProcessInfo("InOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)0, (int)line1.getQtyDelivered().intValue());
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_DocType_ID(true);
        int C_BankAccount_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)"select c_bankaccount_id from c_bankaccount where ad_client_id=? and isdefault='Y'", (Object[])new Object[]{this.getAD_Client_ID()});
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_BPartner_ID(order1.getC_BPartner_ID());
        payment.setC_Order_ID(order1.getC_Order_ID());
        payment.setTenderType("A");
        payment.setPayAmt(order1.getGrandTotal());
        payment.setC_Currency_ID(order1.getC_Currency_ID());
        payment.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        payment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus());
        instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order1.getC_Order_ID()}, null);
        pi = new ProcessInfo("InOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
        MOrder order2 = MOrder.copyFrom((MOrder)order, (Timestamp)today, (int)order.getC_DocType_ID(), (boolean)true, (boolean)false, (boolean)false, (String)this.getTrxName());
        order2.setDeliveryRule("R");
        order2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order2, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order2.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order2.getDocStatus());
        line1 = order2.getLines()[0];
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        instance = new MPInstance(Env.getCtx(), 134, 0, 0, null);
        instance.saveEx();
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order2.getC_Order_ID()}, null);
        pi = new ProcessInfo("InvoiceGenerateManual", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyInvoiced().intValue());
        payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_DocType_ID(true);
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_BPartner_ID(order2.getC_BPartner_ID());
        payment.setC_Invoice_ID(DB.getSQLValueEx((String)this.getTrxName(), (String)"SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=?", (Object[])new Object[]{order2.getC_Order_ID()}));
        payment.setTenderType("A");
        payment.setPayAmt(order2.getGrandTotal());
        payment.setC_Currency_ID(order2.getC_Currency_ID());
        payment.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        payment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus());
        instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order2.getC_Order_ID()}, null);
        pi = new ProcessInfo("InOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyDelivered().intValue());
    }

    @Test
    public void testMultiASIShipment() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        MProduct fert50 = new MProduct(ctx, DictionaryIDs.M_Product.FERTILIZER_50.id, trxName);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        Timestamp past_month = TimeUtil.addMonths((Timestamp)today, (int)-1);
        MWarehouse wh = new MWarehouse(ctx, DictionaryIDs.M_Warehouse.FERTILIZER.id, trxName);
        wh.setIsDisallowNegativeInv(true);
        wh.saveEx();
        CacheMgt.get().reset("M_Warehouse", DictionaryIDs.M_Warehouse.FERTILIZER.id);
        MWarehouse.get((Properties)ctx, (int)DictionaryIDs.M_Warehouse.FERTILIZER.id, (String)trxName);
        MAttributeSetInstance asi = new MAttributeSetInstance(ctx, 0, trxName);
        asi.setM_AttributeSet_ID(fert50.getM_AttributeSet_ID());
        asi.setLot("1010");
        asi.saveEx();
        MStorageOnHand.add((Properties)ctx, (int)DictionaryIDs.M_Locator.FERTILIZER.id, (int)DictionaryIDs.M_Product.FERTILIZER_50.id, (int)asi.getM_AttributeSetInstance_ID(), (BigDecimal)Env.ONE, (Timestamp)past_month, (String)trxName);
        MStorageOnHand.add((Properties)ctx, (int)DictionaryIDs.M_Locator.FERTILIZER.id, (int)DictionaryIDs.M_Product.FERTILIZER_50.id, (int)asi.getM_AttributeSetInstance_ID(), (BigDecimal)Env.ONE, (Timestamp)today, (String)trxName);
        MStorageOnHand[] storages = MStorageOnHand.getWarehouse((Properties)ctx, (int)DictionaryIDs.M_Warehouse.FERTILIZER.id, (int)DictionaryIDs.M_Product.FERTILIZER_50.id, (int)asi.getM_AttributeSetInstance_ID(), null, (boolean)"F".equals(fert50.getMMPolicy()), (boolean)false, (int)0, (String)trxName);
        Assertions.assertEquals((int)2, (int)storages.length);
        int i = 0;
        while (i < storages.length) {
            MStorageOnHand storage = storages[i];
            Assertions.assertEquals((int)1, (int)storage.getQtyOnHand().intValue());
            if (i == 0) {
                Assertions.assertEquals((Object)past_month, (Object)storage.getDateMaterialPolicy());
            } else {
                Assertions.assertEquals((Object)today, (Object)storage.getDateMaterialPolicy());
            }
            ++i;
        }
        MOrder order = new MOrder(ctx, 0, trxName);
        order.setAD_Org_ID(DictionaryIDs.AD_Org.FERTILIZER.id);
        order.setBPartner(MBPartner.get((Properties)ctx, (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.FERTILIZER.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setPaymentRule("P");
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)ctx, (int)DictionaryIDs.M_Product.FERTILIZER_50.id));
        line1.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        line1.setQty(new BigDecimal("2"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(trxName, new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        int AD_Process_ID = 199;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order.getC_Order_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "CO");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", DictionaryIDs.M_Warehouse.FERTILIZER.id);
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        line1.load(trxName, new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)2, (int)line1.getQtyDelivered().intValue());
        storages = MStorageOnHand.getWarehouse((Properties)ctx, (int)DictionaryIDs.M_Warehouse.FERTILIZER.id, (int)DictionaryIDs.M_Product.FERTILIZER_50.id, (int)asi.getM_AttributeSetInstance_ID(), null, (boolean)"F".equals(fert50.getMMPolicy()), (boolean)false, (int)0, (String)trxName);
        Assertions.assertEquals((int)0, (int)storages.length);
        Query query = new Query(Env.getCtx(), "M_InOut", "C_Order_ID=?", this.getTrxName());
        MInOut inout = (MInOut)query.setParameters(new Object[]{order.get_ID()}).first();
        Assertions.assertNotNull((Object)inout, (String)"Can't find shipment for order");
        MInOutLine[] ilines = inout.getLines();
        Assertions.assertTrue((ilines.length == 1 ? 1 : 0) != 0, (String)("Shipment doesn't has 1 line as expected: " + ilines.length));
        Assertions.assertEquals((int)line1.get_ID(), (int)ilines[0].getC_OrderLine_ID(), (String)"Shipment line doesn't has the expected order line ID");
        Assertions.assertEquals((Object)line1.getQtyOrdered(), (Object)ilines[0].getMovementQty(), (String)"Shipment line doesn't has the expected movement quantity");
        Assertions.assertEquals((int)line1.getM_Product_ID(), (int)ilines[0].getM_Product_ID(), (String)"Shipment line doesn't has the expected product ID");
        Assertions.assertEquals((int)line1.getM_AttributeSetInstance_ID(), (int)ilines[0].getM_AttributeSetInstance_ID(), (String)"Shipment line doesn't has the expected ASI ID");
        Assertions.assertEquals((int)DictionaryIDs.M_Locator.FERTILIZER.id, (int)ilines[0].getM_Locator_ID(), (String)"Shipment line doesn't has the expected Locator ID");
    }

    @Test
    public void testUOMDefault() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.MARY.id));
        line1.setQty(new BigDecimal("1"));
        line1.saveEx();
        Assertions.assertEquals((int)DictionaryIDs.C_UOM.HOUR.id, (int)line1.getC_UOM_ID());
        MOrderLine line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setDescription("This is a description order line with no product nor charge");
        line2.saveEx();
        Assertions.assertEquals((int)MUOM.getDefault_UOM_ID((Properties)Env.getCtx()), (int)line2.getC_UOM_ID());
    }

    @Test
    public void testQtyReservedLog() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Query query = new Query(Env.getCtx(), "M_StorageReservationLog", "M_Product_ID=? AND IsSOTrx='Y' AND M_Warehouse_ID=?", this.getTrxName());
        MStorageReservationLog log = (MStorageReservationLog)query.setOrderBy("M_StorageReservationLog_ID Desc").setParameters(new Object[]{DictionaryIDs.M_Product.AZALEA_BUSH.id, line1.getM_Warehouse_ID()}).first();
        Assertions.assertNotNull((Object)log, (String)"MStorageReservationLog not created after completion of sales order");
        Assertions.assertTrue((log.getDeltaQty().intValue() == 1 ? 1 : 0) != 0, (String)("Delta quantity of MStorageReservationLog != 1 (" + log.getDeltaQty().toPlainString() + ")"));
        MStorageReservation reservation = MStorageReservation.get((Properties)Env.getCtx(), (int)line1.getM_Warehouse_ID(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id, (int)0, (boolean)true, (String)this.getTrxName());
        Assertions.assertTrue((boolean)log.getNewQty().equals(reservation.getQty()), (String)"New Qty from MStorageReservationLog != Qty from MStorageReservation");
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        log = (MStorageReservationLog)query.first();
        Assertions.assertNotNull((Object)log, (String)"MStorageReservationLog not created after completion of shipment");
        Assertions.assertTrue((log.getDeltaQty().intValue() == -1 ? 1 : 0) != 0, (String)("Delta quantity of MStorageReservationLog != -1 (" + log.getDeltaQty().toPlainString() + ")"));
        reservation = MStorageReservation.get((Properties)Env.getCtx(), (int)line1.getM_Warehouse_ID(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id, (int)0, (boolean)true, (String)this.getTrxName());
        Assertions.assertTrue((boolean)log.getNewQty().equals(reservation.getQty()), (String)"New Qty from MStorageReservationLog != Qty from MStorageReservation");
    }

    @Test
    public void testQtyLostSales() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("2"));
        shipmentLine.setQty(new BigDecimal("2"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CL");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CL", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)0, (int)line1.getQtyLostSales().intValue());
        order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("2"));
        line1.setDatePromised(today);
        line1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)2, (int)line1.getQtyReserved().intValue());
        shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CL");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CL", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertEquals((int)1, (int)line1.getQtyLostSales().intValue());
        Assertions.assertEquals((int)line1.getQtyDelivered().intValue(), (int)line1.getQtyOrdered().intValue());
    }

    @Test
    public void testWarehouseChange() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDocStatus("DR");
        order.setDocAction("PR");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQT.id);
        boolean success = order.save();
        Assertions.assertEquals((Object)true, (Object)success);
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"PR");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
        success = order.save();
        Assertions.assertEquals((Object)false, (Object)success);
    }

    @Test
    public void testSetASIWhenShipping() {
        MStorageOnHand[] storages;
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected Order document status");
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue(), (String)"Unexpected order line qty reserved value");
        int originalOnHand = MStorageOnHand.getQtyOnHandWithASIZero((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (String)this.getTrxName()).intValue();
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        MAttributeSetInstance asi = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
        asi.setM_AttributeSet_ID(MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id).getM_AttributeSet_ID());
        asi.setSerNo("PChair Serial #1000000");
        asi.saveEx();
        shipmentLine.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected Shipment document status");
        int newOnHand = MStorageOnHand.getQtyOnHandWithASIZero((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(originalOnHand - 1), (int)newOnHand, (String)"Unexpected on hand quantity");
        int asiOnHand = MStorageOnHand.getQtyOnHand((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (int)asi.get_ID(), (String)this.getTrxName()).intValue();
        int asiRecords = 0;
        MStorageOnHand[] mStorageOnHandArray = storages = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id, (String)this.getTrxName());
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            MStorageOnHand storage = mStorageOnHandArray[n2];
            if (storage.getM_Warehouse_ID() == this.getM_Warehouse_ID() && storage.getM_AttributeSetInstance_ID() == asi.get_ID()) {
                ++asiRecords;
            }
            ++n2;
        }
        Assertions.assertEquals((int)0, (int)asiOnHand, (String)"Unexpected on hand quantity for Serial ASI");
        Assertions.assertEquals((int)1, (int)asiRecords, (String)"Unexpected number of Serial ASI Storage records");
        Query query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=0", this.getTrxName());
        MTransaction trxFrom = (MTransaction)query.setParameters(new Object[]{shipmentLine.get_ID(), shipmentLine.getM_Product_ID()}).first();
        Assertions.assertNotNull((Object)trxFrom, (String)"Can't find MTransaction record for no ASI MTransaction record");
        Assertions.assertEquals((int)-1, (int)trxFrom.getMovementQty().intValue(), (String)"Unexpected movement qty for no ASI MTransaction record");
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
        List asiTrxs = query.setParameters(new Object[]{shipmentLine.get_ID(), shipmentLine.getM_Product_ID(), shipmentLine.getM_AttributeSetInstance_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)asiTrxs.size(), (String)"Unexpected number of records for ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)asiTrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected movement qty for first ASI MTransaction record");
        Assertions.assertEquals((int)-1, (int)((MTransaction)asiTrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected movement qty for second ASI MTransaction record");
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
        shipment.load(this.getTrxName(), new String[0]);
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"RE", (Object)shipment.getDocStatus(), (String)"Unexpected Shipment document status");
        newOnHand = MStorageOnHand.getQtyOnHandWithASIZero((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)originalOnHand, (int)newOnHand, (String)"Unexpected on hand quantity no ASI");
        asiOnHand = MStorageOnHand.getQtyOnHand((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (int)asi.get_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)0, (int)asiOnHand, (String)"Unexpected on hand quantity for Serial ASI");
        MStorageOnHand[] mStorageOnHandArray2 = storages = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id, (String)this.getTrxName());
        int n3 = storages.length;
        int n4 = 0;
        while (n4 < n3) {
            MStorageOnHand storage = mStorageOnHandArray2[n4];
            if (storage.getM_Warehouse_ID() == this.getM_Warehouse_ID() && storage.getM_AttributeSetInstance_ID() == asi.get_ID()) {
                Assertions.assertEquals((int)0, (int)storage.getQtyOnHand().intValue(), (String)("Unexpected qty on hand for asi: " + storage.toString()));
            }
            ++n4;
        }
        MInOut reversal = new MInOut(Env.getCtx(), shipment.getReversal_ID(), this.getTrxName());
        MInOutLine[] reversalLines = reversal.getLines();
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=0", this.getTrxName());
        List noASITrxs = query.setParameters(new Object[]{reversalLines[0].get_ID(), reversalLines[0].getM_Product_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)1, (int)noASITrxs.size(), (String)"Unexpected number of records for reversal no ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)noASITrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for no ASI MTransaction record");
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
        asiTrxs = query.setParameters(new Object[]{reversalLines[0].get_ID(), reversalLines[0].getM_Product_ID(), reversalLines[0].getM_AttributeSetInstance_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)asiTrxs.size(), (String)"Unexpected number of records for reversal ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)asiTrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for first ASI MTransaction record");
        Assertions.assertEquals((int)-1, (int)((MTransaction)asiTrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for second ASI MTransaction record");
    }

    @Test
    public void testSetASIWhenShipping2() {
        MStorageOnHand storage;
        MStorageOnHand storage2;
        MStorageOnHand[] storages;
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id));
        line1.setQty(new BigDecimal("2"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected Order document status");
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)2, (int)line1.getQtyReserved().intValue(), (String)"Unexpected order line qty reserved value");
        int originalOnHand = MStorageOnHand.getQtyOnHandWithASIZero((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (String)this.getTrxName()).intValue();
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("2"));
        shipmentLine.setQty(new BigDecimal("2"));
        shipmentLine.saveEx();
        MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
        asi1.setM_AttributeSet_ID(MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id).getM_AttributeSet_ID());
        asi1.setSerNo("PChair Serial #1000000");
        asi1.saveEx();
        MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
        asi2.setM_AttributeSet_ID(MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id).getM_AttributeSet_ID());
        asi2.setSerNo("PChair Serial #1000000");
        asi2.saveEx();
        MInOutLineMA ma1 = new MInOutLineMA(Env.getCtx(), 0, this.getTrxName());
        ma1.setM_AttributeSetInstance_ID(asi1.get_ID());
        ma1.setM_InOutLine_ID(shipmentLine.get_ID());
        ma1.setDateMaterialPolicy(shipment.getMovementDate());
        ma1.setMovementQty(new BigDecimal("1"));
        ma1.setIsAutoGenerated(false);
        ma1.saveEx();
        MInOutLineMA ma2 = new MInOutLineMA(Env.getCtx(), 0, this.getTrxName());
        ma2.setM_AttributeSetInstance_ID(asi2.get_ID());
        ma2.setM_InOutLine_ID(shipmentLine.get_ID());
        ma2.setDateMaterialPolicy(shipment.getMovementDate());
        ma2.setMovementQty(new BigDecimal("1"));
        ma2.setIsAutoGenerated(false);
        ma2.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus(), (String)"Unexpected Shipment document status");
        int newOnHand = MStorageOnHand.getQtyOnHandWithASIZero((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(originalOnHand - 2), (int)newOnHand, (String)"Unexpected on hand quantity");
        int asiOnHand = MStorageOnHand.getQtyOnHand((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (int)asi1.get_ID(), (String)this.getTrxName()).intValue();
        int asiRecords = 0;
        MStorageOnHand[] mStorageOnHandArray = storages = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id, (String)this.getTrxName());
        int n = storages.length;
        int n2 = 0;
        while (n2 < n) {
            storage2 = mStorageOnHandArray[n2];
            if (storage2.getM_Warehouse_ID() == this.getM_Warehouse_ID() && storage2.getM_AttributeSetInstance_ID() == asi1.get_ID()) {
                ++asiRecords;
            }
            ++n2;
        }
        Assertions.assertEquals((int)0, (int)asiOnHand, (String)"Unexpected on hand quantity for Serial ASI 1");
        Assertions.assertEquals((int)1, (int)asiRecords, (String)"Unexpected number of Serial ASI 1 Storage records");
        asiOnHand = MStorageOnHand.getQtyOnHand((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (int)asi2.get_ID(), (String)this.getTrxName()).intValue();
        asiRecords = 0;
        mStorageOnHandArray = storages = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id, (String)this.getTrxName());
        n = storages.length;
        n2 = 0;
        while (n2 < n) {
            storage2 = mStorageOnHandArray[n2];
            if (storage2.getM_Warehouse_ID() == this.getM_Warehouse_ID() && storage2.getM_AttributeSetInstance_ID() == asi2.get_ID()) {
                ++asiRecords;
            }
            ++n2;
        }
        Assertions.assertEquals((int)0, (int)asiOnHand, (String)"Unexpected on hand quantity for Serial ASI 2");
        Assertions.assertEquals((int)1, (int)asiRecords, (String)"Unexpected number of Serial ASI 2 Storage records");
        Query query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=0", this.getTrxName());
        MTransaction trxFrom = (MTransaction)query.setParameters(new Object[]{shipmentLine.get_ID(), shipmentLine.getM_Product_ID()}).first();
        Assertions.assertNotNull((Object)trxFrom, (String)"Can't find MTransaction record for no ASI MTransaction record");
        Assertions.assertEquals((int)-1, (int)trxFrom.getMovementQty().intValue(), (String)"Unexpected movement qty for no ASI MTransaction record");
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
        List asiTrxs = query.setParameters(new Object[]{shipmentLine.get_ID(), shipmentLine.getM_Product_ID(), ma1.getM_AttributeSetInstance_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)asiTrxs.size(), (String)"Unexpected number of records for ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)asiTrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected movement qty for first ASI 1 MTransaction record");
        Assertions.assertEquals((int)-1, (int)((MTransaction)asiTrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected movement qty for second ASI 1 MTransaction record");
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
        asiTrxs = query.setParameters(new Object[]{shipmentLine.get_ID(), shipmentLine.getM_Product_ID(), ma2.getM_AttributeSetInstance_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)asiTrxs.size(), (String)"Unexpected number of records for ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)asiTrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected movement qty for first ASI 2 MTransaction record");
        Assertions.assertEquals((int)-1, (int)((MTransaction)asiTrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected movement qty for second ASI 2 MTransaction record");
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        Env.setContext((Properties)Env.getCtx(), (String)"#Date", (Timestamp)tomorrow);
        shipment.load(this.getTrxName(), new String[0]);
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"RE", (Object)shipment.getDocStatus(), (String)"Unexpected Shipment document status");
        newOnHand = MStorageOnHand.getQtyOnHandWithASIZero((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)originalOnHand, (int)newOnHand, (String)"Unexpected on hand quantity no ASI");
        asiOnHand = MStorageOnHand.getQtyOnHand((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (int)asi1.get_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)0, (int)asiOnHand, (String)"Unexpected on hand quantity for Serial ASI 1");
        MStorageOnHand[] mStorageOnHandArray2 = storages = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id, (String)this.getTrxName());
        int n3 = storages.length;
        int n4 = 0;
        while (n4 < n3) {
            storage = mStorageOnHandArray2[n4];
            if (storage.getM_Warehouse_ID() == this.getM_Warehouse_ID() && storage.getM_AttributeSetInstance_ID() == asi1.get_ID()) {
                Assertions.assertEquals((int)0, (int)storage.getQtyOnHand().intValue(), (String)("Unexpected qty on hand for asi 1: " + storage.toString()));
            }
            ++n4;
        }
        asiOnHand = MStorageOnHand.getQtyOnHand((int)DictionaryIDs.M_Product.P_CHAIR.id, (int)this.getM_Warehouse_ID(), (int)asi2.get_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)0, (int)asiOnHand, (String)"Unexpected on hand quantity for Serial ASI 2");
        mStorageOnHandArray2 = storages = MStorageOnHand.getOfProduct((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.P_CHAIR.id, (String)this.getTrxName());
        n3 = storages.length;
        n4 = 0;
        while (n4 < n3) {
            storage = mStorageOnHandArray2[n4];
            if (storage.getM_Warehouse_ID() == this.getM_Warehouse_ID() && storage.getM_AttributeSetInstance_ID() == asi2.get_ID()) {
                Assertions.assertEquals((int)0, (int)storage.getQtyOnHand().intValue(), (String)("Unexpected qty on hand for asi 2: " + storage.toString()));
            }
            ++n4;
        }
        MInOut reversal = new MInOut(Env.getCtx(), shipment.getReversal_ID(), this.getTrxName());
        MInOutLine[] reversalLines = reversal.getLines();
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=0", this.getTrxName());
        List noASITrxs = query.setParameters(new Object[]{reversalLines[0].get_ID(), reversalLines[0].getM_Product_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)noASITrxs.size(), (String)"Unexpected number of records for reversal no ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)noASITrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for no ASI MTransaction record");
        Assertions.assertEquals((int)1, (int)((MTransaction)noASITrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for no ASI MTransaction record");
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
        asiTrxs = query.setParameters(new Object[]{reversalLines[0].get_ID(), reversalLines[0].getM_Product_ID(), asi1.getM_AttributeSetInstance_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)asiTrxs.size(), (String)"Unexpected number of records for reversal ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)asiTrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for first ASI 1 MTransaction record");
        Assertions.assertEquals((int)-1, (int)((MTransaction)asiTrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for second ASI 1 MTransaction record");
        query = new Query(Env.getCtx(), "M_Transaction", "M_InOutLine_ID=? AND M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
        asiTrxs = query.setParameters(new Object[]{reversalLines[0].get_ID(), reversalLines[0].getM_Product_ID(), asi2.getM_AttributeSetInstance_ID()}).setOrderBy("M_Transaction_ID").list();
        Assertions.assertEquals((int)2, (int)asiTrxs.size(), (String)"Unexpected number of records for reversal ASI MTransaction");
        Assertions.assertEquals((int)1, (int)((MTransaction)asiTrxs.get(0)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for first ASI 2 MTransaction record");
        Assertions.assertEquals((int)-1, (int)((MTransaction)asiTrxs.get(1)).getMovementQty().intValue(), (String)"Unexpected reversal movement qty for second ASI 2 MTransaction record");
    }

    @Test
    public void testShipmentDateMaterialPolicy() {
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        Timestamp tomorrow = TimeUtil.addDays((Timestamp)today, (int)1);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MProduct fert = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.FERTILIZER_50.id);
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(fert);
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Order not completed");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine.setQty(new BigDecimal("1"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"PR");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"IP", (Object)receipt.getDocStatus());
        receiptLine.load(this.getTrxName(), new String[0]);
        MInOutLineMA ma = new MInOutLineMA(Env.getCtx(), 0, this.getTrxName());
        ma.setM_InOutLine_ID(receiptLine.get_ID());
        ma.setIsAutoGenerated(false);
        MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
        asi1.setM_AttributeSet_ID(fert.getM_AttributeSet_ID());
        String lot1 = UUID.randomUUID().toString();
        asi1.setLot(lot1);
        asi1.saveEx();
        ma.setM_AttributeSetInstance_ID(asi1.get_ID());
        ma.setMovementQty(new BigDecimal("1"));
        ma.saveEx();
        Assertions.assertEquals((Object)receipt.getMovementDate(), (Object)ma.getDateMaterialPolicy());
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateOrdered(tomorrow);
        order.setDatePromised(tomorrow);
        order.saveEx();
        line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(fert);
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(tomorrow);
        line1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Order not completed");
        receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(line1, 0, new BigDecimal("1"));
        receiptLine.setQty(new BigDecimal("1"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"PR");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"IP", (Object)receipt.getDocStatus());
        receiptLine.load(this.getTrxName(), new String[0]);
        ma = new MInOutLineMA(Env.getCtx(), 0, this.getTrxName());
        ma.setM_InOutLine_ID(receiptLine.get_ID());
        ma.setIsAutoGenerated(false);
        MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
        asi2.setM_AttributeSet_ID(fert.getM_AttributeSet_ID());
        String lot2 = UUID.randomUUID().toString();
        asi2.setLot(lot2);
        asi2.saveEx();
        ma.setM_AttributeSetInstance_ID(asi2.get_ID());
        ma.setMovementQty(new BigDecimal("1"));
        ma.saveEx();
        Assertions.assertEquals((Object)receipt.getMovementDate(), (Object)ma.getDateMaterialPolicy());
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        int onHand1 = MStorageOnHand.getQtyOnHand((int)fert.get_ID(), (int)this.getM_Warehouse_ID(), (int)asi1.get_ID(), (String)this.getTrxName()).intValue();
        int onHand2 = MStorageOnHand.getQtyOnHand((int)fert.get_ID(), (int)this.getM_Warehouse_ID(), (int)asi2.get_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)onHand1, (int)onHand2);
        Assertions.assertEquals((int)1, (int)onHand1);
        order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(fert);
        line1.setQty(new BigDecimal("2"));
        line1.setDatePromised(today);
        line1.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)2, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, DictionaryIDs.C_DocType.MM_SHIPMENT.id, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("PR");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("2"));
        shipmentLine.setQty(new BigDecimal("2"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"PR");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"IP", (Object)shipment.getDocStatus());
        shipmentLine.load(this.getTrxName(), new String[0]);
        ma = new MInOutLineMA(Env.getCtx(), 0, this.getTrxName());
        ma.setM_InOutLine_ID(shipmentLine.get_ID());
        ma.setIsAutoGenerated(false);
        ma.setM_AttributeSetInstance_ID(asi1.get_ID());
        ma.setMovementQty(new BigDecimal("1"));
        ma.saveEx();
        Assertions.assertEquals((Object)today, (Object)ma.getDateMaterialPolicy());
        ma = new MInOutLineMA(Env.getCtx(), 0, this.getTrxName());
        ma.setM_InOutLine_ID(shipmentLine.get_ID());
        ma.setIsAutoGenerated(false);
        ma.setM_AttributeSetInstance_ID(asi2.get_ID());
        ma.setMovementQty(new BigDecimal("1"));
        ma.saveEx();
        Assertions.assertEquals((Object)tomorrow, (Object)ma.getDateMaterialPolicy());
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        onHand1 = MStorageOnHand.getQtyOnHand((int)fert.get_ID(), (int)this.getM_Warehouse_ID(), (int)asi1.get_ID(), (String)this.getTrxName()).intValue();
        onHand2 = MStorageOnHand.getQtyOnHand((int)fert.get_ID(), (int)this.getM_Warehouse_ID(), (int)asi2.get_ID(), (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)onHand1, (int)onHand2);
        Assertions.assertEquals((int)0, (int)onHand1);
    }

    @Test
    public void testOrderWithParentTax() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.MULCH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.setC_Tax_ID(DictionaryIDs.C_Tax.GST_PST.id);
        line1.saveEx();
        MTax tax = new MTax(Env.getCtx(), line1.getC_Tax_ID(), null);
        MTax[] childs = tax.getChildTaxes(true);
        MOrderTax[] orderTaxes = order.getTaxes(true);
        Assertions.assertEquals((int)childs.length, (int)orderTaxes.length, (String)"Unexpected number of MOrderTax records");
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus(), (String)"Unexpected Order document status");
        orderTaxes = order.getTaxes(true);
        Assertions.assertEquals((int)childs.length, (int)orderTaxes.length, (String)"Unexpected number of MOrderTax records");
        int match = 0;
        MOrderTax[] mOrderTaxArray = orderTaxes;
        int n = orderTaxes.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderTax orderTax = mOrderTaxArray[n2];
            MTax[] mTaxArray = childs;
            int n3 = childs.length;
            int n4 = 0;
            while (n4 < n3) {
                MTax c = mTaxArray[n4];
                if (c.getC_Tax_ID() == orderTax.getC_Tax_ID()) {
                    ++match;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        Assertions.assertEquals((int)orderTaxes.length, (int)match, (String)"MOrdexTax record doesn't match child tax records");
    }

    @Test
    public void testGenerateShipmentCompleteMultiSameLine() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        BigDecimal qtyOnHandMinusOne = MStorageOnHand.getQtyOnHandForShipping((int)DictionaryIDs.M_Product.AZALEA_BUSH.id, (int)order.getM_Warehouse_ID(), (int)0, (String)this.getTrxName());
        if (qtyOnHandMinusOne.signum() > 0) {
            qtyOnHandMinusOne = qtyOnHandMinusOne.subtract(Env.ONE);
        }
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(qtyOnHandMinusOne);
        line1.setDatePromised(today);
        line1.saveEx();
        MOrderLine line2 = new MOrderLine(order);
        line2.setLine(20);
        line2.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line2.setQty(qtyOnHandMinusOne);
        line2.setDatePromised(today);
        line2.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        int AD_Process_ID = 199;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0, 0, null);
        instance.saveEx();
        String insert = "INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) Values (?, ?)";
        DB.executeUpdateEx((String)insert, (Object[])new Object[]{instance.getAD_PInstance_ID(), order.getC_Order_ID()}, null);
        ProcessInfo pi = new ProcessInfo("InOutGen", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("DocAction", "PR");
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("M_Warehouse_ID", this.getM_Warehouse_ID());
        ip.saveEx();
        ServerProcessCtl processCtl = new ServerProcessCtl(pi, this.getTrx());
        processCtl.setManagedTrxForJavaProcess(false);
        processCtl.run();
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
    }

    @Test
    public void testCreditCheckOrder() {
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id, (String)this.getTrxName());
        bp.setSOCreditStatus("H");
        bp.saveEx();
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setM_Warehouse_ID(DictionaryIDs.AD_Org.HQ.id);
        order.setBPartner(bp);
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("A");
        order.setM_Warehouse_ID(DictionaryIDs.M_Warehouse.HQ.id);
        order.setDocStatus("DR");
        order.setDocAction("PR");
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        order.load(this.getTrxName(), new String[0]);
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"PR");
        Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IN", (Object)order.getDocStatus());
        bp.setSOCreditStatus("S");
        bp.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"PR");
        Assertions.assertTrue((boolean)info.isError(), (String)info.getSummary());
        Assertions.assertEquals((Object)"IN", (Object)order.getDocStatus());
    }

    @Test
    public void testPrepayOrderAutoGenerate() {
        MDocType doctype = null;
        Boolean isAutoGenerateInout_old = null;
        Boolean isAutoGenerateInvoice_old = null;
        try {
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setC_DocTypeTarget_ID("PR");
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setDeliveryRule("O");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id));
            line1.setQty(Env.ONE);
            line1.setDatePromised(today);
            line1.saveEx();
            doctype = new MDocType(Env.getCtx(), order.getC_DocTypeTarget_ID(), null);
            isAutoGenerateInout_old = doctype.isAutoGenerateInout();
            isAutoGenerateInvoice_old = doctype.isAutoGenerateInvoice();
            doctype.setIsAutoGenerateInout(true);
            doctype.setIsAutoGenerateInvoice(true);
            doctype.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"WP", (Object)order.getDocStatus());
            order.saveEx();
            MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment.setC_Order_ID(order.getC_Order_ID());
            payment.setC_BPartner_ID(order.getC_BPartner_ID());
            payment.setPayAmt(order.getGrandTotal());
            payment.setC_Currency_ID(order.getC_Currency_ID());
            payment.setDocAction("CO");
            payment.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
            payment.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            payment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus());
            MInOut[] shipments = order.getShipments();
            Assertions.assertTrue((shipments.length > 0 ? 1 : 0) != 0, (String)"No shipment was generated");
            MInvoice[] invoices = order.getInvoices();
            Assertions.assertTrue((invoices.length > 0 ? 1 : 0) != 0, (String)"No invoice was generated");
            Assertions.assertEquals((Object)true, (Object)invoices[0].isPaid(), (String)"Invoice is not paid");
            MAllocationHdr[] allocs = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoices[0].getC_Invoice_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)allocs.length);
            Assertions.assertEquals((Object)"CO", (Object)allocs[0].getDocStatus());
            Assertions.assertEquals((Object)true, (Object)payment.isAllocated(), (String)"Payment is not allocated");
        }
        finally {
            if (doctype != null && isAutoGenerateInout_old != null && isAutoGenerateInvoice_old != null) {
                doctype.setIsAutoGenerateInout(isAutoGenerateInout_old.booleanValue());
                doctype.setIsAutoGenerateInvoice(isAutoGenerateInvoice_old.booleanValue());
                doctype.saveEx();
            }
        }
    }

    @Test
    public void testPrepayOrderAllocateFromOrder() {
        MDocType doctype = null;
        Boolean isAutoGenerateInout_old = null;
        Boolean isAutoGenerateInvoice_old = null;
        try {
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setC_DocTypeTarget_ID("PR");
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setDeliveryRule("O");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.setDateOrdered(today);
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(product);
            line1.setQty(Env.ONE);
            line1.setDatePromised(today);
            line1.saveEx();
            doctype = new MDocType(Env.getCtx(), order.getC_DocTypeTarget_ID(), null);
            doctype.setIsAutoGenerateInout(false);
            doctype.setIsAutoGenerateInvoice(false);
            doctype.saveEx();
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"WP", (Object)order.getDocStatus());
            order.saveEx();
            MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
            payment.setC_Order_ID(order.getC_Order_ID());
            payment.setC_BPartner_ID(order.getC_BPartner_ID());
            payment.setPayAmt(order.getGrandTotal());
            payment.setC_Currency_ID(order.getC_Currency_ID());
            payment.setDocAction("CO");
            payment.setC_BankAccount_ID(DictionaryIDs.C_BankAccount.ACCOUNT_1234.id);
            payment.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            payment.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus());
            payment.saveEx();
            MInvoice[] invoices = order.getInvoices();
            Assertions.assertTrue((invoices.length == 0 ? 1 : 0) != 0, (String)"Invoice already exists");
            MInOut[] shipments = order.getShipments();
            Assertions.assertTrue((shipments.length == 0 ? 1 : 0) != 0, (String)"Shipment already exists");
            MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
            invoice.setOrder(order);
            invoice.setDateAcct(order.getDateOrdered());
            invoice.setSalesRep_ID(order.getSalesRep_ID());
            invoice.setC_BPartner_ID(order.getBill_BPartner_ID());
            invoice.setC_BPartner_Location_ID(order.getBill_Location_ID());
            invoice.setAD_User_ID(order.getBill_User_ID());
            invoice.setC_DocTypeTarget_ID("ARI");
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setC_OrderLine_ID(line1.get_ID());
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(Env.ONE);
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            Assertions.assertEquals((Object)true, (Object)invoice.isPaid(), (String)"Invoice is not paid");
            MAllocationHdr[] allocs = MAllocationHdr.getOfInvoice((Properties)Env.getCtx(), (int)invoice.getC_Invoice_ID(), (String)this.getTrxName());
            Assertions.assertEquals((int)1, (int)allocs.length);
            Assertions.assertEquals((Object)"CO", (Object)allocs[0].getDocStatus());
        }
        finally {
            if (doctype != null && isAutoGenerateInout_old != null && isAutoGenerateInvoice_old != null) {
                doctype.setIsAutoGenerateInout(isAutoGenerateInout_old.booleanValue());
                doctype.setIsAutoGenerateInvoice(isAutoGenerateInvoice_old.booleanValue());
                doctype.saveEx();
            }
        }
    }
}

