/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:
        
    Description:
        
    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/tab/Tab.ts":
/*!******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/tab/Tab.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TabRenderer = exports.Tab = void 0;
/* Tab.ts

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:32:51 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
// ZK-886, called by unbind_ and rerender
// this._oldId used in tab.js
// this.$n() will be cleared during rerender
// but LinkedPanel.firstChild will not,
// the condition LinkedPanel.firstChild != this.$n()
// will get the wrong result
// delete it later for the invalidate() case
function _logId(wgt) {
  if (!wgt._oldId) {
    wgt._oldId = wgt.uuid;
    setTimeout(function () {
      delete wgt._oldId;
    }, 0);
  }
}
/**
 * A tab.
 * @defaultValue {@link getZclass}: z-tab.
 */
var Tab = /** @class */function (_super) {
  __extends(Tab, _super);
  function Tab() {
    var _this = _super.call(this) || this; // FIXME: params?
    _this.listen({
      onClose: _this
    }, -1000);
    return _this;
  }
  /**
   * @returns whether this tab is closable. If closable, a button is displayed
   * and the onClose event is sent if an user clicks the button.
   * @defaultValue `false`.
   */
  Tab.prototype.isClosable = function () {
    return !!this._closable;
  };
  /**
   * Sets whether this tab is closable. If closable, a button is displayed and
   * the onClose event is sent if an user clicks the button.
   * @defaultValue `false`.
   */
  Tab.prototype.setClosable = function (closable, opts) {
    var o = this._closable;
    this._closable = closable;
    if (o !== closable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  Tab.prototype.getImage = function () {
    return this._image;
  };
  Tab.prototype.setImage = function (image, opts) {
    var o = this._image;
    this._image = image;
    if (o !== image || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (image && this._preloadImage) zUtl.loadImage(image);
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether this tab is disabled.
   * @defaultValue `false`.
   */
  Tab.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether this tab is disabled. If a tab is disabled, then it cann't
   * be selected or closed by user, but it still can be controlled by server
   * side program.
   */
  Tab.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether this tab is selected.
   */
  Tab.prototype.isSelected = function () {
    var tabbox = this.getTabbox();
    return (tabbox === null || tabbox === void 0 ? void 0 : tabbox.getSelectedTab()) == this;
  };
  /**
   * Sets whether this tab is selected.
   */
  Tab.prototype.setSelected = function (selected, fromServer) {
    var tabbox = this.getTabbox();
    if (tabbox && selected) {
      tabbox.setSelectedTab(this, fromServer);
    }
    return this;
  };
  /**
   * @returns the tabbox owns this component.
   */
  Tab.prototype.getTabbox = function () {
    return this.parent ? this.parent.parent : undefined;
  };
  /**
   * @returns the index of this panel, or -1 if it doesn't belong to any tabs.
   */
  Tab.prototype.getIndex = function () {
    return this.getChildIndex();
  };
  /**
   * @returns the panel associated with this tab.
   */
  Tab.prototype.getLinkedPanel = function () {
    var _a, _b;
    return (_b = (_a = this.getTabbox()) === null || _a === void 0 ? void 0 : _a.getTabpanels()) === null || _b === void 0 ? void 0 : _b.getChildAt(this.getIndex());
  };
  /** @internal */
  Tab.prototype._doCloseClick = function (evt) {
    if (!this._disabled) {
      this.fire('onClose');
      evt.stop();
    }
  };
  /** @internal */
  Tab.prototype._sel = function (toSel, notify) {
    var _a, _b, _c;
    var tabbox = this.getTabbox();
    /* ZK-1441
     * If tabbox is animating (end-user click different tabs quickly), ignore this action.
     */
    if (!tabbox || tabbox._animating) return;
    var panel = this.getLinkedPanel(),
      inAccordion = tabbox.inAccordionMold();
    if (toSel) {
      var ps = tabbox.tabpanels;
      if (ps) {
        if (ps._selPnl && ps._selPnl != panel) ps._selPnl._sel(false, inAccordion);
        ps._selPnl = panel; //stored in tabpanels
      }
      tabbox._selTab = this;
    }
    if (!this.desktop) return;
    if (toSel) jq(this).addClass(this.$s('selected'));else jq(this).removeClass(this.$s('selected'));
    if (panel === null || panel === void 0 ? void 0 : panel.isVisible())
      //Bug ZK-1618: not show tabpanel if visible is false
      panel._sel(toSel, true);
    if (!inAccordion) {
      (_a = this.parent) === null || _a === void 0 ? void 0 : _a._fixWidth(toSel); //ZK-2810: don't set height to tabbox when deselect
    }
    if (toSel) {
      if (tabbox.isVertical()) (_b = this.parent) === null || _b === void 0 ? void 0 : _b._scrollcheck('vsel', this);else if (!tabbox.inAccordionMold()) (_c = this.parent) === null || _c === void 0 ? void 0 : _c._scrollcheck('sel', this);
    }
    if (notify) this.fire('onSelect', {
      items: [this],
      reference: this
    });
  };
  Tab.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) {
      this._calcHgh();
      zUtl.fireSized(this.parent);
    }
    return this;
  };
  Tab.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop) zUtl.fireSized(this.parent);
    return this;
  };
  /** @internal */
  Tab.prototype._calcHgh = function () {
    var _a;
    var tabbox = this.getTabbox();
    if (!tabbox.isVertical()) {
      var r = tabbox.$n('right'),
        l = tabbox.$n('left'),
        tb = (_a = tabbox.toolbar) === null || _a === void 0 ? void 0 : _a.$n(),
        tabs = tabbox.tabs.$n(),
        hgh = jq.px0(tabs ? tabs.offsetHeight : 0);
      if (r && l) {
        r.style.height = l.style.height = hgh;
      }
      if (tb) {
        tb.style.height = hgh;
      }
    }
  };
  //protected
  /** @internal */
  Tab.prototype.doClick_ = function (evt, popupOnly) {
    var _a;
    if (this._disabled) return;
    /* ZK-1441
     * If tabbox is animating (end-user click different tabs quickly), ignore this action.
     */
    if ((_a = this.getTabbox()) === null || _a === void 0 ? void 0 : _a._animating) return;
    this.setSelected(true);
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  Tab.prototype.domClass_ = function (no) {
    var sclsHTML = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      if (this.isDisabled()) sclsHTML += ' ' + this.$s('disabled');
      if (this.isSelected()) sclsHTML += ' ' + this.$s('selected');
    }
    return sclsHTML;
  };
  /** @internal */
  Tab.prototype.domContent_ = function () {
    var label = zUtl.encodeXML(this.getLabel()),
      img = this.getImage();
    var /*safe*/iconSclass = this.domIcon_();
    if (!label) label = '&nbsp;';
    if (!img && !iconSclass) return label;
    if (!img) {
      img = iconSclass;
    } else /*safe*/img = '<img src="' + /*safe*/img + '" class="' + this.$s('image') + '" alt="" aria-hidden="true"/>' + (iconSclass ? ' ' + /*safe*/iconSclass : '');
    return DOMPurify.sanitize(label ? img + ' ' + label : img);
  };
  //bug #3014664
  Tab.prototype.setVflex = function (vflex) {
    if (vflex != 'min') vflex = false;
    return _super.prototype.setVflex.call(this, vflex);
  };
  //bug #3014664
  Tab.prototype.setHflex = function (hflex) {
    if (hflex != 'min') hflex = false;
    return _super.prototype.setHflex.call(this, hflex);
  };
  /** @internal */
  Tab.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var closebtn = this.isClosable() ? this.$n('cls') : undefined;
    if (closebtn) {
      this.domListen_(closebtn, 'onClick', '_doCloseClick');
    }
    if (this.getHeight()) this._calcHgh();
    //ZK-3016 make sure parent always do scrollCheck on child bind
    this.parent._shallCheck = true;
  };
  /** @internal */
  Tab.prototype.unbind_ = function (skipper, after, keepRod) {
    var closebtn = this.$n('cls');
    // ZK-886
    _logId(this);
    if (closebtn) {
      this.domUnlisten_(closebtn, 'onClick', '_doCloseClick');
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  //event handler//
  Tab.prototype.onClose = function () {
    if (this.getTabbox().inAccordionMold()) {
      this.getTabbox()._syncSize();
    }
  };
  /** @internal */
  Tab.prototype.deferRedrawHTML_ = function (out) {
    var tag = this.getTabbox().inAccordionMold() ? 'div' : 'li';
    out.push("<".concat(tag, " ").concat(this.domAttrs_({
      domClass: true
    }), " class=\"z-renderdefer\"></").concat(tag, ">"));
  };
  Tab.prototype.rerender = function (skipper) {
    // ZK-886
    if (this.desktop) _logId(this);
    _super.prototype.rerender.call(this, skipper);
    return this;
  };
  /** @internal */
  Tab.prototype.contentRenderer_ = function (out) {
    out.push("<span id=\"".concat(this.uuid, "-cnt\" class=\"").concat(this.$s('text'), "\">"), this.domContent_(), '</span>');
  };
  Tab = __decorate([zk.WrapClass('zul.tab.Tab')], Tab);
  return Tab;
}(zul.LabelImageWidget);
exports.Tab = Tab;
/** @class zul.tab.TabRenderer
 * The renderer used to render a Tab.
 * It is designed to be overriden
 * @since 5.0.5
 */
exports.TabRenderer = {
  /**
   * Check the Tab whether to render the frame
   */
  isFrameRequired: function () {
    return false;
  }
};
zul.tab.TabRenderer = exports.TabRenderer;
if (!window.zul) window.zul = {};
if (!window.zul.tab) window.zul.tab = {};
if (!window.zul.tab.Tab) window.zul.tab.Tab = {};
window.zul.tab.Tab._ = {
  _logId: _logId,
  Tab: Tab
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/tab/Tabbox.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/tab/Tabbox.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Tabbox.ts

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:32:34 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
/** The tabbox related widgets, such as tabbox and tabpanel.
 */
//zk.$package('zul.tab');
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Tabbox = void 0;
// TabboxSkipper is only used in this file. No need to export TabboxSkipper.
var TabboxSkipper = /** @class */function (_super) {
  __extends(TabboxSkipper, _super);
  function TabboxSkipper(skipper) {
    var _this = _super.call(this) || this;
    _this.skipper = skipper;
    return _this;
  }
  TabboxSkipper.prototype.skipped = function (wgt, child) {
    var _a;
    return wgt.toolbar === child && wgt.getMold() !== 'default' || !!((_a = this.skipper) === null || _a === void 0 ? void 0 : _a.skipped(wgt, child));
  };
  return TabboxSkipper;
}(zk.Skipper);
/**
 * A tabbox.
 *
 * <p>
 * Event:
 * <ol>
 * <li>onSelect is sent when user changes the tab.</li>
 * </ol>
 *
 * <p>
 * Mold:
 * <dl>
 * <dt>default</dt>
 * <dd>The default tabbox.</dd>
 * <dt>accordion</dt>
 * <dd>The accordion tabbox.</dd>
 * </dl>
 *
 * <p>{@link Toolbar} only works in the horizontal default mold and
 * the {@link isTabscroll} to be true.
 *
 * @defaultValue {@link getZclass}: z-tabbox.
 * @import zul.wgt.Toolbar
 */
var Tabbox = /** @class */function (_super) {
  __extends(Tabbox, _super);
  function Tabbox() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._orient = 'top';
    /** @internal */
    _this._tabscroll = true;
    /** @internal */
    _this._maximalHeight = false;
    /* ZK-1441
     * Reference: doClick_() in Tab.js, _sel() in Tabpanel.js
     */
    /** @internal */
    _this._animating = false;
    /** @internal */
    _this._nativebar = true;
    return _this;
  }
  /**
   * @returns whether the tab scrolling is enabled.
   * @defaultValue `true`.
   */
  Tabbox.prototype.isTabscroll = function () {
    return this._tabscroll;
  };
  /**
   * Sets whether to eable the tab scrolling
   */
  Tabbox.prototype.setTabscroll = function (tabscroll, opts) {
    var o = this._tabscroll;
    this._tabscroll = tabscroll;
    if (o !== tabscroll || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the orient.
   * @defaultValue `"top"`.
   * <p>
   * Note: only the default mold supports it (not supported if accordion).
   */
  Tabbox.prototype.getOrient = function () {
    return this._orient;
  };
  /**
   * Sets the orient.
   *
   * @param orient - either "top", "left", "bottom or "right".
   * @since 7.0.0 "horizontal" is renamed to "top" and "vertical" is renamed to "left".
   */
  Tabbox.prototype.setOrient = function (orient, opts) {
    var o = this._orient;
    this._orient = orient;
    if (o !== orient || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (orient == 'horizontal') this._orient = 'top';else if (orient == 'vertical') this._orient = 'left';
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether to use maximum height of all tabpanel in initial phase or not.
   * @defaultValue `false`.
   * @since 7.0.0
   */
  Tabbox.prototype.isMaximalHeight = function () {
    return this._maximalHeight;
  };
  /**
   * Sets whether to use maximum height of all tabpanel in initial phase or not.
   * <p>
   * The Client ROD feature will be disabled if it is set to true.
   * @since 7.0.0
   */
  Tabbox.prototype.setMaximalHeight = function (maximalHeight, opts) {
    var o = this._maximalHeight;
    this._maximalHeight = maximalHeight;
    if (o !== maximalHeight || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the spacing between {@link Tabpanel}. This is used by certain
   * molds, such as accordion.
   * @defaultValue `null` (no spacing).
   */
  Tabbox.prototype.getPanelSpacing = function () {
    return this._panelSpacing;
  };
  /**
   * Sets the spacing between {@link Tabpanel}. This is used by certain molds,
   * such as accordion.
   */
  Tabbox.prototype.setPanelSpacing = function (panelSpacing, opts) {
    var o = this._panelSpacing;
    this._panelSpacing = panelSpacing;
    if (o !== panelSpacing || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the tabs that this tabbox owns.
   */
  Tabbox.prototype.getTabs = function () {
    return this.tabs;
  };
  /**
   * @returns the tabpanels that this tabbox owns.
   */
  Tabbox.prototype.getTabpanels = function () {
    return this.tabpanels;
  };
  /**
   * @returns the auxiliary toolbar that this tabbox owns.
   */
  Tabbox.prototype.getToolbar = function () {
    return this.toolbar;
  };
  /** @internal */
  Tabbox.prototype.domClass_ = function (no) {
    var scHTML = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      var cls = this.inAccordionMold() ? this.$s('accordion') : this.$s(this.getOrient());
      scHTML += ' ' + /*safe*/cls;
    }
    return scHTML;
  };
  /**
   * @returns whether it is a horizontal tabbox.
   */
  Tabbox.prototype.isHorizontal = function () {
    var orient = this.getOrient();
    return 'horizontal' == orient || 'top' == orient || 'bottom' == orient;
  };
  /**
   * @returns whether it is the top orientation.
   */
  Tabbox.prototype.isTop = function () {
    var orient = this.getOrient();
    return 'horizontal' == orient || 'top' == orient;
  };
  /**
   * @returns whether it is the bottom orientation.
   */
  Tabbox.prototype.isBottom = function () {
    return 'bottom' == this.getOrient();
  };
  /**
   * @returns whether it is a vertical tabbox.
   */
  Tabbox.prototype.isVertical = function () {
    var orient = this.getOrient();
    return 'vertical' == orient || 'left' == orient || 'right' == orient;
  };
  /**
   * @returns whether it is the right orientation.
   */
  Tabbox.prototype.isRight = function () {
    return 'right' == this.getOrient();
  };
  /**
   * @returns whether it is the left orientation.
   */
  Tabbox.prototype.isLeft = function () {
    var orient = this.getOrient();
    return 'vertical' == orient || 'left' == orient;
  };
  /**
   * @returns whether it is in the accordion mold.
   */
  Tabbox.prototype.inAccordionMold = function () {
    return this.getMold().includes('accordion');
  };
  /**
   * @returns the selected index.
   */
  Tabbox.prototype.getSelectedIndex = function () {
    return this._selTab ? this._selTab.getIndex() : -1;
  };
  /**
   * Sets the selected index.
   */
  Tabbox.prototype.setSelectedIndex = function (selectedIndex) {
    if (this.tabs) this.setSelectedTab(this.tabs.getChildAt(selectedIndex));
    return this;
  };
  /**
   * @returns the selected tab panel.
   */
  Tabbox.prototype.getSelectedPanel = function () {
    return this._selTab ? this._selTab.getLinkedPanel() : undefined;
  };
  /**
   * Sets the selected tab panel.
   */
  Tabbox.prototype.setSelectedPanel = function (selectedPanel) {
    if (selectedPanel && selectedPanel.getTabbox() != this) return this;
    var tab = selectedPanel === null || selectedPanel === void 0 ? void 0 : selectedPanel.getLinkedTab();
    if (tab) this.setSelectedTab(tab);
    return this;
  };
  /**
   * @returns the selected tab.
   */
  Tabbox.prototype.getSelectedTab = function () {
    return this._selTab;
  };
  /**
   * Sets the selected tab.
   */
  Tabbox.prototype.setSelectedTab = function (selectedTab, fromServer) {
    if (this._selTab != selectedTab) {
      this._setSel(selectedTab, !fromServer);
      this._selTab = selectedTab;
    }
    return this;
  };
  /** @internal */
  Tabbox.prototype.bind_ = function (desktop, skipper, after) {
    var _this = this;
    _super.prototype.bind_.call(this, desktop, new TabboxSkipper(skipper), after); // F61-ZK-970.zul
    // used in Tabs.js
    this._scrolling = false;
    var toolbar = this.getToolbar();
    if (this.inAccordionMold()) zWatch.listen({
      onResponse: this
    });else if (toolbar && this.getTabs()) {
      zWatch.listen({
        onResponse: this
      });
      this._toolbarWidth = jq(toolbar.$n_()).width();
    }
    for (var key = ['right', 'left', 'down', 'up'], le = key.length; le--;) {
      var btn = this.$n(key[le]);
      if (btn) this.domListen_(btn, 'onClick', '_doClick', key[le]);
    }
    this._fixMaxHeight();
    zk.afterMount(function () {
      var tabs = _this.tabs,
        seltab = _this._selTab;
      if (seltab && tabs) {
        if (_this.isVertical()) tabs._scrollcheck('vsel', seltab);else if (!_this.inAccordionMold()) tabs._scrollcheck('sel', seltab);
      }
    });
  };
  /** @internal */
  Tabbox.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    for (var key = ['right', 'left', 'down', 'up'], le = key.length; le--;) {
      var btn = this.$n(key[le]);
      if (btn) this.domUnlisten_(btn, 'onClick', '_doClick', key[le]);
    }
    this._toolbarWidth = undefined;
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Tabbox.prototype._doClick = function (evt, direction) {
    if (!this.tabs || !this.tabs.nChildren) return; // nothing to do
    var cave = this.tabs.$n_('cave'),
      allTab = jq(cave).children(),
      move = 0,
      head = this.tabs.$n_(),
      isVert = this.isVertical(),
      scrollLength = isVert ? this.tabs._tabsScrollTop : this.tabs._tabsScrollLeft,
      offsetLength = isVert ? head.offsetHeight : head.offsetWidth,
      plus = scrollLength + offsetLength;
    //Scroll to next right tab
    switch (direction) {
      case 'right':
        for (var i = 0, count = allTab.length; i < count; i++) {
          if (allTab[i].offsetLeft + allTab[i].offsetWidth > plus) {
            move = allTab[i].offsetLeft + allTab[i].offsetWidth - scrollLength - offsetLength;
            if (!move || isNaN(move)) return;
            this.tabs._doScroll('right', move);
            return;
          }
        }
        break;
      case 'left':
        for (var i = 0, count = allTab.length; i < count; i++) {
          if (allTab[i].offsetLeft >= scrollLength) {
            //if no Sibling tab no scroll
            var tabli = jq(allTab[i]).prev('li')[0];
            if (!tabli) return;
            move = scrollLength - tabli.offsetLeft;
            if (isNaN(move)) return;
            this.tabs._doScroll('left', move);
            return;
          }
        }
        move = scrollLength - allTab[allTab.length - 1].offsetLeft;
        if (isNaN(move)) return;
        this.tabs._doScroll('left', move);
        break;
      case 'up':
        for (var i = 0, count = allTab.length; i < count; i++) {
          if (allTab[i].offsetTop >= scrollLength) {
            var preli = jq(allTab[i]).prev('li')[0];
            if (!preli) return;
            move = scrollLength - preli.offsetTop;
            this.tabs._doScroll('up', move);
            return;
          }
        }
        var preli = allTab[allTab.length - 1];
        if (!preli) return;
        move = scrollLength - preli.offsetTop;
        this.tabs._doScroll('up', move);
        break;
      case 'down':
        for (var i = 0, count = allTab.length; i < count; i++) {
          if (allTab[i].offsetTop + allTab[i].offsetHeight > plus) {
            move = allTab[i].offsetTop + allTab[i].offsetHeight - scrollLength - offsetLength;
            if (!move || isNaN(move)) return;
            this.tabs._doScroll('down', move);
            return;
          }
        }
        break;
    }
  };
  /**
   * Synchronizes the size immediately.
   * This method is called automatically if the widget is created
   * at the server (i.e., {@link inServer} is true).
   * You have to invoke this method only if you create this widget
   * at client and add or remove children from this widget.
   * @since 5.0.8
   */
  Tabbox.prototype.syncSize = function () {
    this._shallSize = false;
    if (this.desktop) zUtl.fireSized(this, -1); //no beforeSize
  };
  Tabbox.prototype.onResponse = function () {
    if (this.inAccordionMold()) {
      if (this._shallSize) this.syncSize();
    } else if (this._toolbarWidth) {
      // accordion mold not support toolbar
      var toolbarWidth = jq(this.getToolbar().$n_()).width();
      if (toolbarWidth != this._toolbarWidth) {
        // toolbar width changed
        this._toolbarWidth = toolbarWidth;
        this.getTabs().onSize();
      }
    }
  };
  /** @internal */
  Tabbox.prototype._syncSize = function () {
    if (this.desktop) this._shallSize = true;
  };
  /** @internal */
  Tabbox.prototype.beforeChildReplaced_ = function (oldTabs, newTabs) {
    // NOTE: At this point, `this.tabs === oldTabs`. Thus, `this.setSelectedIndex()` will set for `oldTabs` not `newTabs`.
    newTabs.getChildAt(this.getSelectedIndex()).setSelected(true);
  };
  /** @internal */
  Tabbox.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof zul.wgt.Toolbar) this.toolbar = child;else if (child instanceof zul.tab.Tabs) this.tabs = child;else if (child instanceof zul.tab.Tabpanels) {
      this.tabpanels = child;
    }
    this.rerender();
  };
  /** @internal */
  Tabbox.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.toolbar) this.toolbar = undefined;else if (child == this.tabs) this.tabs = undefined;else if (child == this.tabpanels) this.tabpanels = undefined;
    if (!this.childReplacing_) this.rerender();
  };
  Tabbox.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    if (this.desktop) zUtl.fireSized(this, -1); //no beforeSize
    return this;
  };
  Tabbox.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    if (this.desktop) zUtl.fireSized(this, -1); //no beforeSize
    return this;
  };
  /** @internal */
  Tabbox.prototype._fixMaxHeight = function () {
    if (this._maximalHeight) {
      var max = 0,
        pnls = this.getTabpanels(),
        fc = pnls.firstChild;
      for (var c = fc; c; c = c.nextSibling) {
        var panel = c ? c.getCaveNode() : undefined;
        if (!panel) return;else {
          var hgh = jq(panel).outerHeight();
          if (hgh > max) max = hgh;
        }
      }
      for (var c = fc; c; c = c.nextSibling) {
        var panel = c.getCaveNode();
        if (panel) panel.style.height = jq.px0(max);
      }
    }
  };
  /** @internal */
  Tabbox.prototype._setSel = function (newtab, notify) {
    if (newtab) {
      var oldtab = this._selTab;
      if (oldtab != newtab) {
        if (oldtab && this.inAccordionMold()) {
          var p = newtab.getLinkedPanel();
          if (p) p._changeSel(oldtab.getLinkedPanel());
        }
        if (oldtab && oldtab != newtab) oldtab._sel(false, false);
        newtab._sel(true, notify);
      }
    }
  };
  Tabbox = __decorate([zk.WrapClass('zul.tab.Tabbox')], Tabbox);
  return Tabbox;
}(zul.Widget);
exports.Tabbox = Tabbox;
if (!window.zul) window.zul = {};
if (!window.zul.tab) window.zul.tab = {};
if (!window.zul.tab.Tabbox) window.zul.tab.Tabbox = {};
window.zul.tab.Tabbox._ = {
  TabboxSkipper: TabboxSkipper,
  Tabbox: Tabbox
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/tab/Tabpanel.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/tab/Tabpanel.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Tabpanel = void 0;
/* Tabpanel.ts

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:33:02 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
/**
 * A tab panel.
 * @defaultValue {@link getZclass}: z-tabpanel.
 */
var Tabpanel = /** @class */function (_super) {
  __extends(Tabpanel, _super);
  function Tabpanel() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the tabbox owns this component.
   */
  Tabpanel.prototype.getTabbox = function () {
    return this.parent ? this.parent.parent : undefined;
  };
  Tabpanel.prototype.isVisible = function (strict) {
    return _super.prototype.isVisible.call(this) && this.isSelected();
  };
  Tabpanel.prototype.setVisible = function (visible) {
    _super.prototype.setVisible.call(this, visible);
    if (this.desktop && !this.isSelected())
      //Bug ZK-1618: not show if current tabpanel is not selected
      this.$n_().style.display = 'none';
    return this;
  };
  /** @internal */
  Tabpanel.prototype.domClass_ = function (no) {
    var /*safe*/cls = _super.prototype.domClass_.call(this, no),
      tabbox = this.getTabbox();
    if (tabbox.inAccordionMold()) cls += ' ' + this.$s('content');
    return cls;
  };
  /**
   * @returns the tab associated with this tab panel.
   */
  Tabpanel.prototype.getLinkedTab = function () {
    var tabbox = this.getTabbox();
    if (!tabbox) return undefined;
    var tabs = tabbox.getTabs();
    return tabs ? tabs.getChildAt(this.getIndex()) : undefined;
  };
  /**
   * @returns the index of this panel, or -1 if it doesn't belong to any
   * tabpanels.
   */
  Tabpanel.prototype.getIndex = function () {
    return this.getChildIndex();
  };
  /**
   * @returns whether this tab panel is selected.
   */
  Tabpanel.prototype.isSelected = function () {
    var _a;
    return !!((_a = this.getLinkedTab()) === null || _a === void 0 ? void 0 : _a.isSelected());
  };
  // Bug 3026669
  /** @internal */
  Tabpanel.prototype._changeSel = function (oldPanel) {
    if (oldPanel) {
      var cave = this.$n('cave'),
        panel;
      if (cave && !cave.style.height && (panel = oldPanel.$n('cave'))) cave.style.height = panel.style.height;
    }
  };
  /** @internal */
  Tabpanel.prototype._sel = function (toSel, animation) {
    var tabbox = this.getTabbox();
    // B95-ZK-4695.zul, the Tabpanel is removed so that its desktop should be null.
    if (!tabbox || !this.desktop) return; //Bug ZK-1808 removed tabpanel is no longer in hierarchy, and cannot be removed
    var accd = tabbox.inAccordionMold();
    if (accd && animation) {
      var zkp = zk(this.$n('cave'));
      if (toSel) {
        /* ZK-1441
         * When a tabpanel is animating, set tabbox.animating
         * to block other tabpanels enter _sel().
         * Reference: doClick_() in Tab.js
         */
        tabbox._animating = true;
        zkp.slideDown(this, {
          'afterAnima': function () {
            delete tabbox._animating;
          }
        });
      } else {
        zkp.slideUp(this);
      }
    } else {
      var $pl = jq(accd ? this.$n_('cave') : this.$n_()),
        vis = $pl.zk.isVisible();
      if (toSel) {
        if (!vis) {
          $pl.show();
          // Bug ZK-1454: Scrollbar forgets its position when switching tabs in Tabbox
          if (zk.webkit) $pl.scrollTop(this._lastScrollTop);
          zUtl.fireShown(this);
        }
      } else if (vis) {
        zWatch.fireDown('onHide', this);
        // Bug ZK-1454: Scrollbar forgets its position when switching tabs in Tabbox
        if (zk.webkit) this._lastScrollTop = $pl.scrollTop();
        $pl.hide();
      }
    }
  };
  // Could return NaN. Should validate the return value before using it.
  /** @internal */
  Tabpanel.prototype.getPanelContentHeight_ = function () {
    var _a;
    // NOTE: Adding undefined to a number results in NaN. If any argument of
    // Math.max is undefined, the result is NaN. Fortunately, zul.tab.Tabs.prototype._fixHgh
    // validates the return value of this function before using it.
    var node = this.$n(),
      tabpanelsNode = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.$n(),
      panelContentHeight = (tabpanelsNode === null || tabpanelsNode === void 0 ? void 0 : tabpanelsNode.scrollHeight) + zk(tabpanelsNode).padBorderHeight();
    return Math.max(node === null || node === void 0 ? void 0 : node.offsetHeight, panelContentHeight); // B50-ZK-298: concern panel height
  };
  /** @internal */
  Tabpanel.prototype._fixPanelHgh = function () {
    var tabbox = this.getTabbox(),
      tbx = tabbox.$n_(),
      hgh = tbx.style.height;
    if (!hgh && tabbox._vflex) hgh = tbx.offsetHeight;
    if (hgh && hgh != 'auto') {
      if (!tabbox.inAccordionMold()) {
        var n = this.$n_(),
          extraHgh = tabbox.isHorizontal() ? zk(tabbox.tabs).offsetHeight() : zk(n.parentNode).padBorderHeight();
        // B50-ZK-473: Tabpanel in vertical Tabbox should always have full height
        n.style.height = jq.px0(zk(tabbox).contentHeight() - extraHgh);
      } else {
        var n = this.$n_();
        var hgh_1 = tbx.offsetHeight - zk(n.parentNode).padBorderHeight();
        for (var e = n.parentNode.firstChild; e; e = e.nextSibling) if (e != n) hgh_1 -= e.offsetHeight;
        hgh_1 -= n.firstChild.offsetHeight;
        this.$n_('cave').style.height = jq.px0(hgh_1);
      }
    }
  };
  Tabpanel.prototype.onSize = function () {
    var tabbox = this.getTabbox();
    if (tabbox.inAccordionMold() && !zk(this.$n('cave')).isVisible()) return;
    this._fixPanelHgh(); //Bug 2104974
  };
  //bug #3014664
  Tabpanel.prototype.setVflex = function (vflex) {
    if (vflex != 'min') vflex = false;
    return _super.prototype.setVflex.call(this, vflex);
  };
  //bug #3014664
  Tabpanel.prototype.setHflex = function (hflex) {
    if (hflex != 'min') hflex = false;
    return _super.prototype.setHflex.call(this, hflex);
  };
  /** @internal */
  Tabpanel.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this
    });
    // B50-ZK-660: Dynamically generated accordion tabs cannot be closed
    var tab;
    if (this.getTabbox().inAccordionMold() && (tab = this.getLinkedTab())) {
      if (!tab.$n()) tab.unbind().bind(desktop);else if (!jq.isAncestor(this.$n(), tab.$n())) {
        // not display if got wrong tab,
        // it will fixed by Tabpanels#onChildAdded_ if tab add first
        // or by afterMount in tab#bind_ if panel add first
        var cave = this.$n('cave');
        if (cave) cave.style.display = 'none';
      }
    }
  };
  /** @internal */
  Tabpanel.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this
    });
    this._lastScrollTop = undefined;
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Tabpanel = __decorate([zk.WrapClass('zul.tab.Tabpanel')], Tabpanel);
  return Tabpanel;
}(zul.ContainerWidget);
exports.Tabpanel = Tabpanel;
if (!window.zul) window.zul = {};
if (!window.zul.tab) window.zul.tab = {};
if (!window.zul.tab.Tabpanel) window.zul.tab.Tabpanel = {};
window.zul.tab.Tabpanel._ = {
  Tabpanel: Tabpanel
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/tab/Tabpanels.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/tab/Tabpanels.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Tabpanels = void 0;
/* Tabpanels.ts

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:32:57 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
function _syncSelectedPanels(panels) {
  var _a;
  //Note: _selTab is in tabbox, while _selPnl is in tabpanels
  var box = panels.getTabbox();
  if (panels.desktop && box) {
    var oldSel = panels._selPnl,
      sel = (_a = box._selTab) === null || _a === void 0 ? void 0 : _a.getLinkedPanel();
    if (oldSel != sel) {
      if (oldSel === null || oldSel === void 0 ? void 0 : oldSel.desktop) oldSel._sel(false, true);
      if (sel) sel._sel(true, true);
      panels._selPnl = sel;
    }
  }
}
/**
 * A collection of tab panels.
 *
 * @defaultValue {@link getZclass}: z-tabpanels.
 */
var Tabpanels = /** @class */function (_super) {
  __extends(Tabpanels, _super);
  function Tabpanels() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the tabbox owns this component.
   */
  Tabpanels.prototype.getTabbox = function () {
    return this.parent;
  };
  //bug #3014664
  Tabpanels.prototype.setVflex = function (vflex) {
    if (vflex != 'min') vflex = false;
    return _super.prototype.setVflex.call(this, vflex);
  };
  //bug #3014664
  Tabpanels.prototype.setHflex = function (hflex) {
    if (hflex != 'min') hflex = false;
    return _super.prototype.setHflex.call(this, hflex);
  };
  /** @internal */
  Tabpanels.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onResponse: this
    });
  };
  /** @internal */
  Tabpanels.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Tabpanels.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    this._shallSync = true;
  };
  /** @internal */
  Tabpanels.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    // sync select status if tabbox not in accordion mold or
    // the child cave is already visible
    var tabbox = this.getTabbox(),
      cave;
    if (tabbox && (!tabbox.inAccordionMold() || (cave = child.$n('cave')) && cave.style.display != 'none')) this._shallSync = true;
  };
  Tabpanels.prototype.onResponse = function () {
    //bug B65-ZK-1785 synchronize selection only once in the end after all removes have finished
    if (this._shallSync) {
      _syncSelectedPanels(this);
      this._shallSync = false;
    }
  };
  Tabpanels = __decorate([zk.WrapClass('zul.tab.Tabpanels')], Tabpanels);
  return Tabpanels;
}(zul.Widget);
exports.Tabpanels = Tabpanels;
if (!window.zul) window.zul = {};
if (!window.zul.tab) window.zul.tab = {};
if (!window.zul.tab.Tabpanels) window.zul.tab.Tabpanels = {};
window.zul.tab.Tabpanels._ = {
  _syncSelectedPanels: _syncSelectedPanels,
  Tabpanels: Tabpanels
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/tab/Tabs.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/tab/Tabs.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Tabs = void 0;
/* Tabs.ts

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:32:43 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
/**
 * A collection of tabs ({@link Tab}).
 *
 * @defaultValue {@link getZclass}: z-tabs.
 */
var Tabs = /** @class */function (_super) {
  __extends(Tabs, _super);
  function Tabs() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._tabsScrollLeft = 0;
    /** @internal */
    _this._tabsScrollTop = 0;
    return _this;
  }
  /**
   * @returns the tabbox owns this component.
   */
  Tabs.prototype.getTabbox = function () {
    return this.parent;
  };
  Tabs.prototype.getWidth = function () {
    var _a;
    var wd = this._width;
    if (!wd) {
      if ((_a = this.getTabbox()) === null || _a === void 0 ? void 0 : _a.isVertical()) return '50px';
    }
    return wd;
  };
  Tabs.prototype.onSize = function () {
    this._fixWidth(true); //ZK-2810: set height to tabbox when onSize (maybe setHeight or setWidth)
    // ZK-5429, ZK-5433: reset the cache when onSize
    var tabs = this.$n_();
    this._tabsScrollLeft = tabs.scrollLeft;
    this._tabsScrollTop = tabs.scrollTop;
    // Bug Z35-tabbox-004.zul, we need to check again.
    this._scrollcheck('init');
  };
  Tabs.prototype.beforeSize = function () {
    var tabbox = this.getTabbox(),
      width = tabbox.getWidth(),
      style = this.$n_().style;
    if ((!width || width.endsWith('%') || width == 'auto') && !tabbox.inAccordionMold() && !tabbox.isVertical()) {
      this.$n_('cave').style.width = '';
      if (style.width) {
        style.width = '';
        if (!tabbox.isTabscroll()) tabbox.$n_().style.width = '';
      }
    }
  };
  /** @internal */
  Tabs.prototype.insertChildHTML_ = function (child, before, desktop) {
    var last = child.previousSibling,
      outHTML;
    if (before) jq(before).before(outHTML = child.redrawHTML_());else if (last) jq(last).after(outHTML = child.redrawHTML_());else {
      var edge = this.$n('edge');
      if (edge) jq(edge).before(outHTML = child.redrawHTML_());else jq(this.getCaveNode()).append(outHTML = child.redrawHTML_());
    }
    // ZK-5009, if out is empty, ignore for bind()
    if (outHTML) {
      child.bind(desktop);
    }
  };
  //bug #3014664
  Tabs.prototype.setVflex = function (vflex) {
    if (vflex != 'min') vflex = false;
    return _super.prototype.setVflex.call(this, vflex);
  };
  //bug #3014664
  Tabs.prototype.setHflex = function (hflex) {
    if (hflex != 'min') hflex = false;
    return _super.prototype.setHflex.call(this, hflex);
  };
  /** @internal */
  Tabs.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this,
      onResponse: this,
      beforeSize: this
    });
  };
  /** @internal */
  Tabs.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this,
      onResponse: this,
      beforeSize: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Tabs.prototype._scrollcheck = function (way, tb) {
    this._shallCheck = false;
    var tabbox = this.getTabbox();
    if (!this.desktop || tabbox && (!tabbox.isRealVisible() || !tabbox.isTabscroll())) return;
    var tabs = this.$n(),
      tbx = tabbox.$n();
    if (!tabs || !tbx) return; // tabbox is delete , no need to check scroll
    if (tabbox.isVertical()) {
      //vertical
      var tabsOffsetHeight = tabs.offsetHeight,
        tabsScrollTop = tabs.scrollTop,
        childHeight = 0;
      jq(this.$n_('cave')).children().each(function () {
        childHeight += this.offsetHeight;
      });
      if (tabbox._scrolling) {
        //already in scrolling status
        var btnsize = this._getArrowSize();
        if (tabs.offsetHeight <= btnsize) return;
        var sel = tabbox.getSelectedTab(),
          node = tb ? tb.$n() : sel ? sel.$n() : undefined,
          nodeOffsetTop = node ? node.offsetTop : 0,
          nodeOffsetHeight = node ? node.offsetHeight : 0;
        if (childHeight <= tabsOffsetHeight + btnsize) {
          tabbox._scrolling = false;
          this._showbutton(false);
          tabs.style.height = jq.px0(tbx.offsetHeight - 2);
          tabs.scrollTop = 0;
        }
        switch (way) {
          case 'end':
            var d = childHeight - tabsOffsetHeight - tabsScrollTop;
            this._doScroll(d >= 0 ? 'down' : 'up', d >= 0 ? d : Math.abs(d));
            break;
          case 'init':
          case 'vsel':
            if (nodeOffsetTop < tabsScrollTop) {
              this._doScroll('up', tabsScrollTop - nodeOffsetTop);
            } else if (nodeOffsetTop + nodeOffsetHeight > tabsScrollTop + tabsOffsetHeight) {
              this._doScroll('down', nodeOffsetTop + nodeOffsetHeight - tabsScrollTop - tabsOffsetHeight);
            }
            break;
        }
      } else {
        // not enough tab to scroll
        if (childHeight - tabsOffsetHeight > 0) {
          tabbox._scrolling = true;
          this._showbutton(true);
          var btnsize = this._getArrowSize(),
            temp = tbx.offsetHeight - btnsize;
          tabs.style.height = temp > 0 ? temp + 'px' : '';
          if (way == 'end') {
            var d = childHeight - tabsOffsetHeight - tabsScrollTop + 2;
            if (d >= 0) this._doScroll(this.uuid, d);
          }
        } else {
          this._showbutton(false);
        }
      }
    } else if (!tabbox.inAccordionMold()) {
      var cave = this.$n_('cave'),
        sel = tabbox.getSelectedTab(),
        node = tb ? tb.$n() : sel ? sel.$n() : undefined,
        nodeOffsetLeft = node ? node.offsetLeft : 0,
        nodeOffsetWidth = node ? node.offsetWidth : 0,
        tabsOffsetWidth = tabs.offsetWidth,
        tabsScrollLeft = this._tabsScrollLeft,
        childWidth = 0,
        toolbar = tabbox.toolbar,
        toolbarWidth = 0;
      jq(cave).children().each(function () {
        childWidth += this.offsetWidth;
      });
      if (toolbar && toolbar.desktop) toolbarWidth = toolbar.$n_().offsetWidth;
      if (tabbox._scrolling) {
        //already in scrolling status
        var btnsize = this._getArrowSize();
        tabbox.$n_('right').style.right = toolbarWidth + 'px';
        if (childWidth <= tabsOffsetWidth + btnsize) {
          tabbox._scrolling = false;
          this._showbutton(false);
          tabs.style.width = jq.px0(tbx.offsetWidth - toolbarWidth);
          this._fixTabsScrollLeft(0);
        }
        // scroll to specific position
        switch (way) {
          case 'end':
            var d = childWidth - tabsOffsetWidth - tabsScrollLeft;
            this._doScroll(d >= 0 ? 'right' : 'left', d >= 0 ? d : Math.abs(d));
            break;
          case 'init':
          case 'sel':
            if (nodeOffsetLeft == tabsScrollLeft)
              // nothing to do
              break;
            if (nodeOffsetLeft < tabsScrollLeft) {
              this._doScroll('left', tabsScrollLeft - nodeOffsetLeft);
            } else if (nodeOffsetLeft + nodeOffsetWidth > tabsScrollLeft + tabsOffsetWidth) {
              this._doScroll('right', nodeOffsetLeft + nodeOffsetWidth - tabsScrollLeft - tabsOffsetWidth);
            }
            break;
        }
      } else {
        // not enough tab to scroll
        if (childWidth - tabsOffsetWidth > 0) {
          tabbox._scrolling = true;
          this._showbutton(true);
          var btnsize = this._getArrowSize(),
            temp = tbx.offsetWidth - toolbarWidth - btnsize; //coz show button then getsize again
          tabs.style.width = temp > 0 ? temp + 'px' : '';
          tabbox.$n_('right').style.right = toolbarWidth + 'px';
          if (way == 'sel') {
            if (nodeOffsetLeft < tabsScrollLeft) {
              this._doScroll('left', tabsScrollLeft - nodeOffsetLeft);
            } else if (nodeOffsetLeft + nodeOffsetWidth > tabsScrollLeft + tabsOffsetWidth) {
              this._doScroll('right', nodeOffsetLeft + nodeOffsetWidth - tabsScrollLeft - tabsOffsetWidth);
            }
          }
        } else {
          this._showbutton(false);
        }
      }
    }
  };
  /** @internal */
  Tabs.prototype._doScroll = function (to, move) {
    if (!this._doingScroll) this._doingScroll = {};
    if (move <= 0 || this._doingScroll[to]) return;
    var step,
      self = this,
      tabs = this.$n();
    this._doingScroll[to] = move;
    //the tab bigger , the scroll speed faster
    step = move <= 60 ? 5 : 5 * (zk.parseInt(move / 60) + 1);
    //Use to scroll
    var goscroll = function (tabs, to, step) {
        switch (to) {
          case 'right':
            self._fixTabsScrollLeft(self._tabsScrollLeft + step);
            break;
          case 'left':
            self._fixTabsScrollLeft(self._tabsScrollLeft - step);
            break;
          case 'up':
            self._fixTabsScrollTop(self._tabsScrollTop - step);
            break;
          default:
            self._fixTabsScrollTop(self._tabsScrollTop + step);
        }
        var tabsScrollLeft = self._tabsScrollLeft,
          tabsScrollTop = self._tabsScrollTop;
        self._fixTabsScrollLeft(tabsScrollLeft <= 0 ? 0 : tabsScrollLeft);
        self._fixTabsScrollTop(tabsScrollTop <= 0 ? 0 : tabsScrollTop);
      },
      run = setInterval(function () {
        if (!move || !self.desktop) {
          delete self._doingScroll[to];
          clearInterval(run);
          return;
        } else {
          //high speed scroll, need break
          move < step ? goscroll(tabs, to, move) : goscroll(tabs, to, step);
          move -= step;
          move = move < 0 ? 0 : move;
        }
      }, 10);
  };
  /** @internal */
  Tabs.prototype._getArrowSize = function () {
    var tabbox = this.getTabbox(),
      isVer = tabbox.isVertical(),
      btnA = isVer ? tabbox.$n('up') : tabbox.$n('left'),
      btnB = isVer ? tabbox.$n('down') : tabbox.$n('right'),
      size = 0;
    if (btnA && btnB) {
      size = isVer ? btnA.offsetHeight + btnB.offsetHeight : btnA.offsetWidth + btnB.offsetWidth;
    }
    return size;
  };
  /** @internal */
  Tabs.prototype._showbutton = function (show) {
    var tabbox = this.getTabbox();
    if (tabbox.isTabscroll()) {
      var cls = tabbox.$s('scroll');
      jq(tabbox).removeClass(cls);
      if (show) {
        // ZK-1959: the height of arrow should not change when the tabbox add tab
        if (!tabbox.isVertical() && !tabbox.inAccordionMold()) {
          var tb = tabbox.toolbar;
          tabbox.$n_('left').style.height = tabbox.$n_('right').style.height = '';
          if (tb) tb.$n_().style.height = '';
        }
        jq(tabbox).addClass(cls);
      }
    }
  };
  /** @internal */
  Tabs.prototype._fixWidth = function (toSel) {
    var _a;
    var tabs = this.$n_(),
      tabbox = this.getTabbox(),
      tbx = tabbox.$n_(),
      btnsize = tabbox._scrolling ? this._getArrowSize() : 0;
    this._fixHgh(toSel); //ZK-2810: don't set height to tabbox when deselect
    if (tabbox.isVertical()) {
      //LI in IE doesn't have width...
      if (tabs.style.width) {
        tabs._width = tabs.style.width;
      } else {
        //vertical tabs have default width 50px
        tabs.style.width = (_a = tabs._width) !== null && _a !== void 0 ? _a : '50px';
      }
    } else if (!tabbox.inAccordionMold()) {
      if (tbx.offsetWidth < btnsize) return;
      if (tabbox.isTabscroll()) {
        var toolbar = tabbox.toolbar;
        if (toolbar) toolbar = toolbar.$n();
        if (!tbx.style.width) {
          tbx.style.width = '100%';
          if (tabbox._scrolling) tabs.style.width = jq.px0(zk(tbx).contentWidth() - (toolbar ? toolbar.offsetWidth : 0) - btnsize);else tabs.style.width = jq.px0(zk(tbx).contentWidth() - (toolbar ? toolbar.offsetWidth : 0));
        } else {
          if (tabbox._scrolling) tabs.style.width = jq.px0(zk(tbx).contentWidth() - (toolbar ? toolbar.offsetWidth : 0) - btnsize);else tabs.style.width = jq.px0(zk(tbx).contentWidth() - (toolbar ? toolbar.offsetWidth : 0));
        }
        if (toolbar && tabbox._scrolling) tabbox.$n_('right').style.right = toolbar.offsetWidth + 'px';
      } else {
        if (!tbx.style.width) {
          if (tbx.offsetWidth) {
            tbx.style.width = jq.px0(tbx.offsetWidth);
            tabs.style.width = jq.px0(zk(tbx).contentWidth() - zk(tabs).marginWidth());
          }
        } else {
          tabs.style.width = jq.px0(zk(tbx).contentWidth() - zk(tabs).marginWidth());
        }
      }
    }
  };
  /** @internal */
  Tabs.prototype._fixHgh = function (toSel) {
    var _a;
    if (this.getTabbox()._scrolling) return;
    var tabbox = this.getTabbox();
    //fix tabpanels's height if tabbox's height is specified
    //Ignore accordion since its height is controlled by each tabpanel
    if (tabbox.isVertical()) {
      var tabs = this.$n_(),
        tbx = tabbox.$n_(),
        u = tabbox.$n('up'),
        d = tabbox.$n('down'),
        cave = this.$n_('cave'),
        allTab = jq(cave).children();
      if (!tabbox.getHeight() && (!tabbox._vflex || tabbox._vflex == 'min')) {
        // B50-ZK-473: vflex 1
        if (!toSel) {
          //ZK-2810: clear height of tabbox when deselect
          jq(tbx).css('height', '');
        } else {
          var tabsHgh = allTab.length * allTab[0].offsetHeight,
            // default height
            seldPanel = tabbox.getSelectedPanel(),
            panelsHgh = seldPanel && seldPanel.getPanelContentHeight_() || 0,
            //B60-ZK-965
            // NOTE: seldPanel.getPanelContentHeight_() could return NaN; the return value must
            // be validated before use.
            realHgh = Math.max(tabsHgh, panelsHgh);
          tbx.style.height = jq.px0(realHgh + zk(tbx).padBorderHeight());
        }
      }
      tabs.style.height = jq.px0(zk(tbx).contentHeight() - zk(tabs).marginHeight());
      if (u && d) {
        u.style.width = d.style.width = tabs.style.width;
      }
    } else {
      var r = tabbox.$n('right'),
        l = tabbox.$n('left'),
        tb = (_a = tabbox.toolbar) === null || _a === void 0 ? void 0 : _a.$n(),
        tabs = this.$n(),
        hgh = jq.px0(tabs ? tabs.offsetHeight : 0);
      if (r && l) {
        r.style.height = l.style.height = hgh;
      }
      if (tb) {
        tb.style.height = hgh;
      }
      if (tabs) tabs.style.height = '';
    }
  };
  Tabs.prototype.onResponse = function () {
    if (this._shallCheck) {
      this._scrollcheck('init');
    }
  };
  /** @internal */
  Tabs.prototype.beforeChildReplaced_ = function (oldTab, newTab) {
    newTab.setSelected(oldTab.isSelected());
  };
  /** @internal */
  Tabs.prototype.onChildRemoved_ = function (child) {
    var p = this.parent;
    if (p && child == p._selTab) {
      p._selTab = undefined;
    }
    if (this.desktop) this._shallCheck = true;
    _super.prototype.onChildRemoved_.call(this, child);
  };
  /** @internal */
  Tabs.prototype.onChildAdded_ = function (child) {
    if (this.desktop) this._shallCheck = true;
    _super.prototype.onChildAdded_.call(this, child);
  };
  /** @internal */
  Tabs.prototype.onChildVisible_ = function (child) {
    if (this.desktop) {
      var tabbox = this.getTabbox();
      if (tabbox.inAccordionMold() && tabbox.getHeight()) {
        tabbox.syncSize();
      }
    }
    _super.prototype.onChildVisible_.call(this, child);
  };
  /** @internal */
  Tabs.prototype.ignoreFlexSize_ = function (attr) {
    var p = this.getTabbox();
    return p.isVertical() && 'h' == attr || p.isHorizontal() && 'w' == attr;
  };
  /** @internal */
  Tabs.prototype._fixTabsScrollLeft = function (scrollLeft) {
    this.$n_().scrollLeft = this._tabsScrollLeft = scrollLeft;
  };
  /** @internal */
  Tabs.prototype._fixTabsScrollTop = function (scrollTop) {
    this.$n_().scrollTop = this._tabsScrollTop = scrollTop;
  };
  Tabs = __decorate([zk.WrapClass('zul.tab.Tabs')], Tabs);
  return Tabs;
}(zul.Widget);
exports.Tabs = Tabs;
if (!window.zul) window.zul = {};
if (!window.zul.tab) window.zul.tab = {};
if (!window.zul.tab.Tabs) window.zul.tab.Tabs = {};
window.zul.tab.Tabs._ = {
  Tabs: Tabs
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/tab/index.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/tab/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./Tabbox */ "./zul/src/main/resources/web/js/zul/tab/Tabbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Tabs */ "./zul/src/main/resources/web/js/zul/tab/Tabs.ts"), exports);
__exportStar(__webpack_require__(/*! ./Tab */ "./zul/src/main/resources/web/js/zul/tab/Tab.ts"), exports);
__exportStar(__webpack_require__(/*! ./Tabpanels */ "./zul/src/main/resources/web/js/zul/tab/Tabpanels.ts"), exports);
__exportStar(__webpack_require__(/*! ./Tabpanel */ "./zul/src/main/resources/web/js/zul/tab/Tabpanel.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/tab/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;