/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.Core;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocation;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxCategory;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.model.MTaxTest_TaxLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class MTaxTest
extends AbstractTestCase {
    @Test
    public void testClearParentTaxId() {
        MTax tax = new MTax(Env.getCtx(), 0, this.getTrxName());
        tax.setName("testClearParentTaxId");
        tax.setParent_Tax_ID(DictionaryIDs.C_Tax.STANDARD.id);
        tax.setValidFrom(TimeUtil.getDay(null));
        tax.setIsSummary(false);
        tax.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        tax.saveEx();
        Assertions.assertEquals((int)DictionaryIDs.C_Tax.STANDARD.id, (int)tax.getParent_Tax_ID(), (String)"Unexpected parent tax id");
        tax.setIsSummary(true);
        tax.saveEx();
        Assertions.assertEquals((int)0, (int)tax.getParent_Tax_ID(), (String)"Unexpected parent tax id");
    }

    @Test
    public void testTaxLookup() {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        int taxExemptId = Tax.getExemptTax((Properties)ctx, (int)this.getAD_Org_ID(), (String)trxName);
        Assertions.assertTrue((taxExemptId > 0 ? 1 : 0) != 0, (String)"Fail to get tax exempt Id");
        MBPartner bpTree = new MBPartner(ctx, DictionaryIDs.C_BPartner.TREE_FARM.id, trxName);
        MBPartner bpPatio = new MBPartner(ctx, DictionaryIDs.C_BPartner.PATIO.id, trxName);
        MBPartner bpCW = new MBPartner(ctx, DictionaryIDs.C_BPartner.C_AND_W.id, trxName);
        MBPartner bpSeed = new MBPartner(ctx, DictionaryIDs.C_BPartner.SEED_FARM.id, trxName);
        MBPartner bpJoe = new MBPartner(ctx, DictionaryIDs.C_BPartner.JOE_BLOCK.id, trxName);
        bpJoe.setIsTaxExempt(true);
        bpJoe.saveEx();
        this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, this.getAD_Org_ID(), this.getM_Warehouse_ID(), bpJoe.getPrimaryC_BPartner_Location_ID(), bpJoe.getPrimaryC_BPartner_Location_ID(), -1, true, null, taxExemptId);
        bpJoe.setIsTaxExempt(false);
        bpJoe.saveEx();
        this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, this.getAD_Org_ID(), this.getM_Warehouse_ID(), bpJoe.getPrimaryC_BPartner_Location_ID(), bpJoe.getPrimaryC_BPartner_Location_ID(), -1, true, null, DictionaryIDs.C_Tax.STANDARD.id);
        this.expectedTaxLookup(0, DictionaryIDs.C_Charge.FREIGHT.id, DictionaryIDs.AD_Org.FERTILIZER.id, DictionaryIDs.M_Warehouse.FERTILIZER.id, bpJoe.getPrimaryC_BPartner_Location_ID(), bpJoe.getPrimaryC_BPartner_Location_ID(), -1, true, null, taxExemptId);
        this.expectedTaxLookup(0, DictionaryIDs.C_Charge.FREIGHT.id, DictionaryIDs.AD_Org.HQ.id, DictionaryIDs.M_Warehouse.HQ.id, bpPatio.getPrimaryC_BPartner_Location_ID(), bpPatio.getPrimaryC_BPartner_Location_ID(), -1, false, null, DictionaryIDs.C_Tax.STANDARD.id);
        MLocation location = new MLocation(ctx, DictionaryIDs.C_Location.ORG_WH_HQ.id, trxName);
        location.setC_Region_ID(DictionaryIDs.C_Region.CT.id);
        location.saveEx();
        this.expectedTaxLookup(0, DictionaryIDs.C_Charge.FREIGHT.id, DictionaryIDs.AD_Org.HQ.id, DictionaryIDs.M_Warehouse.HQ.id, bpCW.getPrimaryC_BPartner_Location_ID(), bpCW.getPrimaryC_BPartner_Location_ID(), -1, true, null, DictionaryIDs.C_Tax.CT_SALES.id);
        this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, DictionaryIDs.AD_Org.HQ.id, DictionaryIDs.M_Warehouse.HQ.id, bpTree.getPrimaryC_BPartner_Location_ID(), bpTree.getPrimaryC_BPartner_Location_ID(), -1, true, null, DictionaryIDs.C_Tax.STANDARD.id);
        this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, DictionaryIDs.AD_Org.HQ.id, DictionaryIDs.M_Warehouse.HQ.id, bpTree.getPrimaryC_BPartner_Location_ID(), bpTree.getPrimaryC_BPartner_Location_ID(), -1, true, "P", DictionaryIDs.C_Tax.CT_SALES.id);
        this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, DictionaryIDs.AD_Org.FERTILIZER.id, DictionaryIDs.M_Warehouse.FERTILIZER.id, bpPatio.getPrimaryC_BPartner_Location_ID(), bpPatio.getPrimaryC_BPartner_Location_ID(), -1, false, null, taxExemptId);
        this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, DictionaryIDs.AD_Org.FERTILIZER.id, DictionaryIDs.M_Warehouse.FERTILIZER.id, bpSeed.getPrimaryC_BPartner_Location_ID(), bpSeed.getPrimaryC_BPartner_Location_ID(), bpCW.getPrimaryC_BPartner_Location_ID(), false, null, taxExemptId);
        MSysConfig sysCfgTaxLookup = new MSysConfig(ctx, DictionaryIDs.AD_SysConfig.TAX_LOOKUP_SERVICE.id, null);
        String oldValue = sysCfgTaxLookup.getValue();
        try {
            sysCfgTaxLookup.setValue(MTaxTest_TaxLookup.class.getName());
            sysCfgTaxLookup.saveCrossTenantSafeEx();
            CacheMgt.get().reset("AD_SysConfig");
            this.expectedTaxLookup(DictionaryIDs.M_Product.AZALEA_BUSH.id, 0, DictionaryIDs.AD_Org.FERTILIZER.id, DictionaryIDs.M_Warehouse.FERTILIZER.id, bpSeed.getPrimaryC_BPartner_Location_ID(), bpSeed.getPrimaryC_BPartner_Location_ID(), bpCW.getPrimaryC_BPartner_Location_ID(), false, null, DictionaryIDs.C_Tax.CT_SALES.id);
        }
        finally {
            sysCfgTaxLookup.setValue(oldValue);
            sysCfgTaxLookup.saveCrossTenantSafeEx();
        }
    }

    private void expectedTaxLookup(int prodId, int chargeId, int orgId, int warehouseId, int billLocationId, int shipLocationId, int dropshipLocation, boolean isSOTrx, String deliveryViaRule, int expectedTaxId) {
        Properties ctx = Env.getCtx();
        String trxName = this.getTrxName();
        int id = Core.getTaxLookup().get(ctx, prodId, chargeId, this.getLoginDate(), this.getLoginDate(), orgId, warehouseId, billLocationId, shipLocationId, dropshipLocation, isSOTrx, deliveryViaRule, trxName);
        Assertions.assertEquals((int)expectedTaxId, (int)id, (String)"Unexpected tax id");
    }

    @Test
    public void testDistributeTaxToProductCost() {
        MProduct product = null;
        MTaxCategory category = null;
        MTax tax = null;
        try {
            category = new MTaxCategory(Env.getCtx(), 0, null);
            category.setName("testDistributeTaxToProductCost");
            category.saveEx();
            tax = new MTax(Env.getCtx(), 0, null);
            tax.setC_TaxCategory_ID(category.get_ID());
            tax.setIsDocumentLevel(false);
            tax.setIsSummary(false);
            tax.setRate(new BigDecimal("5.00"));
            tax.setTaxPostingIndicator("1");
            tax.setSOPOType("P");
            tax.setName("testDistributeTaxToProductCost");
            tax.saveEx();
            CacheMgt.get().reset();
            MProduct p = MProduct.get((int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(p.getM_Product_Category_ID());
            product.setC_TaxCategory_ID(category.get_ID());
            product.setIsStocked(true);
            product.setIsPurchased(true);
            product.setIsSold(true);
            product.setIsStocked(true);
            product.setProductType("I");
            product.setName("testDistributeTaxToProductCost");
            product.setC_UOM_ID(p.getC_UOM_ID());
            product.saveEx();
            MPriceList priceList = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id);
            MPriceListVersion priceListVersion = priceList.getPriceListVersion(null);
            MProductPrice productPrice = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            productPrice.setM_PriceList_Version_ID(priceListVersion.get_ID());
            productPrice.setM_Product_ID(product.getM_Product_ID());
            productPrice.setPrices(new BigDecimal("2.00"), new BigDecimal("2.00"), new BigDecimal("2.00"));
            productPrice.saveEx();
            BigDecimal expectedCost = new BigDecimal("2.00").add(new BigDecimal("2.00").multiply(new BigDecimal("0.05"))).setScale(2, RoundingMode.HALF_EVEN);
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(product);
            orderLine.setQty(new BigDecimal("1"));
            orderLine.setTax();
            orderLine.saveEx();
            Assertions.assertEquals((int)tax.get_ID(), (int)orderLine.getC_Tax_ID(), (String)"Un-expected tax id");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            Assertions.assertEquals((Object)expectedCost, (Object)order.getGrandTotal().setScale(2, RoundingMode.HALF_EVEN), (String)"Un-expected order grand total");
            MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt.saveEx();
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setOrderLine(orderLine, M_Locator_ID, new BigDecimal("1"));
            receiptLine.setLine(10);
            receiptLine.setQty(new BigDecimal("1"));
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setShipLine(receiptLine);
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(new BigDecimal("1"));
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)matchPOs, (String)"Can't retrieve match po for order line");
            Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Un-expected number of match po record for order line");
            if (!matchPOs[0].isPosted()) {
                DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)473, (int)matchPOs[0].get_ID(), (boolean)true, (String)this.getTrxName());
            }
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            productCost.setQty(new BigDecimal("1"));
            MAcctSchema schema = MClientInfo.get().getMAcctSchema1();
            BigDecimal averageCost = productCost.getProductCosts(schema, this.getAD_Org_ID(), "A", 0, true);
            if (averageCost == null) {
                averageCost = BigDecimal.ZERO;
            }
            averageCost = averageCost.setScale(2, RoundingMode.HALF_EVEN);
            Assertions.assertEquals((Object)expectedCost, (Object)averageCost, (String)"Un-expected average cost");
            MAccount acctAsset = productCost.getAccount(3, schema);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt.get_ID(), (int)schema.getC_AcctSchema_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            BigDecimal totalDebit = new BigDecimal("0.00");
            for (MFactAcct fa : factAccts) {
                if (fa.getAccount_ID() != acctAsset.getAccount_ID()) continue;
                totalDebit = totalDebit.add(fa.getAmtAcctDr());
            }
            Assertions.assertEquals((Object)expectedCost, (Object)totalDebit.setScale(2, RoundingMode.HALF_EVEN), (String)"Un-expected product asset account posted amount");
        }
        finally {
            this.rollback();
            if (product != null && product.get_ID() > 0) {
                product.deleteEx(true);
            }
            if (tax != null && tax.get_ID() > 0) {
                tax.deleteEx(true);
            }
            if (category != null && category.get_ID() > 0) {
                category.deleteEx(true);
            }
        }
    }

    @Test
    public void testSeparateTaxPosting() {
        MProduct product = null;
        MTaxCategory category = null;
        MTax tax = null;
        try {
            category = new MTaxCategory(Env.getCtx(), 0, null);
            category.setName("testSeparateTaxPosting");
            category.saveEx();
            tax = new MTax(Env.getCtx(), 0, null);
            tax.setC_TaxCategory_ID(category.get_ID());
            tax.setIsDocumentLevel(false);
            tax.setIsSummary(false);
            tax.setRate(new BigDecimal("5.00"));
            tax.setTaxPostingIndicator("0");
            tax.setSOPOType("P");
            tax.setName("testSeparateTaxPosting");
            tax.saveEx();
            CacheMgt.get().reset();
            MProduct p = MProduct.get((int)DictionaryIDs.M_Product.AZALEA_BUSH.id);
            product = new MProduct(Env.getCtx(), 0, null);
            product.setM_Product_Category_ID(p.getM_Product_Category_ID());
            product.setC_TaxCategory_ID(category.get_ID());
            product.setIsStocked(true);
            product.setIsPurchased(true);
            product.setIsSold(true);
            product.setIsStocked(true);
            product.setProductType("I");
            product.setName("testSeparateTaxPosting");
            product.setC_UOM_ID(p.getC_UOM_ID());
            product.saveEx();
            MPriceList priceList = MPriceList.get((int)DictionaryIDs.M_PriceList.PURCHASE.id);
            MPriceListVersion priceListVersion = priceList.getPriceListVersion(null);
            MProductPrice productPrice = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            productPrice.setM_PriceList_Version_ID(priceListVersion.get_ID());
            productPrice.setM_Product_ID(product.getM_Product_ID());
            productPrice.setPrices(new BigDecimal("2.00"), new BigDecimal("2.00"), new BigDecimal("2.00"));
            productPrice.saveEx();
            BigDecimal expectedCost = new BigDecimal("2.00").setScale(2, RoundingMode.HALF_EVEN);
            BigDecimal expectedTotal = new BigDecimal("2.00").add(new BigDecimal("2.00").multiply(new BigDecimal("0.05"))).setScale(2, RoundingMode.HALF_EVEN);
            MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id);
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(bpartner);
            order.setIsSOTrx(false);
            order.setC_DocTypeTarget_ID();
            order.setDocStatus("DR");
            order.setDocAction("CO");
            order.saveEx();
            MOrderLine orderLine = new MOrderLine(order);
            orderLine.setLine(10);
            orderLine.setProduct(product);
            orderLine.setQty(new BigDecimal("1"));
            orderLine.setTax();
            orderLine.saveEx();
            Assertions.assertEquals((int)tax.get_ID(), (int)orderLine.getC_Tax_ID(), (String)"Un-expected tax id");
            ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            order.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
            Assertions.assertEquals((Object)expectedTotal, (Object)order.getGrandTotal().setScale(2, RoundingMode.HALF_EVEN), (String)"Un-expected order grand total");
            MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
            receipt.saveEx();
            MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
            int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            MInOutLine receiptLine = new MInOutLine(receipt);
            receiptLine.setOrderLine(orderLine, M_Locator_ID, new BigDecimal("1"));
            receiptLine.setLine(10);
            receiptLine.setQty(new BigDecimal("1"));
            receiptLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            receipt.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
            MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
            invoice.setDocStatus("DR");
            invoice.setDocAction("CO");
            invoice.saveEx();
            MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
            invoiceLine.setShipLine(receiptLine);
            invoiceLine.setLine(10);
            invoiceLine.setProduct(product);
            invoiceLine.setQty(new BigDecimal("1"));
            invoiceLine.saveEx();
            info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
            Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
            invoice.load(this.getTrxName(), new String[0]);
            Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
            MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
            Assertions.assertNotNull((Object)matchPOs, (String)"Can't retrieve match po for order line");
            Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Un-expected number of match po record for order line");
            if (!matchPOs[0].isPosted()) {
                DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)this.getAD_Client_ID(), (int)473, (int)matchPOs[0].get_ID(), (boolean)true, (String)this.getTrxName());
            }
            ProductCost productCost = new ProductCost(Env.getCtx(), product.get_ID(), 0, this.getTrxName());
            productCost.setQty(new BigDecimal("1"));
            MAcctSchema schema = MClientInfo.get().getMAcctSchema1();
            BigDecimal averageCost = productCost.getProductCosts(schema, this.getAD_Org_ID(), "A", 0, true);
            if (averageCost == null) {
                averageCost = BigDecimal.ZERO;
            }
            averageCost = averageCost.setScale(2, RoundingMode.HALF_EVEN);
            Assertions.assertEquals((Object)expectedCost, (Object)averageCost, (String)"Un-expected average cost");
            MAccount acctAsset = productCost.getAccount(3, schema);
            Query query = MFactAcct.createRecordIdQuery((int)319, (int)receipt.get_ID(), (int)schema.getC_AcctSchema_ID(), (String)this.getTrxName());
            List factAccts = query.list();
            BigDecimal totalDebit = new BigDecimal("0.00");
            for (MFactAcct fa : factAccts) {
                if (fa.getAccount_ID() != acctAsset.getAccount_ID()) continue;
                totalDebit = totalDebit.add(fa.getAmtAcctDr());
            }
            Assertions.assertEquals((Object)expectedCost, (Object)totalDebit.setScale(2, RoundingMode.HALF_EVEN), (String)"Un-expected product asset account posted amount");
        }
        finally {
            this.rollback();
            if (product != null && product.get_ID() > 0) {
                product.deleteEx(true);
            }
            if (tax != null && tax.get_ID() > 0) {
                tax.deleteEx(true);
            }
            if (category != null && category.get_ID() > 0) {
                category.deleteEx(true);
            }
        }
    }
}

