/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi;

import org.eclipse.jetty.deploy.App;
import org.eclipse.jetty.deploy.bindings.StandardUndeployer;
import org.eclipse.jetty.deploy.graph.Node;
import org.eclipse.jetty.osgi.OSGiApp;
import org.eclipse.jetty.osgi.util.EventSender;
import org.eclipse.jetty.server.Server;

public class OSGiUndeployer
extends StandardUndeployer {
    private Server _server;

    public OSGiUndeployer(Server server) {
        this._server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBinding(Node node, App app) throws Exception {
        EventSender.getInstance().send("org/osgi/service/web/UNDEPLOYING", ((OSGiApp)app).getBundle(), app.getContextPath());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = (ClassLoader)this._server.getAttribute("org.eclipse.jetty.osgi.server.classLoader");
        Thread.currentThread().setContextClassLoader(cl);
        try {
            super.processBinding(node, app);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        EventSender.getInstance().send("org/osgi/service/web/UNDEPLOYED", ((OSGiApp)app).getBundle(), app.getContextPath());
        ((OSGiApp)app).deregisterAsOSGiService();
    }
}

