/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.zkoss.zk.ui.UiException;

public class ComponentRedraws {
    private static final ThreadLocal<Stack<List<Integer>>> _tempStates = new ThreadLocal();
    private static final ThreadLocal<Context> _ctx = new ThreadLocal();

    private ComponentRedraws() {
    }

    public static final int beforeRedraw(boolean includingPage) {
        int order;
        Context ctx = _ctx.get();
        if (ctx == null) {
            ctx = new Context();
            _ctx.set(ctx);
            order = -1;
        } else if (ctx.states.isEmpty()) {
            order = -1;
        } else {
            order = ctx.states.get(0);
            ctx.states.set(0, order + 1);
        }
        ctx.states.add(0, includingPage ? -1 : 0);
        return order;
    }

    public static final Writer getScriptBuffer() {
        return ComponentRedraws._ctx.get().out;
    }

    public static final String afterRedraw() {
        try {
            Context ctx = _ctx.get();
            ctx.states.remove(0);
            if (ctx.states.isEmpty()) {
                _ctx.remove();
                return ctx.out.getBuffer().toString();
            }
        }
        catch (Throwable ex) {
            _ctx.remove();
            throw UiException.Aide.wrap(ex);
        }
        return "";
    }

    public static final void saveStates() {
        Context ctx = _ctx.get();
        if (ctx != null) {
            Stack<List<Integer>> tmpStates = _tempStates.get();
            if (tmpStates == null) {
                tmpStates = new Stack();
                _tempStates.set(tmpStates);
            }
            tmpStates.push(new LinkedList<Integer>(ctx.states));
        }
    }

    public static final void restoreStates() {
        Context ctx = _ctx.get();
        if (ctx != null) {
            ctx.states.clear();
            ctx.states.addAll((Collection<Integer>)_tempStates.get().pop());
            if (_tempStates.get().isEmpty()) {
                _tempStates.remove();
            }
        }
    }

    private static class Context {
        private final List<Integer> states = new LinkedList<Integer>();
        private final StringWriter out = new StringWriter();

        private Context() {
        }
    }
}

